/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.media.MediaCodecList;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.opentok.android.AudioDeviceManager;
import com.opentok.android.BaseAudioDevice;
import com.opentok.android.Camera2VideoCapturer;
import com.opentok.android.Connection;
import com.opentok.android.DefaultAudioDevice;
import com.opentok.android.DefaultVideoRenderer;
import com.opentok.android.Loader;
import com.opentok.android.MuteForcedInfo;
import com.opentok.android.OpenTokConfig;
import com.opentok.android.OpentokError;
import com.opentok.android.OtLog;
import com.opentok.android.PublisherKit;
import com.opentok.android.Stream;
import com.opentok.android.SubscriberKit;
import com.opentok.android.Utils;
import com.opentok.android.VideoRenderFactory;
import com.opentok.impl.a;
import com.opentok.otc.SWIGTYPE_p_otc_session;
import com.opentok.otc.b;
import com.opentok.otc.e;
import com.opentok.otc.g;
import com.opentok.otc.h;
import com.opentok.otc.otc_on_mute_forced_info;
import com.opentok.otc.otc_session_callbacks;
import com.opentok.otc.otc_session_capabilities;
import com.opentok.otc.otc_signal_options;
import com.opentok.otc.otc_stream_video_type;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import org.json.JSONArray;
import org.json.JSONObject;

public class Session
extends Observable {
    private static final String ANDROID_SDK_PACKAGE_NAME = "com.opentok.android";
    private static final String PERMISSION_DEFAULT_PREFIX = "android.permission.";
    private static final String DEFAULT_API_URL = "https://api.opentok.com";
    private static final int VIDEO_TYPE = 0;
    private static final int AUDIO_TYPE = 1;
    protected SessionListener sessionListener;
    protected ConnectionListener connectionListener;
    protected StreamPropertiesListener streamPropertiesListener;
    protected StreamCaptionsPropertiesListener streamCaptionsPropertiesListener;
    protected SignalListener signalListener;
    protected ArchiveListener archiveListener;
    protected ReconnectionListener reconnectionListener;
    protected MuteListener muteListener;
    protected Context context;
    protected String apiKey;
    protected String sessionId;
    protected URL apiUrl;
    private Handler handler;
    private SWIGTYPE_p_otc_session otc_session;
    private swig_otc_session_cb session_cb;
    private boolean shouldDestroyOnFinalize;
    private final OtLog.LogToken log;

    @Deprecated
    public Session(Context context, String string, String string2) {
        SessionOptions sessionOptions;
        Session session = sessionOptions2;
        SessionOptions sessionOptions2 = sessionOptions;
        sessionOptions = new SessionOptions(){};
        session(context, string, string2, sessionOptions2);
    }

    @Deprecated
    public Session(Context context, String string, String string2, SessionOptionsProvider sessionOptionsProvider) {
        ConfigurableSessionOptions configurableSessionOptions;
        Session session = configurableSessionOptions2;
        ConfigurableSessionOptions configurableSessionOptions2 = configurableSessionOptions;
        configurableSessionOptions = new ConfigurableSessionOptions(sessionOptionsProvider.isHwDecodingSupported());
        session(context, string, string2, configurableSessionOptions2);
    }

    @Deprecated
    public Session(Context context, String string, String string2, SessionOptions sessionOptions) {
        Session session = object;
        Object object = Builder.TransportPolicy.All;
        Builder.IncludeServers includeServers = Builder.IncludeServers.All;
        Builder.IceServer[] iceServerArray = new Builder.IceServer[]{};
        session(context, string, string2, false, sessionOptions, (Builder.TransportPolicy)((Object)object), includeServers, iceServerArray, null, false, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Session(Context var1_1, String var2_2, String var3_3, boolean var4_4, SessionOptions var5_7, Builder.TransportPolicy var6_8, Builder.IncludeServers var7_10, Builder.IceServer[] var8_12, URL var9_14, boolean var10_15, String var11_17) {
        block6: {
            super();
            this.shouldDestroyOnFinalize = true;
            this.log = new OtLog.LogToken(this);
            if (AudioDeviceManager.getAudioDevice() == null) {
                var12_18 = v0;
                new DefaultAudioDevice(var1_1 /* !! */ .getApplicationContext()).setAudioBus(new BaseAudioDevice.AudioBus((BaseAudioDevice)var12_18));
                AudioDeviceManager.setAudioDevice((BaseAudioDevice)var12_18);
            }
            Utils.initOtcEngine(var1_1 /* !! */ , AudioDeviceManager.getAudioDevice(), OpenTokConfig.getJNILogs(), OpenTokConfig.getOTKitLogs(), OpenTokConfig.getWebRTCLogs(), OpenTokConfig.getDumpClientLoggingToFile());
            if (OpenTokConfig.getPreferH264Codec() != OpenTokConfig.PreferH264.NOT_SET) {
                var12_19 = OpenTokConfig.getPreferH264Codec() == OpenTokConfig.PreferH264.ENABLE;
                this.set_prefer_h264(var12_19);
            }
            var12_18 = e.c();
            e.a((b)var12_18, (String)var11_17);
            e.a((b)var12_18, (int)var4_4);
            e.b((b)var12_18, (int)var10_15);
            var4_5 = new String[var8_12.length];
            var10_16 = new String[var8_12.length];
            var11_17 = new String[var8_12.length];
            var13_20 = 0;
            var14_21 = var8_12.length;
            for (var15_22 = 0; var15_22 < var14_21; ++var15_22) {
                var16_23 = var8_12[var15_22];
                this.log.d("Using custom ICE server " + var16_23.toString(), new Object[0]);
                var4_5[var13_20] = var16_23.url;
                var10_16[var13_20] = var16_23.user;
                var11_17[var13_20] = var16_23.credential;
                ++var13_20;
            }
            var6_9 = var8_12.length;
            var7_11 = Builder.TransportPolicy.access$000(var6_8);
            var4_6 = e.a((b)var12_18, var6_9, var4_5, var10_16, var11_17, var7_11, var8_13 = Builder.IncludeServers.access$100(var7_10));
            if (var4_6 != g.c.a()) break block6;
            v1 = var1_1 /* !! */ ;
            var1_1 /* !! */  = v2;
            this.session_cb = new swig_otc_session_cb(this.build_native_session_cb());
            this.otc_session = e.a(var2_2, var3_3, (otc_session_callbacks)var1_1 /* !! */ , (b)var12_18);
            e.a((b)var12_18);
            this.handler = new Handler(Looper.myLooper());
            VideoRenderFactory.useTextureViews(var5_7.useTextureViews());
            this.context = v1;
            this.apiKey = var2_2;
            this.sessionId = var3_3;
            if (var9_14 != null) ** GOTO lbl51
            var9_14 = v3;
            try {
                v3 = new URL("https://api.opentok.com");
lbl51:
                // 2 sources

                this.apiUrl = var9_14;
            }
            catch (MalformedURLException v4) {}
            return;
        }
        this.throwError(new OpentokError(OpentokError.Domain.SessionErrorDomain, var4_6, "Invalid ICE Settings"));
        throw new Exception("Invalid ICE Settings");
    }

    Session(SWIGTYPE_p_otc_session sWIGTYPE_p_otc_session, boolean bl) {
        OtLog.LogToken logToken;
        this.shouldDestroyOnFinalize = true;
        OtLog.LogToken logToken2 = logToken;
        logToken = new OtLog.LogToken(this);
        this.log = logToken2;
        this.otc_session = sWIGTYPE_p_otc_session;
        this.shouldDestroyOnFinalize = bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private /* synthetic */ void a() {
        block59: {
            if (Build.VERSION.SDK_INT < 19) break block59;
            var1_1 /* !! */  = v0;
            v0 = new JSONObject();
            var2_4 = v1;
            v1 = new JSONArray();
            var3_5 = v2;
            v2 = new JSONArray();
            v0.put("encoders", var2_4);
            v0.put("decoders", (Object)var3_5);
            var4_8 = 0;
            while (true) {
                block60: {
                    block57: {
                        if (var4_8 >= MediaCodecList.getCodecCount()) break;
                        var5_9 = MediaCodecList.getCodecInfoAt((int)var4_8);
                        if (var5_9 == null) break block57;
                        if (!var5_9.isEncoder()) break block57;
                        var6_10 = var5_9.getSupportedTypes();
                        var7_11 = var6_10.length;
                        for (var8_12 = 0; var8_12 < var7_11; ++var8_12) {
                            var9_13 = var6_10[var8_12];
                            if (!var9_13.equals("video/avc")) continue;
                            v3 = var2_4;
                            var9_13 = var5_9.getCapabilitiesForType(var9_13);
                            v4 = var5_9;
                            v5 = new JSONObject();
                            var10_14 = "codec";
                            v5.put(var10_14, (Object)v4.getName());
                            v5.put("color_format", (Object)Arrays.toString(var9_13.colorFormats));
                            v3.put((Object)v5);
                        }
                        break block60;
                    }
                    if (var5_9 != null) {
                        var6_10 = var5_9.getSupportedTypes();
                        var7_11 = var6_10.length;
                        for (var8_12 = 0; var8_12 < var7_11; ++var8_12) {
                            var9_13 = var6_10[var8_12];
                            if (!var9_13.equals("video/avc")) continue;
                            v6 = var3_5;
                            var9_13 = var5_9.getCapabilitiesForType(var9_13);
                            v7 = var5_9;
                            v8 = new JSONObject();
                            var10_14 = "codec";
                            v8.put(var10_14, (Object)v7.getName());
                            v8.put("color_format", (Object)Arrays.toString(var9_13.colorFormats));
                            v6.put((Object)v8);
                        }
                    }
                }
                ++var4_8;
            }
            this.log.i("Log custom client event: \"codec-avail\" " + var1_1 /* !! */ .toString(), new Object[0]);
            v9 = this.otc_session;
            v10 = var1_1 /* !! */ ;
            var1_1 /* !! */  = "codec-avail";
            try {
                e.a(v9, (String)var1_1 /* !! */ , v10.toString());
            }
            catch (Exception var1_2) {
                this.log.w("Failed to analyze codec list: " + var1_2.getMessage(), new Object[0]);
                var1_2.printStackTrace();
            }
            try {
                v11 = this.context.getPackageManager().getPackageInfo("com.opentok.android", 4096);
            }
            catch (Exception v12) {
                v13 = this;
                v14 = this.log;
                v14.w("com.opentok.android not found probably because android SDK was added as a direct project dependency. Using current context package instead", new Object[0]);
                v11 = v13.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 4096);
                ** continue;
            }
lbl98:
            // 2 sources

            while (true) {
                continue;
                break;
            }
            var1_1 /* !! */  = v11;
            if (var1_1 /* !! */  == null) break block59;
            var1_1 /* !! */  = var1_1 /* !! */ .requestedPermissions;
            var2_4 = v15;
            v15 = new ArrayList<E>();
            var3_6 = var1_1 /* !! */ .requestedPermissions.length;
            for (var4_8 = 0; var4_8 < var3_6; ++var4_8) {
                block58: {
                    v16 = this;
                    var5_9 = var1_1 /* !! */ [var4_8];
                    if (v16.context.checkCallingOrSelfPermission((String)var5_9) < 0) ** GOTO lbl125
                    this.log.i("Permission granted: " + (String)var5_9, new Object[0]);
                    continue;
lbl125:
                    // 1 sources

                    this.log.w("Missing permission: " + (String)var5_9, new Object[0]);
                    if (!var5_9.startsWith("android.permission.")) break block58;
                    var5_9 = var5_9.substring(19);
                }
                var2_4.add(var5_9);
            }
            ** if (var2_4.size() <= 0) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                v17 = this;
                var1_1 /* !! */  = v18;
                v18 = new JSONObject();
                var3_7 = v19;
                v19 = new JSONArray((Collection)var2_4);
                v18.put("perm", (Object)var3_7);
                v20 = v17.otc_session;
                v21 = var1_1 /* !! */ ;
                var1_1 /* !! */  = "missing-permissions";
                e.a(v20, (String)var1_1 /* !! */ , v21.toString());
            }
lbl-1000:
            // 2 sources

            {
            }
            {
                catch (Exception var1_3) {
                    v22 = new Object[1];
                    this = v22;
                    v22[0] = var1_3;
                    this.log.e("Error checking permissions", this);
                }
            }
        }
    }

    static {
        Loader.load();
    }

    boolean isSessionConnected() {
        return e.e(this.otc_session) != null;
    }

    public Connection getConnection() {
        return new Connection(e.e(this.otc_session), true);
    }

    public String getSessionId() {
        return e.f(this.otc_session);
    }

    public void setSessionListener(SessionListener sessionListener) {
        this.sessionListener = sessionListener;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public void setStreamPropertiesListener(StreamPropertiesListener streamPropertiesListener) {
        this.streamPropertiesListener = streamPropertiesListener;
    }

    public void setStreamCaptionsPropertiesListener(StreamCaptionsPropertiesListener streamCaptionsPropertiesListener) {
        this.streamCaptionsPropertiesListener = streamCaptionsPropertiesListener;
    }

    public void setSignalListener(SignalListener signalListener) {
        this.signalListener = signalListener;
    }

    public void setArchiveListener(ArchiveListener archiveListener) {
        this.archiveListener = archiveListener;
    }

    public void setReconnectionListener(ReconnectionListener reconnectionListener) {
        this.reconnectionListener = reconnectionListener;
    }

    public void setMuteListener(MuteListener muteListener) {
        this.muteListener = muteListener;
    }

    public void connect(String string) {
        Session session = this;
        session.log.d("Connect(...) called", new Object[0]);
        Object object = session.apiKey;
        if (object != null && !((String)object).isEmpty()) {
            object = this.sessionId;
            if (object != null && !((String)object).isEmpty()) {
                int n;
                int n2;
                String string2;
                Session session2 = this;
                object = session2.otc_session;
                String string3 = session2.apiUrl.getHost();
                int n3 = e.a((SWIGTYPE_p_otc_session)object, string3, string2 = session2.apiUrl.getPath(), n2 = session2.apiUrl.getPort() == -1 ? this.apiUrl.getDefaultPort() : this.apiUrl.getPort(), n = Utils.booleanToInt(this.apiUrl.getProtocol().equals("https")), string);
                if (n3 == g.c.a()) {
                    if (!(AudioDeviceManager.getAudioDevice() instanceof DefaultAudioDevice)) {
                        this.reportExternalDeviceUsage(1);
                    }
                    return;
                }
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n3));
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.InvalidSessionId.getErrorCode()));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.AuthorizationFailure.getErrorCode()));
    }

    public void disconnect() {
        Session session = this;
        session.log.d("Disconnect(...) called", new Object[0]);
        int n = e.c(session.otc_session);
        if (n == g.c.a()) {
            this.deleteObservers();
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void onPause() {
        SessionPauseResumeEvent sessionPauseResumeEvent;
        ((Session)((Object)sessionPauseResumeEvent2)).log.d("onPause() called", new Object[0]);
        BaseAudioDevice baseAudioDevice = AudioDeviceManager.getAudioDevice();
        if (baseAudioDevice != null) {
            baseAudioDevice.onPause();
        }
        Session session = sessionPauseResumeEvent2;
        session.setChanged();
        SessionPauseResumeEvent sessionPauseResumeEvent2 = sessionPauseResumeEvent;
        sessionPauseResumeEvent = new SessionPauseResumeEvent(true);
        session.notifyObservers(sessionPauseResumeEvent2);
        session.clearChanged();
    }

    public void onResume() {
        SessionPauseResumeEvent sessionPauseResumeEvent;
        ((Session)((Object)sessionPauseResumeEvent2)).log.d("onResume() called", new Object[0]);
        BaseAudioDevice baseAudioDevice = AudioDeviceManager.getAudioDevice();
        if (baseAudioDevice != null) {
            baseAudioDevice.onResume();
        }
        Session session = sessionPauseResumeEvent2;
        session.setChanged();
        SessionPauseResumeEvent sessionPauseResumeEvent2 = sessionPauseResumeEvent;
        sessionPauseResumeEvent = new SessionPauseResumeEvent(false);
        session.notifyObservers(sessionPauseResumeEvent2);
        session.clearChanged();
    }

    public void publish(PublisherKit publisherKit) {
        this.log.d("publish(...) called", new Object[0]);
        if (publisherKit != null && publisherKit.getOtcPublisher() != null) {
            if (!this.isSessionConnected()) {
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionDisconnected.getErrorCode()));
                return;
            }
            int n = e.a(this.otc_session, publisherKit.getOtcPublisher());
            if (n == g.c.a()) {
                if (!(publisherKit.getCapturer() instanceof Camera2VideoCapturer) || !(publisherKit.getRenderer() instanceof DefaultVideoRenderer)) {
                    this.reportExternalDeviceUsage(0);
                }
                this.addObserver(publisherKit);
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
    }

    public void unpublish(PublisherKit publisherKit) {
        this.log.d("unpublish(...) called", new Object[0]);
        if (publisherKit != null && publisherKit.getOtcPublisher() != null) {
            if (!this.isSessionConnected()) {
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionDisconnected.getErrorCode()));
                return;
            }
            int n = e.b(this.otc_session, publisherKit.getOtcPublisher());
            if (n == g.c.a()) {
                this.deleteObserver(publisherKit);
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
    }

    public void subscribe(SubscriberKit subscriberKit) {
        this.log.d("subscribe(...) called", new Object[0]);
        if (subscriberKit != null && subscriberKit.getOtcSubscriber() != null) {
            if (!this.isSessionConnected()) {
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionDisconnected.getErrorCode()));
                return;
            }
            int n = e.a(this.otc_session, subscriberKit.getOtcSubscriber());
            if (n == g.c.a()) {
                SubscriberKit subscriberKit2 = subscriberKit;
                subscriberKit2.attachToSession(this);
                this.addObserver(subscriberKit2);
                if (!(subscriberKit.getRenderer() instanceof DefaultVideoRenderer)) {
                    this.reportExternalDeviceUsage(0);
                }
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
    }

    public void unsubscribe(SubscriberKit subscriberKit) {
        this.log.d("unsubscribe(...) called", new Object[0]);
        if (subscriberKit != null && subscriberKit.getOtcSubscriber() != null) {
            if (!this.isSessionConnected()) {
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionDisconnected.getErrorCode()));
                return;
            }
            int n = e.b(this.otc_session, subscriberKit.getOtcSubscriber());
            if (n == g.c.a()) {
                this.deleteObserver(subscriberKit);
                subscriberKit.detachFromSession(this);
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
    }

    public void sendSignal(String string, String string2) {
        int n = e.b(this.otc_session, string, string2);
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void sendSignal(String string, String string2, boolean bl) {
        otc_signal_options otc_signal_options2;
        otc_signal_options otc_signal_options3 = otc_signal_options2;
        otc_signal_options3();
        otc_signal_options2.a(bl ? 1 : 0);
        int n = e.a(this.otc_session, string, string2, otc_signal_options3);
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void sendSignal(String string, String string2, Connection connection) {
        int n = e.a(this.otc_session, string, string2, connection.getOtcConnection());
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void sendSignal(String string, String string2, Connection connection, boolean bl) {
        otc_signal_options otc_signal_options2;
        otc_signal_options otc_signal_options3 = otc_signal_options2;
        otc_signal_options3();
        otc_signal_options2.a(bl ? 1 : 0);
        int n = e.a(this.otc_session, string, string2, connection.getOtcConnection(), otc_signal_options3);
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        otc_session_capabilities otc_session_capabilities2 = e.d(((Session)((Object)otc_session_capabilities2)).otc_session);
        Capabilities capabilities2 = capabilities;
        capabilities2();
        capabilities2.canPublish = Utils.intToBoolean(otc_session_capabilities2.c());
        capabilities.canForceMute = Utils.intToBoolean(otc_session_capabilities2.b());
        return capabilities;
    }

    public String reportIssue() {
        String string = e.b(((Session)((Object)string)).otc_session, "");
        if (string == null && string.equals("")) {
            return null;
        }
        return string;
    }

    public void forceMuteStream(@NonNull Stream stream) {
        if (stream == null) {
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
            return;
        }
        Session session = this;
        session.log.d("forceMuteStream() called with streamID = " + stream.getStreamId(), new Object[0]);
        int n = e.a(session.otc_session, stream.getStreamId());
        if (n != g.c.a()) {
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
        }
    }

    public void forceMuteAll(@Nullable Iterable<Stream> stringArray) {
        int n;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (stringArray != null) {
            stringArray = stringArray.iterator();
            while (stringArray.hasNext()) {
                arrayList2.add(((Stream)stringArray.next()).getStreamId());
            }
        }
        if ((n = e.a(this.otc_session, stringArray = (String[])Arrays.copyOf(arrayList2.toArray(), arrayList2.size(), String[].class), arrayList2.size())) == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void disableForceMute() {
        int n = e.b(this.otc_session);
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    void throwError(final OpentokError opentokError) {
        if (this.sessionListener != null) {
            this.handler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    2 v0 = this;
                    synchronized (v0) {
                        if (v0.Session.this.sessionListener != null) {
                            2 v1 = this;
                            Session session = v1.Session.this;
                            Session.this.sessionListener.onError(session, v1.opentokError);
                        }
                        // ** MonitorExit[this] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    protected void onArchiveStarted(String string, String string2) {
    }

    void onArchiveStartedJNI(String string, String string2) {
        Session session = this;
        session.handler.post(() -> this.onArchiveStarted(string, string2));
        if (session.archiveListener != null) {
            this.handler.post(() -> {
                ArchiveListener archiveListener = this.archiveListener;
                if (archiveListener != null) {
                    archiveListener.onArchiveStarted(this, string, string2);
                }
            });
        }
    }

    protected void onArchiveStopped(String string) {
    }

    void onArchiveStoppedJNI(String string) {
        Session session = this;
        session.handler.post(() -> this.onArchiveStopped(string));
        if (session.archiveListener != null) {
            this.handler.post(() -> {
                ArchiveListener archiveListener = this.archiveListener;
                if (archiveListener != null) {
                    archiveListener.onArchiveStopped(this, string);
                }
            });
        }
    }

    protected void onStreamHasAudioChanged(Stream stream, int n) {
    }

    void onStreamHasAudioChangedJNI(long l2, int n) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l2, true);
        session.handler.post(() -> this.onStreamHasAudioChanged(stream2, n));
        if (session.streamPropertiesListener != null) {
            this.handler.post(() -> {
                StreamPropertiesListener streamPropertiesListener = this.streamPropertiesListener;
                if (streamPropertiesListener != null) {
                    n = Utils.intToBoolean(n) ? 1 : 0;
                    streamPropertiesListener.onStreamHasAudioChanged(this, stream2, n != 0);
                }
            });
        }
    }

    protected void onStreamHasCaptionsChanged(Stream stream, int n) {
    }

    void onStreamHasCaptionsChangedJNI(long l2, int n) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l2, true);
        session.handler.post(() -> this.onStreamHasCaptionsChanged(stream2, n));
        if (session.streamCaptionsPropertiesListener != null) {
            this.handler.post(() -> {
                StreamCaptionsPropertiesListener streamCaptionsPropertiesListener = this.streamCaptionsPropertiesListener;
                if (streamCaptionsPropertiesListener != null) {
                    n = Utils.intToBoolean(n) ? 1 : 0;
                    streamCaptionsPropertiesListener.onStreamHasCaptionsChanged(this, stream2, n != 0);
                }
            });
        }
    }

    protected void onStreamHasVideoChanged(Stream stream, int n) {
    }

    void onStreamHasVideoChangedJNI(long l2, int n) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l2, true);
        session.handler.post(() -> this.onStreamHasVideoChanged(stream2, n));
        if (session.streamPropertiesListener != null) {
            this.handler.post(() -> {
                StreamPropertiesListener streamPropertiesListener = this.streamPropertiesListener;
                if (streamPropertiesListener != null) {
                    n = Utils.intToBoolean(n) ? 1 : 0;
                    streamPropertiesListener.onStreamHasVideoChanged(this, stream2, n != 0);
                }
            });
        }
    }

    protected void onStreamVideoDimensionsChanged(Stream stream, int n, int n2) {
    }

    void onStreamVideoDimensionsChangedJNI(long l2, int n, int n2) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l2, true);
        session.handler.post(() -> this.onStreamVideoDimensionsChanged(stream2, n, n2));
        if (session.streamPropertiesListener != null) {
            this.handler.post(() -> {
                StreamPropertiesListener streamPropertiesListener = this.streamPropertiesListener;
                if (streamPropertiesListener != null) {
                    streamPropertiesListener.onStreamVideoDimensionsChanged(this, stream2, n, n2);
                }
            });
        }
    }

    protected void onStreamVideoTypeChanged(Stream stream, int n) {
    }

    void onStreamVideoTypeChangedJNI(long l2, int n) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l2, true);
        session.handler.post(() -> this.onStreamVideoTypeChanged(stream2, n));
        if (session.streamPropertiesListener != null) {
            this.handler.post(() -> {
                StreamPropertiesListener streamPropertiesListener = this.streamPropertiesListener;
                if (streamPropertiesListener != null) {
                    streamPropertiesListener.onStreamVideoTypeChanged(this, stream2, Stream.StreamVideoType.fromSwig(otc_stream_video_type.a(n)));
                }
            });
        }
    }

    protected void onConnectionCreated(Connection connection) {
    }

    void onConnectionCreatedJNI(long l2) {
        Connection connection;
        Session session = this;
        Connection connection2 = connection;
        connection = new Connection(l2, true);
        session.handler.post(() -> this.onConnectionCreated(connection2));
        if (session.connectionListener != null) {
            this.handler.post(() -> {
                ConnectionListener connectionListener = this.connectionListener;
                if (connectionListener != null) {
                    connectionListener.onConnectionCreated(this, connection2);
                }
            });
        }
    }

    protected void onConnectionDestroyed(Connection connection) {
    }

    void onConnectionDroppedJNI(long l2) {
        Connection connection;
        Session session = this;
        Connection connection2 = connection;
        connection = new Connection(l2, true);
        session.handler.post(() -> this.onConnectionDestroyed(connection2));
        if (session.connectionListener != null) {
            this.handler.post(() -> {
                ConnectionListener connectionListener = this.connectionListener;
                if (connectionListener != null) {
                    connectionListener.onConnectionDestroyed(this, connection2);
                }
            });
        }
    }

    protected void onSignalReceived(String string, String string2, Connection connection) {
    }

    void onSignalReceivedJNI(String string, String string2, long l2) {
        Connection connection;
        Session session = this;
        Connection connection2 = connection;
        connection = new Connection(l2, true);
        session.handler.post(() -> this.onSignalReceived(string, string2, connection2));
        if (session.signalListener != null) {
            this.handler.post(() -> {
                SignalListener signalListener = this.signalListener;
                if (signalListener != null) {
                    signalListener.onSignalReceived(this, string, string2, connection2);
                }
            });
        }
    }

    protected void onReconnecting() {
    }

    void onReconnectingJNI() {
        Session session = this;
        session.handler.post(() -> this.onReconnecting());
        if (session.reconnectionListener != null) {
            this.handler.post(() -> {
                ReconnectionListener reconnectionListener = this.reconnectionListener;
                if (reconnectionListener != null) {
                    reconnectionListener.onReconnecting(this);
                }
            });
        }
    }

    protected void onReconnected() {
    }

    void onReconnectedJNI() {
        Session session = this;
        session.handler.post(() -> this.onReconnected());
        if (session.reconnectionListener != null) {
            this.handler.post(() -> {
                ReconnectionListener reconnectionListener = this.reconnectionListener;
                if (reconnectionListener != null) {
                    reconnectionListener.onReconnected(this);
                }
            });
        }
    }

    protected void onConnected() {
    }

    void onConnectedJNI() {
        Session session = this;
        session.handler.post(this::a);
        session.handler.post(() -> this.onConnected());
        if (session.sessionListener != null) {
            this.handler.post(() -> {
                SessionListener sessionListener = this.sessionListener;
                if (sessionListener != null) {
                    sessionListener.onConnected(this);
                }
            });
        }
        this.handler.post(() -> {
            String string;
            if (this.otc_session != null && (string = OpenTokConfig.getRTCStatsReportFilePath()) != null && string.length() > 0) {
                e.c(this.otc_session, string);
            }
        });
    }

    protected void onDisconnected() {
    }

    void onDisconnectedJNI() {
        Session session = this;
        session.handler.post(() -> this.onDisconnected());
        if (session.sessionListener != null) {
            this.handler.post(() -> {
                SessionListener sessionListener = this.sessionListener;
                if (sessionListener != null) {
                    sessionListener.onDisconnected(this);
                }
            });
        }
    }

    protected void onStreamReceived(Stream stream) {
    }

    void onStreamReceivedJNI(long l2) {
        Stream stream;
        Stream stream2 = stream;
        stream = new Stream(l2, true);
        String string = Build.MANUFACTURER.toLowerCase(Locale.ROOT);
        int n = 1000;
        if (string.equals("huawei")) {
            Runnable runnable = () -> this.onStreamReceived(stream2);
            long l3 = n;
            ((Session)((Object)runnable)).handler.postDelayed(runnable, l3);
        } else {
            ((Session)((Object)runnable)).handler.post(() -> this.onStreamReceived(stream2));
        }
        if (((Session)((Object)runnable)).sessionListener != null) {
            if (string.equals("huawei")) {
                Runnable runnable = () -> {
                    SessionListener sessionListener = this.sessionListener;
                    if (sessionListener != null) {
                        sessionListener.onStreamReceived(this, stream2);
                    }
                };
                long l4 = n;
                ((Session)((Object)runnable)).handler.postDelayed(runnable, l4);
            } else {
                ((Session)((Object)runnable)).handler.post(() -> {
                    SessionListener sessionListener = this.sessionListener;
                    if (sessionListener != null) {
                        sessionListener.onStreamReceived(this, stream2);
                    }
                });
            }
        }
    }

    protected void onStreamDropped(Stream stream) {
    }

    void onStreamDroppedJNI(long l2) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l2, true);
        session.handler.post(() -> this.onStreamDropped(stream2));
        if (session.sessionListener != null) {
            this.handler.post(() -> {
                SessionListener sessionListener = this.sessionListener;
                if (sessionListener != null) {
                    sessionListener.onStreamDropped(this, stream2);
                }
            });
        }
    }

    protected void onError(OpentokError opentokError) {
    }

    void onErrorJNI(String string, int n) {
        OpentokError opentokError;
        Session session = this;
        OpentokError opentokError2 = opentokError;
        opentokError = new OpentokError(OpentokError.Domain.SessionErrorDomain, n, string);
        session.handler.post(() -> this.onError(opentokError2));
        if (session.sessionListener != null) {
            this.handler.post(() -> {
                SessionListener sessionListener = this.sessionListener;
                if (sessionListener != null) {
                    sessionListener.onError(this, opentokError2);
                }
            });
        }
    }

    protected void onMuteForced(MuteForcedInfo muteForcedInfo) {
    }

    void onMuteForcedJNI(long l2) {
        MuteForcedInfo muteForcedInfo;
        this.log.d("onMuteForcedJNI(long) called", new Object[0]);
        boolean bl = new swig_on_mute_forced_info(l2).getActive() == 1;
        Session session = this;
        MuteForcedInfo muteForcedInfo2 = muteForcedInfo;
        muteForcedInfo = new MuteForcedInfo(bl);
        session.handler.post(() -> this.onMuteForced(muteForcedInfo2));
        if (session.muteListener != null) {
            this.handler.post(() -> {
                MuteListener muteListener = this.muteListener;
                if (muteListener != null) {
                    muteListener.onMuteForced(this, muteForcedInfo2);
                }
            });
        }
    }

    Builder.IceServer[] getIceServers() {
        int[] nArray = new int[1];
        if (e.b(stringArray.otc_session, nArray) != g.c.a()) {
            return new Builder.IceServer[0];
        }
        if (nArray[0] == 0) {
            return new Builder.IceServer[0];
        }
        String[] stringArray = e.c(stringArray.otc_session, nArray);
        String[] stringArray2 = e.d(stringArray.otc_session, nArray);
        String[] stringArray3 = e.a(stringArray.otc_session, nArray);
        Builder.IceServer[] iceServerArray = new Builder.IceServer[nArray[0]];
        for (int i2 = 0; i2 < nArray[0]; ++i2) {
            Builder.IceServer iceServer;
            Builder.IceServer iceServer2 = iceServer;
            String string = stringArray[i2];
            String string2 = stringArray2[i2];
            String string3 = stringArray3[i2];
            iceServer = new Builder.IceServer(string, string2, string3);
            iceServerArray[i2] = iceServer2;
        }
        return iceServerArray;
    }

    void simulateReconnect() {
        if (e.g(this.otc_session) != g.c.a()) {
            this.log.e("Error when simulating a client reconnection.", new Object[0]);
        }
    }

    void reportExternalDeviceUsage(int n) {
        e.a(this.otc_session, h.a(n));
    }

    protected void finalize() {
        Session session = this;
        session.log.d("finalize()", new Object[0]);
        Object object = session.otc_session;
        if (object != null && this.shouldDestroyOnFinalize) {
            e.a((SWIGTYPE_p_otc_session)object);
            this.otc_session = null;
            object = this.session_cb;
            if (object != null) {
                this.destroy_native_session_cb(((swig_otc_session_cb)object).getCPointer());
            }
        }
        super.finalize();
    }

    native long build_native_session_cb();

    native void destroy_native_session_cb(long var1);

    native void init_otc_engine(Context var1, BaseAudioDevice var2, boolean var3, boolean var4, boolean var5, boolean var6);

    native void set_prefer_h264(boolean var1);

    static class swig_on_mute_forced_info
    extends otc_on_mute_forced_info {
        public swig_on_mute_forced_info(long l2) {
            super(l2, false);
        }

        public long getCPointer() {
            return otc_on_mute_forced_info.getCPtr(this);
        }
    }

    static class swig_otc_session_cb
    extends otc_session_callbacks {
        public swig_otc_session_cb(long l2) {
            super(l2, false);
        }

        public long getCPointer() {
            return otc_session_callbacks.getCPtr(this);
        }
    }

    public static class Builder {
        Context context;
        String apiKey;
        String sessionId;
        URL apiUrl;
        boolean connectionEventsSuppressed = false;
        SessionOptions sessionOptions = new SessionOptions(){};
        TransportPolicy turnRouting = TransportPolicy.All;
        IceServer[] iceServers = new IceServer[0];
        IncludeServers turnServerConfig = IncludeServers.All;
        boolean ipWhitelist = false;
        String proxyUrl;

        public Builder(Context context, String string, String string2) {
            this.context = context;
            this.apiKey = string;
            this.sessionId = string2;
        }

        public Builder connectionEventsSuppressed(Boolean bl) {
            this.connectionEventsSuppressed = bl;
            return this;
        }

        public Builder sessionOptions(SessionOptions sessionOptions) {
            this.sessionOptions = sessionOptions;
            return this;
        }

        public Builder setCustomIceServers(List<IceServer> list, IncludeServers includeServers) {
            List<IceServer> list2 = list;
            this.iceServers = list2.toArray(new IceServer[list2.size()]);
            this.turnServerConfig = includeServers;
            return this;
        }

        public Builder setIceRouting(TransportPolicy transportPolicy) {
            this.turnRouting = transportPolicy;
            return this;
        }

        @Deprecated
        public Builder setApiUrl(URL uRL) {
            this.apiUrl = uRL;
            return this;
        }

        public Builder setIpWhitelist(boolean bl) {
            this.ipWhitelist = bl;
            return this;
        }

        public Builder setProxyUrl(String string) {
            this.proxyUrl = string;
            return this;
        }

        public Session build() {
            Builder builder;
            Builder builder2;
            Builder builder3;
            Builder builder4;
            Builder builder5;
            Builder builder6;
            Builder builder7;
            Builder builder8;
            Builder builder9;
            Builder builder10;
            Session session;
            Session session2;
            try {
                Session session3;
                session2 = session3;
                session = session3;
                Builder builder11 = builder12;
                builder10 = builder11;
                builder9 = builder11;
                builder8 = builder11;
                builder7 = builder11;
                builder6 = builder11;
                builder5 = builder11;
                builder4 = builder11;
                builder3 = builder11;
                builder2 = builder11;
                builder = builder11;
                Builder builder12 = builder11.context;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            String string = builder3.apiKey;
            String string2 = builder2.sessionId;
            boolean bl = builder.connectionEventsSuppressed;
            SessionOptions sessionOptions = builder5.sessionOptions;
            TransportPolicy transportPolicy = builder4.turnRouting;
            IncludeServers includeServers = builder7.turnServerConfig;
            IceServer[] iceServerArray = builder6.iceServers;
            URL uRL = builder9.apiUrl;
            boolean bl2 = builder8.ipWhitelist;
            String string3 = builder10.proxyUrl;
            session2((Context)builder12, string, string2, bl, sessionOptions, transportPolicy, includeServers, iceServerArray, uRL, bl2, string3);
            return session;
        }

        public static class IceServer {
            public String url = "";
            public String user = "";
            public String credential = "";

            public IceServer(String string, String string2, String string3) {
                this.url = string;
                this.user = string2;
                this.credential = string3;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object object) {
                if (!(object instanceof IceServer)) return false;
                object = (IceServer)object;
                if (!this.url.equals(((IceServer)object).url)) return false;
                if (!this.user.equals(((IceServer)object).user)) return false;
                if (!this.credential.equals(((IceServer)object).credential)) return false;
                return true;
            }

            public String toString() {
                return "[url: " + this.url + ", user: " + this.user + ", credential: " + this.credential + "]";
            }
        }

        public static final class TransportPolicy
        extends Enum<TransportPolicy> {
            public static final /* enum */ TransportPolicy All;
            public static final /* enum */ TransportPolicy Relay;
            private static final /* synthetic */ TransportPolicy[] $VALUES;
            private int val;

            public static TransportPolicy[] values() {
                return (TransportPolicy[])$VALUES.clone();
            }

            public static TransportPolicy valueOf(String string) {
                return Enum.valueOf(TransportPolicy.class, string);
            }

            private TransportPolicy(int n2) {
                this.val = n2;
            }

            static /* synthetic */ int access$000(TransportPolicy transportPolicy) {
                return transportPolicy.val;
            }

            static {
                TransportPolicy transportPolicy;
                All = new TransportPolicy(0);
                TransportPolicy transportPolicy2 = transportPolicy;
                Relay = new TransportPolicy(1);
                $VALUES = new TransportPolicy[]{All, transportPolicy2};
            }
        }

        public static final class IncludeServers
        extends Enum<IncludeServers> {
            public static final /* enum */ IncludeServers All;
            public static final /* enum */ IncludeServers Custom;
            private static final /* synthetic */ IncludeServers[] $VALUES;
            private int val;

            public static IncludeServers[] values() {
                return (IncludeServers[])$VALUES.clone();
            }

            public static IncludeServers valueOf(String string) {
                return Enum.valueOf(IncludeServers.class, string);
            }

            private IncludeServers(int n2) {
                this.val = n2;
            }

            static /* synthetic */ int access$100(IncludeServers includeServers) {
                return includeServers.val;
            }

            static {
                IncludeServers includeServers;
                All = new IncludeServers(0);
                IncludeServers includeServers2 = includeServers;
                Custom = new IncludeServers(1);
                $VALUES = new IncludeServers[]{All, includeServers2};
            }
        }
    }

    static class SessionPauseResumeEvent {
        boolean mIsSessionPaused;

        SessionPauseResumeEvent(boolean bl) {
            this.mIsSessionPaused = bl;
        }

        boolean isSessionPaused() {
            return this.mIsSessionPaused;
        }
    }

    protected static class ConfigurableSessionOptions
    extends SessionOptions {
        private boolean hwDecCapable = false;

        ConfigurableSessionOptions(boolean bl) {
            this.hwDecCapable = bl;
        }

        @Override
        public boolean isHwDecodingSupported() {
            return this.hwDecCapable;
        }
    }

    public static abstract class SessionOptions {
        @Deprecated
        public boolean isHwDecodingSupported() {
            return false;
        }

        @Deprecated
        public boolean isCamera2Capable() {
            return true;
        }

        public boolean useTextureViews() {
            return false;
        }
    }

    @Deprecated
    public static interface SessionOptionsProvider {
        @Deprecated
        public boolean isHwDecodingSupported();
    }

    public static interface MuteListener {
        public void onMuteForced(Session var1, MuteForcedInfo var2);
    }

    public static interface ReconnectionListener {
        public void onReconnecting(Session var1);

        public void onReconnected(Session var1);
    }

    public static interface ArchiveListener {
        public void onArchiveStarted(Session var1, String var2, String var3);

        public void onArchiveStopped(Session var1, String var2);
    }

    public static interface SignalListener {
        public void onSignalReceived(Session var1, String var2, String var3, Connection var4);
    }

    public static interface StreamCaptionsPropertiesListener {
        public void onStreamHasCaptionsChanged(Session var1, Stream var2, boolean var3);
    }

    public static interface StreamPropertiesListener {
        public void onStreamHasAudioChanged(Session var1, Stream var2, boolean var3);

        public void onStreamHasVideoChanged(Session var1, Stream var2, boolean var3);

        public void onStreamVideoDimensionsChanged(Session var1, Stream var2, int var3, int var4);

        public void onStreamVideoTypeChanged(Session var1, Stream var2, Stream.StreamVideoType var3);
    }

    public static interface ConnectionListener {
        public void onConnectionCreated(Session var1, Connection var2);

        public void onConnectionDestroyed(Session var1, Connection var2);
    }

    public static interface SessionListener {
        public void onConnected(Session var1);

        public void onDisconnected(Session var1);

        public void onStreamReceived(Session var1, Stream var2);

        public void onStreamDropped(Session var1, Stream var2);

        public void onError(Session var1, OpentokError var2);
    }

    public static class Capabilities {
        public boolean canPublish;
        public boolean canSubscribe;
        public boolean canForceMute;
        private final OtLog.LogToken log;

        public Capabilities() {
            OtLog.LogToken logToken;
            OtLog.LogToken logToken2 = logToken;
            logToken = new OtLog.LogToken(this);
            this.log = logToken2;
        }

        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder("[\n");
            for (Field field : Capabilities.class.getFields()) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                int n = 0;
                objectArray2[n] = field.getName();
                n = 1;
                try {
                    objectArray[n] = field.get(this);
                    stringBuilder2.append(String.format("\t%s = %b\n", objectArray));
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.log.e("Error converting Capabilities to String", new Object[0]);
                }
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append(']');
            return stringBuilder3.toString();
        }
    }
}

