/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import android.view.View;
import com.opentok.android.BaseVideoRenderer;
import com.opentok.android.Loader;
import com.opentok.android.OpentokError;
import com.opentok.android.OtLog;
import com.opentok.android.Session;
import com.opentok.android.Stream;
import com.opentok.android.Utils;
import com.opentok.android.VideoUtils;
import com.opentok.otc.SWIGTYPE_p_otc_stream;
import com.opentok.otc.SWIGTYPE_p_otc_subscriber;
import com.opentok.otc.e;
import com.opentok.otc.g;
import com.opentok.otc.k;
import com.opentok.otc.otc_subscriber_callbacks;
import com.opentok.otc.otc_subscriber_rtc_stats_report_cb;
import java.util.Observable;
import java.util.Observer;

public class SubscriberKit
implements Observer {
    public static final String VIDEO_REASON_PUBLISH_VIDEO = "publishVideo";
    public static final String VIDEO_REASON_SUBSCRIBE_TO_VIDEO = "subscribeToVideo";
    public static final String VIDEO_REASON_QUALITY = "quality";
    public static final String VIDEO_REASON_CODEC_NOT_SUPPORTED = "codecNotSupported";
    public static final VideoUtils.Size NO_PREFERRED_RESOLUTION;
    public static final float NO_PREFERRED_FRAMERATE = Float.MAX_VALUE;
    private static final SparseArray<String> VideoReasonMap;
    protected VideoStatsListener videoStatsListener;
    protected AudioStatsListener audioStatsListener;
    protected SubscriberListener subscriberListener;
    protected SubscriberRtcStatsReportListener rtcStatsReportListener;
    protected VideoListener videoListener;
    protected AudioLevelListener audioLevelListener;
    protected CaptionsListener captionsListener;
    protected StreamListener streamListener;
    protected Session session;
    protected BaseVideoRenderer renderer;
    protected Stream stream;
    boolean resumeSubscribeToVideoOnSessionResume;
    boolean isPaused;
    SWIGTYPE_p_otc_subscriber otc_subscriber;
    swig_otc_subscriber_cb subscriber_cb;
    swig_otc_rtc_stats_report_cb rtc_stats_report_cb;
    private Handler handler;
    private final OtLog.LogToken log;

    @Deprecated
    public SubscriberKit(Context context, Stream stream) {
        this(context, stream, null);
    }

    protected SubscriberKit(Context context, Stream stream, BaseVideoRenderer baseVideoRenderer) {
        SubscriberKit subscriberKit = this;
        this.resumeSubscribeToVideoOnSessionResume = false;
        this.isPaused = false;
        this.log = new OtLog.LogToken(this);
        this.handler = new Handler(Looper.myLooper());
        subscriberKit.renderer = baseVideoRenderer;
        subscriberKit.session = null;
        subscriberKit.subscriber_cb = new swig_otc_subscriber_cb(this.build_native_subscriber_cb());
        this.otc_subscriber = e.a(stream.getOtc_stream(), this.subscriber_cb);
        e.d(this.otc_subscriber, k.d.a());
    }

    static {
        Loader.load();
        NO_PREFERRED_RESOLUTION = new VideoUtils.Size(Integer.MAX_VALUE, Integer.MAX_VALUE);
        VideoReasonMap = new SparseArray<String>(){
            {
                1 v0 = this;
                v0.append(1, SubscriberKit.VIDEO_REASON_PUBLISH_VIDEO);
                v0.append(2, SubscriberKit.VIDEO_REASON_SUBSCRIBE_TO_VIDEO);
                v0.append(3, SubscriberKit.VIDEO_REASON_QUALITY);
                v0.append(4, SubscriberKit.VIDEO_REASON_CODEC_NOT_SUPPORTED);
            }
        };
    }

    @Deprecated
    public void destroy() {
        this.log.d("Destroy(...) called", new Object[0]);
    }

    public void setSubscriberListener(SubscriberListener subscriberListener) {
        this.subscriberListener = subscriberListener;
    }

    public void setVideoListener(VideoListener videoListener) {
        this.videoListener = videoListener;
    }

    public void setAudioLevelListener(AudioLevelListener audioLevelListener) {
        this.audioLevelListener = audioLevelListener;
    }

    public void setCaptionsListener(CaptionsListener captionsListener) {
        this.captionsListener = captionsListener;
    }

    public void setAudioVolume(double d2) {
        e.a(this.otc_subscriber, d2);
    }

    public double getAudioVolume() {
        double[] dArray = new double[1];
        e.a(this.otc_subscriber, dArray);
        return dArray[0];
    }

    public void setStreamListener(StreamListener streamListener) {
        this.streamListener = streamListener;
    }

    public Session getSession() {
        return new Session(e.c(this.otc_subscriber), false);
    }

    public Stream getStream() {
        Object object;
        Object object2 = e.d(((SubscriberKit)object2).otc_subscriber);
        if (object2 == null) {
            object = object2 = null;
        } else {
            Stream stream;
            object = stream;
            stream = new Stream((SWIGTYPE_p_otc_stream)object2, false);
        }
        return object;
    }

    public boolean getSubscribeToAudio() {
        return Utils.intToBoolean(e.e(this.otc_subscriber));
    }

    public boolean getSubscribeToVideo() {
        return Utils.intToBoolean(e.g(this.otc_subscriber));
    }

    public boolean getSubscribeToCaptions() {
        return Utils.intToBoolean(e.f(this.otc_subscriber));
    }

    public void setSubscribeToAudio(boolean bl) {
        e.a(this.otc_subscriber, Utils.booleanToInt(bl));
    }

    public void setSubscribeToVideo(boolean bl) {
        e.c(this.otc_subscriber, Utils.booleanToInt(bl));
    }

    public void setSubscribeToCaptions(boolean bl) {
        e.b(this.otc_subscriber, Utils.booleanToInt(bl));
    }

    public void setStyle(String string, String string2) {
        BaseVideoRenderer baseVideoRenderer = ((SubscriberKit)((Object)baseVideoRenderer)).renderer;
        if (baseVideoRenderer != null) {
            baseVideoRenderer.setStyle(string, string2);
        }
    }

    @Deprecated
    public void setRenderer(BaseVideoRenderer baseVideoRenderer) {
        this.log.e("Renderer cannot be changed after the subscriber has been built. From 2.17 this method is empty", new Object[0]);
    }

    public BaseVideoRenderer getRenderer() {
        return this.renderer;
    }

    public View getView() {
        BaseVideoRenderer baseVideoRenderer = ((SubscriberKit)((Object)baseVideoRenderer)).renderer;
        if (baseVideoRenderer != null) {
            return baseVideoRenderer.getView();
        }
        return null;
    }

    public void setVideoStatsListener(VideoStatsListener videoStatsListener) {
        this.videoStatsListener = videoStatsListener;
    }

    public void setAudioStatsListener(AudioStatsListener audioStatsListener) {
        this.audioStatsListener = audioStatsListener;
    }

    public void setPreferredResolution(VideoUtils.Size size) {
        e.a(this.otc_subscriber, size.width, (long)size.height);
    }

    public void setPreferredFrameRate(float f2) {
        e.a(this.otc_subscriber, f2);
    }

    public VideoUtils.Size getPreferredResolution() {
        Object object = new long[1];
        long[] lArray = new long[1];
        if (e.a(((SubscriberKit)object).otc_subscriber, (long[])object, lArray) == g.c.a()) {
            int n = (int)object[0];
            return new VideoUtils.Size(n, (int)lArray[0]);
        }
        return NO_PREFERRED_RESOLUTION;
    }

    public void setRtcStatsReportListener(SubscriberRtcStatsReportListener object) {
        swig_otc_rtc_stats_report_cb swig_otc_rtc_stats_report_cb2;
        SubscriberRtcStatsReportListener subscriberRtcStatsReportListener = object;
        object = swig_otc_rtc_stats_report_cb2;
        this.rtc_stats_report_cb = new swig_otc_rtc_stats_report_cb(this.build_rtc_stats_report_cb());
        e.a(this.otc_subscriber, (otc_subscriber_rtc_stats_report_cb)object);
        this.rtcStatsReportListener = subscriberRtcStatsReportListener;
    }

    public void getRtcStatsReport() {
        e.b(this.otc_subscriber);
    }

    protected void onRtcStatsReport(String string) {
    }

    void onRtcStatsReportJNI(String string) {
        SubscriberKit subscriberKit = this;
        subscriberKit.log.d("onRtcStatsReportJNI(...) called", new Object[0]);
        subscriberKit.handler.post(() -> this.onRtcStatsReport(string));
        if (subscriberKit.rtcStatsReportListener != null) {
            this.handler.post(() -> {
                SubscriberRtcStatsReportListener subscriberRtcStatsReportListener = this.rtcStatsReportListener;
                if (subscriberRtcStatsReportListener != null) {
                    subscriberRtcStatsReportListener.onRtcStatsReport(this, string);
                }
            });
        }
    }

    public float getPreferredFrameRate() {
        Object object = new float[1];
        if (e.a(((SubscriberKit)object).otc_subscriber, (float[])object) == g.c.a()) {
            return (float)object[0];
        }
        return -1.0f;
    }

    void error(SubscriberKit subscriberKit, int n, String string) {
        this.throwError(new OpentokError(OpentokError.Domain.SubscriberErrorDomain, n, string));
    }

    void throwError(OpentokError opentokError) {
        this.onErrorJNI(opentokError.errorMessage, opentokError.errorCode.getErrorCode());
    }

    protected void onConnected() {
    }

    void onConnectedJNI() {
        SubscriberKit subscriberKit = this;
        subscriberKit.log.d("onConnected(...) called", new Object[0]);
        subscriberKit.handler.post(() -> this.onConnected());
        if (subscriberKit.subscriberListener != null) {
            this.handler.post(() -> {
                SubscriberListener subscriberListener = this.subscriberListener;
                if (subscriberListener != null) {
                    subscriberListener.onConnected(this);
                }
            });
        }
    }

    @Deprecated
    protected void onDisconnected() {
    }

    protected void onError(OpentokError opentokError) {
    }

    void onErrorJNI(String string, int n) {
        OpentokError opentokError;
        SubscriberKit subscriberKit = this;
        OpentokError opentokError2 = opentokError;
        opentokError = new OpentokError(OpentokError.Domain.SubscriberErrorDomain, n, string);
        subscriberKit.log.d("onError(...) called", new Object[0]);
        subscriberKit.handler.post(() -> this.onError(opentokError2));
        if (subscriberKit.subscriberListener != null) {
            this.handler.post(() -> {
                SubscriberListener subscriberListener = this.subscriberListener;
                if (subscriberListener != null) {
                    subscriberListener.onError(this, opentokError2);
                }
            });
        }
    }

    protected void onStreamDisconnected() {
    }

    void onStreamDisconnectedJNI() {
        SubscriberKit subscriberKit = this;
        subscriberKit.log.d("onStreamDisconnected(...) called", new Object[0]);
        subscriberKit.handler.post(() -> this.onStreamDisconnected());
        if (subscriberKit.streamListener != null) {
            this.handler.post(() -> {
                StreamListener streamListener = this.streamListener;
                if (streamListener != null) {
                    streamListener.onDisconnected(this);
                }
            });
        }
    }

    protected void onStreamReconnected() {
    }

    void onStreamReconnectedJNI() {
        SubscriberKit subscriberKit = this;
        subscriberKit.log.d("onStreamReconnected(...) called", new Object[0]);
        subscriberKit.handler.post(() -> this.onStreamReconnected());
        if (subscriberKit.streamListener != null) {
            this.handler.post(() -> {
                StreamListener streamListener = this.streamListener;
                if (streamListener != null) {
                    streamListener.onReconnected(this);
                }
            });
        }
    }

    protected void onAudioEnabled() {
    }

    void onAudioEnabledJNI() {
        SubscriberKit subscriberKit = this;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.getStream().getStreamId();
        subscriberKit.log.i("Stream: %s has audio enabled", objectArray2);
        subscriberKit.handler.post(() -> this.onAudioEnabled());
        if (subscriberKit.streamListener != null) {
            this.handler.post(() -> {
                StreamListener streamListener = this.streamListener;
                if (streamListener != null) {
                    streamListener.onAudioEnabled(this);
                }
            });
        }
    }

    protected void onAudioDisabled() {
    }

    void onAudioDisabledJNI() {
        SubscriberKit subscriberKit = this;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.getStream().getStreamId();
        subscriberKit.log.i("Stream: %s has audio disabled", objectArray2);
        subscriberKit.handler.post(() -> this.onAudioDisabled());
        if (subscriberKit.streamListener != null) {
            this.handler.post(() -> {
                StreamListener streamListener = this.streamListener;
                if (streamListener != null) {
                    streamListener.onAudioDisabled(this);
                }
            });
        }
    }

    protected void onVideoDisabled(String string) {
    }

    void onVideoDisabledJNI(int n) {
        SubscriberKit subscriberKit = this;
        subscriberKit.log.d("onVideoDisabled(...) callled", new Object[0]);
        String string = (String)VideoReasonMap.get(n);
        subscriberKit.handler.post(() -> this.onVideoDisabled(string));
        if (subscriberKit.videoListener != null) {
            this.handler.post(() -> {
                VideoListener videoListener = this.videoListener;
                if (videoListener != null) {
                    videoListener.onVideoDisabled(this, string);
                }
            });
        }
        if (this.renderer != null) {
            this.handler.post(() -> {
                BaseVideoRenderer baseVideoRenderer = ((SubscriberKit)((Object)baseVideoRenderer)).renderer;
                if (baseVideoRenderer != null) {
                    baseVideoRenderer.onVideoPropertiesChanged(false);
                }
            });
        }
    }

    protected void onVideoEnabled(String string) {
    }

    void onVideoEnabledJNI(int n) {
        SubscriberKit subscriberKit = this;
        subscriberKit.log.d("onVideoEnabled(...) callled", new Object[0]);
        String string = (String)VideoReasonMap.get(n);
        subscriberKit.handler.post(() -> this.onVideoEnabled(string));
        if (subscriberKit.videoListener != null) {
            this.handler.post(() -> {
                VideoListener videoListener = this.videoListener;
                if (videoListener != null) {
                    videoListener.onVideoEnabled(this, string);
                }
            });
        }
        if (this.renderer != null) {
            this.handler.post(() -> {
                BaseVideoRenderer baseVideoRenderer = ((SubscriberKit)((Object)baseVideoRenderer)).renderer;
                if (baseVideoRenderer != null) {
                    baseVideoRenderer.onVideoPropertiesChanged(true);
                }
            });
        }
    }

    protected void onVideoDisableWarning() {
    }

    void onVideoDisableWarningJNI() {
        SubscriberKit subscriberKit = this;
        subscriberKit.handler.post(() -> this.onVideoDisableWarning());
        if (subscriberKit.videoListener != null) {
            this.handler.post(() -> {
                VideoListener videoListener = this.videoListener;
                if (videoListener != null) {
                    videoListener.onVideoDisableWarning(this);
                }
            });
        }
    }

    protected void onVideoDisableWarningLifted() {
    }

    void onVideoDisableWarningLiftedJNI() {
        SubscriberKit subscriberKit = this;
        subscriberKit.handler.post(() -> this.onVideoDisableWarningLifted());
        if (subscriberKit.videoListener != null) {
            this.handler.post(() -> {
                VideoListener videoListener = this.videoListener;
                if (videoListener != null) {
                    videoListener.onVideoDisableWarningLifted(this);
                }
            });
        }
    }

    protected void onVideoDataReceived() {
    }

    void onVideoDataReceivedJNI() {
        SubscriberKit subscriberKit = this;
        subscriberKit.handler.post(() -> this.onVideoDataReceived());
        if (subscriberKit.videoListener != null) {
            this.handler.post(() -> {
                VideoListener videoListener = this.videoListener;
                if (videoListener != null) {
                    videoListener.onVideoDataReceived(this);
                }
            });
        }
    }

    protected void attachToSession(Session session) {
        this.session = session;
    }

    protected void detachFromSession(Session session) {
        this.session = null;
    }

    protected void onAudioLevelUpdated(float f2) {
    }

    void onAudioLevelUpdatedJNI(float f2) {
        SubscriberKit subscriberKit = this;
        subscriberKit.handler.post(() -> this.onAudioLevelUpdated(f2));
        if (subscriberKit.audioLevelListener != null) {
            this.handler.post(() -> {
                AudioLevelListener audioLevelListener = this.audioLevelListener;
                if (audioLevelListener != null) {
                    audioLevelListener.onAudioLevelUpdated(this, f2);
                }
            });
        }
    }

    protected void onCaptionText(String string, boolean bl) {
    }

    void onCaptionTextJNI(String string, boolean bl) {
        SubscriberKit subscriberKit = this;
        subscriberKit.handler.post(() -> this.onCaptionText(string, bl));
        if (subscriberKit.captionsListener != null) {
            this.handler.post(() -> {
                CaptionsListener captionsListener = this.captionsListener;
                if (captionsListener != null) {
                    captionsListener.onCaptionText(this, string, bl);
                }
            });
        }
    }

    void onFrameJNI(long l2) {
        BaseVideoRenderer baseVideoRenderer = ((SubscriberKit)((Object)frame)).renderer;
        if (baseVideoRenderer != null) {
            SubscriberKit subscriberKit = frame;
            BaseVideoRenderer.Frame frame = baseVideoRenderer.buildFrameInstance();
            frame.copyOtcFrame(l2, null);
            subscriberKit.renderer.onFrame(frame);
        }
    }

    void onAudioStatsJNI(SubscriberAudioStats subscriberAudioStats) {
        if (this.audioStatsListener != null) {
            this.handler.post(() -> {
                AudioStatsListener audioStatsListener = this.audioStatsListener;
                if (audioStatsListener != null) {
                    audioStatsListener.onAudioStats(this, subscriberAudioStats);
                }
            });
        }
    }

    void onVideoStatsJNI(SubscriberVideoStats subscriberVideoStats) {
        if (this.videoStatsListener != null) {
            this.handler.post(() -> {
                VideoStatsListener videoStatsListener = this.videoStatsListener;
                if (videoStatsListener != null) {
                    videoStatsListener.onVideoStats(this, subscriberVideoStats);
                }
            });
        }
    }

    SWIGTYPE_p_otc_subscriber getOtcSubscriber() {
        return this.otc_subscriber;
    }

    public void onPause() {
        SubscriberKit subscriberKit = this;
        subscriberKit.log.d("onPause() called", new Object[0]);
        BaseVideoRenderer baseVideoRenderer = subscriberKit.renderer;
        if (baseVideoRenderer != null) {
            baseVideoRenderer.onPause();
        }
        SubscriberKit subscriberKit2 = this;
        subscriberKit2.resumeSubscribeToVideoOnSessionResume = subscriberKit2.getSubscribeToVideo();
        subscriberKit2.setSubscribeToVideo(false);
        subscriberKit2.isPaused = true;
    }

    public void onResume() {
        SubscriberKit subscriberKit = baseVideoRenderer;
        subscriberKit.log.d("onResume() called", new Object[0]);
        if (subscriberKit.isPaused) {
            SubscriberKit subscriberKit2 = baseVideoRenderer;
            subscriberKit2.isPaused = false;
            subscriberKit2.setSubscribeToVideo(subscriberKit2.resumeSubscribeToVideoOnSessionResume);
            BaseVideoRenderer baseVideoRenderer = subscriberKit2.renderer;
            if (baseVideoRenderer != null) {
                baseVideoRenderer.onResume();
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(observable instanceof Session)) {
            return;
        }
        if (!(object instanceof Session.SessionPauseResumeEvent)) {
            return;
        }
        if (((Session.SessionPauseResumeEvent)object).isSessionPaused()) {
            this.onPause();
        } else {
            this.onResume();
        }
    }

    protected void finalize() {
        SubscriberKit subscriberKit = this;
        subscriberKit.log.d("finalize()", new Object[0]);
        Object object = subscriberKit.otc_subscriber;
        if (object != null) {
            e.a((SWIGTYPE_p_otc_subscriber)object);
            this.otc_subscriber = null;
            object = this.rtc_stats_report_cb;
            long l2 = object != null ? ((swig_otc_rtc_stats_report_cb)object).getCPointer() : 0L;
            swig_otc_subscriber_cb swig_otc_subscriber_cb2 = this.subscriber_cb;
            if (swig_otc_subscriber_cb2 != null) {
                this.destroy_native_subscriber_cb(swig_otc_subscriber_cb2.getCPointer(), l2);
            }
        }
        super.finalize();
    }

    native long build_native_subscriber_cb();

    native void destroy_native_subscriber_cb(long var1, long var3);

    native long build_rtc_stats_report_cb();

    static class swig_otc_rtc_stats_report_cb
    extends otc_subscriber_rtc_stats_report_cb {
        public swig_otc_rtc_stats_report_cb(long l2) {
            super(l2, false);
        }

        public long getCPointer() {
            return otc_subscriber_rtc_stats_report_cb.getCPtr(this);
        }
    }

    static class swig_otc_subscriber_cb
    extends otc_subscriber_callbacks {
        public swig_otc_subscriber_cb(long l2) {
            super(l2, false);
        }

        public long getCPointer() {
            return otc_subscriber_callbacks.getCPtr(this);
        }
    }

    public static class Builder {
        Context context;
        Stream stream;
        BaseVideoRenderer renderer;

        public Builder(Context context, Stream stream) {
            this.context = context;
            this.stream = stream;
        }

        public Builder renderer(BaseVideoRenderer baseVideoRenderer) {
            this.renderer = baseVideoRenderer;
            return this;
        }

        public SubscriberKit build() {
            Builder builder = builder2;
            Builder builder2 = builder.context;
            Stream stream = builder.stream;
            BaseVideoRenderer baseVideoRenderer = builder.renderer;
            return new SubscriberKit((Context)builder2, stream, baseVideoRenderer);
        }
    }

    public static interface SubscriberRtcStatsReportListener {
        public void onRtcStatsReport(SubscriberKit var1, String var2);
    }

    public static interface AudioStatsListener {
        public void onAudioStats(SubscriberKit var1, SubscriberAudioStats var2);
    }

    public static interface VideoStatsListener {
        public void onVideoStats(SubscriberKit var1, SubscriberVideoStats var2);
    }

    public static class SubscriberAudioStats {
        public int audioPacketsLost;
        public int audioPacketsReceived;
        public int audioBytesReceived;
        public double timeStamp;

        SubscriberAudioStats(int n, int n2, int n3, double d2) {
            this.audioPacketsLost = n;
            this.audioPacketsReceived = n2;
            this.audioBytesReceived = n3;
            this.timeStamp = d2;
        }
    }

    public static class SubscriberVideoStats {
        public int videoPacketsLost;
        public int videoPacketsReceived;
        public int videoBytesReceived;
        public double timeStamp;

        SubscriberVideoStats(int n, int n2, int n3, double d2) {
            this.videoPacketsLost = n;
            this.videoPacketsReceived = n2;
            this.videoBytesReceived = n3;
            this.timeStamp = d2;
        }
    }

    public static interface StreamListener {
        public void onReconnected(SubscriberKit var1);

        public void onDisconnected(SubscriberKit var1);

        default public void onAudioEnabled(SubscriberKit subscriberKit) {
        }

        default public void onAudioDisabled(SubscriberKit subscriberKit) {
        }
    }

    public static interface CaptionsListener {
        public void onCaptionText(SubscriberKit var1, String var2, boolean var3);
    }

    public static interface AudioLevelListener {
        public void onAudioLevelUpdated(SubscriberKit var1, float var2);
    }

    public static interface VideoListener {
        public void onVideoDataReceived(SubscriberKit var1);

        public void onVideoDisabled(SubscriberKit var1, String var2);

        public void onVideoEnabled(SubscriberKit var1, String var2);

        public void onVideoDisableWarning(SubscriberKit var1);

        public void onVideoDisableWarningLifted(SubscriberKit var1);
    }

    public static interface SubscriberListener {
        public void onConnected(SubscriberKit var1);

        public void onDisconnected(SubscriberKit var1);

        public void onError(SubscriberKit var1, OpentokError var2);
    }
}

