/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.webrtc.voiceengine61;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Process;
import com.vonage.webrtc.ContextUtils;
import com.vonage.webrtc.Logging;
import com.vonage.webrtc.voiceengine61.WebRtcAudioUtils;
import java.nio.ByteBuffer;

public class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static volatile boolean speakerMute = false;
    private static WebRtcAudioTrackErrorCallback errorCallback;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private ByteBuffer byteBuffer;
    private AudioTrack audioTrack;
    private AudioTrackThread audioThread;
    private byte[] emptyBytes;

    public static void setErrorCallback(WebRtcAudioTrackErrorCallback webRtcAudioTrackErrorCallback) {
        Logging.d((String)TAG, (String)"Set error callback");
        errorCallback = webRtcAudioTrackErrorCallback;
    }

    WebRtcAudioTrack(long l2) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        this.audioTrack = null;
        this.audioThread = null;
        Logging.d((String)TAG, (String)("ctor" + WebRtcAudioUtils.getThreadInfo()));
        webRtcAudioTrack.nativeAudioTrack = l2;
        webRtcAudioTrack.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initPlayout(int n, int n2) {
        block5: {
            AudioTrack audioTrack;
            WebRtcAudioTrack webRtcAudioTrack = this;
            Logging.d((String)TAG, (String)("initPlayout(sampleRate=" + n + ", channels=" + n2 + ")"));
            webRtcAudioTrack.byteBuffer = ByteBuffer.allocateDirect(n2 * 2 * (n / 100));
            Logging.d((String)TAG, (String)("byteBuffer.capacity: " + this.byteBuffer.capacity()));
            webRtcAudioTrack.emptyBytes = new byte[webRtcAudioTrack.byteBuffer.capacity()];
            ByteBuffer byteBuffer = webRtcAudioTrack.byteBuffer;
            long l2 = webRtcAudioTrack.nativeAudioTrack;
            webRtcAudioTrack.nativeCacheDirectBufferAddress(byteBuffer, l2);
            int n3 = this.channelCountToConfiguration(n2);
            int n4 = AudioTrack.getMinBufferSize((int)n, (int)n3, (int)2);
            Logging.d((String)TAG, (String)("AudioTrack.getMinBufferSize: " + n4));
            if (n4 < this.byteBuffer.capacity()) {
                this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
                return false;
            }
            if (this.audioTrack != null) {
                this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
                return false;
            }
            try {
                this.audioTrack = WebRtcAudioUtils.runningOnLollipopOrHigher() ? this.createAudioTrackOnLollipopOrHigher(n, n3, n4) : new AudioTrack(0, n, n3, 2, n4, 1);
                audioTrack = this.audioTrack;
                if (audioTrack == null) break block5;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = illegalArgumentException.getMessage();
                WebRtcAudioTrack webRtcAudioTrack2 = this;
                webRtcAudioTrack2.reportWebRtcAudioTrackInitError(string);
                webRtcAudioTrack2.releaseAudioResources();
                return false;
            }
            if (audioTrack.getState() == 1) {
                WebRtcAudioTrack webRtcAudioTrack3 = this;
                webRtcAudioTrack3.logMainParameters();
                webRtcAudioTrack3.logMainParametersExtended();
                return true;
            }
        }
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
        webRtcAudioTrack.releaseAudioResources();
        return false;
    }

    private boolean startPlayout() {
        AudioTrackThread audioTrackThread;
        Logging.d((String)TAG, (String)"startPlayout");
        WebRtcAudioTrack.assertTrue(this.audioTrack != null);
        WebRtcAudioTrack.assertTrue(this.audioThread == null);
        if (this.audioTrack.getState() != 1) {
            this.reportWebRtcAudioTrackStartError("AudioTrack instance is not successfully initialized.");
            return false;
        }
        AudioTrackThread audioTrackThread2 = audioTrackThread;
        audioTrackThread2("AudioTrackJavaThread");
        this.audioThread = audioTrackThread2;
        audioTrackThread.start();
        return true;
    }

    private boolean stopPlayout() {
        Logging.d((String)TAG, (String)"stopPlayout");
        WebRtcAudioTrack.assertTrue(this.audioThread != null);
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.logUnderrunCount();
        webRtcAudioTrack.audioThread.joinThread();
        webRtcAudioTrack.audioThread = null;
        webRtcAudioTrack.releaseAudioResources();
        return true;
    }

    private int getStreamMaxVolume() {
        Logging.d((String)TAG, (String)"getStreamMaxVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamMaxVolume(0);
    }

    private boolean setStreamVolume(int n) {
        Logging.d((String)TAG, (String)("setStreamVolume(" + n + ")"));
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        if (this.isVolumeFixed()) {
            Logging.e((String)TAG, (String)"The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, n, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (!WebRtcAudioUtils.runningOnLollipopOrHigher()) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        Logging.d((String)TAG, (String)"getStreamVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamVolume(0);
    }

    private void logMainParameters() {
        Logging.d((String)TAG, (String)("AudioTrack: session ID: " + this.audioTrack.getAudioSessionId() + ", channels: " + this.audioTrack.getChannelCount() + ", sample rate: " + this.audioTrack.getSampleRate() + ", max gain: " + AudioTrack.getMaxVolume()));
    }

    @TargetApi(value=21)
    private AudioTrack createAudioTrackOnLollipopOrHigher(int n, int n2, int n3) {
        Logging.d((String)TAG, (String)"createAudioTrackOnLollipopOrHigher");
        int n4 = AudioTrack.getNativeOutputSampleRate((int)0);
        Logging.d((String)TAG, (String)("nativeOutputSampleRate: " + n4));
        if (n != n4) {
            Logging.w((String)TAG, (String)"Unable to use fast mode since requested sample rate is not native");
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(2).setContentType(1).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(n).setChannelMask(n2).build(), n3, 1, 0);
    }

    @TargetApi(value=24)
    private void logMainParametersExtended() {
        if (WebRtcAudioUtils.runningOnMarshmallowOrHigher()) {
            Logging.d((String)TAG, (String)("AudioTrack: buffer size in frames: " + this.audioTrack.getBufferSizeInFrames()));
        }
        if (WebRtcAudioUtils.runningOnNougatOrHigher()) {
            Logging.d((String)TAG, (String)("AudioTrack: buffer capacity in frames: " + this.audioTrack.getBufferCapacityInFrames()));
        }
    }

    @TargetApi(value=24)
    private void logUnderrunCount() {
        if (WebRtcAudioUtils.runningOnNougatOrHigher()) {
            Logging.d((String)TAG, (String)("underrun count: " + this.audioTrack.getUnderrunCount()));
        }
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n) {
        return n == 1 ? 4 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    public static void setSpeakerMute(boolean bl) {
        Logging.w((String)TAG, (String)("setSpeakerMute(" + bl + ")"));
        speakerMute = bl;
    }

    private void releaseAudioResources() {
        AudioTrack audioTrack = this.audioTrack;
        if (audioTrack != null) {
            audioTrack.release();
            this.audioTrack = null;
        }
    }

    private void reportWebRtcAudioTrackInitError(String string) {
        Logging.e((String)TAG, (String)("Init error: " + string));
        WebRtcAudioTrackErrorCallback webRtcAudioTrackErrorCallback = errorCallback;
        if (webRtcAudioTrackErrorCallback != null) {
            webRtcAudioTrackErrorCallback.onWebRtcAudioTrackInitError(string);
        }
    }

    private void reportWebRtcAudioTrackStartError(String string) {
        Logging.e((String)TAG, (String)("Start error: " + string));
        WebRtcAudioTrackErrorCallback webRtcAudioTrackErrorCallback = errorCallback;
        if (webRtcAudioTrackErrorCallback != null) {
            webRtcAudioTrackErrorCallback.onWebRtcAudioTrackStartError(string);
        }
    }

    private void reportWebRtcAudioTrackError(String string) {
        Logging.e((String)TAG, (String)("Run-time playback error: " + string));
        WebRtcAudioTrackErrorCallback webRtcAudioTrackErrorCallback = errorCallback;
        if (webRtcAudioTrackErrorCallback != null) {
            webRtcAudioTrackErrorCallback.onWebRtcAudioTrackError(string);
        }
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        @TargetApi(value=21)
        private int writeOnLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int n) {
            return audioTrack.write(byteBuffer, n, 0);
        }

        private int writePreLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int n) {
            ByteBuffer byteBuffer2 = byteBuffer;
            Object object = byteBuffer2.array();
            return audioTrack.write((byte[])object, byteBuffer2.arrayOffset(), n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int n;
            AudioTrackThread audioTrackThread = this;
            Process.setThreadPriority((int)-19);
            Logging.d((String)WebRtcAudioTrack.TAG, (String)("AudioTrackThread" + WebRtcAudioUtils.getThreadInfo()));
            try {
                audioTrackThread.WebRtcAudioTrack.this.audioTrack.play();
                n = audioTrackThread.WebRtcAudioTrack.this.audioTrack.getPlayState() == 3 ? 1 : 0;
                WebRtcAudioTrack.assertTrue(n != 0);
                n = WebRtcAudioTrack.this.byteBuffer.capacity();
            }
            catch (IllegalStateException illegalStateException) {
                AudioTrackThread audioTrackThread2 = this;
                audioTrackThread2.WebRtcAudioTrack.this.reportWebRtcAudioTrackStartError("AudioTrack.play failed: " + illegalStateException.getMessage());
                audioTrackThread2.WebRtcAudioTrack.this.releaseAudioResources();
                return;
            }
            while (this.keepAlive) {
                int n2;
                AudioTrackThread audioTrackThread3 = this;
                WebRtcAudioTrack webRtcAudioTrack = audioTrackThread3.WebRtcAudioTrack.this;
                webRtcAudioTrack.nativeGetPlayoutData(n, webRtcAudioTrack.nativeAudioTrack);
                WebRtcAudioTrack.assertTrue(n <= audioTrackThread3.WebRtcAudioTrack.this.byteBuffer.remaining());
                if (speakerMute) {
                    AudioTrackThread audioTrackThread4 = this;
                    audioTrackThread4.WebRtcAudioTrack.this.byteBuffer.clear();
                    audioTrackThread4.WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    audioTrackThread4.WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                if (WebRtcAudioUtils.runningOnLollipopOrHigher()) {
                    AudioTrackThread audioTrackThread5 = this;
                    n2 = audioTrackThread5.writeOnLollipop(audioTrackThread5.WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n);
                } else {
                    AudioTrackThread audioTrackThread6 = this;
                    n2 = audioTrackThread6.writePreLollipop(audioTrackThread6.WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n);
                }
                if (n2 != n) {
                    Logging.e((String)WebRtcAudioTrack.TAG, (String)("AudioTrack.write failed: " + n2));
                    if (n2 == -3) {
                        this.keepAlive = false;
                        WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write failed: " + n2);
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            try {
                WebRtcAudioTrack.this.audioTrack.stop();
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e((String)WebRtcAudioTrack.TAG, (String)("AudioTrack.stop failed: " + illegalStateException.getMessage()));
            }
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 1);
            WebRtcAudioTrack.this.audioTrack.flush();
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static interface WebRtcAudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(String var1);

        public void onWebRtcAudioTrackError(String var1);
    }
}

