/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import com.opentok.android.OpentokError;
import com.opentok.android.OtLog;
import com.opentok.android.Publisher;
import com.opentok.android.PublisherKit;
import com.opentok.impl.a;
import com.opentok.otc.opentokJNI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseVideoCapturer {
    public static final int NV21 = 1;
    public static final int ARGB = 2;
    public static final int YUV420P = 3;
    public static final int NV12 = 4;
    public static final int YUY2 = 5;
    public static final int UYVY = 6;
    public static final int BGRA = 7;
    public static final int RGB = 8;
    public static final int MJPEG = 9;
    public static final int ABGR = 10;
    public static final int RGBA = 11;
    protected boolean frameMirrorX = false;
    boolean isStopped = false;
    private PublisherKit publisherKit;
    private final OtLog.LogToken log;

    public BaseVideoCapturer() {
        OtLog.LogToken logToken;
        OtLog.LogToken logToken2 = logToken;
        logToken = new OtLog.LogToken(this);
        this.log = logToken2;
    }

    private int mapFormatToOTCFormat(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Invalid pixel format");
            }
            case 11: {
                return 11;
            }
            case 10: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 8: {
                return 8;
            }
            case 7: {
                return 7;
            }
            case 6: {
                return 5;
            }
            case 5: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 6;
            }
            case 1: 
        }
        return 3;
    }

    private native void provideFramePlanarNative(long var1, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, byte[] var15);

    private native void proviveByteFrameNative(long var1, byte[] var3, int var4, int var5, int var6, int var7, byte[] var8);

    private native void provideByteBufferFrameNative(long var1, ByteBuffer var3, int var4, int var5, int var6, int var7, byte[] var8);

    private native void provideIntArrayFrameNative(long var1, int[] var3, int var4, int var5, int var6, int var7, byte[] var8);

    public void setVideoContentHint(VideoContentHint videoContentHint) {
        long l;
        PublisherKit publisherKit = ((BaseVideoCapturer)((Object)publisherKit)).publisherKit;
        if (publisherKit != null && (l = publisherKit.otcCapturerHandle) != 0L) {
            opentokJNI.otc_video_capturer_set_content_hint(l, videoContentHint.getValue());
            return;
        }
        throw new IllegalStateException("Content hint can only be set after constructing the Publisher and Capturer.");
    }

    public VideoContentHint getVideoContentHint() {
        long l;
        PublisherKit publisherKit = ((BaseVideoCapturer)((Object)publisherKit)).publisherKit;
        if (publisherKit != null && (l = publisherKit.otcCapturerHandle) != 0L) {
            return VideoContentHint.valueOf(opentokJNI.otc_video_capturer_get_content_hint(l));
        }
        throw new IllegalStateException("Content hint can only be accessed after constructing the Publisher and Capturer.");
    }

    public abstract void init();

    public abstract int startCapture();

    public abstract int stopCapture();

    public abstract void destroy();

    public abstract boolean isCaptureStarted();

    public abstract CaptureSettings getCaptureSettings();

    public abstract void onPause();

    public abstract void onResume();

    public void onStop() {
        BaseVideoCapturer baseVideoCapturer = this;
        baseVideoCapturer.log.d("onStop() enter", new Object[0]);
        if (baseVideoCapturer.isStopped) {
            this.log.e("onStop() called on a capturer already stopped", new Object[0]);
            return;
        }
        BaseVideoCapturer baseVideoCapturer2 = this;
        baseVideoCapturer2.stopCapture();
        baseVideoCapturer2.destroy();
        baseVideoCapturer2.isStopped = true;
        baseVideoCapturer2.log.d("onStop() exit", new Object[0]);
    }

    public void onRestart() {
        BaseVideoCapturer baseVideoCapturer = this;
        baseVideoCapturer.log.d("onRestart() enter", new Object[0]);
        if (!baseVideoCapturer.isStopped) {
            this.log.e("onRestart called on a capturer not being stopped", new Object[0]);
            return;
        }
        BaseVideoCapturer baseVideoCapturer2 = this;
        baseVideoCapturer2.init();
        baseVideoCapturer2.startCapture();
        baseVideoCapturer2.isStopped = false;
        baseVideoCapturer2.log.d("onRestart() exit", new Object[0]);
    }

    public void provideByteArrayFrame(byte[] byArray, int n, int n2, int n3, int n4, boolean bl) {
        this.provideByteArrayFrame(byArray, n, n2, n3, n4, bl, null);
    }

    public void provideByteArrayFrame(byte[] byArray, int n, int n2, int n3, int n4, boolean bl, byte[] byArray2) {
        PublisherKit publisherKit = this.publisherKit;
        if (publisherKit != null && byArray != null && n2 > 0 && n3 > 0) {
            long l = publisherKit.otcCapturerHandle;
            if (l == 0L) {
                return;
            }
            BaseVideoCapturer baseVideoCapturer = this;
            baseVideoCapturer.frameMirrorX = bl;
            int n5 = baseVideoCapturer.mapFormatToOTCFormat(n);
            baseVideoCapturer.proviveByteFrameNative(l, byArray, n5, n2, n3, n4, byArray2);
            return;
        }
    }

    public void provideIntArrayFrame(int[] nArray, int n, int n2, int n3, int n4, boolean bl) {
        this.provideIntArrayFrame(nArray, n, n2, n3, n4, bl, null);
    }

    public void provideIntArrayFrame(int[] nArray, int n, int n2, int n3, int n4, boolean bl, byte[] byArray) {
        PublisherKit publisherKit = this.publisherKit;
        if (publisherKit != null && nArray != null && n2 > 0 && n3 > 0) {
            long l = publisherKit.otcCapturerHandle;
            if (l == 0L) {
                return;
            }
            BaseVideoCapturer baseVideoCapturer = this;
            baseVideoCapturer.frameMirrorX = bl;
            int n5 = baseVideoCapturer.mapFormatToOTCFormat(n);
            baseVideoCapturer.provideIntArrayFrameNative(l, nArray, n5, n2, n3, n4, byArray);
            return;
        }
    }

    public void provideBufferFrame(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, boolean bl) {
        this.provideBufferFrame(byteBuffer, n, n2, n3, n4, bl, null);
    }

    public void provideBufferFrame(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, boolean bl, byte[] byArray) {
        PublisherKit publisherKit = this.publisherKit;
        if (publisherKit != null && byteBuffer != null && n2 > 0 && n3 > 0) {
            long l = publisherKit.otcCapturerHandle;
            if (l == 0L) {
                return;
            }
            BaseVideoCapturer baseVideoCapturer = this;
            baseVideoCapturer.frameMirrorX = bl;
            int n5 = baseVideoCapturer.mapFormatToOTCFormat(n);
            baseVideoCapturer.provideByteBufferFrameNative(l, byteBuffer, n5, n2, n3, n4, byArray);
            return;
        }
    }

    public void provideBufferFramePlanar(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        this.provideBufferFramePlanar(byteBuffer, byteBuffer2, byteBuffer3, n, n2, n3, n4, n5, n6, n7, n8, n9, bl, null);
    }

    public void provideBufferFramePlanar(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, byte[] byArray) {
        PublisherKit publisherKit = this.publisherKit;
        if (publisherKit != null && n7 > 0 && n8 > 0) {
            long l = publisherKit.otcCapturerHandle;
            if (l == 0L) {
                return;
            }
            this.frameMirrorX = bl;
            this.provideFramePlanarNative(l, byteBuffer, byteBuffer2, byteBuffer3, n, n2, n3, n4, n5, n6, n7, n8, n9, byArray);
            return;
        }
    }

    protected void onCaptureError(Exception object) {
        OpentokError opentokError;
        this.log.d("onCaptureError() enter.", new Object[0]);
        if (object != null) {
            OpentokError opentokError2;
            opentokError = opentokError2;
            opentokError2 = new OpentokError(OpentokError.Domain.PublisherErrorDomain, OpentokError.ErrorCode.VideoCaptureFailed.getErrorCode(), (Exception)object);
        } else {
            a a2;
            opentokError = a2;
            a2 = new a(OpentokError.Domain.PublisherErrorDomain, OpentokError.ErrorCode.VideoCaptureFailed.getErrorCode());
        }
        object = this.publisherKit;
        if (object != null) {
            ((PublisherKit)object).throwError(opentokError);
        }
        this.log.d("onCaptureError() exit.", new Object[0]);
    }

    protected void onCameraChanged(int n) {
        PublisherKit publisherKit = ((BaseVideoCapturer)((Object)publisherKit)).publisherKit;
        if (publisherKit instanceof Publisher) {
            Publisher publisher = (Publisher)publisherKit;
            publisher.onPublisherCameraPositionChanged(publisher, n);
        }
    }

    protected void setPublisherKit(PublisherKit publisherKit) {
        this.publisherKit = publisherKit;
    }

    public static enum VideoContentHint {
        NONE(0),
        MOTION(1),
        DETAIL(2),
        TEXT(3);

        private static final Map<Object, Object> map;
        private final int value;

        private VideoContentHint(int n2) {
            this.value = n2;
        }

        public static VideoContentHint valueOf(int n) {
            return (VideoContentHint)((Object)map.get(n));
        }

        static {
            map = new HashMap<Object, Object>();
            for (VideoContentHint videoContentHint : VideoContentHint.values()) {
                map.put(videoContentHint.value, (Object)videoContentHint);
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    public static interface CaptureSwitch {
        public void cycleCamera();

        public int getCameraIndex();

        public void swapCamera(int var1);
    }

    public static class CaptureSettings {
        public int format;
        public int width;
        public int height;
        public int fps;
        public int expectedDelay;
        public boolean mirrorInLocalRender;
    }
}

