/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.view.View;
import com.opentok.otc.SWIGTYPE_p_otc_video_frame;
import com.opentok.otc.c;
import com.opentok.otc.d;
import com.opentok.otc.e;
import com.opentok.otc.j;
import com.opentok.otc.opentokJNI;
import com.opentok.otc.otc_video_frame_format;
import java.nio.ByteBuffer;

public abstract class BaseVideoRenderer {
    public static final String STYLE_VIDEO_SCALE = "STYLE_VIDEO_SCALE";
    public static final String STYLE_VIDEO_FILL = "STYLE_VIDEO_FILL";
    public static final String STYLE_VIDEO_FIT = "STYLE_VIDEO_FIT";

    public abstract void onFrame(Frame var1);

    public abstract void setStyle(String var1, String var2);

    public abstract void onVideoPropertiesChanged(boolean var1);

    public abstract View getView();

    public abstract void onPause();

    public abstract void onResume();

    Frame buildFrameInstance() {
        return new Frame();
    }

    public final class Frame {
        protected long internalBuffer;
        protected ByteBuffer buffer;
        protected otc_video_frame_format format;
        protected int width;
        protected int height;
        protected boolean mirrored;
        protected int yStride;
        protected int uvStride;
        protected byte[] metadata;
        swig_otc_video_frame otcFrame;

        protected Frame() {
        }

        private native ByteBuffer get_frame_byte_buffer(long var1);

        private native ByteBuffer get_frame_plane_byte_buffer(long var1, int var3);

        private native long copy_video_frame(long var1);

        private native void convert_in_place(long var1, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5, int var6, int var7);

        @Deprecated
        public void recycle() {
        }

        protected void finalize() {
            Frame frame = this;
            super.finalize();
            frame.destroy();
        }

        public void destroy() {
            swig_otc_video_frame swig_otc_video_frame2 = this.otcFrame;
            if (swig_otc_video_frame2 != null && swig_otc_video_frame2.getCPtr() != 0L) {
                this.otcFrame.destroy();
            }
            Frame frame = this;
            frame.buffer = null;
            frame.otcFrame = null;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getFormat() {
            return this.format.a();
        }

        public boolean isMirroredX() {
            return this.mirrored;
        }

        public int getYstride() {
            return this.yStride;
        }

        public int getUvStride() {
            return this.uvStride;
        }

        public byte[] getMetadata() {
            return this.metadata;
        }

        public ByteBuffer getYplane() {
            Frame frame = this;
            return frame.get_frame_plane_byte_buffer(frame.otcFrame.getCPtr(), j.c.a());
        }

        public ByteBuffer getUplane() {
            Frame frame = this;
            return frame.get_frame_plane_byte_buffer(frame.otcFrame.getCPtr(), j.d.a());
        }

        public ByteBuffer getVplane() {
            Frame frame = this;
            return frame.get_frame_plane_byte_buffer(frame.otcFrame.getCPtr(), j.e.a());
        }

        public int getYplaneSize() {
            return (int)e.a((SWIGTYPE_p_otc_video_frame)this.otcFrame, j.c);
        }

        public int getUVplaneSize() {
            return (int)e.a((SWIGTYPE_p_otc_video_frame)this.otcFrame, j.d);
        }

        public void convertInPlace(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, int n, int n2) {
            Frame frame = this;
            frame.convert_in_place(frame.otcFrame.getCPtr(), byteBuffer, byteBuffer2, byteBuffer3, n, n2);
        }

        void copyOtcFrame(long l, Boolean bl) {
            swig_otc_video_frame swig_otc_video_frame2;
            Frame frame = this;
            l = frame.copy_video_frame(l);
            swig_otc_video_frame swig_otc_video_frame3 = swig_otc_video_frame2;
            frame.otcFrame = new swig_otc_video_frame(l);
            frame.buffer = frame.get_frame_byte_buffer(swig_otc_video_frame3.getCPtr());
            frame.format = e.a(frame.otcFrame);
            frame.height = e.b(frame.otcFrame);
            frame.width = e.c(frame.otcFrame);
            frame.yStride = e.b(frame.otcFrame, j.c);
            frame.uvStride = e.b(frame.otcFrame, j.d);
            if (bl != null) {
                this.mirrored = bl;
            }
            c c2 = e.a();
            d d2 = e.a((SWIGTYPE_p_otc_video_frame)this.otcFrame, c2);
            int n = (int)e.a(c2);
            this.metadata = new byte[n];
            for (int k = 0; k < n; ++k) {
                this.metadata[k] = (byte)e.a(d2, (long)k);
            }
        }
    }

    static class swig_otc_video_frame
    extends SWIGTYPE_p_otc_video_frame {
        public swig_otc_video_frame(long l) {
            super(l, true);
        }

        public long getCPtr() {
            return SWIGTYPE_p_otc_video_frame.getCPtr(this);
        }

        public void destroy() {
            if (this.getCPtr() != 0L) {
                opentokJNI.otc_video_frame_delete(this.getCPtr());
            }
        }
    }
}

