/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import com.opentok.android.BaseAudioDevice;
import com.opentok.android.DefaultAudioDevice;
import com.opentok.android.OtLog;
import java.util.List;

class BluetoothManager {
    public static final int MAX_SCO_CONNECTION_ATTEMPTS = 6;
    public static final int SCO_CONNECTION_ATTEMPT_DELAY = 25;
    final OtLog.LogToken log;
    private State bluetoothConnectionState;
    private boolean isBluetoothBroadcastReceiverRegistered;
    int scoConnectionAttempts;
    private BluetoothAdapter bluetoothAdapter;
    BluetoothProfile bluetoothProfile;
    private final AudioManager audioManager;
    Context audioDeviceContext;
    DefaultAudioDevice audioDevice;
    BluetoothDevice bluetoothDevice;
    private final BluetoothProfile.ServiceListener bluetoothProfileServiceListener;
    final BroadcastReceiver bluetoothBroadcastReceiver;

    static BluetoothManager create(Context context, DefaultAudioDevice defaultAudioDevice) {
        return new BluetoothManager(context, defaultAudioDevice);
    }

    protected BluetoothManager(Context context, DefaultAudioDevice defaultAudioDevice) {
        AudioManager audioManager;
        OtLog.LogToken logToken;
        OtLog.LogToken logToken2 = logToken;
        BluetoothManager bluetoothManager = this;
        OtLog.LogToken logToken3 = logToken2;
        logToken3(this);
        bluetoothManager.log = logToken3;
        bluetoothManager.scoConnectionAttempts = 0;
        bluetoothManager.bluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onServiceConnected(int n, BluetoothProfile object) {
                1 v0 = this;
                BluetoothManager bluetoothManager = v0.BluetoothManager.this;
                synchronized (bluetoothManager) {
                    Throwable throwable2;
                    block11: {
                        block10: {
                            block8: {
                                block9: {
                                    Intent intent;
                                    1 v2;
                                    List list;
                                    try {
                                        if (!v0.BluetoothManager.this.hasBluetoothPermission()) {
                                            return;
                                        }
                                        BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceConnected() enter.", new Object[0]);
                                        if (1 != n) break block8;
                                        BluetoothManager.this.bluetoothProfile = object;
                                        list = object.getConnectedDevices();
                                        if (list.isEmpty() || 2 != object.getConnectionState((BluetoothDevice)list.get(0))) break block9;
                                        1 v1 = this;
                                        v2 = v1;
                                        v1.BluetoothManager.this.bluetoothDevice = (BluetoothDevice)list.get(0);
                                        v1.BluetoothManager.this.log.d("Connected to bluetooth headset " + BluetoothManager.this.bluetoothDevice.getName(), new Object[0]);
                                    }
                                    catch (Throwable throwable2) {
                                        break block11;
                                    }
                                    list = intent;
                                    new Intent("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED").putExtra("android.bluetooth.profile.extra.STATE", 2);
                                    object = v2.BluetoothManager.this;
                                    object.bluetoothBroadcastReceiver.onReceive(object.audioDeviceContext, (Intent)list);
                                    break block10;
                                }
                                BluetoothManager.this.log.d("No bluetooth headset connected.", new Object[0]);
                                break block10;
                            }
                            BluetoothManager.this.log.d("profile = " + n, new Object[0]);
                        }
                        BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceConnected() exit.", new Object[0]);
                        return;
                    }
                    throw throwable2;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onServiceDisconnected(int n) {
                1 v0 = this;
                BluetoothManager bluetoothManager = v0.BluetoothManager.this;
                synchronized (bluetoothManager) {
                    Throwable throwable2;
                    block4: {
                        try {
                            v0.BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceDisconnected() enter.", new Object[0]);
                            if (n != 1) {
                                return;
                            }
                        }
                        catch (Throwable throwable2) {
                            break block4;
                        }
                        BluetoothManager.this.bluetoothDevice = null;
                        BluetoothManager.this.bluetoothProfile = null;
                        BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceDisconnected() exit.", new Object[0]);
                        return;
                    }
                    throw throwable2;
                }
            }
        };
        bluetoothManager.bluetoothBroadcastReceiver = new BroadcastReceiver(){

            /*
             * Exception decompiling
             */
            public void onReceive(Context var1_1, Intent var2_2) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 42->45)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        logToken.d("BluetoothManager constructor enter.", new Object[0]);
        this.audioManager = audioManager = (AudioManager)context.getSystemService("audio");
        if (!audioManager.isBluetoothScoAvailableOffCall()) {
            logToken2.e("Bluetooth SCO audio is not available off call", new Object[0]);
            return;
        }
        BluetoothManager bluetoothManager2 = this;
        bluetoothManager2.audioDeviceContext = context;
        bluetoothManager2.audioDevice = defaultAudioDevice;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            logToken2.w("Device does not support Bluetooth", new Object[0]);
            return;
        }
        BluetoothManager bluetoothManager3 = this;
        bluetoothManager3.setBluetoothState(State.SCO_DISCONNECTED);
        bluetoothManager3.registerBtReceiver();
        audioManager.setBluetoothScoOn(true);
        this.audioManagerStartBluetoothSCO();
        logToken2.d("BluetoothManager constructor exit.", new Object[0]);
    }

    private void audioManagerStartBluetoothSCO() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("audioManagerStartBluetoothSCO() enter <-", new Object[0]);
        bluetoothManager.audioManager.startBluetoothSco();
        bluetoothManager.log.d("audioManagerStartBluetoothSCO() exit <-", new Object[0]);
    }

    static /* synthetic */ AudioManager access$000(BluetoothManager bluetoothManager) {
        return bluetoothManager.audioManager;
    }

    protected void finalize() {
        BluetoothManager bluetoothManager = this;
        super.finalize();
        bluetoothManager.audioManager.setBluetoothScoOn(false);
        BluetoothProfile bluetoothProfile = bluetoothManager.bluetoothProfile;
        if (bluetoothProfile != null && (this = this.bluetoothAdapter) != null) {
            this.closeProfileProxy(1, bluetoothProfile);
        }
    }

    void onPause() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("onPause() enter.", new Object[0]);
        bluetoothManager.log.d("onPause() exit.", new Object[0]);
    }

    void onResume() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("onResume() enter.", new Object[0]);
        bluetoothManager.forceInvokeConnectBluetooth();
        bluetoothManager.log.d("onResume() exit.", new Object[0]);
    }

    void registerBtReceiver() {
        IntentFilter intentFilter;
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("isBluetoothBroadcastReceiverRegistered = " + this.isBluetoothBroadcastReceiverRegistered, new Object[0]);
        if (bluetoothManager.isBluetoothBroadcastReceiverRegistered) {
            return;
        }
        BluetoothManager bluetoothManager2 = this;
        bluetoothManager2.log.d("registerBtReceiver() enter.", new Object[0]);
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter2.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        bluetoothManager2.audioDeviceContext.registerReceiver(this.bluetoothBroadcastReceiver, intentFilter2);
        bluetoothManager2.isBluetoothBroadcastReceiverRegistered = true;
        bluetoothManager2.log.d("registerBtReceiver() exit", new Object[0]);
    }

    public synchronized void unregisterBtReceiver() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("isBluetoothBroadcastReceiverRegistered = " + this.isBluetoothBroadcastReceiverRegistered, new Object[0]);
        if (!bluetoothManager.isBluetoothBroadcastReceiverRegistered) {
            return;
        }
        BluetoothManager bluetoothManager2 = this;
        bluetoothManager2.log.d("unregisterBtReceiver() enter", new Object[0]);
        bluetoothManager2.audioDeviceContext.unregisterReceiver(this.bluetoothBroadcastReceiver);
        bluetoothManager2.isBluetoothBroadcastReceiverRegistered = false;
        bluetoothManager2.log.d("unregisterBtReceiver() exit", new Object[0]);
    }

    synchronized void startBluetoothSCO() {
        if (this.audioDevice.isWiredHeadSetConnected()) {
            this.log.e("Bluetooth cannot be turned on when wired headset is connected.", new Object[0]);
            return;
        }
        BluetoothManager bluetoothManager = this;
        bluetoothManager.setConnectionAttempts(0);
        bluetoothManager.tryStartBluetoothSCO();
    }

    synchronized void setConnectionAttempts(int n) {
        this.scoConnectionAttempts = n;
        this.log.d("setConnectionAttempts(). scoConnectionAttempts set to " + n, new Object[0]);
    }

    synchronized void tryStartBluetoothSCO() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("tryStartBluetoothSCO() enter <-", new Object[0]);
        State state = bluetoothManager.bluetoothConnectionState;
        if (state != State.SCO_CONNECTED && state != (state = State.SCO_CONNECT_ATTEMPT)) {
            double d2;
            Handler handler;
            BluetoothManager bluetoothManager2 = this;
            bluetoothManager2.setBluetoothState(state);
            state = handler;
            handler = new Handler();
            Runnable runnable = () -> {
                if (this.bluetoothConnectionState == State.SCO_CONNECTED) {
                    this.setConnectionAttempts(0);
                    return;
                }
                try {
                    BluetoothManager bluetoothManager = this;
                    bluetoothManager.audioManagerStopBluetoothSCO();
                    bluetoothManager.audioManagerStartBluetoothSCO();
                }
                catch (NullPointerException nullPointerException) {
                    this.log.e("tryStartBluetoothSco(): " + ((Throwable)nullPointerException).getMessage(), new Object[0]);
                }
            };
            int n = bluetoothManager2.scoConnectionAttempts;
            if (n == 0) {
                d2 = 0.0;
            } else {
                double d3 = n;
                d2 = Math.pow(2.0, d3) * 25.0;
            }
            long l = (long)d2;
            BluetoothManager bluetoothManager3 = this;
            state.postDelayed(runnable, l);
            bluetoothManager3.setConnectionAttempts(bluetoothManager3.scoConnectionAttempts + 1);
            bluetoothManager3.log.d("tryStartBluetoothSCO() exit ->", new Object[0]);
            return;
        }
    }

    synchronized void stopBluetoothSCO() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("stopBluetoothSCO() enter <-", new Object[0]);
        bluetoothManager.setConnectionAttempts(-1);
        if (bluetoothManager.bluetoothConnectionState == State.SCO_CONNECT_ATTEMPT) {
            return;
        }
        try {
            this.audioManagerStopBluetoothSCO();
        }
        catch (NullPointerException nullPointerException) {
            this.log.e("stopBluetoothSco(): " + ((Throwable)nullPointerException).getMessage(), new Object[0]);
        }
        this.log.d("stopBluetoothSCO() exit ->", new Object[0]);
    }

    synchronized void audioManagerStopBluetoothSCO() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("audioManagerStopBluetoothSCO() enter <-", new Object[0]);
        bluetoothManager.audioManager.stopBluetoothSco();
        bluetoothManager.log.d("audioManagerStopBluetoothSCO() exit ->", new Object[0]);
    }

    boolean hasBluetoothPermission() {
        if (Build.VERSION.SDK_INT >= 31 && this.audioDeviceContext.checkSelfPermission("android.permission.BLUETOOTH_CONNECT") != 0) {
            this.log.e("Audio may not route through paired Bluetooth device unless the bluetooth permission has been granted explicitly in the App settings.", new Object[0]);
            return false;
        }
        return true;
    }

    public synchronized boolean isBluetoothConnected() {
        boolean bl = this.bluetoothDevice != null;
        this.log.d("isBluetoothConnected = " + bl, new Object[0]);
        return bl;
    }

    synchronized BaseAudioDevice.BluetoothState getBluetoothState() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("getBluetoothState(). Current bluetoothState = " + (Object)((Object)this.bluetoothConnectionState), new Object[0]);
        return bluetoothManager.bluetoothConnectionState == State.SCO_CONNECTED ? BaseAudioDevice.BluetoothState.Connected : BaseAudioDevice.BluetoothState.Disconnected;
    }

    synchronized void setBluetoothState(State state) {
        this.bluetoothConnectionState = state;
        this.log.d("setBluetoothState(). bluetoothState set to " + (Object)((Object)this.bluetoothConnectionState), new Object[0]);
    }

    synchronized void forceInvokeConnectBluetooth() {
        if (this.audioDevice == null) {
            return;
        }
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("forceInvokeConnectBluetooth() enter", new Object[0]);
        BluetoothAdapter bluetoothAdapter = bluetoothManager.bluetoothAdapter;
        if (bluetoothAdapter != null) {
            BluetoothAdapter bluetoothAdapter2 = bluetoothAdapter;
            BluetoothManager bluetoothManager2 = this;
            bluetoothAdapter = bluetoothManager2.audioDeviceContext;
            bluetoothAdapter2.getProfileProxy((Context)bluetoothAdapter, bluetoothManager2.bluetoothProfileServiceListener, 1);
        }
        this.log.d("forceInvokeConnectBluetooth() exit", new Object[0]);
    }

    private static enum State {
        SCO_DISCONNECTED,
        SCO_CONNECTING,
        SCO_CONNECT_ATTEMPT,
        SCO_CONNECTED;

    }
}

