/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.display.DisplayManager;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Range;
import android.util.Size;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.WindowManager;
import com.opentok.android.BaseVideoCapturer;
import com.opentok.android.OtLog;
import com.opentok.android.Publisher;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class Camera2VideoCapturer
extends BaseVideoCapturer
implements BaseVideoCapturer.CaptureSwitch {
    private static final int PREFERRED_FACING_CAMERA = 0;
    private static final int PIXEL_FORMAT = 35;
    static final SparseIntArray rotationTable = new SparseIntArray(){
        {
            1 v0 = this;
            v0.append(0, 0);
            v0.append(1, 90);
            v0.append(2, 180);
            v0.append(3, 270);
        }
    };
    private static final SparseArray<Size> resolutionTable = new SparseArray<Size>(){
        {
            2 v0 = this;
            v0.append(Publisher.CameraCaptureResolution.LOW.ordinal(), new Size(352, 288));
            v0.append(Publisher.CameraCaptureResolution.MEDIUM.ordinal(), new Size(640, 480));
            v0.append(Publisher.CameraCaptureResolution.HIGH.ordinal(), new Size(1280, 720));
            v0.append(Publisher.CameraCaptureResolution.HIGH_1080P.ordinal(), new Size(1920, 1080));
        }
    };
    private static final SparseIntArray frameRateTable = new SparseIntArray(){
        {
            3 v0 = this;
            v0.append(Publisher.CameraCaptureFrameRate.FPS_1.ordinal(), 1);
            v0.append(Publisher.CameraCaptureFrameRate.FPS_7.ordinal(), 7);
            v0.append(Publisher.CameraCaptureFrameRate.FPS_15.ordinal(), 15);
            v0.append(Publisher.CameraCaptureFrameRate.FPS_30.ordinal(), 30);
        }
    };
    private final CameraManager cameraManager;
    CameraDevice camera;
    private HandlerThread cameraThread;
    private Handler cameraThreadHandler;
    private ImageReader cameraFrame;
    CaptureRequest.Builder captureRequestBuilder;
    CameraCaptureSession captureSession;
    private CameraInfoCache cameraInfoCache;
    CameraState cameraState;
    private Display display;
    private DisplayOrientationCache displayOrientationCache;
    private int cameraIndex;
    private final Size frameDimensions;
    private final int desiredFps;
    private Range<Integer> camFps;
    final OtLog.LogToken log;
    Runnable executeAfterClosed;
    Runnable executeAfterCameraOpened;
    Runnable executeAfterCameraSessionConfigured;
    private final CameraDevice.StateCallback cameraObserver;
    private final ImageReader.OnImageAvailableListener frameObserver;
    private final CameraCaptureSession.StateCallback captureSessionObserver;
    final CameraCaptureSession.CaptureCallback captureNotification;
    private boolean cycleCameraInProgress;
    private final Object lock;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Camera2VideoCapturer(Context object, Publisher.CameraCaptureResolution cameraCaptureResolution, Publisher.CameraCaptureFrameRate cameraCaptureFrameRate) {
        Exception exception3;
        block10: {
            block9: {
                Object object2;
                CameraCaptureSession.CaptureCallback captureCallback;
                CameraCaptureSession.StateCallback stateCallback;
                ImageReader.OnImageAvailableListener onImageAvailableListener;
                CameraDevice.StateCallback stateCallback2;
                OtLog.LogToken logToken;
                Object object3 = logToken;
                logToken = new OtLog.LogToken(this);
                this.log = object3;
                object3 = stateCallback2;
                stateCallback2 = new CameraDevice.StateCallback(){

                    public void onOpened(CameraDevice object) {
                        4 v0 = this;
                        v0.Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onOpened() enter", new Object[0]);
                        v0.Camera2VideoCapturer.this.cameraState = CameraState.OPEN;
                        v0.Camera2VideoCapturer.this.camera = object;
                        object = v0.Camera2VideoCapturer.this.executeAfterCameraOpened;
                        if (object != null) {
                            object.run();
                        }
                        Camera2VideoCapturer.this.executeAfterCameraOpened = null;
                        Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onOpened() exit", new Object[0]);
                    }

                    public void onDisconnected(CameraDevice cameraDevice) {
                        4 v0 = this;
                        v0.Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onDisconnected() enter", new Object[0]);
                        try {
                            v0.Camera2VideoCapturer.this.executeAfterClosed = null;
                            v0.Camera2VideoCapturer.this.camera.close();
                        }
                        catch (Exception exception) {
                            Camera2VideoCapturer.this.handleException(exception);
                        }
                        Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onDisconnected() exit", new Object[0]);
                    }

                    public void onError(CameraDevice cameraDevice, int n) {
                        Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onError() enter", new Object[0]);
                        try {
                            cameraDevice.close();
                        }
                        catch (Exception exception) {
                            Camera2VideoCapturer.this.handleException(exception);
                        }
                        Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onError() exit", new Object[0]);
                    }

                    public void onClosed(CameraDevice object) {
                        4 v0 = this;
                        Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onClosed() enter.", new Object[0]);
                        super.onClosed((CameraDevice)object);
                        v0.Camera2VideoCapturer.this.cameraState = CameraState.CLOSED;
                        v0.Camera2VideoCapturer.this.camera = null;
                        object = v0.Camera2VideoCapturer.this.executeAfterClosed;
                        if (object != null) {
                            object.run();
                        }
                        Camera2VideoCapturer.this.executeAfterClosed = null;
                        Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onClosed() exit.", new Object[0]);
                    }
                };
                this.cameraObserver = object3;
                object3 = onImageAvailableListener;
                onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void onImageAvailable(ImageReader imageReader) {
                        IllegalStateException illegalStateException2;
                        block7: {
                            block5: {
                                block6: {
                                    Object object;
                                    try {
                                        imageReader = imageReader.acquireNextImage();
                                        if (imageReader == null || imageReader.getPlanes().length > 0 && imageReader.getPlanes()[0].getBuffer() == null || imageReader.getPlanes().length > 1 && imageReader.getPlanes()[1].getBuffer() == null || imageReader.getPlanes().length > 2 && imageReader.getPlanes()[2].getBuffer() == null) break block5;
                                        object = Camera2VideoCapturer.this;
                                        if (CameraState.CAPTURE != ((Camera2VideoCapturer)object).cameraState) break block6;
                                    }
                                    catch (IllegalStateException illegalStateException2) {
                                        break block7;
                                    }
                                    Camera2VideoCapturer camera2VideoCapturer = object;
                                    ImageReader imageReader2 = imageReader;
                                    object = imageReader2.getPlanes()[0].getBuffer();
                                    ByteBuffer byteBuffer = imageReader2.getPlanes()[1].getBuffer();
                                    ByteBuffer byteBuffer2 = imageReader2.getPlanes()[2].getBuffer();
                                    int n = imageReader2.getPlanes()[0].getPixelStride();
                                    int n2 = imageReader2.getPlanes()[0].getRowStride();
                                    int n3 = imageReader2.getPlanes()[1].getPixelStride();
                                    int n4 = imageReader2.getPlanes()[1].getRowStride();
                                    int n5 = imageReader2.getPlanes()[2].getPixelStride();
                                    int n6 = imageReader2.getPlanes()[2].getRowStride();
                                    int n7 = imageReader2.getWidth();
                                    int n8 = imageReader2.getHeight();
                                    5 v2 = this;
                                    int n9 = v2.Camera2VideoCapturer.this.calculateCamRotation();
                                    boolean bl = v2.Camera2VideoCapturer.this.isFrontCamera();
                                    camera2VideoCapturer.provideBufferFramePlanar((ByteBuffer)object, byteBuffer, byteBuffer2, n, n2, n3, n4, n5, n6, n7, n8, n9, bl);
                                }
                                imageReader.close();
                                return;
                            }
                            Camera2VideoCapturer.this.log.d("onImageAvailable frame provided has no image data", new Object[0]);
                            return;
                        }
                        Camera2VideoCapturer.this.log.e("ImageReader.acquireNextImage() throws error !", new Object[0]);
                        throw new Camera2Exception(illegalStateException2.getMessage());
                    }
                };
                this.frameObserver = object3;
                object3 = stateCallback;
                stateCallback = new CameraCaptureSession.StateCallback(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    public void onConfigured(CameraCaptureSession object) {
                        block10: {
                            6 v0 = this;
                            v0.Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onConfigured() enter.", new Object[0]);
                            try {
                                v0.Camera2VideoCapturer.this.cameraState = CameraState.CAPTURE;
                                v0.Camera2VideoCapturer.this.captureSession = object;
                                object = v0.Camera2VideoCapturer.this.captureRequestBuilder.build();
                                Camera2VideoCapturer camera2VideoCapturer = v0.Camera2VideoCapturer.this;
                                camera2VideoCapturer.captureSession.setRepeatingRequest((CaptureRequest)object, camera2VideoCapturer.captureNotification, null);
                            }
                            catch (Exception exception) {
                                Camera2VideoCapturer.this.handleException(exception);
                            }
                            object = Camera2VideoCapturer.this.executeAfterCameraSessionConfigured;
                            if (object != null) {
                                object.run();
                                Camera2VideoCapturer.this.executeAfterCameraSessionConfigured = null;
                            }
                            6 v1 = this;
                            object = v1.Camera2VideoCapturer.this.lock;
                            // MONITORENTER : object
                            if (!v1.Camera2VideoCapturer.this.cycleCameraInProgress) break block10;
                            6 v2 = this;
                            6 v3 = v2;
                            Camera2VideoCapturer.access$202(v2.Camera2VideoCapturer.this, false);
                            Camera2VideoCapturer camera2VideoCapturer = v3.Camera2VideoCapturer.this;
                            camera2VideoCapturer.onCameraChanged(camera2VideoCapturer.getCameraIndex());
                        }
                        // MONITOREXIT : object
                        Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onConfigured() exit.", new Object[0]);
                    }

                    public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                        6 v0 = this;
                        v0.Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onFailed() enter.", new Object[0]);
                        v0.Camera2VideoCapturer.this.cameraState = CameraState.ERROR;
                        v0.Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onFailed() exit.", new Object[0]);
                    }

                    public void onClosed(CameraCaptureSession cameraCaptureSession) {
                        6 v0 = this;
                        v0.Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onClosed() enter.", new Object[0]);
                        cameraCaptureSession = v0.Camera2VideoCapturer.this.camera;
                        if (cameraCaptureSession != null) {
                            cameraCaptureSession.close();
                        }
                        Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onClosed() exit.", new Object[0]);
                    }
                };
                this.captureSessionObserver = object3;
                object3 = captureCallback;
                captureCallback = new CameraCaptureSession.CaptureCallback(){

                    public void onCaptureStarted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, long l, long l2) {
                        super.onCaptureStarted(cameraCaptureSession, captureRequest, l, l2);
                    }
                };
                this.captureNotification = object3;
                this.cycleCameraInProgress = false;
                object3 = object2;
                object2 = new Object();
                this.lock = object3;
                this.cameraManager = (CameraManager)object.getSystemService("camera");
                if (Build.VERSION.SDK_INT >= 30) {
                    try {
                        this.display = object.getDisplay();
                    }
                    catch (Exception exception2) {
                        this.display = ((DisplayManager)object.getSystemService("display")).getDisplay(0);
                    }
                } else {
                    this.display = ((WindowManager)object.getSystemService("window")).getDefaultDisplay();
                }
                this.camera = null;
                this.cameraState = CameraState.CLOSED;
                this.frameDimensions = (Size)resolutionTable.get(cameraCaptureResolution.ordinal());
                this.desiredFps = frameRateTable.get(cameraCaptureFrameRate.ordinal());
                try {
                    object = this.selectCamera(0);
                    if (object != null) break block9;
                }
                catch (Exception exception3) {
                    break block10;
                }
                if (this.cameraManager.getCameraIdList().length > 0) {
                    object = this.cameraManager.getCameraIdList()[0];
                }
            }
            this.setCameraIndex(this.findCameraIndex((String)object));
            if (this.getCameraIndex() == -1) {
                this.log.e("Exception!. Camera Index cannot be -1.", new Object[0]);
                return;
            }
            this.initCameraFrame();
            return;
        }
        this.handleException(exception3);
    }

    private void doInit() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("doInit() enter", new Object[0]);
        camera2VideoCapturer.cameraInfoCache = null;
        camera2VideoCapturer.startCamThread();
        camera2VideoCapturer.startDisplayOrientationCache();
        camera2VideoCapturer.initCamera();
        camera2VideoCapturer.log.d("doInit() exit", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doStartCapture() {
        block7: {
            CameraAccessException cameraAccessException2;
            block6: {
                this.log.d("doStartCapture() enter", new Object[0]);
                this.cameraState = CameraState.CREATESESSION;
                try {
                    Integer n;
                    CaptureRequest.Key key;
                    CaptureRequest.Builder builder;
                    if (this.isFrontCamera()) {
                        this.captureRequestBuilder = this.camera.createCaptureRequest(1);
                        this.captureRequestBuilder.addTarget(this.cameraFrame.getSurface());
                        this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.camFps);
                        this.captureRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)2);
                        this.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        builder = this.captureRequestBuilder;
                        key = CaptureRequest.CONTROL_SCENE_MODE;
                        n = 1;
                    } else {
                        this.captureRequestBuilder = this.camera.createCaptureRequest(3);
                        this.captureRequestBuilder.addTarget(this.cameraFrame.getSurface());
                        this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.camFps);
                        builder = this.captureRequestBuilder;
                        key = CaptureRequest.CONTROL_AF_MODE;
                        n = 4;
                    }
                    builder.set(key, (Object)n);
                }
                catch (CameraAccessException cameraAccessException2) {
                    break block6;
                }
                this.camera.createCaptureSession(Collections.singletonList(this.cameraFrame.getSurface()), this.captureSessionObserver, null);
                break block7;
            }
            this.handleException((Exception)((Object)cameraAccessException2));
        }
        this.log.d("doStartCapture() exit", new Object[0]);
    }

    private synchronized void scheduleStartCapture() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("scheduleStartCapture() enter (cameraState: " + (Object)((Object)this.cameraState) + ")", new Object[0]);
        if (camera2VideoCapturer.camera != null && CameraState.OPEN == this.cameraState) {
            this.doStartCapture();
            return;
        }
        CameraState cameraState = this.cameraState;
        if (CameraState.SETUP == cameraState) {
            Camera2VideoCapturer camera2VideoCapturer2 = this;
            camera2VideoCapturer2.log.d("camera not yet ready, queuing the start until camera is opened.", new Object[0]);
            camera2VideoCapturer2.executeAfterCameraOpened = camera2VideoCapturer2::doStartCapture;
        } else if (CameraState.CREATESESSION == cameraState) {
            this.log.d("Camera session creation already requested", new Object[0]);
        } else {
            this.log.d("Start Capture called before init successfully completed.", new Object[0]);
        }
        this.log.d("scheduleStartCapture() exit", new Object[0]);
    }

    private boolean isDepthOutputCamera(String object) {
        int[] nArray = (int[])this.cameraManager.getCameraCharacteristics((String)object).get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        object = nArray;
        if (nArray != null) {
            int n = ((Object)object).length;
            for (int k = 0; k < n; ++k) {
                if (object[k] != 8) continue;
                this.log.d(" REQUEST_AVAILABLE_CAPABILITIES_DEPTH_OUTPUT => TRUE", new Object[0]);
                return true;
            }
        }
        this.log.d(" REQUEST_AVAILABLE_CAPABILITIES_DEPTH_OUTPUT => FALSE", new Object[0]);
        return false;
    }

    private boolean isBackwardCompatible(String object) {
        int[] nArray = (int[])this.cameraManager.getCameraCharacteristics((String)object).get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        object = nArray;
        if (nArray != null) {
            int n = ((Object)object).length;
            for (int k = 0; k < n; ++k) {
                if (object[k] != false) continue;
                this.log.d(" REQUEST_AVAILABLE_CAPABILITIES_BACKWARD_COMPATIBLE => TRUE", new Object[0]);
                return true;
            }
        }
        this.log.d(" REQUEST_AVAILABLE_CAPABILITIES_BACKWARD_COMPATIBLE => FALSE", new Object[0]);
        return false;
    }

    private Size[] getCameraOutputSizes(String string) {
        Camera2VideoCapturer camera2VideoCapturer = (StreamConfigurationMap)camera2VideoCapturer.cameraManager.getCameraCharacteristics(string).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        return camera2VideoCapturer != null ? camera2VideoCapturer.getOutputSizes(35) : new Size[]{};
    }

    private int getNextSupportedCameraIndex() {
        String[] stringArray = this.cameraManager.getCameraIdList();
        int n = stringArray.length;
        for (int k = 0; k < n; ++k) {
            int n2;
            boolean bl = this.isDepthOutputCamera(stringArray[n2]);
            boolean bl2 = this.isBackwardCompatible(stringArray[n2]);
            n2 = (this.getCameraIndex() + k + 1) % n;
            Size[] sizeArray = this.getCameraOutputSizes(stringArray[n2]);
            if (!(sizeArray != null && sizeArray.length > 0) || !bl2 || bl) continue;
            return n2;
        }
        return -1;
    }

    private void setCameraIndex(int n) {
        this.cameraIndex = n;
    }

    private void startCamThread() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("startCamThread() enter", new Object[0]);
        this.cameraThread = new HandlerThread("Camera2VideoCapturer-Camera-Thread");
        this.cameraThread.start();
        camera2VideoCapturer.cameraThreadHandler = new Handler(this.cameraThread.getLooper());
        camera2VideoCapturer.log.d("startCamThread() exit", new Object[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopCamThread() {
        Throwable throwable2;
        block5: {
            block6: {
                Camera2VideoCapturer camera2VideoCapturer = this;
                camera2VideoCapturer.log.d("stopCamThread() enter", new Object[0]);
                camera2VideoCapturer.cameraThread.quitSafely();
                {
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    catch (Exception exception) {}
                    {
                        this.handleException(exception);
                        this.cameraThread = null;
                        this.cameraThreadHandler = null;
                        break block6;
                    }
                }
                {
                    camera2VideoCapturer.cameraThread.join();
                    camera2VideoCapturer.cameraThread = null;
                    camera2VideoCapturer.cameraThreadHandler = null;
                }
            }
            this.log.d("stopCamThread() exit", new Object[0]);
            return;
        }
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.cameraThread = null;
        camera2VideoCapturer.cameraThreadHandler = null;
        throw throwable2;
    }

    private String selectCamera(int n) {
        for (String string : this.cameraManager.getCameraIdList()) {
            CameraCharacteristics.Key key;
            CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics(string);
            if (n != (Integer)cameraCharacteristics.get(key = CameraCharacteristics.LENS_FACING)) continue;
            this.log.d("selectCamera() Direction the camera faces relative to device screen: " + cameraCharacteristics.get(key), new Object[0]);
            return string;
        }
        return null;
    }

    private Range<Integer> selectCameraFpsRange(String range, final int n) {
        Object object = this.cameraManager.getCameraIdList();
        int n2 = ((String[])object).length;
        for (int k = 0; k < n2; ++k) {
            ArrayList arrayList;
            String string = object[k];
            if (!string.equals(range)) continue;
            range = this.cameraManager.getCameraCharacteristics(string);
            object = arrayList;
            object();
            Collections.addAll(object, (Range[])range.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES));
            this.log.d("Supported fps ranges = " + object, new Object[0]);
            range = Collections.min(arrayList, new Comparator<Range<Integer>>(){

                private int calcError(Range<Integer> range) {
                    return Math.abs((Integer)range.getLower() - n) + Math.abs((Integer)range.getUpper() - n);
                }

                @Override
                public int compare(Range<Integer> range, Range<Integer> range2) {
                    return this.calcError(range) - this.calcError(range2);
                }
            });
            this.log.d("Desired fps = " + n + " || Selected frame rate range = " + range, new Object[0]);
            return range;
        }
        return null;
    }

    private int findCameraIndex(String string) {
        String[] stringArray = stringArray.cameraManager.getCameraIdList();
        for (int k = 0; k < stringArray.length; ++k) {
            if (!stringArray[k].equals(string)) continue;
            return k;
        }
        return -1;
    }

    private Size selectPreferredSize(String sizeArray, final int n, final int n2) {
        sizeArray = this.getCameraOutputSizes((String)sizeArray);
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, sizeArray);
        return Collections.min(arrayList, new Comparator<Size>(){

            @Override
            public int compare(Size size, Size size2) {
                Size size3 = size2;
                int n3 = Math.abs(size3.getWidth() - n);
                int n22 = Math.abs(size3.getHeight() - n2);
                return Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2) - (n3 + n22);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initCameraFrame() {
        block6: {
            Exception exception2;
            block5: {
                Size size;
                block4: {
                    ImageReader imageReader;
                    if (this.getCameraIndex() == -1) {
                        this.log.e(" Camera Index cannot be -1. initCameraFrame() unsuccessful.", new Object[0]);
                        return;
                    }
                    Camera2VideoCapturer camera2VideoCapturer = this;
                    camera2VideoCapturer.log.d("initCameraFrame() enter.", new Object[0]);
                    try {
                        Camera2VideoCapturer camera2VideoCapturer2 = this;
                        int n = camera2VideoCapturer2.frameDimensions.getWidth();
                        size = camera2VideoCapturer.selectPreferredSize(camera2VideoCapturer.cameraManager.getCameraIdList()[this.getCameraIndex()], n, camera2VideoCapturer2.frameDimensions.getHeight());
                        imageReader = camera2VideoCapturer.cameraFrame;
                        if (imageReader == null) break block4;
                    }
                    catch (Exception exception2) {
                        break block5;
                    }
                    imageReader.close();
                }
                this.cameraFrame = ImageReader.newInstance((int)size.getWidth(), (int)size.getHeight(), (int)35, (int)3);
                break block6;
            }
            this.handleException(exception2);
        }
        this.log.d("initCameraFrame() exit.", new Object[0]);
    }

    private void initCamera() {
        if (this.getCameraIndex() == -1) {
            this.log.e(" Camera Index cannot be -1. initCamera() unsuccessful.", new Object[0]);
            return;
        }
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("initCamera() enter.", new Object[0]);
        camera2VideoCapturer.cameraState = CameraState.SETUP;
        String string = camera2VideoCapturer.cameraManager.getCameraIdList()[this.getCameraIndex()];
        camera2VideoCapturer.camFps = camera2VideoCapturer.selectCameraFpsRange(string, camera2VideoCapturer.desiredFps);
        ImageReader imageReader = camera2VideoCapturer.cameraFrame;
        Camera2VideoCapturer camera2VideoCapturer2 = this;
        Camera2VideoCapturer camera2VideoCapturer3 = camera2VideoCapturer2;
        ImageReader.OnImageAvailableListener onImageAvailableListener = camera2VideoCapturer2.frameObserver;
        try {
            imageReader.setOnImageAvailableListener(onImageAvailableListener, camera2VideoCapturer3.cameraThreadHandler);
            camera2VideoCapturer.cameraInfoCache = new CameraInfoCache(this.cameraManager.getCameraCharacteristics(string));
            camera2VideoCapturer.cameraManager.openCamera(string, this.cameraObserver, null);
        }
        catch (Exception exception) {
            this.log.e("Camera cannot be opened. Check the error message below.", new Object[0]);
            this.handleException(exception);
        }
        this.log.d("initCamera() exit.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleException(Exception exception) {
        StringWriter stringWriter;
        Object object2;
        Camera2VideoCapturer camera2VideoCapturer = object2;
        Camera2VideoCapturer camera2VideoCapturer2 = object2;
        camera2VideoCapturer2.cameraState = CameraState.ERROR;
        Object object = camera2VideoCapturer2.lock;
        synchronized (object) {
            ((Camera2VideoCapturer)object2).cycleCameraInProgress = false;
        }
        object2 = stringWriter;
        stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)object2);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        object2 = stringWriter.toString();
        camera2VideoCapturer2.log.e((String)object2, new Object[0]);
        camera2VideoCapturer.onCaptureError(exception);
    }

    private void startDisplayOrientationCache() {
        DisplayOrientationCache displayOrientationCache;
        Camera2VideoCapturer camera2VideoCapturer = camera2VideoCapturer3;
        DisplayOrientationCache displayOrientationCache2 = displayOrientationCache;
        Camera2VideoCapturer camera2VideoCapturer2 = camera2VideoCapturer3;
        Camera2VideoCapturer camera2VideoCapturer3 = camera2VideoCapturer2.display;
        displayOrientationCache = new DisplayOrientationCache((Display)camera2VideoCapturer3, camera2VideoCapturer2.cameraThreadHandler);
        camera2VideoCapturer.displayOrientationCache = displayOrientationCache2;
    }

    private void stopDisplayOrientationCache() {
        Handler handler = ((Camera2VideoCapturer)this).cameraThreadHandler;
        if (handler != null && (this = ((Camera2VideoCapturer)this).displayOrientationCache) != null) {
            handler.removeCallbacks((Runnable)this);
        }
    }

    static /* synthetic */ boolean access$202(Camera2VideoCapturer camera2VideoCapturer, boolean bl) {
        camera2VideoCapturer.cycleCameraInProgress = bl;
        return bl;
    }

    @Override
    public synchronized void init() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("init() enter", new Object[0]);
        camera2VideoCapturer.doInit();
        camera2VideoCapturer.cameraState = CameraState.SETUP;
        camera2VideoCapturer.log.d("init() exit", new Object[0]);
    }

    @Override
    public synchronized int startCapture() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("startCapture() enter (cameraState: " + (Object)((Object)this.cameraState) + ")", new Object[0]);
        Runnable runnable = () -> {
            Camera2VideoCapturer camera2VideoCapturer = this;
            camera2VideoCapturer.initCamera();
            camera2VideoCapturer.scheduleStartCapture();
        };
        CameraState cameraState = camera2VideoCapturer.cameraState;
        if (cameraState == CameraState.CLOSING) {
            this.executeAfterClosed = runnable;
        } else if (cameraState == CameraState.CLOSED) {
            runnable.run();
        } else {
            this.scheduleStartCapture();
        }
        this.log.d("startCapture() exit", new Object[0]);
        return 0;
    }

    @Override
    public synchronized int stopCapture() {
        CameraCaptureSession cameraCaptureSession;
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("stopCapture() enter (cameraState: " + (Object)((Object)this.cameraState) + ")", new Object[0]);
        Object object = camera2VideoCapturer.camera;
        if (object != null && (cameraCaptureSession = this.captureSession) != null && CameraState.CAPTURE == this.cameraState) {
            try {
                cameraCaptureSession.stopRepeating();
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            catch (CameraAccessException cameraAccessException) {
            }
            catch (IllegalStateException illegalStateException) {}
            this.captureSession.close();
            this.cameraInfoCache = null;
            this.cameraState = CameraState.CLOSING;
        } else if (object != null && CameraState.OPEN == this.cameraState) {
            this.cameraState = CameraState.CLOSING;
            object.close();
        } else {
            object = this.cameraState;
            if (CameraState.SETUP == object) {
                this.executeAfterCameraOpened = () -> {
                    camera2VideoCapturer.cameraState = CameraState.CLOSING;
                    Camera2VideoCapturer camera2VideoCapturer = camera2VideoCapturer.camera;
                    if (camera2VideoCapturer != null) {
                        camera2VideoCapturer.close();
                    }
                };
            } else if (CameraState.CREATESESSION == object) {
                this.executeAfterCameraSessionConfigured = () -> {
                    this.captureSession.close();
                    this.cameraState = CameraState.CLOSING;
                    this.executeAfterCameraSessionConfigured = null;
                };
            }
        }
        this.log.d("stopCapture exit", new Object[0]);
        return 0;
    }

    @Override
    public synchronized void destroy() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("destroy() enter", new Object[0]);
        camera2VideoCapturer.stopDisplayOrientationCache();
        camera2VideoCapturer.stopCamThread();
        camera2VideoCapturer.cameraFrame.close();
        camera2VideoCapturer.log.d("destroy() exit", new Object[0]);
    }

    @Override
    public boolean isCaptureStarted() {
        return this.cameraState == CameraState.CAPTURE;
    }

    @Override
    public synchronized BaseVideoCapturer.CaptureSettings getCaptureSettings() {
        BaseVideoCapturer.CaptureSettings captureSettings;
        BaseVideoCapturer.CaptureSettings captureSettings2 = captureSettings;
        captureSettings2();
        captureSettings.fps = this.desiredFps;
        ImageReader imageReader = this.cameraFrame;
        int n = imageReader != null ? imageReader.getWidth() : -1;
        captureSettings2.width = n;
        ImageReader imageReader2 = this.cameraFrame;
        int n2 = imageReader2 != null ? imageReader2.getHeight() : -1;
        BaseVideoCapturer.CaptureSettings captureSettings3 = captureSettings2;
        captureSettings3.height = n2;
        captureSettings3.format = 1;
        captureSettings3.expectedDelay = 0;
        captureSettings2.mirrorInLocalRender = this.frameMirrorX;
        return captureSettings2;
    }

    @Override
    public synchronized void onPause() {
    }

    @Override
    public void onResume() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void cycleCamera() {
        block9: {
            Exception exception22;
            block8: {
                block7: {
                    Camera2VideoCapturer camera2VideoCapturer = this;
                    Object object = camera2VideoCapturer.lock;
                    // MONITORENTER : object
                    if (camera2VideoCapturer.cycleCameraInProgress) {
                        this.log.w("cycleCamera is still in progress.", new Object[0]);
                        // MONITOREXIT : object
                        return;
                    }
                    Camera2VideoCapturer camera2VideoCapturer2 = this;
                    this.cycleCameraInProgress = true;
                    // MONITOREXIT : object
                    camera2VideoCapturer2.log.d("cycleCamera() enter", new Object[0]);
                    try {
                        camera2VideoCapturer2.setCameraIndex(camera2VideoCapturer2.getNextSupportedCameraIndex());
                        if (camera2VideoCapturer2.getCameraIndex() == -1) break block7;
                        Camera2VideoCapturer camera2VideoCapturer3 = this;
                        camera2VideoCapturer3.swapCamera(camera2VideoCapturer3.getCameraIndex());
                    }
                    catch (Exception exception22) {
                        break block8;
                    }
                }
                this.handleException(new Camera2Exception("No cameras with supported outputs found"));
                break block9;
            }
            this.handleException(exception22);
        }
        this.log.d("cycleCamera() exit", new Object[0]);
    }

    @Override
    public int getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    public synchronized void swapCamera(int n) {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("swapCamera() enter. cameraState = " + (Object)((Object)this.cameraState), new Object[0]);
        CameraState cameraState = camera2VideoCapturer.cameraState;
        int n2 = 10.$SwitchMap$com$opentok$android$Camera2VideoCapturer$CameraState[cameraState.ordinal()];
        if (n2 != 1) {
            if (n2 == 2 || n2 == 3) {
                Camera2VideoCapturer camera2VideoCapturer2 = this;
                camera2VideoCapturer2.initCameraFrame();
                camera2VideoCapturer2.initCamera();
                camera2VideoCapturer2.startCapture();
            }
        } else {
            this.stopCapture();
        }
        Camera2VideoCapturer camera2VideoCapturer3 = this;
        this.setCameraIndex(n);
        camera2VideoCapturer3.executeAfterClosed = () -> {
            if (10.$SwitchMap$com$opentok$android$Camera2VideoCapturer$CameraState[cameraState.ordinal()] == 1) {
                Camera2VideoCapturer camera2VideoCapturer = this;
                camera2VideoCapturer.initCameraFrame();
                camera2VideoCapturer.initCamera();
                camera2VideoCapturer.startCapture();
            }
        };
        camera2VideoCapturer3.log.d("swapCamera() exit", new Object[0]);
    }

    boolean isFrontCamera() {
        CameraInfoCache cameraInfoCache = ((Camera2VideoCapturer)((Object)cameraInfoCache)).cameraInfoCache;
        return cameraInfoCache != null && cameraInfoCache.isFrontFacing();
    }

    int calculateCamRotation() {
        if (this.cameraInfoCache != null) {
            Camera2VideoCapturer camera2VideoCapturer = this;
            int n = camera2VideoCapturer.displayOrientationCache.getOrientation();
            int n2 = camera2VideoCapturer.cameraInfoCache.sensorOrientation();
            if (!camera2VideoCapturer.cameraInfoCache.isFrontFacing()) {
                return Math.abs((n - n2) % 360);
            }
            return (n + n2 + 360) % 360;
        }
        return 0;
    }

    private static enum CameraState {
        CLOSED,
        CLOSING,
        SETUP,
        OPEN,
        CAPTURE,
        CREATESESSION,
        ERROR;

    }

    private static class CameraInfoCache {
        private final boolean frontFacing;
        private final int sensorOrientation;

        public CameraInfoCache(CameraCharacteristics cameraCharacteristics) {
            boolean bl = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
            this.frontFacing = bl;
            this.sensorOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        }

        public boolean isFrontFacing() {
            return this.frontFacing;
        }

        public int sensorOrientation() {
            return this.sensorOrientation;
        }
    }

    public static class Camera2Exception
    extends RuntimeException {
        public Camera2Exception(String string) {
            super(string);
        }
    }

    private static class DisplayOrientationCache
    implements Runnable {
        private static final int POLL_DELAY_MS = 750;
        private int displayRotation;
        private final Display display;
        private final Handler handler;

        public DisplayOrientationCache(Display display, Handler handler) {
            this.display = display;
            this.handler = handler;
            this.displayRotation = rotationTable.get(display.getRotation());
            handler.postDelayed((Runnable)this, 750L);
        }

        public int getOrientation() {
            return this.displayRotation;
        }

        @Override
        public void run() {
            this.displayRotation = rotationTable.get(this.display.getRotation());
            this.handler.postDelayed((Runnable)this, 750L);
        }
    }
}

