/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.os.Handler;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.opentok.android.BaseAudioDevice;
import com.opentok.android.BluetoothManager;
import com.opentok.android.OtLog;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class DefaultAudioDevice
extends BaseAudioDevice {
    private static final int NUM_CHANNELS_CAPTURING = 1;
    private static final int NUM_CHANNELS_RENDERING = 1;
    private static final int STEREO_CHANNELS = 2;
    private static final int DEFAULT_SAMPLE_RATE = 44100;
    private static final int SAMPLE_SIZE_IN_BYTES = 2;
    private static final int DEFAULT_SAMPLES_PER_BUFFER = 440;
    private static final int DEFAULT_BUFFER_SIZE = 1760;
    private static final int DEFAULT_START_RENDERER_AND_CAPTURER_DELAY = 5000;
    private static final String HEADSET_PLUG_STATE_KEY = "state";
    private final OtLog.LogToken log;
    private final Context context;
    private AudioTrack audioTrack;
    private AudioRecord audioRecord;
    private ByteBuffer playBuffer;
    private ByteBuffer recBuffer;
    private byte[] tempBufPlay;
    private byte[] tempBufRec;
    private final ReentrantLock rendererLock;
    private final Condition renderEvent;
    private volatile boolean isRendering;
    private volatile boolean shutdownRenderThread;
    private final ReentrantLock captureLock;
    private final Condition captureEvent;
    private volatile boolean isCapturing;
    private volatile boolean shutdownCaptureThread;
    private final BaseAudioDevice.AudioSettings captureSettings;
    private final BaseAudioDevice.AudioSettings rendererSettings;
    private NoiseSuppressor noiseSuppressor;
    private AcousticEchoCanceler echoCanceler;
    private int estimatedCaptureDelay;
    private int bufferedPlaySamples;
    private int playPosition;
    private int estimatedRenderDelay;
    private final AudioManager audioManager;
    private final AudioManagerMode audioManagerMode;
    private int outputSamplingRate;
    private final int captureSamplingRate;
    private int samplesPerBuffer;
    private TelephonyManager telephonyManager;
    private final BluetoothManager bluetoothManager;
    private boolean isResumingAfterPaused;
    private OutputType audioOutputType;
    private final AudioState audioState;
    private final BroadcastReceiver headsetBroadcastReceiver;
    private final PhoneStateListener phoneStateListener;
    private boolean wasRendering;
    private boolean wasCapturing;
    private final AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    private final Runnable captureThread;
    private final Runnable renderThread;
    private boolean isHeadsetReceiverRegistered;
    private boolean isPhoneStateListenerRegistered;

    private void startRendererAndCapturer() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("startRendererAndCapturer() enter <-", new Object[0]);
        if (defaultAudioDevice.wasRendering) {
            this.startRenderer();
        }
        if (this.wasCapturing) {
            this.startCapturer();
        }
        this.log.d("startRendererAndCapturer() exit ->", new Object[0]);
    }

    private void stopRendererAndCapturer() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("stopRendererAndCapturer() enter <-", new Object[0]);
        if (defaultAudioDevice.isRendering) {
            this.stopRenderer();
            this.wasRendering = true;
        }
        if (this.isCapturing) {
            this.stopCapturer();
            this.wasCapturing = true;
        }
        this.log.d("stopRendererAndCapturer() exit ->", new Object[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultAudioDevice(Context object) {
        Throwable throwable2;
        block20: {
            BaseAudioDevice.AudioSettings audioSettings;
            BaseAudioDevice.AudioSettings audioSettings2;
            int n;
            block24: {
                NumberFormatException numberFormatException3;
                block23: {
                    int n2;
                    block21: {
                        block22: {
                            AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener;
                            PhoneStateListener phoneStateListener;
                            BroadcastReceiver broadcastReceiver;
                            AudioState audioState;
                            AudioManagerMode audioManagerMode;
                            ReentrantLock reentrantLock;
                            ReentrantLock reentrantLock2;
                            OtLog.LogToken logToken;
                            Object object2 = logToken;
                            logToken = new OtLog.LogToken(this);
                            this.log = object2;
                            this.rendererLock = object2 = reentrantLock2;
                            this.renderEvent = new ReentrantLock(true).newCondition();
                            this.isRendering = false;
                            this.shutdownRenderThread = false;
                            this.captureLock = object2 = reentrantLock;
                            this.captureEvent = new ReentrantLock(true).newCondition();
                            this.isCapturing = false;
                            this.shutdownCaptureThread = false;
                            this.estimatedCaptureDelay = 0;
                            this.bufferedPlaySamples = 0;
                            this.playPosition = 0;
                            this.estimatedRenderDelay = 0;
                            object2 = audioManagerMode;
                            audioManagerMode = new AudioManagerMode();
                            this.audioManagerMode = object2;
                            this.outputSamplingRate = 44100;
                            this.captureSamplingRate = 44100;
                            this.samplesPerBuffer = 440;
                            this.audioOutputType = OutputType.SPEAKER_PHONE;
                            object2 = audioState;
                            audioState = new AudioState();
                            this.audioState = object2;
                            object2 = broadcastReceiver;
                            broadcastReceiver = new BroadcastReceiver(){

                                public void onReceive(Context object, Intent intent) {
                                    if (intent.getAction().equals("android.intent.action.HEADSET_PLUG")) {
                                        if (intent.getIntExtra(DefaultAudioDevice.HEADSET_PLUG_STATE_KEY, 0) == 1) {
                                            1 v0 = this;
                                            v0.DefaultAudioDevice.this.log.d("headsetBroadcastReceiver.onReceive():  Headphones connected", new Object[0]);
                                            v0.DefaultAudioDevice.this.audioState.setPreviousOutputType(DefaultAudioDevice.this.getOutputType());
                                            v0.DefaultAudioDevice.this.setOutputType(OutputType.HEAD_PHONES);
                                            v0.DefaultAudioDevice.this.audioManager.setSpeakerphoneOn(false);
                                            v0.DefaultAudioDevice.this.bluetoothManager.stopBluetoothSCO();
                                        } else {
                                            1 v1 = this;
                                            v1.DefaultAudioDevice.this.log.d("headsetBroadcastReceiver.onReceive():  Headphones disconnected", new Object[0]);
                                            if (v1.DefaultAudioDevice.this.getOutputType() == OutputType.HEAD_PHONES) {
                                                object = DefaultAudioDevice.this.audioState.getPreviousOutputType();
                                                int n = 4.$SwitchMap$com$opentok$android$DefaultAudioDevice$OutputType[object.ordinal()];
                                                if (n != 1) {
                                                    if (n != 2) {
                                                        if (n != 3) {
                                                            DefaultAudioDevice.this.log.e("This should not happen :(", new Object[0]);
                                                        } else {
                                                            1 v2 = this;
                                                            v2.DefaultAudioDevice.this.audioManager.setSpeakerphoneOn(false);
                                                            v2.DefaultAudioDevice.this.setOutputType((OutputType)((Object)object));
                                                        }
                                                    } else {
                                                        1 v3 = this;
                                                        v3.DefaultAudioDevice.this.audioManager.setSpeakerphoneOn(true);
                                                        v3.DefaultAudioDevice.this.setOutputType((OutputType)((Object)object));
                                                    }
                                                } else {
                                                    DefaultAudioDevice.this.bluetoothManager.startBluetoothSCO();
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            this.headsetBroadcastReceiver = object2;
                            object2 = phoneStateListener;
                            phoneStateListener = new PhoneStateListener(){

                                public void onCallStateChanged(int n, String string) {
                                    DefaultAudioDevice.this.log.d("PhoneStateListener.onCallStateChanged() enter <-", new Object[0]);
                                    super.onCallStateChanged(n, string);
                                    if (n != 0) {
                                        if (n != 1) {
                                            if (n != 2) {
                                                DefaultAudioDevice.this.log.d("PhoneStateListener.onCallStateChanged() default", new Object[0]);
                                            } else {
                                                2 v0 = this;
                                                v0.DefaultAudioDevice.this.log.d("PhoneStateListener.onCallStateChanged(): TelephonyManager.CALL_STATE_OFFHOOK", new Object[0]);
                                                v0.DefaultAudioDevice.this.stopRendererAndCapturer();
                                            }
                                        } else {
                                            2 v1 = this;
                                            v1.DefaultAudioDevice.this.log.d("PhoneStateListener.onCallStateChanged(): TelephonyManager.CALL_STATE_RINGING", new Object[0]);
                                            v1.DefaultAudioDevice.this.stopRendererAndCapturer();
                                        }
                                    } else {
                                        DefaultAudioDevice.this.log.d("PhoneStateListener.onCallStateChanged(): TelephonyManager.CALL_STATE_IDLE", new Object[0]);
                                        new Handler().postDelayed(() -> DefaultAudioDevice.this.startRendererAndCapturer(), 5000L);
                                    }
                                    DefaultAudioDevice.this.log.d("PhoneStateListener.onCallStateChanged() exit ->", new Object[0]);
                                }
                            };
                            this.phoneStateListener = object2;
                            object2 = onAudioFocusChangeListener;
                            onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

                                public void onAudioFocusChange(int n) {
                                    DefaultAudioDevice.this.log.d("AudioManager.OnAudioFocusChangeListener.onAudioFocusChange() enter <-", new Object[0]);
                                    switch (n) {
                                        default: {
                                            DefaultAudioDevice.this.log.d("AudioManager.OnAudioFocusChangeListener.onAudioFocusChange(" + n + "): default", new Object[0]);
                                            break;
                                        }
                                        case 1: {
                                            3 v0 = this;
                                            v0.DefaultAudioDevice.this.log.d("AudioManager.OnAudioFocusChangeListener.onAudioFocusChange(" + n + "): ", new Object[0]);
                                            switch (v0.DefaultAudioDevice.this.audioState.getLastKnownFocusState()) {
                                                default: {
                                                    DefaultAudioDevice.this.log.d("focusChange = " + n, new Object[0]);
                                                    break;
                                                }
                                                case -3: {
                                                    DefaultAudioDevice.this.audioManager.setStreamVolume(0, DefaultAudioDevice.this.audioState.getLastStreamVolume(), 0);
                                                }
                                                case -2: 
                                                case -1: 
                                            }
                                            3 v1 = this;
                                            DefaultAudioDevice defaultAudioDevice = v1.DefaultAudioDevice.this;
                                            defaultAudioDevice.setOutputType(defaultAudioDevice.audioState.getPreviousOutputType());
                                            v1.DefaultAudioDevice.this.bluetoothManager.forceInvokeConnectBluetooth();
                                            break;
                                        }
                                        case 0: {
                                            DefaultAudioDevice.this.log.d("AudioManager.OnAudioFocusChangeListener.onAudioFocusChange(" + n + "): AudioManager.AUDIOFOCUS_NONE", new Object[0]);
                                            break;
                                        }
                                        case -1: {
                                            DefaultAudioDevice.this.log.d("AudioManager.OnAudioFocusChangeListener.onAudioFocusChange(" + n + "): AudioManager.AUDIOFOCUS_LOSS", new Object[0]);
                                            break;
                                        }
                                        case -2: {
                                            DefaultAudioDevice.this.log.d("AudioManager.OnAudioFocusChangeListener.onAudioFocusChange(" + n + "): AudioManager.AUDIOFOCUS_LOSS_TRANSIENT", new Object[0]);
                                            break;
                                        }
                                        case -3: {
                                            3 v3 = this;
                                            v3.DefaultAudioDevice.this.log.d("AudioManager.OnAudioFocusChangeListener.onAudioFocusChange(" + n + "): AudioManager.AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK", new Object[0]);
                                            v3.DefaultAudioDevice.this.audioState.setLastStreamVolume(DefaultAudioDevice.this.audioManager.getStreamVolume(0));
                                            v3.DefaultAudioDevice.this.audioManager.setStreamVolume(0, 0, 0);
                                        }
                                    }
                                    3 v4 = this;
                                    v4.DefaultAudioDevice.this.audioState.setPreviousOutputType(DefaultAudioDevice.this.getOutputType());
                                    v4.DefaultAudioDevice.this.audioState.setLastKnownFocusState(n);
                                    v4.DefaultAudioDevice.this.log.d("AudioManager.OnAudioFocusChangeListener.onAudioFocusChange() exit ->", new Object[0]);
                                }
                            };
                            this.audioFocusChangeListener = object2;
                            this.captureThread = this::lambda$new$0;
                            this.renderThread = this::lambda$new$1;
                            logToken.d("DefaultAudioDevice() enter " + this, new Object[0]);
                            this.context = object;
                            try {
                                this.recBuffer = ByteBuffer.allocateDirect(1760);
                            }
                            catch (Exception exception) {
                                this.log.e(exception.getMessage(), new Object[0]);
                            }
                            this.tempBufRec = new byte[1760];
                            object2 = (AudioManager)object.getSystemService("audio");
                            this.audioManager = object2;
                            this.bluetoothManager = BluetoothManager.create(object, this);
                            n = 1760;
                            int n3 = Integer.parseInt(object2.getProperty("android.media.property.OUTPUT_SAMPLE_RATE"));
                            {
                                catch (Throwable throwable2) {
                                    break block20;
                                }
                                catch (NumberFormatException numberFormatException2) {}
                                {
                                    this.log.e("DefaultAudioDevice(): " + numberFormatException2.getMessage(), new Object[0]);
                                    if (this.outputSamplingRate != 0) break block21;
                                    break block22;
                                }
                            }
                            {
                                this.outputSamplingRate = n3;
                            }
                            if (n3 != 0) break block21;
                        }
                        this.outputSamplingRate = 44100;
                    }
                    try {
                        n2 = Integer.parseInt(this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER"));
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    catch (NumberFormatException numberFormatException3) {
                        break block23;
                    }
                    {
                        this.samplesPerBuffer = n2;
                    }
                    n = n2 * 2;
                    if (n == 0) {
                        n = 1760;
                        this.samplesPerBuffer = 440;
                    }
                    break block24;
                }
                this.log.e("DefaultAudioDevice(): " + numberFormatException3.getMessage(), new Object[0]);
            }
            try {
                this.playBuffer = ByteBuffer.allocateDirect(n);
            }
            catch (Exception exception) {
                this.log.e(exception.getMessage(), new Object[0]);
            }
            Context context = object;
            this.tempBufPlay = new byte[n];
            object = audioSettings2;
            audioSettings2 = new BaseAudioDevice.AudioSettings(44100, 1);
            this.captureSettings = object;
            object = audioSettings;
            audioSettings = new BaseAudioDevice.AudioSettings(this.outputSamplingRate, 1);
            this.rendererSettings = object;
            try {
                this.telephonyManager = (TelephonyManager)context.getSystemService("phone");
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            this.isPhoneStateListenerRegistered = false;
            this.wasCapturing = false;
            this.wasRendering = false;
            this.isResumingAfterPaused = false;
            this.log.d("DefaultAudioDevice() exit  " + this, new Object[0]);
            return;
        }
        if (this.outputSamplingRate != 0) throw throwable2;
        this.outputSamplingRate = 44100;
        throw throwable2;
    }

    private void destroyAudioTrack() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.rendererLock.lock();
        defaultAudioDevice.audioTrack.release();
        defaultAudioDevice.audioTrack = null;
        defaultAudioDevice.shutdownRenderThread = true;
        defaultAudioDevice.renderEvent.signal();
        defaultAudioDevice.rendererLock.unlock();
    }

    private synchronized void registerHeadsetReceiver() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("registerHeadsetReceiver() enter ... isHeadsetReceiverRegistered = " + this.isHeadsetReceiverRegistered, new Object[0]);
        if (!defaultAudioDevice.isHeadsetReceiverRegistered) {
            this.context.registerReceiver(this.headsetBroadcastReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
            this.isHeadsetReceiverRegistered = true;
        }
        this.log.d("registerHeadsetReceiver() exit ... isHeadsetReceiverRegistered = " + this.isHeadsetReceiverRegistered, new Object[0]);
    }

    private synchronized void unregisterHeadsetReceiver() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("unregisterHeadsetReceiver() enter .. isHeadsetReceiverRegistered = " + this.isHeadsetReceiverRegistered, new Object[0]);
        if (defaultAudioDevice.isHeadsetReceiverRegistered) {
            this.context.unregisterReceiver(this.headsetBroadcastReceiver);
            this.isHeadsetReceiverRegistered = false;
        }
        this.log.d("unregisterHeadsetReceiver() exit .. isHeadsetReceiverRegistered = " + this.isHeadsetReceiverRegistered, new Object[0]);
    }

    private boolean hasPhoneStatePermission() {
        if (Build.VERSION.SDK_INT >= 31 && this.context.checkSelfPermission("android.permission.READ_PHONE_STATE") != 0) {
            this.log.e("Some features may not be available unless the phone permissions has been granted explicitly in the App settings.", new Object[0]);
            return false;
        }
        return true;
    }

    private void registerPhoneStateListener() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("registerPhoneStateListener() enter", new Object[0]);
        if (defaultAudioDevice.isPhoneStateListenerRegistered) {
            this.log.d("phoneStateListener is already registered.", new Object[0]);
            return;
        }
        if (!this.hasPhoneStatePermission()) {
            this.log.d("No Phone State permissions. Register phoneStateListener cannot be completed.", new Object[0]);
            return;
        }
        TelephonyManager telephonyManager = this.telephonyManager;
        if (telephonyManager != null) {
            telephonyManager.listen(this.phoneStateListener, 32);
            this.isPhoneStateListenerRegistered = true;
        }
        this.log.d("registerPhoneStateListener() exit", new Object[0]);
    }

    private void unRegisterPhoneStateListener() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("unRegisterPhoneStateListener() enter.", new Object[0]);
        if (!defaultAudioDevice.isPhoneStateListenerRegistered) {
            this.log.d("phoneStateListener is already unregistered.", new Object[0]);
            return;
        }
        if (!this.hasPhoneStatePermission()) {
            this.log.d("No Phone State permissions. Unregister phoneStateListener cannot be completed.", new Object[0]);
            return;
        }
        TelephonyManager telephonyManager = this.telephonyManager;
        if (telephonyManager != null) {
            telephonyManager.listen(this.phoneStateListener, 0);
            this.isPhoneStateListenerRegistered = false;
        }
        this.log.d("unRegisterPhoneStateListener() exit.", new Object[0]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$new$1() {
        block19: {
            var1_1 = this.samplesPerBuffer;
            try {
                Process.setThreadPriority((int)-19);
            }
            catch (Exception var2_3) {
                this.log.e("android.os.Process.setThreadPriority(): " + var2_3.getMessage(), new Object[0]);
            }
            while (true) {
                block18: {
                    if (this.shutdownRenderThread) {
                        return;
                    }
                    this.rendererLock.lock();
                    if (!this.isRendering) {
                        this.renderEvent.await();
                        break block18;
                    }
                    this.rendererLock.unlock();
                    this.playBuffer.clear();
                    var2_4 = this.getAudioBus().readRenderData(this.playBuffer, var1_1);
                    this.rendererLock.lock();
                    if (this.audioTrack == null || !this.isRendering) break block18;
                    this.playBuffer.get(this.tempBufPlay, 0, var2_4 <<= 1);
                    var2_4 = this.audioTrack.write(this.tempBufPlay, 0, var2_4);
                    if (var2_4 <= 0) ** GOTO lbl40
                    this.bufferedPlaySamples += var2_4 >> 1;
                    var2_4 = this.audioTrack.getPlaybackHeadPosition();
                    if (var2_4 < this.playPosition) {
                        this.playPosition = 0;
                    }
                    v0 = this.bufferedPlaySamples - (var2_4 - this.playPosition);
                    this.bufferedPlaySamples = v0;
                    this.playPosition = var2_4;
                    this.estimatedRenderDelay = v0 * 1000 / this.outputSamplingRate;
                    break block18;
lbl40:
                    // 1 sources

                    if (var2_4 == -3) {
                        throw new RuntimeException("renderThread(): AudioTrack.ERROR_INVALID_OPERATION");
                    }
                    if (var2_4 != -2) {
                        throw new RuntimeException("renderThread(): AudioTrack.ERROR or default");
                    }
                    throw new RuntimeException("renderThread(): AudioTrack.ERROR_BAD_VALUE");
                }
                this.rendererLock.unlock();
            }
            catch (Throwable v1) {
                break block19;
            }
            catch (Exception var1_2) {}
            this.log.e("Audio device capture error: " + var1_2.getMessage(), new Object[0]);
            this.rendererLock.unlock();
            return;
        }
        this.rendererLock.unlock();
        throw v1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$new$0() {
        block16: {
            block15: {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception var1_1) {
                    this.log.e("android.os.Process.setThreadPriority(): " + var1_1.getMessage(), new Object[0]);
                }
                while (true) {
                    if (this.shutdownCaptureThread) {
                        return;
                    }
                    v0 = this;
                    v0.captureLock.lock();
                    try {
                        if (!v0.isCapturing) {
                            v1 = this;
                            v1.captureEvent.await();
                            v1.captureLock.unlock();
                            continue;
                        }
                    }
                    catch (Exception var1_2) {
                        break block15;
                    }
                    catch (Throwable v2) {
                        break block16;
                    }
                    {
                        var1_3 = this.audioRecord;
                        if (var1_3 == null) {
                            this.captureLock.unlock();
                            continue;
                        }
                        var1_4 = 882;
                    }
                    {
                        if ((var1_4 = var1_3.read(this.tempBufRec, 0, var1_4)) < 0) break;
                    }
                    {
                        v3 = this;
                        v4 = var1_4;
                        v5 = this;
                        v6 = v5;
                        v5.recBuffer.rewind();
                    }
                    {
                        v6.recBuffer.put(this.tempBufRec);
                    }
                    var1_4 = v4 >> 1;
                    v7 = this;
                    v7.captureLock.unlock();
                    v7.getAudioBus().writeCaptureData(this.recBuffer, var1_4);
                    v3.estimatedCaptureDelay = var1_4 * 1000 / 44100;
                }
                if (var1_4 == -3) ** GOTO lbl46
                if (var1_4 == -2) ** GOTO lbl45
                {
                    throw new RuntimeException("captureThread(): AudioRecord.ERROR or default");
lbl45:
                    // 1 sources

                    throw new RuntimeException("captureThread(): AudioRecord.ERROR_BAD_VALUE");
lbl46:
                    // 1 sources

                    throw new RuntimeException("captureThread(): AudioRecord.ERROR_INVALID_OPERATION");
                }
            }
            v8 = this;
            v8.log.e("Audio device capture error: " + var1_2.getMessage(), new Object[0]);
            v8.captureLock.unlock();
            return;
        }
        this.captureLock.unlock();
        throw v2;
    }

    public OutputType getOutputType() {
        return this.audioOutputType;
    }

    public void setOutputType(OutputType outputType) {
        this.log.d("setOutputType(). Setting output type to " + (Object)((Object)outputType), new Object[0]);
        this.audioOutputType = outputType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean initCapturer() {
        AudioRecord audioRecord;
        this.log.d("initCapturer() enter <-", new Object[0]);
        int n = AudioRecord.getMinBufferSize((int)this.captureSettings.getSampleRate(), (int)16, (int)2);
        int n2 = n * 2;
        NoiseSuppressor noiseSuppressor = this.noiseSuppressor;
        if (noiseSuppressor != null) {
            noiseSuppressor.release();
            this.noiseSuppressor = null;
        }
        if ((noiseSuppressor = this.echoCanceler) != null) {
            noiseSuppressor.release();
            this.echoCanceler = null;
        }
        if ((noiseSuppressor = this.audioRecord) != null) {
            noiseSuppressor.release();
            this.audioRecord = null;
        }
        noiseSuppressor = audioRecord;
        try {
            audioRecord = new AudioRecord(7, this.captureSettings.getSampleRate(), 16, 2, n2);
            this.audioRecord = noiseSuppressor;
            if (NoiseSuppressor.isAvailable()) {
                this.noiseSuppressor = NoiseSuppressor.create((int)this.audioRecord.getAudioSessionId());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        if (AcousticEchoCanceler.isAvailable()) {
            this.echoCanceler = AcousticEchoCanceler.create((int)this.audioRecord.getAudioSessionId());
        }
        if (this.audioRecord.getState() == 1) {
            this.registerPhoneStateListener();
            this.shutdownCaptureThread = false;
            new Thread(this.captureThread).start();
            this.log.d("initCapturer() exit ->", new Object[0]);
            return true;
        }
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.captureSettings.getSampleRate();
        objectArray2[1] = this.captureSettings.getNumChannels();
        objectArray[2] = n;
        String string = String.format(Locale.getDefault(), "Audio capture could not be initialized.\nRequested parameters\n  Sampling Rate: %d\n  Number of channels: %d\n  Buffer size: %d\n", objectArray2);
        this.log.e(string, new Object[0]);
        throw new RuntimeException(string);
    }

    @Override
    public boolean destroyCapturer() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("destroyCapturer() enter <-", new Object[0]);
        defaultAudioDevice.captureLock.lock();
        AcousticEchoCanceler acousticEchoCanceler = defaultAudioDevice.echoCanceler;
        if (acousticEchoCanceler != null) {
            acousticEchoCanceler.release();
            this.echoCanceler = null;
        }
        if ((acousticEchoCanceler = this.noiseSuppressor) != null) {
            acousticEchoCanceler.release();
            this.noiseSuppressor = null;
        }
        DefaultAudioDevice defaultAudioDevice2 = this;
        defaultAudioDevice2.audioRecord.release();
        defaultAudioDevice2.audioRecord = null;
        defaultAudioDevice2.shutdownCaptureThread = true;
        defaultAudioDevice2.captureEvent.signal();
        defaultAudioDevice2.captureLock.unlock();
        defaultAudioDevice2.unRegisterPhoneStateListener();
        defaultAudioDevice2.wasCapturing = false;
        defaultAudioDevice2.log.d("destroyCapturer() exit ->", new Object[0]);
        return true;
    }

    @Override
    public int getEstimatedCaptureDelay() {
        return this.estimatedCaptureDelay;
    }

    @Override
    public boolean startCapturer() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("startCapturer() enter <-", new Object[0]);
        AudioRecord audioRecord = defaultAudioDevice.audioRecord;
        if (audioRecord != null) {
            try {
                DefaultAudioDevice defaultAudioDevice2 = this;
                audioRecord.startRecording();
                defaultAudioDevice2.captureLock.lock();
                defaultAudioDevice2.isCapturing = true;
                defaultAudioDevice2.captureEvent.signal();
                defaultAudioDevice2.captureLock.unlock();
                defaultAudioDevice2.audioManagerMode.acquireMode(this.audioManager);
                defaultAudioDevice2.log.d("startCapturer() exit ->", new Object[0]);
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                throw new RuntimeException(illegalStateException.getMessage());
            }
        }
        throw new IllegalStateException("startCapturer(): startRecording() called on an uninitialized AudioRecord.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean stopCapturer() {
        Throwable throwable2;
        block7: {
            block6: {
                DefaultAudioDevice defaultAudioDevice = this;
                defaultAudioDevice.log.d("stopCapturer() enter <-", new Object[0]);
                if (defaultAudioDevice.audioRecord == null) {
                    throw new IllegalStateException("stopCapturer(): stop() called on an uninitialized AudioRecord.");
                }
                DefaultAudioDevice defaultAudioDevice2 = this;
                defaultAudioDevice2.captureLock.lock();
                try {
                    try {
                        if (defaultAudioDevice2.audioRecord.getRecordingState() != 3) break block6;
                        this.audioRecord.stop();
                    }
                    catch (Throwable throwable2) {
                        break block7;
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
            DefaultAudioDevice defaultAudioDevice = this;
            defaultAudioDevice.isCapturing = false;
            defaultAudioDevice.captureLock.unlock();
            defaultAudioDevice.audioManagerMode.releaseMode(this.audioManager);
            defaultAudioDevice.log.d("stopCapturer() exit ->", new Object[0]);
            return true;
        }
        this.isCapturing = false;
        this.captureLock.unlock();
        throw throwable2;
    }

    @Override
    public boolean initRenderer() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("initRenderer() enter <-", new Object[0]);
        if (defaultAudioDevice.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 1) == 1) {
            block7: {
                int n;
                DefaultAudioDevice defaultAudioDevice2;
                int n2;
                DefaultAudioDevice defaultAudioDevice3 = this;
                defaultAudioDevice3.log.d("initRenderer(): AudioManager.AUDIOFOCUS_REQUEST_GRANTED", new Object[0]);
                int n3 = AudioTrack.getMinBufferSize((int)defaultAudioDevice3.rendererSettings.getSampleRate(), (int)4, (int)2);
                AudioTrack audioTrack = defaultAudioDevice3.audioTrack;
                if (audioTrack != null) {
                    audioTrack.release();
                    this.audioTrack = null;
                }
                try {
                    n2 = n3;
                    defaultAudioDevice2 = this;
                    n = 0;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                int n4 = defaultAudioDevice2.rendererSettings.getSampleRate();
                int n5 = 4;
                int n6 = 2;
                if (n2 < 6000) {
                    n3 *= 2;
                }
                AudioTrack audioTrack2 = audioTrack;
                audioTrack2(n, n4, n5, n6, n3, 1);
                this.audioTrack = audioTrack2;
                if (audioTrack.getState() != 1) break block7;
                DefaultAudioDevice defaultAudioDevice4 = this;
                defaultAudioDevice4.bufferedPlaySamples = 0;
                defaultAudioDevice4.registerPhoneStateListener();
                defaultAudioDevice4.shutdownRenderThread = false;
                new Thread(this.renderThread).start();
                defaultAudioDevice4.log.d("initRenderer() exit ->", new Object[0]);
                return true;
            }
            throw new RuntimeException("Audio renderer not initialized " + this.rendererSettings.getSampleRate());
        }
        this.log.d("initRenderer(): !AudioManager.AUDIOFOCUS_REQUEST_GRANTED", new Object[0]);
        return false;
    }

    @Override
    public boolean destroyRenderer() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("destroyRenderer() enter <-", new Object[0]);
        defaultAudioDevice.destroyAudioTrack();
        defaultAudioDevice.unregisterHeadsetReceiver();
        defaultAudioDevice.bluetoothManager.unregisterBtReceiver();
        defaultAudioDevice.audioManager.setSpeakerphoneOn(false);
        defaultAudioDevice.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        defaultAudioDevice.unRegisterPhoneStateListener();
        defaultAudioDevice.wasRendering = false;
        defaultAudioDevice.log.d("destroyRenderer() exit ->", new Object[0]);
        return true;
    }

    @Override
    public int getEstimatedRenderDelay() {
        return this.estimatedRenderDelay;
    }

    @Override
    public boolean startRenderer() {
        AudioTrack audioTrack;
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("startRenderer() enter <-", new Object[0]);
        defaultAudioDevice.bluetoothManager.forceInvokeConnectBluetooth();
        if (!defaultAudioDevice.bluetoothManager.isBluetoothConnected()) {
            if (this.isWiredHeadSetConnected()) {
                DefaultAudioDevice defaultAudioDevice2 = this;
                defaultAudioDevice2.log.d("startRenderer(): Turn off Speaker phone", new Object[0]);
                defaultAudioDevice2.audioManager.setSpeakerphoneOn(false);
            } else if (this.getOutputType() == OutputType.SPEAKER_PHONE && !this.bluetoothManager.isBluetoothConnected()) {
                DefaultAudioDevice defaultAudioDevice3 = this;
                defaultAudioDevice3.log.d("startRenderer(): Turn on Speaker phone", new Object[0]);
                defaultAudioDevice3.audioManager.setSpeakerphoneOn(true);
            }
        }
        if ((audioTrack = this.audioTrack) != null) {
            try {
                DefaultAudioDevice defaultAudioDevice4 = this;
                audioTrack.play();
                defaultAudioDevice4.rendererLock.lock();
                defaultAudioDevice4.isRendering = true;
                defaultAudioDevice4.renderEvent.signal();
                defaultAudioDevice4.rendererLock.unlock();
                defaultAudioDevice4.audioManagerMode.acquireMode(this.audioManager);
                defaultAudioDevice4.registerHeadsetReceiver();
                defaultAudioDevice4.log.d("startRenderer() exit ->", new Object[0]);
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                throw new RuntimeException(illegalStateException.getMessage());
            }
        }
        throw new IllegalStateException("startRenderer(): play() called on uninitialized AudioTrack.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean stopRenderer() {
        Throwable throwable2;
        block6: {
            DefaultAudioDevice defaultAudioDevice = this;
            defaultAudioDevice.log.d("stopRenderer() enter <-", new Object[0]);
            if (defaultAudioDevice.audioTrack == null) {
                throw new IllegalStateException("stopRenderer(): stop() called on uninitialized AudioTrack.");
            }
            DefaultAudioDevice defaultAudioDevice2 = this;
            defaultAudioDevice2.rendererLock.lock();
            try {
                if (defaultAudioDevice2.audioTrack.getPlayState() == 3) {
                    this.audioTrack.stop();
                }
                DefaultAudioDevice defaultAudioDevice3 = this;
                defaultAudioDevice3.audioTrack.flush();
                defaultAudioDevice3.isRendering = false;
                defaultAudioDevice3.rendererLock.unlock();
                defaultAudioDevice3.audioManagerMode.releaseMode(this.audioManager);
                defaultAudioDevice3.unregisterHeadsetReceiver();
                defaultAudioDevice3.log.d("stopRenderer() exit ->", new Object[0]);
                return true;
            }
            catch (Throwable throwable2) {
                break block6;
            }
            catch (Exception exception) {}
            throw new RuntimeException(exception.getMessage());
        }
        this.isRendering = false;
        this.rendererLock.unlock();
        throw throwable2;
    }

    @Override
    public BaseAudioDevice.AudioSettings getCaptureSettings() {
        return this.captureSettings;
    }

    @Override
    public BaseAudioDevice.AudioSettings getRenderSettings() {
        return this.rendererSettings;
    }

    @Override
    public boolean setOutputMode(BaseAudioDevice.OutputMode enum_) {
        this.log.d("setOutputMode(). Audio Output mode set to --> " + enum_, new Object[0]);
        super.setOutputMode((BaseAudioDevice.OutputMode)enum_);
        if (BaseAudioDevice.OutputMode.SpeakerPhone == enum_) {
            DefaultAudioDevice defaultAudioDevice = this;
            defaultAudioDevice.audioState.setPreviousOutputType(this.getOutputType());
            defaultAudioDevice.setOutputType(OutputType.SPEAKER_PHONE);
            defaultAudioDevice.audioManager.setSpeakerphoneOn(true);
            defaultAudioDevice.bluetoothManager.stopBluetoothSCO();
        } else {
            DefaultAudioDevice defaultAudioDevice = this;
            defaultAudioDevice.audioManager.setSpeakerphoneOn(false);
            enum_ = OutputType.BLUETOOTH;
            if (defaultAudioDevice.audioState.getPreviousOutputType() != enum_ && this.getBluetoothState() != BaseAudioDevice.BluetoothState.Connected) {
                DefaultAudioDevice defaultAudioDevice2 = this;
                defaultAudioDevice2.audioState.setPreviousOutputType(this.getOutputType());
                defaultAudioDevice2.setOutputType(OutputType.EAR_PIECE);
                defaultAudioDevice2.bluetoothManager.stopBluetoothSCO();
            } else {
                this.setOutputType((OutputType)enum_);
            }
        }
        return true;
    }

    @Override
    public synchronized void onPause() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("onPause() enter <-", new Object[0]);
        defaultAudioDevice.audioState.setPreviousOutputType(this.getOutputType());
        defaultAudioDevice.bluetoothManager.onPause();
        defaultAudioDevice.unregisterHeadsetReceiver();
        defaultAudioDevice.isResumingAfterPaused = true;
        defaultAudioDevice.log.d("onPause() exit ->", new Object[0]);
    }

    @Override
    public synchronized void onResume() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("onResume() enter. isResumingAfterPaused = " + this.isResumingAfterPaused, new Object[0]);
        defaultAudioDevice.registerHeadsetReceiver();
        defaultAudioDevice.bluetoothManager.onResume();
        if (defaultAudioDevice.isResumingAfterPaused) {
            if (this.getBluetoothState() == BaseAudioDevice.BluetoothState.Disconnected && this.isRendering && this.audioState.getPreviousOutputType() == OutputType.SPEAKER_PHONE && !this.isWiredHeadSetConnected()) {
                DefaultAudioDevice defaultAudioDevice2 = this;
                defaultAudioDevice2.log.d("onResume() - Set Speaker Phone ON True", new Object[0]);
                defaultAudioDevice2.audioManager.setSpeakerphoneOn(true);
            }
            this.isResumingAfterPaused = false;
        }
        this.log.d("onResume() exit ->", new Object[0]);
    }

    @Override
    public BaseAudioDevice.BluetoothState getBluetoothState() {
        return this.bluetoothManager.getBluetoothState();
    }

    boolean isWiredHeadSetConnected() {
        for (AudioDeviceInfo audioDeviceInfo : this.audioManager.getDevices(2)) {
            this.log.d("Detected connected audio output device of type: " + audioDeviceInfo.getType(), new Object[0]);
            if (audioDeviceInfo.getType() != 4 && audioDeviceInfo.getType() != 3 && audioDeviceInfo.getType() != 22) {
                continue;
            }
            this.log.d("Detected connected wired headset", new Object[0]);
            return true;
        }
        return false;
    }

    public void restoreAudioAfterBluetoothDisconnect() {
        DefaultAudioDevice defaultAudioDevice = this;
        defaultAudioDevice.log.d("restoreAudioAfterBluetoothDisconnect enter.", new Object[0]);
        if (defaultAudioDevice.isWiredHeadSetConnected()) {
            DefaultAudioDevice defaultAudioDevice2 = this;
            defaultAudioDevice2.setOutputType(OutputType.HEAD_PHONES);
            defaultAudioDevice2.audioManager.setSpeakerphoneOn(false);
        } else {
            int n = 4.$SwitchMap$com$opentok$android$BaseAudioDevice$OutputMode[this.getOutputMode().ordinal()];
            if (n != 1) {
                if (n != 2) {
                    this.log.e("This should not happen. :(", new Object[0]);
                } else {
                    DefaultAudioDevice defaultAudioDevice3 = this;
                    defaultAudioDevice3.log.d("Falling back to handset mode.", new Object[0]);
                    defaultAudioDevice3.setOutputType(OutputType.EAR_PIECE);
                    defaultAudioDevice3.audioManager.setSpeakerphoneOn(false);
                }
            } else {
                DefaultAudioDevice defaultAudioDevice4 = this;
                defaultAudioDevice4.log.d("Falling back to speaker mode.", new Object[0]);
                defaultAudioDevice4.setOutputType(OutputType.SPEAKER_PHONE);
                defaultAudioDevice4.audioManager.setSpeakerphoneOn(true);
            }
        }
        this.log.d("restoreAudioAfterBluetoothDisconnect exit.", new Object[0]);
    }

    private static class AudioState {
        private int lastStreamVolume = 0;
        private int lastKnownFocusState = 0;
        private OutputType lastOutputType = OutputType.SPEAKER_PHONE;
        private final OtLog.LogToken log = new OtLog.LogToken(this);

        private AudioState() {
        }

        int getLastStreamVolume() {
            return this.lastStreamVolume;
        }

        void setLastStreamVolume(int n) {
            this.lastStreamVolume = n;
        }

        int getLastKnownFocusState() {
            return this.lastKnownFocusState;
        }

        void setLastKnownFocusState(int n) {
            this.lastKnownFocusState = n;
        }

        OutputType getPreviousOutputType() {
            AudioState audioState = this;
            audioState.log.d("AudioState.getPreviousOutputType() = " + (Object)((Object)this.lastOutputType), new Object[0]);
            return audioState.lastOutputType;
        }

        void setPreviousOutputType(OutputType outputType) {
            this.log.d("AudioState.setPreviousOutputType() = " + (Object)((Object)outputType), new Object[0]);
            this.lastOutputType = outputType;
        }
    }

    public static enum OutputType {
        SPEAKER_PHONE,
        EAR_PIECE,
        HEAD_PHONES,
        BLUETOOTH;

    }

    private static class AudioManagerMode {
        private int oldMode;
        private int naquire;
        private final OtLog.LogToken log;

        AudioManagerMode() {
            OtLog.LogToken logToken;
            OtLog.LogToken logToken2 = logToken;
            logToken = new OtLog.LogToken(this);
            this.log = logToken2;
            this.oldMode = 0;
            this.naquire = 0;
        }

        void acquireMode(AudioManager audioManager) {
            AudioManagerMode audioManagerMode = this;
            audioManagerMode.log.d("AudioManagerMode.acquireMode() called", new Object[0]);
            int n = audioManagerMode.naquire;
            this.naquire = n + 1;
            if (n == 0) {
                this.oldMode = audioManager.getMode();
                audioManager.setMode(3);
            }
        }

        void releaseMode(AudioManager audioManager) {
            AudioManagerMode audioManagerMode = this;
            audioManagerMode.log.d("AudioManagerMode.releaseMode() called", new Object[0]);
            this.naquire = audioManagerMode.naquire - 1;
            if (this.naquire == 0) {
                audioManager.setMode(this.oldMode);
            }
        }
    }
}

