/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.view.View;
import com.opentok.android.BaseVideoRenderer;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class DefaultVideoRenderer
extends BaseVideoRenderer {
    protected long nativeInstance;
    Context context;
    GLSurfaceView view;
    MyRenderer renderer;
    BaseVideoRenderer.Frame lastFrame;
    ReentrantLock frameLock;
    boolean isPillarBoxEnabled;
    boolean isVideoDisabled;

    public DefaultVideoRenderer(Context object) {
        MyRenderer myRenderer;
        DefaultVideoRenderer defaultVideoRenderer = this;
        this.frameLock = new ReentrantLock();
        this.isPillarBoxEnabled = true;
        this.isVideoDisabled = false;
        defaultVideoRenderer.context = object;
        this.view = new GLSurfaceView(object);
        this.view.setEGLContextClientVersion(2);
        object = myRenderer;
        defaultVideoRenderer.renderer = new MyRenderer();
        defaultVideoRenderer.view.setRenderer((GLSurfaceView.Renderer)object);
        defaultVideoRenderer.view.setRenderMode(0);
        defaultVideoRenderer.view.setZOrderMediaOverlay(true);
    }

    @Override
    public void onPause() {
        this.view.onPause();
    }

    @Override
    public void onResume() {
        this.view.onResume();
    }

    @Override
    public void onFrame(BaseVideoRenderer.Frame frame) {
        DefaultVideoRenderer defaultVideoRenderer = this;
        defaultVideoRenderer.frameLock.lock();
        BaseVideoRenderer.Frame frame2 = defaultVideoRenderer.lastFrame;
        if (frame2 != null) {
            frame2.destroy();
        }
        DefaultVideoRenderer defaultVideoRenderer2 = this;
        defaultVideoRenderer2.lastFrame = frame;
        defaultVideoRenderer2.frameLock.unlock();
        defaultVideoRenderer2.view.requestRender();
    }

    @Override
    public void setStyle(String string, String string2) {
        if ("STYLE_VIDEO_SCALE".equals(string)) {
            if ("STYLE_VIDEO_FIT".equals(string2)) {
                this.isPillarBoxEnabled = true;
            } else if ("STYLE_VIDEO_FILL".equals(string2)) {
                this.isPillarBoxEnabled = false;
            }
        }
    }

    @Override
    public void onVideoPropertiesChanged(boolean bl) {
        DefaultVideoRenderer defaultVideoRenderer = this;
        this.frameLock.lock();
        defaultVideoRenderer.isVideoDisabled = bl ^ true;
        defaultVideoRenderer.frameLock.unlock();
        defaultVideoRenderer.view.requestRender();
    }

    @Override
    public View getView() {
        return this.view;
    }

    native void nativeCreateRenderer();

    native void nativeSetupRenderer(int var1, int var2);

    native void nativeRenderFrame(ByteBuffer var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, ByteBuffer var9, ByteBuffer var10, ByteBuffer var11, boolean var12, boolean var13);

    private class MyRenderer
    implements GLSurfaceView.Renderer {
        public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
            gL10.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            GLES20.glClear((int)16384);
            DefaultVideoRenderer.this.nativeCreateRenderer();
        }

        public void onSurfaceChanged(GL10 gL10, int n, int n2) {
            DefaultVideoRenderer.this.nativeSetupRenderer(n, n2);
        }

        public void onDrawFrame(GL10 object) {
            MyRenderer myRenderer = this;
            int n = 0;
            BaseVideoRenderer.Frame frame = null;
            myRenderer.DefaultVideoRenderer.this.frameLock.lock();
            DefaultVideoRenderer defaultVideoRenderer = myRenderer.DefaultVideoRenderer.this;
            if (!defaultVideoRenderer.isVideoDisabled) {
                BaseVideoRenderer.Frame frame2 = defaultVideoRenderer.lastFrame;
                if (frame2 != null) {
                    defaultVideoRenderer.lastFrame = null;
                    frame = frame2;
                }
            } else {
                n = 1;
            }
            defaultVideoRenderer.frameLock.unlock();
            if (n == 0) {
                if (frame != null) {
                    object = frame.getBuffer();
                    object.clear();
                    BaseVideoRenderer.Frame frame3 = frame;
                    int n2 = frame3.getWidth();
                    int n3 = frame3.getHeight();
                    n = frame3.getYstride();
                    int n4 = frame3.getUvStride();
                    int n5 = frame3.getYplaneSize();
                    int n6 = frame3.getUVplaneSize();
                    int n7 = frame3.getUVplaneSize();
                    ByteBuffer byteBuffer = frame3.getYplane();
                    ByteBuffer byteBuffer2 = frame3.getUplane();
                    ByteBuffer byteBuffer3 = frame3.getVplane();
                    boolean bl = frame3.isMirroredX();
                    boolean bl2 = DefaultVideoRenderer.this.isPillarBoxEnabled;
                    DefaultVideoRenderer.this.nativeRenderFrame((ByteBuffer)object, n2, n3, n, n4, n5, n6, n7, byteBuffer, byteBuffer2, byteBuffer3, bl, bl2);
                    frame.destroy();
                }
            } else {
                object.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                GLES20.glClear((int)16384);
            }
        }
    }
}

