/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.util.Pair;
import android.util.SparseArray;
import android.view.Surface;
import com.opentok.android.MediaCodecVideoEncoder;
import com.opentok.android.OtLog;
import com.vonage.webrtc.SurfaceTextureHelper61;
import com.vonage.webrtc.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class MediaCodecVideoDecoder {
    private static final long MAX_DECODE_TIME_MS = 200L;
    static final OtLog.LogToken log;
    private static final String FORMAT_KEY_STRIDE = "stride";
    private static final String FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static MediaCodecVideoDecoder runningInstance;
    private static MediaCodecVideoDecoderErrorCallback errorCallback;
    private static int codecErrors;
    private static Set<String> hwDecoderDisabledTypes;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    static final SupportedDecoderRecord[] VP8_SUPPORT;
    static final SupportedDecoderRecord[] VP9_SUPPORT;
    static final SupportedDecoderRecord[] H264_SUPPORT;
    private static final SparseArray<Pair<String, SupportedDecoderRecord[]>> SupportedDecoderTbl;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList;
    private Thread mediaCodecThread;
    MediaCodec mediaCodec;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private final Queue<TimeStamps> decodeStartTimeMs;
    private boolean useSurface;
    private TextureListener textureListener;
    private int droppedFrames;
    private Surface surface;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers;

    MediaCodecVideoDecoder() {
        LinkedList linkedList;
        LinkedList linkedList2;
        Object object = linkedList2;
        linkedList2 = new LinkedList();
        v1.decodeStartTimeMs = object;
        v1.surface = null;
        object = linkedList;
        linkedList = new LinkedList();
        v1.dequeuedSurfaceOutputBuffers = object;
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        log.d("Set error callback", new Object[0]);
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        log.w("VP8 decoding is disabled by application.", new Object[0]);
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        log.w("VP9 decoding is disabled by application.", new Object[0]);
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        log.w("H.264 decoding is disabled by application.", new Object[0]);
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, VP8_SUPPORT).length > 0;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, VP9_SUPPORT).length > 0;
    }

    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, H264_SUPPORT).length > 0;
    }

    public static boolean isH264HighProfileHwSupported() {
        DecoderProperties[] decoderPropertiesArray = MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, H264_SUPPORT);
        return decoderPropertiesArray.length > 0 && decoderPropertiesArray[0].meta.containsKey("HighProfile") && Build.VERSION.SDK_INT >= decoderPropertiesArray[0].meta.get("HighProfile");
    }

    public static void printStackTrace() {
        Object object = runningInstance;
        if (object != null && (object = object.mediaCodecThread) != null && ((StackTraceElement[])(object = object.getStackTrace())).length > 0) {
            log.d("MediaCodecVideoDecoder stacks trace:", new Object[0]);
            int n = ((StackTraceElement[])object).length;
            for (int k = 0; k < n; ++k) {
                log.d(object[k].toString(), new Object[0]);
            }
        }
    }

    private static MediaCodecInfo[] getCodecList() {
        Vector<MediaCodecInfo> vector;
        Vector<MediaCodecInfo> vector2 = vector;
        vector = new Vector<MediaCodecInfo>();
        for (int k = 0; k < MediaCodecList.getCodecCount(); ++k) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)k);
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
            vector2.add(mediaCodecInfo);
        }
        Vector<MediaCodecInfo> vector3 = vector2;
        return vector3.toArray(new MediaCodecInfo[vector3.size()]);
    }

    private static DecoderProperties[] findDecoder(String string, SupportedDecoderRecord[] objectArray) {
        Vector vector;
        log.d("Trying to find HW decoder for mime " + string, new Object[0]);
        Object object = vector;
        vector = new Vector();
        block15: for (MediaCodecInfo mediaCodecInfo : MediaCodecVideoDecoder.getCodecList()) {
            if (!Arrays.asList(mediaCodecInfo.getSupportedTypes()).contains(string)) continue;
            log.d("Found candidate decoder " + mediaCodecInfo.getName(), new Object[0]);
            Object[] objectArray2 = MediaCodecVideoDecoder.createIntList(mediaCodecInfo.getCapabilitiesForType((String)string).colorFormats);
            int n = objectArray.length;
            block16: for (int k = 0; k < n; ++k) {
                IllegalArgumentException illegalArgumentException2;
                block20: {
                    Exception exception2;
                    block19: {
                        DecoderProperties decoderProperties;
                        Pair pair;
                        int n2;
                        Object object2 = objectArray[k];
                        if (Build.VERSION.SDK_INT < ((SupportedDecoderRecord)object2).supportedVersion) continue;
                        if (!mediaCodecInfo.getName().startsWith(((SupportedDecoderRecord)object2).prefix)) continue;
                        Object object3 = supportedColorList.iterator();
                        while (true) {
                            if (!object3.hasNext()) continue block16;
                            Object[] objectArray3 = objectArray2;
                            n2 = object3.next();
                            if (!objectArray3.contains(n2)) continue;
                            break;
                        }
                        Object object4 = object;
                        log.d("Found target decoder " + mediaCodecInfo.getName() + ". Color: 0x" + Integer.toHexString(n2), new Object[0]);
                        Pair pair2 = pair;
                        Pair pair3 = pair;
                        Object object5 = object2;
                        object3 = decoderProperties;
                        Object object6 = object2;
                        object2 = mediaCodecInfo.getName();
                        Map<String, Integer> map = ((SupportedDecoderRecord)object6).meta;
                        try {
                            decoderProperties = new DecoderProperties((String)object2, n2, map);
                            pair2(object3, (Object)((SupportedDecoderRecord)object5).priority);
                            object4.add(pair3);
                        }
                        catch (Exception exception2) {
                            break block19;
                        }
                        catch (IllegalArgumentException illegalArgumentException2) {
                            break block20;
                        }
                        continue;
                    }
                    Object[] objectArray4 = new Object[1];
                    objectArray2 = objectArray4;
                    objectArray4[0] = exception2;
                    log.e("general error", objectArray2);
                    exception2.printStackTrace();
                    continue block15;
                }
                Object[] objectArray5 = new Object[1];
                objectArray2 = objectArray5;
                objectArray5[0] = illegalArgumentException2;
                log.e("Cannot retreive decoder capabilities", objectArray2);
                continue block15;
            }
        }
        Vector vector2 = object;
        Collections.sort(vector2, new Comparator<Pair<DecoderProperties, SupportedDecoderRecord.Priority>>(){

            @Override
            public int compare(Pair<DecoderProperties, SupportedDecoderRecord.Priority> pair, Pair<DecoderProperties, SupportedDecoderRecord.Priority> pair2) {
                return ((SupportedDecoderRecord.Priority)((Object)pair.second)).ordinal() - ((SupportedDecoderRecord.Priority)((Object)pair2.second)).ordinal();
            }
        });
        int n = 0;
        objectArray = new DecoderProperties[vector2.size()];
        object = vector2.iterator();
        while (object.hasNext()) {
            objectArray[n++] = (DecoderProperties)((Pair)object.next()).first;
        }
        return objectArray;
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() == Thread.currentThread().getId()) {
            return;
        }
        throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initDecode(VideoCodecType videoCodecType, int n, int n2, SurfaceTextureHelper61 surfaceTextureHelper61) {
        if (this.mediaCodecThread != null) throw new RuntimeException("initDecode: Forgot to release()?");
        boolean bl = surfaceTextureHelper61 != null;
        this.useSurface = bl;
        Pair pair = (Pair)SupportedDecoderTbl.get(videoCodecType.ordinal());
        DecoderProperties[] decoderPropertiesArray = MediaCodecVideoDecoder.findDecoder((String)pair.first, (SupportedDecoderRecord[])pair.second);
        if (decoderPropertiesArray == null) throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
        if (decoderPropertiesArray.length == 0) throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
        log.d("Java initDecode: " + (Object)((Object)videoCodecType) + " : " + n + " x " + n2 + ". Color: 0x" + Integer.toHexString(decoderPropertiesArray[0].colorFormat) + ". Use Surface: " + this.useSurface, new Object[0]);
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        this.width = n;
        this.height = n2;
        this.stride = n;
        this.sliceHeight = n2;
        videoCodecType = MediaFormat.createVideoFormat((String)((String)pair.first), (int)n, (int)n2);
        n = 0;
        n2 = decoderPropertiesArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block8: {
                boolean bl2;
                boolean bl3;
                Object object;
                DecoderProperties decoderProperties = decoderPropertiesArray[n3];
                try {
                    if (this.useSurface) {
                        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
                        mediaCodecVideoDecoder.textureListener = new TextureListener(surfaceTextureHelper61);
                        mediaCodecVideoDecoder.surface = new Surface(surfaceTextureHelper61.getSurfaceTexture());
                    } else {
                        object = "color-format";
                        videoCodecType.setInteger((String)object, decoderProperties.colorFormat);
                    }
                    object = log;
                    ((OtLog.LogToken)object).d("  Format: " + (Object)((Object)videoCodecType), new Object[0]);
                    bl3 = true;
                    bl2 = this.initDecoder(decoderProperties, (MediaFormat)videoCodecType);
                }
                catch (Exception exception) {}
                n = bl2 ? 1 : 0;
                if (bl3 != bl2) break block8;
                ((OtLog.LogToken)object).d("using decoder: " + decoderProperties.codecName, new Object[0]);
                return n != 0;
            }
            ++n3;
        }
        return n != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initDecoder(DecoderProperties objectArray, MediaFormat mediaFormat) {
        IllegalStateException illegalStateException2;
        block4: {
            MediaCodec mediaCodec;
            try {
                mediaCodec = MediaCodecVideoEncoder.createByCodecName(objectArray.codecName);
            }
            catch (IllegalStateException illegalStateException2) {
                break block4;
            }
            this.mediaCodec = mediaCodec;
            if (mediaCodec == null) {
                log.e("Can not create media decoder", new Object[0]);
                return false;
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            mediaCodec.configure(mediaFormat, this.surface, null, 0);
            this.mediaCodec.start();
            mediaCodecVideoDecoder.colorFormat = objectArray.colorFormat;
            mediaCodecVideoDecoder.outputBuffers = mediaCodecVideoDecoder.mediaCodec.getOutputBuffers();
            mediaCodecVideoDecoder.inputBuffers = mediaCodecVideoDecoder.mediaCodec.getInputBuffers();
            mediaCodecVideoDecoder.decodeStartTimeMs.clear();
            mediaCodecVideoDecoder.hasDecodedFirstFrame = false;
            mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.clear();
            mediaCodecVideoDecoder.droppedFrames = 0;
            log.d("Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length, new Object[0]);
            return true;
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = illegalStateException2;
        log.e("initDecode failed", objectArray);
        return false;
    }

    private void reset(int n, int n2) {
        if (this.mediaCodecThread != null && this.mediaCodec != null) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            log.d("Java reset: " + n + " x " + n2, new Object[0]);
            this.mediaCodec.flush();
            this.width = n;
            mediaCodecVideoDecoder.height = n2;
            mediaCodecVideoDecoder.decodeStartTimeMs.clear();
            mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.clear();
            mediaCodecVideoDecoder.hasDecodedFirstFrame = false;
            mediaCodecVideoDecoder.droppedFrames = 0;
            return;
        }
        throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
    }

    private void release() {
        Runnable runnable;
        CountDownLatch countDownLatch;
        OtLog.LogToken logToken = log;
        logToken.d("Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames, new Object[0]);
        this.checkOnMediaCodecThread();
        final CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                OtLog.LogToken logToken = log;
                try {
                    5 v0 = this;
                    logToken.d("Java releaseDecoder on release thread", new Object[0]);
                    v0.MediaCodecVideoDecoder.this.mediaCodec.stop();
                    v0.MediaCodecVideoDecoder.this.mediaCodec.release();
                    logToken.d("Java releaseDecoder on release thread done", new Object[0]);
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = exception;
                    log.e("Media decoder release failed", objectArray2);
                }
                countDownLatch2.countDown();
            }
        };
        new Thread(runnable2).start();
        if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)countDownLatch, (long)5000L)) {
            logToken.e("Media decoder release timeout", new Object[0]);
            ++codecErrors;
            if (errorCallback != null) {
                logToken.e("Invoke codec error callback. Errors: " + codecErrors, new Object[0]);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        if (this.useSurface) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            mediaCodecVideoDecoder.surface.release();
            mediaCodecVideoDecoder.surface = null;
            mediaCodecVideoDecoder.textureListener.release();
        }
        logToken.d("Java releaseDecoder done", new Object[0]);
    }

    private int dequeueInputBuffer() {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        try {
            return mediaCodecVideoDecoder.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("dequeueIntputBuffer failed", objectArray2);
            return -2;
        }
    }

    private boolean queueInputBuffer(int n, int n2, long l, long l2, long l3) {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        try {
            mediaCodecVideoDecoder.inputBuffers[n].position(0);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("decode failed", objectArray2);
            return false;
        }
        mediaCodecVideoDecoder.inputBuffers[n].limit(n2);
        mediaCodecVideoDecoder.decodeStartTimeMs.add(new TimeStamps(SystemClock.elapsedRealtime(), l2, l3));
        mediaCodecVideoDecoder.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
        return true;
    }

    private DecodedOutputBuffer dequeueOutputBuffer(int n) {
        MediaCodec.BufferInfo bufferInfo;
        this.checkOnMediaCodecThread();
        if (this.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            int n2 = this.mediaCodec.dequeueOutputBuffer(bufferInfo2, TimeUnit.MILLISECONDS.toMicros(n));
            switch (n2) {
                default: {
                    this.hasDecodedFirstFrame = true;
                    TimeStamps timeStamps = this.decodeStartTimeMs.remove();
                    long l = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
                    if (l > 200L) {
                        log.e("Very high decode time: " + l + "ms. Q size: " + this.decodeStartTimeMs.size() + ". Might be caused by resuming H264 decoding after a pause.", new Object[0]);
                        l = 200L;
                    }
                    TimeStamps timeStamps2 = timeStamps;
                    MediaCodec.BufferInfo bufferInfo3 = bufferInfo2;
                    int n3 = bufferInfo3.offset;
                    int n4 = bufferInfo3.size;
                    long l2 = TimeUnit.MICROSECONDS.toMillis(bufferInfo2.presentationTimeUs);
                    long l3 = timeStamps2.timeStampMs;
                    long l4 = timeStamps2.ntpTimeStampMs;
                    long l5 = SystemClock.elapsedRealtime();
                    return new DecodedOutputBuffer(n2, n3, n4, l2, l3, l4, l, l5);
                }
                case -1: {
                    return null;
                }
                case -2: {
                    int n5;
                    int n6;
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    OtLog.LogToken logToken = log;
                    logToken.d("Decoder format changed: " + mediaFormat.toString(), new Object[0]);
                    if (mediaFormat.containsKey(FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(FORMAT_KEY_CROP_TOP)) {
                        MediaFormat mediaFormat2 = mediaFormat;
                        n6 = mediaFormat2.getInteger(FORMAT_KEY_CROP_RIGHT) + 1 - mediaFormat.getInteger(FORMAT_KEY_CROP_LEFT);
                        n5 = mediaFormat2.getInteger(FORMAT_KEY_CROP_BOTTOM) + 1 - mediaFormat.getInteger(FORMAT_KEY_CROP_TOP);
                    } else {
                        MediaFormat mediaFormat3 = mediaFormat;
                        n6 = mediaFormat3.getInteger("width");
                        n5 = mediaFormat3.getInteger("height");
                    }
                    if (this.hasDecodedFirstFrame && (n6 != this.width || n5 != this.height)) {
                        throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n6 + "*" + n5);
                    }
                    this.width = n6;
                    this.height = n5;
                    if (!this.useSurface && mediaFormat.containsKey("color-format")) {
                        this.colorFormat = mediaFormat.getInteger("color-format");
                        logToken.d("Color: 0x" + Integer.toHexString(this.colorFormat), new Object[0]);
                        if (!supportedColorList.contains(this.colorFormat)) {
                            throw new IllegalStateException("Non supported color format: " + this.colorFormat);
                        }
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_STRIDE)) {
                        this.stride = mediaFormat.getInteger(FORMAT_KEY_STRIDE);
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_SLICE_HEIGHT)) {
                        this.sliceHeight = mediaFormat.getInteger(FORMAT_KEY_SLICE_HEIGHT);
                    }
                    logToken.d("Frame stride and slice height: " + this.stride + " x " + this.sliceHeight, new Object[0]);
                    this.stride = Math.max(this.width, this.stride);
                    this.sliceHeight = Math.max(this.height, this.sliceHeight);
                    continue block5;
                }
                case -3: 
            }
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            log.d("Decoder output buffers changed: " + this.outputBuffers.length, new Object[0]);
            if (this.hasDecodedFirstFrame) break;
        }
        throw new RuntimeException("Unexpected output buffer change event.");
    }

    private DecodedTextureBuffer dequeueTextureBuffer(int n) {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        if (mediaCodecVideoDecoder.useSurface) {
            Object object = this.dequeueOutputBuffer(n);
            if (object != null) {
                this.dequeuedSurfaceOutputBuffers.add((DecodedOutputBuffer)object);
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder2 = this;
            mediaCodecVideoDecoder2.MaybeRenderDecodedTextureBuffer();
            object = mediaCodecVideoDecoder2.textureListener.dequeueTextureBuffer(n);
            if (object != null) {
                this.MaybeRenderDecodedTextureBuffer();
                return object;
            }
            if (this.dequeuedSurfaceOutputBuffers.size() < Math.min(3, this.outputBuffers.length) && (n <= 0 || this.dequeuedSurfaceOutputBuffers.isEmpty())) {
                return null;
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder3 = this;
            ++mediaCodecVideoDecoder3.droppedFrames;
            DecodedOutputBuffer decodedOutputBuffer = mediaCodecVideoDecoder3.dequeuedSurfaceOutputBuffers.remove();
            if (n > 0) {
                log.w("Draining decoder. Dropping frame with TS: " + decodedOutputBuffer.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames, new Object[0]);
            } else {
                log.w("Too many output buffers " + this.dequeuedSurfaceOutputBuffers.size() + ". Dropping frame with TS: " + decodedOutputBuffer.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames, new Object[0]);
            }
            this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, false);
            DecodedOutputBuffer decodedOutputBuffer2 = decodedOutputBuffer;
            long l = decodedOutputBuffer2.presentationTimeStampMs;
            long l2 = decodedOutputBuffer2.timeStampMs;
            long l3 = decodedOutputBuffer2.ntpTimeStampMs;
            long l4 = decodedOutputBuffer2.decodeTimeMs;
            long l5 = SystemClock.elapsedRealtime() - decodedOutputBuffer.endDecodeTimeMs;
            return new DecodedTextureBuffer(0, null, l, l2, l3, l4, l5);
        }
        throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (!((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).dequeuedSurfaceOutputBuffers.isEmpty() && !((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).textureListener.isWaitingForTexture()) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder = decodedOutputBuffer;
            DecodedOutputBuffer decodedOutputBuffer = mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.remove();
            mediaCodecVideoDecoder.textureListener.addBufferToRender(decodedOutputBuffer);
            mediaCodecVideoDecoder.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
            return;
        }
    }

    private void returnDecodedOutputBuffer(int n) {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        if (!mediaCodecVideoDecoder.useSurface) {
            this.mediaCodec.releaseOutputBuffer(n, false);
            return;
        }
        throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
    }

    private static List<Integer> createIntList(int[] nArray) {
        Vector<Integer> vector;
        Vector<Integer> vector2 = vector;
        vector = new Vector<Integer>(nArray.length);
        int n = nArray.length;
        for (int k = 0; k < n; ++k) {
            vector2.add(nArray[k]);
        }
        return vector2;
    }

    static {
        SupportedDecoderRecord supportedDecoderRecord;
        SupportedDecoderRecord supportedDecoderRecord2;
        SupportedDecoderRecord supportedDecoderRecord3;
        HashMap<String, Integer> hashMap;
        SupportedDecoderRecord supportedDecoderRecord4;
        SupportedDecoderRecord supportedDecoderRecord5;
        HashMap<String, Integer> hashMap2;
        SupportedDecoderRecord supportedDecoderRecord6;
        log = OtLog.LogToken("[MediaCodecDecoder]");
        runningInstance = null;
        errorCallback = null;
        codecErrors = 0;
        hwDecoderDisabledTypes = new HashSet<String>();
        VP8_SUPPORT = new SupportedDecoderRecord[0];
        VP9_SUPPORT = new SupportedDecoderRecord[0];
        SupportedDecoderRecord[] supportedDecoderRecordArray = new SupportedDecoderRecord[6];
        SupportedDecoderRecord supportedDecoderRecord7 = supportedDecoderRecord6;
        SupportedDecoderRecord.Priority priority = SupportedDecoderRecord.Priority.HARDWARE;
        HashMap<String, Integer> hashMap3 = hashMap2;
        hashMap2 = new HashMap<String, Integer>(){
            {
                1 v0 = this;
                ((AbstractMap)v0).put("HighProfile", 21);
            }
        };
        supportedDecoderRecord6 = new SupportedDecoderRecord("OMX.qcom.", 19, priority, (Map<String, Integer>)hashMap3);
        supportedDecoderRecordArray[0] = supportedDecoderRecord7;
        supportedDecoderRecord7 = supportedDecoderRecord5;
        supportedDecoderRecord5 = new SupportedDecoderRecord("OMX.Intel.", 19, priority, null);
        supportedDecoderRecordArray[1] = supportedDecoderRecord7;
        supportedDecoderRecord7 = supportedDecoderRecord4;
        hashMap3 = hashMap;
        hashMap = new HashMap<String, Integer>(){
            {
                2 v0 = this;
                ((AbstractMap)v0).put("HighProfile", 23);
            }
        };
        supportedDecoderRecord4 = new SupportedDecoderRecord("OMX.Exynos.", 19, priority, (Map<String, Integer>)hashMap3);
        supportedDecoderRecordArray[2] = supportedDecoderRecord7;
        supportedDecoderRecord7 = supportedDecoderRecord3;
        supportedDecoderRecord3 = new SupportedDecoderRecord("OMX.IMG.", 19, priority, null);
        supportedDecoderRecordArray[3] = supportedDecoderRecord7;
        supportedDecoderRecord7 = supportedDecoderRecord2;
        supportedDecoderRecord2 = new SupportedDecoderRecord("OMX.MTK.", 19, priority, null);
        supportedDecoderRecordArray[4] = supportedDecoderRecord7;
        supportedDecoderRecord7 = supportedDecoderRecord;
        priority = SupportedDecoderRecord.Priority.SOFTWARE;
        supportedDecoderRecord = new SupportedDecoderRecord("OMX.google.h264.", 23, priority, null);
        supportedDecoderRecordArray[5] = supportedDecoderRecord7;
        H264_SUPPORT = supportedDecoderRecordArray;
        SupportedDecoderTbl = new SparseArray<Pair<String, SupportedDecoderRecord[]>>(){
            {
                3 v0 = this;
                v0.append(VideoCodecType.VIDEO_CODEC_VP8.ordinal(), new Pair((Object)MediaCodecVideoDecoder.VP8_MIME_TYPE, (Object)VP8_SUPPORT));
                v0.append(VideoCodecType.VIDEO_CODEC_VP9.ordinal(), new Pair((Object)MediaCodecVideoDecoder.VP9_MIME_TYPE, (Object)VP9_SUPPORT));
                v0.append(VideoCodecType.VIDEO_CODEC_H264.ordinal(), new Pair((Object)MediaCodecVideoDecoder.H264_MIME_TYPE, (Object)H264_SUPPORT));
            }
        };
        supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    private static class SupportedDecoderRecord {
        public final String prefix;
        public final int supportedVersion;
        public final Priority priority;
        public final Map<String, Integer> meta;

        public SupportedDecoderRecord(String string, int n, Priority priority, Map<String, Integer> hashMap) {
            this.prefix = string;
            this.supportedVersion = n;
            this.priority = priority;
            if (hashMap == null) {
                HashMap hashMap2;
                hashMap = hashMap2;
                hashMap2 = new HashMap();
            }
            this.meta = hashMap;
        }

        public static enum Priority {
            HARDWARE(100),
            SOFTWARE(10);

            private final int priority;

            private Priority(int n2) {
                this.priority = n2;
            }
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final Map<String, Integer> meta;

        public DecoderProperties(String string, int n, Map<String, Integer> map) {
            this.codecName = string;
            this.colorFormat = n;
            this.meta = map;
        }
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_GENERIC,
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_AV1,
        VIDEO_CODEC_H264;

    }

    private static class TextureListener
    implements SurfaceTextureHelper61.OnTextureFrameAvailableListener {
        private final SurfaceTextureHelper61 surfaceTextureHelper;
        private final Object newFrameLock;
        private DecodedOutputBuffer bufferToRender;
        private DecodedTextureBuffer renderedBuffer;

        public TextureListener(SurfaceTextureHelper61 surfaceTextureHelper61) {
            Object object;
            Object object2 = object;
            object = new Object();
            this.newFrameLock = object2;
            this.surfaceTextureHelper = surfaceTextureHelper61;
            surfaceTextureHelper61.startListening(this);
        }

        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            if (this.bufferToRender == null) {
                this.bufferToRender = decodedOutputBuffer;
                return;
            }
            log.e("Unexpected addBufferToRender() called while waiting for a texture.", new Object[0]);
            throw new IllegalStateException("Waiting for a texture.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWaitingForTexture() {
            TextureListener textureListener = object;
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                boolean bl = textureListener.bufferToRender != null;
                return bl;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onTextureFrameAvailable(int n, float[] fArray, long l) {
            TextureListener textureListener = this;
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                Throwable throwable2;
                block5: {
                    block4: {
                        long l2;
                        long l3;
                        long l4;
                        long l5;
                        long l6;
                        float[] fArray2;
                        int n2;
                        DecodedTextureBuffer decodedTextureBuffer;
                        DecodedTextureBuffer decodedTextureBuffer2;
                        TextureListener textureListener2;
                        try {
                            DecodedTextureBuffer decodedTextureBuffer3;
                            if (textureListener.renderedBuffer != null) break block4;
                            Object object2 = object;
                            TextureListener textureListener3 = this;
                            textureListener2 = textureListener3;
                            TextureListener textureListener4 = textureListener3;
                            TextureListener textureListener5 = textureListener3;
                            decodedTextureBuffer2 = decodedTextureBuffer3;
                            decodedTextureBuffer = decodedTextureBuffer3;
                            n2 = n;
                            fArray2 = fArray;
                            DecodedOutputBuffer decodedOutputBuffer = this.bufferToRender;
                            l6 = decodedOutputBuffer.presentationTimeStampMs;
                            l5 = decodedOutputBuffer.timeStampMs;
                            l4 = decodedOutputBuffer.ntpTimeStampMs;
                            l3 = decodedOutputBuffer.decodeTimeMs;
                            l2 = SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs;
                        }
                        catch (Throwable throwable2) {
                            break block5;
                        }
                        decodedTextureBuffer2(n2, fArray2, l6, l5, l4, l3, l2);
                        textureListener4.renderedBuffer = decodedTextureBuffer;
                        textureListener5.bufferToRender = null;
                        textureListener2.newFrameLock.notifyAll();
                        // ** MonitorExit[v1] (shouldn't be in output)
                        return;
                    }
                    log.e("Unexpected onTextureFrameAvailable() called while already holding a texture.", new Object[0]);
                    throw new IllegalStateException("Already holding a texture.");
                }
                throw throwable2;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public DecodedTextureBuffer dequeueTextureBuffer(int var1_1) {
            v0 = this;
            var2_2 = v0.newFrameLock;
            synchronized (var2_2) {
                block10: {
                    try {
                        if (v0.renderedBuffer == null && var1_1 > 0 && this.isWaitingForTexture()) {
                        }
                        ** GOTO lbl18
                    }
                    catch (Throwable v1) {
                        try {
                            break block10;
                        }
                        catch (InterruptedException v2) {
                            try {}
                            catch (Throwable v1) {
                                // empty catch block
                                break block10;
                            }
                            Thread.currentThread().interrupt();
lbl18:
                            // 3 sources

                            while (true) {
                                this.renderedBuffer = null;
                                return this.renderedBuffer;
                            }
                        }
                    }
                    {
                        this.newFrameLock.wait(var1_1);
                        ** continue;
                    }
                }
                throw v1;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release() {
            TextureListener textureListener = this;
            textureListener.surfaceTextureHelper.stopListening();
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                Throwable throwable2;
                block4: {
                    block3: {
                        try {
                            if (textureListener.renderedBuffer == null) break block3;
                            this.surfaceTextureHelper.returnTextureFrame();
                            this.renderedBuffer = null;
                        }
                        catch (Throwable throwable2) {
                            break block4;
                        }
                    }
                    return;
                }
                throw throwable2;
            }
        }
    }

    private static class TimeStamps {
        final long decodeStartTimeMs;
        final long timeStampMs;
        final long ntpTimeStampMs;

        public TimeStamps(long l, long l2, long l3) {
            this.decodeStartTimeMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
        }
    }

    private static class DecodedOutputBuffer {
        final int index;
        private final int offset;
        private final int size;
        final long presentationTimeStampMs;
        final long timeStampMs;
        final long ntpTimeStampMs;
        final long decodeTimeMs;
        final long endDecodeTimeMs;

        public DecodedOutputBuffer(int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
            this.index = n;
            this.offset = n2;
            this.size = n3;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.endDecodeTimeMs = l5;
        }
    }

    private static class DecodedTextureBuffer {
        private final int textureID;
        private final float[] transformMatrix;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;

        public DecodedTextureBuffer(int n, float[] fArray, long l, long l2, long l3, long l4, long l5) {
            this.textureID = n;
            this.transformMatrix = fArray;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.ntpTimeStampMs = l3;
            this.decodeTimeMs = l4;
            this.frameDelayMs = l5;
        }
    }
}

