/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.Surface;
import com.opentok.android.OtLog;
import com.vonage.webrtc.EglBase14;
import com.vonage.webrtc.GlRectDrawer;
import com.vonage.webrtc.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class MediaCodecVideoEncoder {
    static final OtLog.LogToken log;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static final int BITRATE_ADJUSTMENT_FPS = 30;
    private static final int MAXIMUM_INITIAL_FPS = 30;
    private static final double BITRATE_CORRECTION_SEC = 3.0;
    private static final double BITRATE_CORRECTION_MAX_SCALE = 4.0;
    private static final int BITRATE_CORRECTION_STEPS = 20;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000L;
    private static MediaCodecVideoEncoder runningInstance;
    private static MediaCodecVideoEncoderErrorCallback errorCallback;
    private static int codecErrors;
    private static Set<String> hwEncoderDisabledTypes;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final int VIDEO_AVCProfileHigh = 8;
    private static final int VIDEO_AVCLevel3 = 256;
    static final SupportedEncoderRecord[] VP8_SUPPORT;
    static final SupportedEncoderRecord[] VP9_SUPPORT;
    static final SupportedEncoderRecord[] H264_SUPPORT;
    private static final SparseArray<Pair<String, SupportedEncoderRecord[]>> SupportedEncoderTbl;
    private static final SparseIntArray KeyFrameIntervalSecTbl;
    private static final String[] H264_BLACKLIST;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList;
    private static final int[] supportedSurfaceColorList;
    private Thread mediaCodecThread;
    MediaCodec mediaCodec;
    private ByteBuffer[] outputBuffers;
    private EglBase14 eglBase;
    private int profile;
    private int width;
    private int height;
    private Surface inputSurface;
    private GlRectDrawer drawer;
    private VideoCodecType type;
    private int colorFormat;
    private BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
    private double bitrateAccumulator;
    private double bitrateAccumulatorMax;
    private double bitrateObservationTimeMs;
    private int bitrateAdjustmentScaleExp;
    private int targetBitrateBps;
    private int targetFps;
    private long forcedKeyFrameMs;
    private long lastKeyFrameMs;
    private ByteBuffer configData = null;

    MediaCodecVideoEncoder() {
    }

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        log.d("Set error callback", new Object[0]);
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        log.w("VP8 encoding is disabled by application.", new Object[0]);
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        log.w("VP9 encoding is disabled by application.", new Object[0]);
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        log.w("H.264 encoding is disabled by application.", new Object[0]);
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, VP8_SUPPORT, nArray = supportedColorList).length > 0;
    }

    public static boolean isVp9HwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, VP9_SUPPORT, nArray = supportedColorList).length > 0;
    }

    public static boolean isH264HwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, H264_SUPPORT, nArray = supportedColorList).length > 0;
    }

    public static boolean isH264HighProfileHwSupported() {
        Object[] objectArray = supportedColorList;
        EncoderProperties[] encoderPropertiesArray = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, H264_SUPPORT, objectArray);
        objectArray = encoderPropertiesArray;
        return encoderPropertiesArray.length > 0 && objectArray[0].meta.containsKey("HighProfile") && Build.VERSION.SDK_INT >= objectArray[0].meta.get("HighProfile");
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, VP8_SUPPORT, nArray = supportedSurfaceColorList).length > 0;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, VP9_SUPPORT, nArray = supportedSurfaceColorList).length > 0;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, H264_SUPPORT, nArray = supportedSurfaceColorList).length > 0;
    }

    private static MediaCodecInfo[] getCodecList() {
        Vector<MediaCodecInfo> vector;
        Vector<MediaCodecInfo> vector2 = vector;
        vector = new Vector<MediaCodecInfo>();
        for (int k = 0; k < MediaCodecList.getCodecCount(); ++k) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)k);
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder()) continue;
            vector2.add(mediaCodecInfo);
        }
        Vector<MediaCodecInfo> vector3 = vector2;
        return vector3.toArray(new MediaCodecInfo[vector3.size()]);
    }

    private static EncoderProperties[] findHwEncoder(String string, SupportedEncoderRecord[] objectArray, int[] object) {
        Vector<Pair> vector;
        log.d("Trying to find HW encoder for mime " + string, new Object[0]);
        Vector<Pair> vector2 = vector;
        vector = new Vector<Pair>();
        block15: for (MediaCodecInfo mediaCodecInfo : MediaCodecVideoEncoder.getCodecList()) {
            Object[] objectArray2;
            if (!Arrays.asList(mediaCodecInfo.getSupportedTypes()).contains(string)) continue;
            if (string.equals(H264_MIME_TYPE)) {
                objectArray2 = Build.MODEL;
                if (Arrays.asList(H264_BLACKLIST).contains(objectArray2)) {
                    log.w("Model: " + (String)objectArray2 + " is blacklisted for H264.", new Object[0]);
                    continue;
                }
            }
            Object[] objectArray3 = objectArray;
            objectArray2 = MediaCodecVideoEncoder.createIntList(mediaCodecInfo.getCapabilitiesForType((String)string).colorFormats);
            int n = objectArray3.length;
            block16: for (int k = 0; k < n; ++k) {
                IllegalArgumentException illegalArgumentException2;
                block22: {
                    Exception exception2;
                    block21: {
                        Object object2 = objectArray[k];
                        if (Build.VERSION.SDK_INT < ((SupportedEncoderRecord)object2).supportedVersion) continue;
                        if (!mediaCodecInfo.getName().startsWith(((SupportedEncoderRecord)object2).prefix)) continue;
                        int n2 = ((Object)object).length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            EncoderProperties encoderProperties;
                            Pair pair;
                            Object[] objectArray4 = objectArray2;
                            Object object3 = object[i2];
                            if (!objectArray4.contains((int)object3)) continue;
                            Vector<Pair> vector3 = vector2;
                            log.d("Found target encoder " + mediaCodecInfo.getName() + ". Color: 0x" + Integer.toHexString((int)object3) + ". Bitrate adjustment: " + (Object)((Object)((SupportedEncoderRecord)object2).bitrateAdjustmentType), new Object[0]);
                            Pair pair2 = pair;
                            Pair pair3 = pair;
                            Object object4 = object2;
                            EncoderProperties encoderProperties2 = encoderProperties;
                            Object object5 = object2;
                            Object object6 = object5;
                            Object object7 = object5;
                            object2 = mediaCodecInfo.getName();
                            BitrateAdjustmentType bitrateAdjustmentType = ((SupportedEncoderRecord)object6).bitrateAdjustmentType;
                            Map<String, Integer> map = ((SupportedEncoderRecord)object7).meta;
                            try {
                                encoderProperties = new EncoderProperties((String)object2, (int)object3, bitrateAdjustmentType, map);
                                pair2((Object)encoderProperties2, (Object)((SupportedEncoderRecord)object4).priority);
                                vector3.add(pair3);
                            }
                            catch (Exception exception2) {
                                break block21;
                            }
                            catch (IllegalArgumentException illegalArgumentException2) {
                                break block22;
                            }
                            continue block16;
                        }
                        continue;
                    }
                    Object[] objectArray5 = new Object[1];
                    objectArray2 = objectArray5;
                    objectArray5[0] = exception2;
                    log.e("general error", objectArray2);
                    exception2.printStackTrace();
                    continue block15;
                }
                Object[] objectArray6 = new Object[1];
                objectArray2 = objectArray6;
                objectArray6[0] = illegalArgumentException2;
                log.e("Cannot retreive decoder capabilities", objectArray2);
                continue block15;
            }
        }
        Vector<Pair> vector4 = vector2;
        Collections.sort(vector4, new Comparator<Pair<EncoderProperties, SupportedEncoderRecord.Priority>>(){

            @Override
            public int compare(Pair<EncoderProperties, SupportedEncoderRecord.Priority> pair, Pair<EncoderProperties, SupportedEncoderRecord.Priority> pair2) {
                return ((SupportedEncoderRecord.Priority)((Object)pair.second)).ordinal() - ((SupportedEncoderRecord.Priority)((Object)pair2.second)).ordinal();
            }
        });
        int n = 0;
        objectArray = new EncoderProperties[vector4.size()];
        object = vector4.iterator();
        while (object.hasNext()) {
            objectArray[n++] = (EncoderProperties)((Pair)object.next()).first;
        }
        return objectArray;
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() == Thread.currentThread().getId()) {
            return;
        }
        throw new RuntimeException("MediaCodecVideoEncoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
    }

    public static void printStackTrace() {
        Object object = runningInstance;
        if (object != null && (object = object.mediaCodecThread) != null && ((StackTraceElement[])(object = object.getStackTrace())).length > 0) {
            log.d("MediaCodecVideoEncoder stacks trace:", new Object[0]);
            int n = ((StackTraceElement[])object).length;
            for (int k = 0; k < n; ++k) {
                log.d(object[k].toString(), new Object[0]);
            }
        }
    }

    static MediaCodec createByCodecName(String string) {
        try {
            return MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initEncoder(VideoCodecType videoCodecType, EncoderProperties object, EglBase14.Context context, String string) {
        Exception exception2;
        block7: {
            MediaCodec mediaCodec;
            MediaFormat mediaFormat;
            int n = KeyFrameIntervalSecTbl.get(videoCodecType.ordinal());
            boolean bl = objectArray3.profile == H264Profile.CONSTRAINED_HIGH.getValue() && MediaCodecVideoEncoder.isH264HighProfileHwSupported();
            try {
                int n2 = objectArray3.width;
                mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n2, (int)objectArray3.height);
            }
            catch (Exception exception2) {
                break block7;
            }
            MediaFormat mediaFormat2 = mediaFormat;
            String string2 = "bitrate";
            mediaFormat2.setInteger(string2, objectArray3.targetBitrateBps);
            mediaFormat2.setInteger("bitrate-mode", 2);
            string2 = "color-format";
            mediaFormat.setInteger(string2, ((EncoderProperties)object).colorFormat);
            string2 = "frame-rate";
            mediaFormat.setInteger(string2, objectArray3.targetFps);
            mediaFormat.setInteger("i-frame-interval", n);
            if (bl) {
                MediaFormat mediaFormat3 = mediaFormat;
                mediaFormat3.setInteger("profile", 8);
                mediaFormat3.setInteger("level", 256);
            }
            EncoderProperties encoderProperties = object;
            object = log;
            {
                ((OtLog.LogToken)object).d("  Format: " + mediaFormat, new Object[0]);
                mediaCodec = MediaCodecVideoEncoder.createByCodecName(encoderProperties.codecName);
            }
            {
                objectArray3.mediaCodec = mediaCodec;
                objectArray3.type = videoCodecType;
                if (mediaCodec == null) {
                    ((OtLog.LogToken)object).e("Can not create media encoder", new Object[0]);
                    objectArray3.release();
                    return false;
                }
                mediaCodec.configure(mediaFormat, null, null, 1);
                objectArray3.mediaCodec.start();
                objectArray3.outputBuffers = objectArray3.mediaCodec.getOutputBuffers();
                ((OtLog.LogToken)object).d("Output buffers: " + objectArray3.outputBuffers.length, new Object[0]);
                return true;
            }
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = exception2;
        log.e("initEncode failed", objectArray3);
        objectArray.release();
        return false;
    }

    private boolean setRates(int n, int n2) {
        Bundle bundle;
        MediaCodecVideoEncoder mediaCodecVideoEncoder;
        mediaCodecVideoEncoder2.checkOnMediaCodecThread();
        int n3 = n * 1000;
        BitrateAdjustmentType bitrateAdjustmentType = mediaCodecVideoEncoder2.bitrateAdjustmentType;
        BitrateAdjustmentType bitrateAdjustmentType2 = BitrateAdjustmentType.DYNAMIC_ADJUSTMENT;
        if (bitrateAdjustmentType == bitrateAdjustmentType2) {
            double d2 = n3;
            mediaCodecVideoEncoder2.bitrateAccumulatorMax = d2 / 8.0;
            int n4 = mediaCodecVideoEncoder2.targetBitrateBps;
            if (n4 > 0 && n3 < n4) {
                mediaCodecVideoEncoder2.bitrateAccumulator = mediaCodecVideoEncoder2.bitrateAccumulator * d2 / (double)n4;
            }
        }
        mediaCodecVideoEncoder2.targetBitrateBps = n3;
        mediaCodecVideoEncoder2.targetFps = n2;
        if (bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT && n2 > 0) {
            n3 = n * 30000 / n2;
            log.v("setRates: " + n + " -> " + n3 / 1000 + " kbps. Fps: " + mediaCodecVideoEncoder2.targetFps, new Object[0]);
        } else if (bitrateAdjustmentType == bitrateAdjustmentType2) {
            log.v("setRates: " + n + " kbps. Fps: " + mediaCodecVideoEncoder2.targetFps + ". ExpScale: " + mediaCodecVideoEncoder2.bitrateAdjustmentScaleExp, new Object[0]);
            n = mediaCodecVideoEncoder2.bitrateAdjustmentScaleExp;
            if (n != 0) {
                n3 = (int)((double)n3 * mediaCodecVideoEncoder2.getBitrateScale(n));
            }
        } else {
            log.v("setRates: " + n + " kbps. Fps: " + mediaCodecVideoEncoder2.targetFps, new Object[0]);
        }
        try {
            mediaCodecVideoEncoder = mediaCodecVideoEncoder2;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("setRates failed", objectArray2);
            return false;
        }
        MediaCodecVideoEncoder mediaCodecVideoEncoder2 = bundle;
        new Bundle().putInt("video-bitrate", n3);
        mediaCodecVideoEncoder.mediaCodec.setParameters((Bundle)mediaCodecVideoEncoder2);
        return true;
    }

    private double getBitrateScale(int n) {
        double d2 = (double)n / 20.0;
        return Math.pow(4.0, d2);
    }

    private void reportEncodedFrame(int n) {
        block2: {
            block3: {
                block6: {
                    OtLog.LogToken logToken;
                    block5: {
                        double d2;
                        double d3;
                        block4: {
                            double d4;
                            double d5;
                            int n2 = this.targetFps;
                            if (n2 == 0 || this.bitrateAdjustmentType != BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) break block2;
                            double d6 = (double)this.targetBitrateBps / ((double)n2 * 8.0);
                            this.bitrateAccumulator = d6 = this.bitrateAccumulator + ((double)n - d6);
                            d3 = n2;
                            this.bitrateObservationTimeMs = d3 = this.bitrateObservationTimeMs + 1000.0 / d3;
                            d3 = this.bitrateAccumulatorMax * 3.0;
                            this.bitrateAccumulator = d2 = Math.min(d6, d3);
                            this.bitrateAccumulator = d3 = Math.max(d2, -d3);
                            if (!(this.bitrateObservationTimeMs > 3000.0)) break block3;
                            logToken = log;
                            logToken.d("Acc: " + (int)this.bitrateAccumulator + ". Max: " + (int)this.bitrateAccumulatorMax + ". ExpScale: " + this.bitrateAdjustmentScaleExp, new Object[0]);
                            d3 = this.bitrateAccumulator;
                            d2 = this.bitrateAccumulatorMax;
                            if (!(d5 > d4)) break block4;
                            this.bitrateAdjustmentScaleExp -= (int)(d3 / d2 + 0.5);
                            this.bitrateAccumulator = d2;
                            break block5;
                        }
                        if (!(d3 < -d2)) break block6;
                        this.bitrateAdjustmentScaleExp += (int)(-d3 / d2 + 0.5);
                        this.bitrateAccumulator = d3 = -d2;
                    }
                    this.bitrateAdjustmentScaleExp = Math.min(this.bitrateAdjustmentScaleExp, 20);
                    this.bitrateAdjustmentScaleExp = Math.max(this.bitrateAdjustmentScaleExp, -20);
                    logToken.d("Adjusting bitrate scale to " + this.bitrateAdjustmentScaleExp + ". Value: " + this.getBitrateScale(this.bitrateAdjustmentScaleExp), new Object[0]);
                    int n3 = this.targetFps;
                    this.setRates(this.targetBitrateBps / 1000, n3);
                }
                this.bitrateObservationTimeMs = 0.0;
            }
            return;
        }
    }

    private static List<Integer> createIntList(int[] nArray) {
        Vector<Integer> vector;
        Vector<Integer> vector2 = vector;
        vector = new Vector<Integer>(nArray.length);
        int n = nArray.length;
        for (int k = 0; k < n; ++k) {
            vector2.add(nArray[k]);
        }
        return vector2;
    }

    static {
        SupportedEncoderRecord supportedEncoderRecord;
        SupportedEncoderRecord supportedEncoderRecord2;
        SupportedEncoderRecord supportedEncoderRecord3;
        HashMap<String, Integer> hashMap;
        SupportedEncoderRecord supportedEncoderRecord4;
        SupportedEncoderRecord supportedEncoderRecord5;
        log = OtLog.LogToken("[MediaCodecEncoder]");
        runningInstance = null;
        errorCallback = null;
        codecErrors = 0;
        hwEncoderDisabledTypes = new HashSet<String>();
        VP8_SUPPORT = new SupportedEncoderRecord[0];
        VP9_SUPPORT = new SupportedEncoderRecord[0];
        SupportedEncoderRecord[] supportedEncoderRecordArray = new SupportedEncoderRecord[5];
        SupportedEncoderRecord supportedEncoderRecord6 = supportedEncoderRecord5;
        SupportedEncoderRecord.Priority priority = SupportedEncoderRecord.Priority.HARDWARE;
        BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        supportedEncoderRecord5 = new SupportedEncoderRecord("OMX.qcom.", 19, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray[0] = supportedEncoderRecord6;
        supportedEncoderRecord6 = supportedEncoderRecord4;
        BitrateAdjustmentType bitrateAdjustmentType2 = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
        HashMap<String, Integer> hashMap2 = hashMap;
        hashMap = new HashMap<String, Integer>(){
            {
                1 v0 = this;
                ((AbstractMap)v0).put("HighProfile", 23);
            }
        };
        supportedEncoderRecord4 = new SupportedEncoderRecord("OMX.Exynos.", 21, priority, bitrateAdjustmentType2, (Map<String, Integer>)hashMap2);
        supportedEncoderRecordArray[1] = supportedEncoderRecord6;
        supportedEncoderRecord6 = supportedEncoderRecord3;
        supportedEncoderRecord3 = new SupportedEncoderRecord("OMX.IMG.", 19, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray[2] = supportedEncoderRecord6;
        supportedEncoderRecord6 = supportedEncoderRecord2;
        supportedEncoderRecord2 = new SupportedEncoderRecord("OMX.MTK.", 19, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray[3] = supportedEncoderRecord6;
        supportedEncoderRecord6 = supportedEncoderRecord;
        priority = SupportedEncoderRecord.Priority.SOFTWARE;
        supportedEncoderRecord = new SupportedEncoderRecord("OMX.google.h264.", 23, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray[4] = supportedEncoderRecord6;
        H264_SUPPORT = supportedEncoderRecordArray;
        SupportedEncoderTbl = new SparseArray<Pair<String, SupportedEncoderRecord[]>>(){
            {
                2 v0 = this;
                v0.append(VideoCodecType.VIDEO_CODEC_VP8.ordinal(), new Pair((Object)MediaCodecVideoEncoder.VP8_MIME_TYPE, (Object)VP8_SUPPORT));
                v0.append(VideoCodecType.VIDEO_CODEC_VP9.ordinal(), new Pair((Object)MediaCodecVideoEncoder.VP9_MIME_TYPE, (Object)VP9_SUPPORT));
                v0.append(VideoCodecType.VIDEO_CODEC_H264.ordinal(), new Pair((Object)MediaCodecVideoEncoder.H264_MIME_TYPE, (Object)H264_SUPPORT));
            }
        };
        KeyFrameIntervalSecTbl = new SparseIntArray(){
            {
                3 v0 = this;
                v0.append(VideoCodecType.VIDEO_CODEC_VP8.ordinal(), 100);
                v0.append(VideoCodecType.VIDEO_CODEC_VP9.ordinal(), 100);
                v0.append(VideoCodecType.VIDEO_CODEC_H264.ordinal(), 20);
            }
        };
        H264_BLACKLIST = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
        supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
        supportedSurfaceColorList = new int[]{2130708361};
    }

    boolean initEncode(VideoCodecType videoCodecType, int n, int n2, int n3, int n4, int n5, EglBase14.Context context) {
        OtLog.LogToken logToken = log;
        EncoderProperties[] encoderPropertiesArray = new StringBuilder().append("Java initEncode: ").append((Object)videoCodecType).append(". Profile: ").append(n).append(" : ").append(n2).append(" x ").append(n3).append(". @ ").append(n4).append(" kbps. Fps: ").append(n5).append(". Encode from texture : ");
        boolean bl = context != null;
        logToken.d(encoderPropertiesArray.append(bl).toString(), new Object[0]);
        if (this.mediaCodecThread == null) {
            logToken = (Pair)SupportedEncoderTbl.get(videoCodecType.ordinal());
            encoderPropertiesArray = (String)((Pair)logToken).first;
            Object object = (SupportedEncoderRecord[])((Pair)logToken).second;
            int[] nArray = context != null ? supportedSurfaceColorList : supportedColorList;
            if ((encoderPropertiesArray = MediaCodecVideoEncoder.findHwEncoder((String)encoderPropertiesArray, object, nArray)) != null && encoderPropertiesArray.length != 0) {
                double d2;
                this.profile = n;
                this.width = n2;
                this.height = n3;
                runningInstance = this;
                this.bitrateAccumulator = 0.0;
                this.bitrateObservationTimeMs = 0.0;
                this.bitrateAdjustmentScaleExp = 0;
                this.targetBitrateBps = n4 * 1000;
                this.bitrateAccumulatorMax = d2 = (double)this.targetBitrateBps / 8.0;
                this.mediaCodecThread = Thread.currentThread();
                for (EncoderProperties encoderProperties : encoderPropertiesArray) {
                    this.colorFormat = encoderProperties.colorFormat;
                    this.bitrateAdjustmentType = encoderProperties.bitrateAdjustmentType;
                    this.lastKeyFrameMs = -1L;
                    this.forcedKeyFrameMs = 0L;
                    n4 = this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT ? 30 : Math.min(n5, 30);
                    this.targetFps = n4;
                    if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8 && encoderProperties.codecName.startsWith("OMX.qcom.")) {
                        this.forcedKeyFrameMs = 15000L;
                    }
                    OtLog.LogToken logToken2 = log;
                    logToken2.d("Color format: " + this.colorFormat + ". Bitrate adjustment: " + (Object)((Object)this.bitrateAdjustmentType) + ". Key frame interval: " + this.forcedKeyFrameMs + " . Initial fps: " + n5, new Object[0]);
                    object = (String)((Pair)logToken).first;
                    if (this.initEncoder(videoCodecType, encoderProperties, context, (String)object)) {
                        logToken2.d("[h.264] using encoder: " + encoderProperties.codecName, new Object[0]);
                        return true;
                    }
                    this.mediaCodecThread = Thread.currentThread();
                    logToken2.d("[h.264] encoder init failed: " + encoderProperties.codecName, new Object[0]);
                }
                return false;
            }
            throw new RuntimeException("Can not find HW encoder for " + (Object)((Object)videoCodecType));
        }
        throw new RuntimeException("Forgot to release()?");
    }

    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = byteBufferArray.mediaCodec.getInputBuffers();
        log.d("Input buffers: " + byteBufferArray.length, new Object[0]);
        return byteBufferArray;
    }

    void checkKeyFrameRequired(boolean bl, long l) {
        long l2;
        l = (l + 500L) / 1000L;
        if (mediaCodecVideoEncoder3.lastKeyFrameMs < 0L) {
            mediaCodecVideoEncoder3.lastKeyFrameMs = l;
        }
        boolean bl2 = false;
        if (!bl && (l2 = mediaCodecVideoEncoder3.forcedKeyFrameMs) > 0L && l > mediaCodecVideoEncoder3.lastKeyFrameMs + l2) {
            bl2 = true;
        }
        if (bl || bl2) {
            Bundle bundle;
            if (bl) {
                log.d("Sync frame request", new Object[0]);
            } else {
                log.d("Sync frame forced", new Object[0]);
            }
            MediaCodecVideoEncoder mediaCodecVideoEncoder = mediaCodecVideoEncoder3;
            MediaCodecVideoEncoder mediaCodecVideoEncoder2 = mediaCodecVideoEncoder3;
            MediaCodecVideoEncoder mediaCodecVideoEncoder3 = bundle;
            new Bundle().putInt("request-sync", 0);
            mediaCodecVideoEncoder2.mediaCodec.setParameters((Bundle)mediaCodecVideoEncoder3);
            mediaCodecVideoEncoder.lastKeyFrameMs = l;
        }
    }

    boolean encodeBuffer(boolean bl, int n, int n2, long l) {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        this.checkOnMediaCodecThread();
        try {
            mediaCodecVideoEncoder.checkKeyFrameRequired(bl, l);
            mediaCodecVideoEncoder.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("encodeBuffer failed", objectArray2);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean encodeTexture(boolean bl, int n, float[] fArray, long l) {
        void var3_7;
        int n2;
        MediaCodecVideoEncoder mediaCodecVideoEncoder;
        void v2;
        int n3;
        GlRectDrawer glRectDrawer;
        void var4_8;
        MediaCodecVideoEncoder mediaCodecVideoEncoder2 = this;
        this.checkOnMediaCodecThread();
        try {
            mediaCodecVideoEncoder2.checkKeyFrameRequired(bl, (long)var4_8);
            mediaCodecVideoEncoder2.eglBase.makeCurrent();
            GLES20.glClear((int)16384);
            glRectDrawer = mediaCodecVideoEncoder2.drawer;
            v2 = n3;
            MediaCodecVideoEncoder mediaCodecVideoEncoder3 = this;
            mediaCodecVideoEncoder = mediaCodecVideoEncoder3;
            n2 = mediaCodecVideoEncoder3.width;
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = runtimeException;
            log.e("encodeTexture failed", objectArray2);
            return false;
        }
        int objectArray2 = mediaCodecVideoEncoder.height;
        n3 = 0;
        int n4 = 0;
        glRectDrawer.drawOes((int)v2, (float[])var3_7, n2, objectArray2, n3, n4, n2, objectArray2);
        mediaCodecVideoEncoder2.eglBase.swapBuffers(TimeUnit.MICROSECONDS.toNanos((long)var4_8));
        return true;
    }

    void release() {
        CountDownLatch countDownLatch;
        CaughtException caughtException;
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        OtLog.LogToken logToken = log;
        logToken.d("Java releaseEncoder", new Object[0]);
        mediaCodecVideoEncoder.checkOnMediaCodecThread();
        final CaughtException caughtException2 = caughtException;
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        caughtException = new CaughtException();
        boolean bl = false;
        if (mediaCodecVideoEncoder.mediaCodec != null) {
            Runnable runnable;
            CountDownLatch countDownLatch2;
            countDownLatch = countDownLatch2;
            countDownLatch2 = new CountDownLatch(1);
            Runnable runnable2 = runnable;
            runnable = new Runnable(){
                {
                }

                @Override
                public void run() {
                    Object[] objectArray;
                    log.d("Java releaseEncoder on release thread", new Object[0]);
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.stop();
                    }
                    catch (Exception exception) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = exception;
                        log.e("Media encoder stop failed", objectArray);
                    }
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.release();
                    }
                    catch (Exception exception) {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = exception;
                        log.e("Media encoder release failed", objectArray);
                        caughtException2.e = exception;
                    }
                    log.d("Java releaseEncoder on release thread done", new Object[0]);
                    countDownLatch.countDown();
                }
            };
            new Thread(runnable2).start();
            if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)countDownLatch2, (long)5000L)) {
                logToken.e("Media encoder release timeout", new Object[0]);
                bl = true;
            }
            this.mediaCodec = null;
        }
        this.mediaCodecThread = null;
        countDownLatch = this.drawer;
        if (countDownLatch != null) {
            countDownLatch.release();
            this.drawer = null;
        }
        if ((countDownLatch = this.eglBase) != null) {
            countDownLatch.release();
            this.eglBase = null;
        }
        if ((countDownLatch = this.inputSurface) != null) {
            countDownLatch.release();
            this.inputSurface = null;
        }
        runningInstance = null;
        if (bl) {
            ++codecErrors;
            if (errorCallback != null) {
                logToken.e("Invoke codec error callback. Errors: " + codecErrors, new Object[0]);
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
            throw new RuntimeException("Media encoder release timeout.");
        }
        if (caughtException2.e == null) {
            logToken.d("Java releaseEncoder done", new Object[0]);
            return;
        }
        throw new RuntimeException(caughtException2.e);
    }

    int dequeueInputBuffer() {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        mediaCodecVideoEncoder.checkOnMediaCodecThread();
        try {
            return mediaCodecVideoEncoder.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("dequeueIntputBuffer failed", objectArray2);
            return -2;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OutputBufferInfo dequeueOutputBuffer() {
        block25: {
            block23: {
                block24: {
                    this.checkOnMediaCodecThread();
                    var1_2 = v0;
                    v0 = new MediaCodec.BufferInfo();
                    var2_4 = this.mediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)var1_2, 0L);
                    if (var2_4 < 0) ** GOTO lbl31
                    if ((var1_2.flags & 2) == 0) ** GOTO lbl31
                    MediaCodecVideoEncoder.log.d("Config frame generated. Offset: " + var1_2.offset + ". Size: " + var1_2.size, new Object[0]);
                    this.configData = ByteBuffer.allocateDirect(var1_2.size);
                    this.outputBuffers[var2_4].position(var1_2.offset);
                    this.outputBuffers[var2_4].limit(var1_2.offset + var1_2.size);
                    this.configData.put(this.outputBuffers[var2_4]);
                    var3_5 = v1;
                    try {
                        v1 = new StringBuilder();
                        for (var4_6 = 0; var4_6 < Math.min(var1_2.size, 8); var4_6 += 1) {
                            var3_5.append(Integer.toHexString(this.configData.get(var4_6) & 255)).append(" ");
                        }
                    }
                    catch (IllegalStateException var0_1) {}
                    {
                        continue;
                    }
                    MediaCodecVideoEncoder.log.d(var3_5.toString(), new Object[0]);
                    this.mediaCodec.releaseOutputBuffer(var2_4, false);
                    var2_4 = this.mediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)var1_2, 0L);
lbl31:
                    // 3 sources

                    if (var2_4 < 0) break block23;
                    var3_5 = this.outputBuffers[var2_4].duplicate();
                    var3_5.position(var1_2.offset);
                    var3_5.limit(var1_2.offset + var1_2.size);
                    this.reportEncodedFrame(var1_2.size);
                    var4_6 = (var1_2.flags & 1) != 0 ? 1 : 0;
                    if (var4_6) {
                        MediaCodecVideoEncoder.log.d("Sync frame generated", new Object[0]);
                    }
                    if (!var4_6 || this.type != VideoCodecType.VIDEO_CODEC_H264) break block24;
                    MediaCodecVideoEncoder.log.d("Appending config frame of size " + this.configData.capacity() + " to output buffer with offset " + var1_2.offset + ", size " + var1_2.size, new Object[0]);
                    var5_7 = ByteBuffer.allocateDirect(this.configData.capacity() + var1_2.size);
                    v2 = var3_5;
                    v3 = var5_7;
                    this.configData.rewind();
                    v3.put(this.configData);
                    var5_7.put((ByteBuffer)v2);
                    var5_7.position(0);
                    var1_3 = var1_2.presentationTimeUs;
                    return new OutputBufferInfo(var2_4, var5_7, (boolean)var4_6, var1_3);
                    break block25;
                }
                var5_8 = var1_2.presentationTimeUs;
                return new OutputBufferInfo(var2_4, var3_5.slice(), (boolean)var4_6, var5_8);
            }
            if (var2_4 == -3) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                return this.dequeueOutputBuffer();
            }
            if (var2_4 == -2) {
                return this.dequeueOutputBuffer();
            }
            if (var2_4 == -1) {
                return null;
            }
            throw new RuntimeException("dequeueOutputBuffer: " + var2_4);
        }
        v4 = new Object[1];
        var1_2 = v4;
        v4[0] = var0_1;
        MediaCodecVideoEncoder.log.e("dequeueOutputBuffer failed", var1_2);
        return new OutputBufferInfo(-1, null, false, -1L);
    }

    boolean releaseOutputBuffer(int n) {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        mediaCodecVideoEncoder.checkOnMediaCodecThread();
        try {
            mediaCodecVideoEncoder.mediaCodec.releaseOutputBuffer(n, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("releaseOutputBuffer failed", objectArray2);
            return false;
        }
    }

    public static enum BitrateAdjustmentType {
        NO_ADJUSTMENT,
        FRAMERATE_ADJUSTMENT,
        DYNAMIC_ADJUSTMENT;

    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    private static class SupportedEncoderRecord {
        public final String prefix;
        public final int supportedVersion;
        public final Priority priority;
        public final Map<String, Integer> meta;
        public final BitrateAdjustmentType bitrateAdjustmentType;

        public SupportedEncoderRecord(String string, int n, Priority priority, BitrateAdjustmentType bitrateAdjustmentType, Map<String, Integer> hashMap) {
            this.prefix = string;
            this.supportedVersion = n;
            this.priority = priority;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
            if (hashMap == null) {
                HashMap hashMap2;
                hashMap = hashMap2;
                hashMap2 = new HashMap();
            }
            this.meta = hashMap;
        }

        public static enum Priority {
            HARDWARE(100),
            SOFTWARE(10);

            private final int priority;

            private Priority(int n2) {
                this.priority = n2;
            }
        }
    }

    public static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final BitrateAdjustmentType bitrateAdjustmentType;
        public final Map<String, Integer> meta;

        public EncoderProperties(String string, int n, BitrateAdjustmentType bitrateAdjustmentType, Map<String, Integer> map) {
            this.codecName = string;
            this.colorFormat = n;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
            this.meta = map;
        }
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_GENERIC,
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_AV1,
        VIDEO_CODEC_H264;

    }

    public static enum H264Profile {
        CONSTRAINED_BASELINE(0),
        BASELINE(1),
        MAIN(2),
        CONSTRAINED_HIGH(3),
        HIGH(4);

        private final int value;

        private H264Profile(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    static class OutputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n, ByteBuffer byteBuffer, boolean bl, long l) {
            this.index = n;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l;
        }
    }
}

