/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import com.opentok.impl.a;

public class OpentokError {
    protected Domain errorDomain;
    protected ErrorCode errorCode;
    protected String errorMessage;
    protected Exception exception;

    public OpentokError(Domain domain, int n, String string) {
        if (string == null) {
            string = "(null description)";
        }
        this.errorMessage = string;
        this.errorDomain = domain;
        this.errorCode = ErrorCode.fromTypeCode(n);
    }

    public OpentokError(Domain domain, int n, Exception exception) {
        String string = exception == null ? "(null description)" : exception.getMessage();
        this.errorMessage = string;
        this.errorDomain = domain;
        this.errorCode = ErrorCode.fromTypeCode(n);
        this.exception = exception;
        if (exception == null) {
            this.errorMessage = a.a(n);
        }
    }

    public Domain getErrorDomain() {
        return this.errorDomain;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.errorMessage;
    }

    public Exception getException() {
        return this.exception;
    }

    public static enum Domain {
        SessionErrorDomain,
        PublisherErrorDomain,
        SubscriberErrorDomain;

    }

    public static final class ErrorCode
    extends Enum<ErrorCode> {
        public static final /* enum */ ErrorCode UnknownError;
        public static final /* enum */ ErrorCode AuthorizationFailure;
        public static final /* enum */ ErrorCode InvalidSessionId;
        public static final /* enum */ ErrorCode ConnectionFailed;
        public static final /* enum */ ErrorCode NoMessagingServer;
        public static final /* enum */ ErrorCode ConnectionRefused;
        public static final /* enum */ ErrorCode SessionStateFailed;
        public static final /* enum */ ErrorCode P2PSessionMaxParticipants;
        public static final /* enum */ ErrorCode SessionConnectionTimeout;
        public static final /* enum */ ErrorCode SessionInternalError;
        public static final /* enum */ ErrorCode SessionInvalidSignalType;
        public static final /* enum */ ErrorCode SessionSignalDataTooLong;
        public static final /* enum */ ErrorCode SessionSignalTypeTooLong;
        public static final /* enum */ ErrorCode SessionUnableToForceMute;
        public static final /* enum */ ErrorCode SessionUnableToSendSignal;
        public static final /* enum */ ErrorCode ConnectionDropped;
        public static final /* enum */ ErrorCode SessionDisconnected;
        public static final /* enum */ ErrorCode PublisherInternalError;
        public static final /* enum */ ErrorCode PublisherWebRTCError;
        public static final /* enum */ ErrorCode PublisherUnableToPublish;
        public static final /* enum */ ErrorCode PublisherUnexpectedPeerConnectionDisconnection;
        public static final /* enum */ ErrorCode PublisherCannotAccessCamera;
        public static final /* enum */ ErrorCode PublisherCameraAccessDenied;
        public static final /* enum */ ErrorCode ConnectionTimedOut;
        public static final /* enum */ ErrorCode SubscriberWebRTCError;
        public static final /* enum */ ErrorCode SubscriberServerCannotFindStream;
        public static final /* enum */ ErrorCode SubscriberStreamLimitExceeded;
        public static final /* enum */ ErrorCode SubscriberInternalError;
        public static final /* enum */ ErrorCode UnknownPublisherInstance;
        public static final /* enum */ ErrorCode UnknownSubscriberInstance;
        public static final /* enum */ ErrorCode SessionNullOrInvalidParameter;
        public static final /* enum */ ErrorCode VideoCaptureFailed;
        public static final /* enum */ ErrorCode CameraFailed;
        public static final /* enum */ ErrorCode VideoRenderFailed;
        public static final /* enum */ ErrorCode SessionSubscriberNotFound;
        public static final /* enum */ ErrorCode SessionPublisherNotFound;
        public static final /* enum */ ErrorCode PublisherTimeout;
        public static final /* enum */ ErrorCode SessionBlockedCountry;
        public static final /* enum */ ErrorCode SessionConnectionLimitExceeded;
        public static final /* enum */ ErrorCode SessionUnexpectedGetSessionInfoResponse;
        public static final /* enum */ ErrorCode SessionIllegalState;
        public static final /* enum */ ErrorCode EncryptionSecretMissing;
        public static final /* enum */ ErrorCode EncryptionInternalError;
        public static final /* enum */ ErrorCode DecryptionInternalError;
        public static final /* enum */ ErrorCode EncryptionSecretMismatch;
        public static final /* enum */ ErrorCode InvalidEncryptionSecret;
        public static final /* enum */ ErrorCode MediaTransformerInternalError;
        public static final /* enum */ ErrorCode MediaTransformerInvalidType;
        public static final /* enum */ ErrorCode MediaTransformerNameNotProvided;
        public static final /* enum */ ErrorCode MediaTransformerCustomCallbackNotProvided;
        public static final /* enum */ ErrorCode MediaTransformerPropertiesNotProvided;
        public static final /* enum */ ErrorCode MediaTransformerModelNotFound;
        public static final /* enum */ ErrorCode MediaTransformerOpenTokTransformersLibraryNotLoaded;
        public static final /* enum */ ErrorCode MediaTransformerOpenTokTransformersSymbolNotFound;
        public static final /* enum */ ErrorCode OpenTokTransformersInternalError;
        public static final /* enum */ ErrorCode OpenTokTransformersInvalidParam;
        public static final /* enum */ ErrorCode OpenTokTransformersNameNotProvided;
        public static final /* enum */ ErrorCode OpenTokTransformersInvalidName;
        public static final /* enum */ ErrorCode OpenTokTransformersPropertiesNotProvided;
        public static final /* enum */ ErrorCode OpenTokTransformersInvalidPropertiesFormat;
        public static final /* enum */ ErrorCode OpenTokTransformersModelFileNotFound;
        public static final /* enum */ ErrorCode OpenTokTransformersRadiusPropertyNotProvided;
        public static final /* enum */ ErrorCode OpenTokTransformersInvalidRadiusProperty;
        public static final /* enum */ ErrorCode OpenTokTransformersCustomRadiusPropertyNotProvided;
        public static final /* enum */ ErrorCode OpenTokTransformersInvalidCustomRadiusProperty;
        public static final /* enum */ ErrorCode OpenTokTransformersImageFilePathPropertyNotProvided;
        public static final /* enum */ ErrorCode OpenTokTransformersImageFilePathNotFound;
        public static final /* enum */ ErrorCode OpenTokTransformersMlTransformerInitError;
        private static final /* synthetic */ ErrorCode[] $VALUES;
        private final int code;

        public static ErrorCode[] values() {
            return (ErrorCode[])$VALUES.clone();
        }

        public static ErrorCode valueOf(String string) {
            return Enum.valueOf(ErrorCode.class, string);
        }

        private ErrorCode(int n2) {
            this.code = n2;
        }

        public static ErrorCode fromTypeCode(int n) {
            for (ErrorCode errorCode : ErrorCode.values()) {
                if (errorCode.getErrorCode() != n) continue;
                return errorCode;
            }
            return UnknownError;
        }

        private static /* synthetic */ ErrorCode[] $values() {
            ErrorCode errorCode = UnknownError;
            errorCode = AuthorizationFailure;
            errorCode = InvalidSessionId;
            errorCode = ConnectionFailed;
            errorCode = NoMessagingServer;
            errorCode = ConnectionRefused;
            errorCode = SessionStateFailed;
            errorCode = P2PSessionMaxParticipants;
            errorCode = SessionConnectionTimeout;
            errorCode = SessionInternalError;
            errorCode = SessionInvalidSignalType;
            errorCode = SessionSignalDataTooLong;
            errorCode = SessionSignalTypeTooLong;
            errorCode = SessionUnableToForceMute;
            errorCode = SessionUnableToSendSignal;
            errorCode = ConnectionDropped;
            errorCode = SessionDisconnected;
            errorCode = PublisherInternalError;
            errorCode = PublisherWebRTCError;
            errorCode = PublisherUnableToPublish;
            errorCode = PublisherUnexpectedPeerConnectionDisconnection;
            errorCode = PublisherCannotAccessCamera;
            errorCode = PublisherCameraAccessDenied;
            errorCode = ConnectionTimedOut;
            errorCode = SubscriberWebRTCError;
            errorCode = SubscriberServerCannotFindStream;
            errorCode = SubscriberStreamLimitExceeded;
            errorCode = SubscriberInternalError;
            errorCode = UnknownPublisherInstance;
            errorCode = UnknownSubscriberInstance;
            errorCode = SessionNullOrInvalidParameter;
            errorCode = VideoCaptureFailed;
            errorCode = CameraFailed;
            errorCode = VideoRenderFailed;
            errorCode = SessionSubscriberNotFound;
            errorCode = SessionPublisherNotFound;
            errorCode = PublisherTimeout;
            errorCode = SessionBlockedCountry;
            errorCode = SessionConnectionLimitExceeded;
            errorCode = SessionUnexpectedGetSessionInfoResponse;
            errorCode = SessionIllegalState;
            errorCode = EncryptionSecretMissing;
            errorCode = EncryptionInternalError;
            errorCode = DecryptionInternalError;
            errorCode = EncryptionSecretMismatch;
            errorCode = InvalidEncryptionSecret;
            errorCode = MediaTransformerInternalError;
            errorCode = MediaTransformerInvalidType;
            errorCode = MediaTransformerNameNotProvided;
            errorCode = MediaTransformerCustomCallbackNotProvided;
            errorCode = MediaTransformerPropertiesNotProvided;
            errorCode = MediaTransformerModelNotFound;
            errorCode = MediaTransformerOpenTokTransformersLibraryNotLoaded;
            errorCode = MediaTransformerOpenTokTransformersSymbolNotFound;
            errorCode = OpenTokTransformersInternalError;
            errorCode = OpenTokTransformersInvalidParam;
            errorCode = OpenTokTransformersNameNotProvided;
            errorCode = OpenTokTransformersInvalidName;
            errorCode = OpenTokTransformersPropertiesNotProvided;
            errorCode = OpenTokTransformersInvalidPropertiesFormat;
            errorCode = OpenTokTransformersModelFileNotFound;
            errorCode = OpenTokTransformersRadiusPropertyNotProvided;
            errorCode = OpenTokTransformersInvalidRadiusProperty;
            errorCode = OpenTokTransformersCustomRadiusPropertyNotProvided;
            errorCode = OpenTokTransformersInvalidCustomRadiusProperty;
            errorCode = OpenTokTransformersImageFilePathPropertyNotProvided;
            errorCode = OpenTokTransformersImageFilePathNotFound;
            errorCode = OpenTokTransformersMlTransformerInitError;
            ErrorCode[] errorCodeArray = new ErrorCode[]{errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode, errorCode};
            return errorCodeArray;
        }

        static {
            ErrorCode errorCode;
            ErrorCode errorCode2;
            UnknownError = new ErrorCode(-1);
            AuthorizationFailure = new ErrorCode(1004);
            InvalidSessionId = new ErrorCode(1005);
            ConnectionFailed = new ErrorCode(1006);
            NoMessagingServer = new ErrorCode(1503);
            ConnectionRefused = new ErrorCode(1023);
            SessionStateFailed = new ErrorCode(1020);
            P2PSessionMaxParticipants = new ErrorCode(1403);
            SessionConnectionTimeout = new ErrorCode(1021);
            SessionInternalError = new ErrorCode(2000);
            SessionInvalidSignalType = new ErrorCode(1461);
            SessionSignalDataTooLong = new ErrorCode(1413);
            SessionSignalTypeTooLong = new ErrorCode(1414);
            SessionUnableToForceMute = new ErrorCode(1540);
            SessionUnableToSendSignal = new ErrorCode(1550);
            ConnectionDropped = new ErrorCode(1022);
            SessionDisconnected = new ErrorCode(1010);
            PublisherInternalError = new ErrorCode(2000);
            PublisherWebRTCError = new ErrorCode(1610);
            PublisherUnableToPublish = new ErrorCode(1500);
            PublisherUnexpectedPeerConnectionDisconnection = new ErrorCode(1710);
            PublisherCannotAccessCamera = new ErrorCode(1650);
            PublisherCameraAccessDenied = new ErrorCode(1670);
            ConnectionTimedOut = new ErrorCode(1542);
            SubscriberWebRTCError = new ErrorCode(1600);
            SubscriberServerCannotFindStream = new ErrorCode(1604);
            SubscriberStreamLimitExceeded = new ErrorCode(1605);
            SubscriberInternalError = new ErrorCode(2000);
            UnknownPublisherInstance = new ErrorCode(2003);
            UnknownSubscriberInstance = new ErrorCode(2004);
            SessionNullOrInvalidParameter = new ErrorCode(1011);
            VideoCaptureFailed = new ErrorCode(3000);
            CameraFailed = new ErrorCode(3010);
            VideoRenderFailed = new ErrorCode(4000);
            SessionSubscriberNotFound = new ErrorCode(1112);
            SessionPublisherNotFound = new ErrorCode(1113);
            PublisherTimeout = new ErrorCode(1541);
            SessionBlockedCountry = new ErrorCode(1026);
            SessionConnectionLimitExceeded = new ErrorCode(1027);
            SessionUnexpectedGetSessionInfoResponse = new ErrorCode(2001);
            SessionIllegalState = new ErrorCode(1015);
            EncryptionSecretMissing = new ErrorCode(6000);
            EncryptionInternalError = new ErrorCode(6001);
            DecryptionInternalError = new ErrorCode(6002);
            EncryptionSecretMismatch = new ErrorCode(6003);
            InvalidEncryptionSecret = new ErrorCode(6004);
            ErrorCode errorCode3 = errorCode2;
            MediaTransformerInternalError = new ErrorCode(0xA000000);
            int n = errorCode3.code + 1;
            MediaTransformerInvalidType = new ErrorCode(n);
            n = errorCode3.code + 2;
            MediaTransformerNameNotProvided = new ErrorCode(n);
            n = errorCode3.code + 3;
            MediaTransformerCustomCallbackNotProvided = new ErrorCode(n);
            n = errorCode3.code + 4;
            MediaTransformerPropertiesNotProvided = new ErrorCode(n);
            n = errorCode3.code + 5;
            MediaTransformerModelNotFound = new ErrorCode(n);
            n = errorCode3.code + 6;
            MediaTransformerOpenTokTransformersLibraryNotLoaded = new ErrorCode(n);
            int n2 = errorCode3.code + 7;
            MediaTransformerOpenTokTransformersSymbolNotFound = new ErrorCode(n2);
            ErrorCode errorCode4 = errorCode;
            OpenTokTransformersInternalError = new ErrorCode(0xB000000);
            n = errorCode4.code + 1;
            OpenTokTransformersInvalidParam = new ErrorCode(n);
            n = errorCode4.code + 2;
            OpenTokTransformersNameNotProvided = new ErrorCode(n);
            n = errorCode4.code + 3;
            OpenTokTransformersInvalidName = new ErrorCode(n);
            n = errorCode4.code + 4;
            OpenTokTransformersPropertiesNotProvided = new ErrorCode(n);
            n = errorCode4.code + 5;
            OpenTokTransformersInvalidPropertiesFormat = new ErrorCode(n);
            n = errorCode4.code + 6;
            OpenTokTransformersModelFileNotFound = new ErrorCode(n);
            n = errorCode4.code + 7;
            OpenTokTransformersRadiusPropertyNotProvided = new ErrorCode(n);
            n = errorCode4.code + 8;
            OpenTokTransformersInvalidRadiusProperty = new ErrorCode(n);
            n = errorCode4.code + 9;
            OpenTokTransformersCustomRadiusPropertyNotProvided = new ErrorCode(n);
            n = errorCode4.code + 10;
            OpenTokTransformersInvalidCustomRadiusProperty = new ErrorCode(n);
            n = errorCode4.code + 11;
            OpenTokTransformersImageFilePathPropertyNotProvided = new ErrorCode(n);
            n = errorCode4.code + 12;
            OpenTokTransformersImageFilePathNotFound = new ErrorCode(n);
            int n3 = errorCode4.code + 13;
            OpenTokTransformersMlTransformerInitError = new ErrorCode(n3);
            $VALUES = ErrorCode.$values();
        }

        public int getErrorCode() {
            return this.code;
        }
    }
}

