/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class OtLog {
    public static LogToken LogToken() {
        return new LogToken();
    }

    public static LogToken LogToken(String string) {
        return new LogToken(string, true);
    }

    public static void d(String string, Object ... objectArray) {
        new LogToken().d(string, objectArray);
    }

    public static void d(Throwable throwable, String string, Object ... objectArray) {
        new LogToken().d(throwable, string, objectArray);
    }

    public static void i(String string, Object ... objectArray) {
        new LogToken().i(string, objectArray);
    }

    public static void i(Throwable throwable, String string, Object ... objectArray) {
        new LogToken().i(throwable, string, objectArray);
    }

    public static void v(String string, Object ... objectArray) {
        new LogToken().v(string, objectArray);
    }

    public static void v(Throwable throwable, String string, Object ... objectArray) {
        new LogToken().v(throwable, string, objectArray);
    }

    public static void w(String string, Object ... objectArray) {
        new LogToken().w(string, objectArray);
    }

    public static void w(Throwable throwable, String string, Object ... objectArray) {
        new LogToken().w(throwable, string, objectArray);
    }

    public static void e(String string, Object ... objectArray) {
        new LogToken().e(string, objectArray);
    }

    public static void e(Throwable throwable, String string, Object ... objectArray) {
        new LogToken().e(throwable, string, objectArray);
    }

    public static class LogToken {
        private final String tag;
        private final boolean enabled;
        private Object caller = null;

        public LogToken() {
            this("[" + LogToken.getCallerClassName() + "]", true);
        }

        public LogToken(Object object) {
            this("[" + object.getClass().getCanonicalName() + "]", true);
            this.caller = object;
        }

        public LogToken(boolean bl) {
            this(LogToken.getCallerClassName(), bl);
        }

        public LogToken(String string, boolean bl) {
            this.tag = string;
            this.enabled = false;
        }

        private String addCallerReference(String string) {
            if (this.caller != null) {
                return string + " [" + this.caller.toString() + "] (" + System.currentTimeMillis() + ") {" + Thread.currentThread().getName() + "}";
            }
            return string;
        }

        private static String getCallerClassName() {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            String string = OtLog.class.getName();
            String string2 = LogToken.class.getName();
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (!bl && stackTraceElement.getClassName().equals(string2)) {
                    bl = true;
                    continue;
                }
                if (!bl || stackTraceElement.getClassName().equals(string2) || stackTraceElement.getClassName().equals(string)) continue;
                try {
                    return Class.forName(stackTraceElement.getClassName()).getSimpleName();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return stackTraceElement.getClassName();
                }
            }
            return string;
        }

        private static String appendStackTraceString(String string, Throwable throwable) {
            PrintWriter printWriter;
            StringWriter stringWriter;
            StringWriter stringWriter2 = stringWriter;
            stringWriter = new StringWriter(256);
            PrintWriter printWriter2 = printWriter;
            printWriter2((Writer)stringWriter2, false);
            throwable.printStackTrace(printWriter2);
            printWriter.flush();
            if (string != null) {
                return string + "\n" + stringWriter2.toString();
            }
            return stringWriter2.toString();
        }

        public void d(String string, Object ... objectArray) {
            if (this.enabled) {
                Log.d((String)this.tag, (String)this.addCallerReference(String.format(string, objectArray)));
            }
        }

        public void d(Throwable throwable, String string, Object ... objectArray) {
            this.d(LogToken.appendStackTraceString(string, throwable), objectArray);
        }

        public void i(String string, Object ... objectArray) {
            if (this.enabled) {
                Log.i((String)this.tag, (String)this.addCallerReference(String.format(string, objectArray)));
            }
        }

        public void i(Throwable throwable, String string, Object ... objectArray) {
            this.i(LogToken.appendStackTraceString(string, throwable), objectArray);
        }

        public void v(String string, Object ... objectArray) {
            if (this.enabled) {
                Log.v((String)this.tag, (String)this.addCallerReference(String.format(string, objectArray)));
            }
        }

        public void v(Throwable throwable, String string, Object ... objectArray) {
            this.v(LogToken.appendStackTraceString(string, throwable), objectArray);
        }

        public void w(String string, Object ... objectArray) {
            if (this.enabled) {
                Log.w((String)this.tag, (String)this.addCallerReference(String.format(string, objectArray)));
            }
        }

        public void w(Throwable throwable, String string, Object ... objectArray) {
            this.w(LogToken.appendStackTraceString(string, throwable), objectArray);
        }

        public void e(String string, Object ... objectArray) {
            if (this.enabled) {
                Log.e((String)this.tag, (String)this.addCallerReference(String.format(string, objectArray)));
            }
        }

        public void e(Throwable throwable, String string, Object ... objectArray) {
            this.e(LogToken.appendStackTraceString(string, throwable), objectArray);
        }
    }
}

