/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.opentok.android.OtLog;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Iterator;

class ProxyReceiver
extends BroadcastReceiver {
    private static final OtLog.LogToken log = new OtLog.LogToken();
    private final Context applicationsCtn;

    protected ProxyReceiver(Context context) {
        IntentFilter intentFilter;
        Context context2 = context;
        ProxyReceiver proxyReceiver = this;
        proxyReceiver.updateProxyInfo();
        context = intentFilter;
        intentFilter = new IntentFilter("android.intent.action.PROXY_CHANGE");
        context2.getApplicationContext().registerReceiver((BroadcastReceiver)this, (IntentFilter)context);
        this.applicationsCtn = context2.getApplicationContext();
    }

    private void updateProxyInfo() {
        Iterator<Proxy> iterator = ProxySelector.getDefault().select(URI.create("https://api.opentok.com")).iterator();
        while (iterator.hasNext()) {
            InetSocketAddress inetSocketAddress;
            try {
                inetSocketAddress = (InetSocketAddress)((Proxy)iterator.next()).address();
                if (inetSocketAddress == null) continue;
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (inetSocketAddress.getHostName() == null) continue;
            log.d("updateProxyInfo() Set proxy " + inetSocketAddress.toString(), new Object[0]);
            ProxyReceiver.setProxyNative(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            break;
        }
    }

    public static void forceSetProxy(String string, int n) {
        log.d("forceSetProxy(" + string + ", " + n + ")", new Object[0]);
        ProxyReceiver.setProxyNative(string, n);
    }

    private static native void registerNatives();

    private static native void setProxyNative(String var0, int var1);

    static {
        ProxyReceiver.registerNatives();
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction() != null && intent.getAction().equals("android.intent.action.PROXY_CHANGE")) {
            this.updateProxyInfo();
        }
    }

    protected void close() {
        this.applicationsCtn.unregisterReceiver((BroadcastReceiver)this);
    }
}

