/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import android.view.View;
import com.opentok.android.AudioData;
import com.opentok.android.AudioDeviceManager;
import com.opentok.android.BaseAudioDevice;
import com.opentok.android.BaseVideoCapturer;
import com.opentok.android.BaseVideoRenderer;
import com.opentok.android.DefaultAudioDevice;
import com.opentok.android.Loader;
import com.opentok.android.OpenTokConfig;
import com.opentok.android.OpentokError;
import com.opentok.android.OtLog;
import com.opentok.android.Session;
import com.opentok.android.Stream;
import com.opentok.android.Utils;
import com.opentok.otc.SWIGTYPE_p_otc_audio_transformer;
import com.opentok.otc.SWIGTYPE_p_otc_publisher;
import com.opentok.otc.SWIGTYPE_p_otc_stream;
import com.opentok.otc.SWIGTYPE_p_otc_video_transformer;
import com.opentok.otc.SWIGTYPE_p_void;
import com.opentok.otc.a;
import com.opentok.otc.e;
import com.opentok.otc.h;
import com.opentok.otc.otc_media_transformer_type;
import com.opentok.otc.otc_publisher_callbacks;
import com.opentok.otc.otc_publisher_rtc_stats_report_cb;
import com.opentok.otc.otc_video_capturer_callbacks;
import com.opentok.otc.otc_video_capturer_settings;
import com.vonage.webrtc.ContextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class PublisherKit
implements Observer {
    private static final Map<PublisherKitVideoType, h> OTCPublisherVideoTypeMap;
    private static final SparseArray<String> VideoReasonMap;
    private static final Map<h, PublisherKitVideoType> PublisherKitVideoTypeMap;
    private static String modelsFolderPath;
    protected Handler handler;
    protected PublisherListener publisherListener;
    protected AudioLevelListener audioLevelListener;
    protected VideoStatsListener videoStatsListener;
    protected AudioStatsListener audioStatsListener;
    protected MuteListener muteListener;
    protected PublisherRtcStatsReportListener rtcStatsReportListener;
    protected Context context;
    protected BaseVideoRenderer renderer;
    protected BaseVideoCapturer capturer;
    protected VideoListener videoListener;
    boolean resumePublishVideoOnSessionResume;
    boolean isPaused = false;
    private ArrayList<VideoTransformer> _videoTransformers;
    private ArrayList<AudioTransformer> _audioTransformers;
    SWIGTYPE_p_otc_publisher otc_publisher;
    swig_otc_publisher_cb publisher_cb;
    swig_otc_video_capturer_cb capturer_cb;
    swig_otc_rtc_stats_report_cb rtc_stats_report_cb;
    long otcCapturerHandle = 0L;
    private final OtLog.LogToken log;

    @Deprecated
    protected PublisherKit(Context context, String string, boolean bl, boolean bl2, BaseVideoCapturer baseVideoCapturer, BaseVideoRenderer baseVideoRenderer) {
        this(context, string, bl, 0, bl2, baseVideoCapturer, baseVideoRenderer, false, false);
    }

    @Deprecated
    protected PublisherKit(Context context, String string, boolean bl, int n, boolean bl2, BaseVideoCapturer baseVideoCapturer, BaseVideoRenderer baseVideoRenderer, boolean bl3, boolean bl4) {
        this(context, string, bl, n, bl2, baseVideoCapturer, baseVideoRenderer, bl3, bl4, true, false);
    }

    protected PublisherKit(Context context, String object, boolean bl, int n, boolean bl2, BaseVideoCapturer object2, BaseVideoRenderer baseVideoRenderer, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        OtLog.LogToken logToken;
        Object object3 = logToken;
        logToken = new OtLog.LogToken(this);
        this.log = object3;
        if (context != null) {
            this.context = context;
            if (AudioDeviceManager.getAudioDevice() == null) {
                DefaultAudioDevice defaultAudioDevice;
                object3 = defaultAudioDevice;
                new DefaultAudioDevice(context.getApplicationContext()).setAudioBus(new BaseAudioDevice.AudioBus((BaseAudioDevice)object3));
                AudioDeviceManager.setAudioDevice((BaseAudioDevice)object3);
            }
            PublisherKit publisherKit = this;
            Utils.initOtcEngine(context, AudioDeviceManager.getAudioDevice(), OpenTokConfig.getJNILogs(), OpenTokConfig.getOTKitLogs(), OpenTokConfig.getWebRTCLogs(), OpenTokConfig.getDumpClientLoggingToFile());
            this.handler = new Handler(Looper.myLooper());
            this.renderer = baseVideoRenderer;
            publisherKit.capturer = object2;
            publisherKit.publisher_cb = new swig_otc_publisher_cb(this.build_native_publisher_cb());
            publisherKit.capturer_cb = new swig_otc_video_capturer_cb(this.build_native_video_capturer_cb());
            object2 = e.c();
            e.a((a)object2, Utils.booleanToInt(bl));
            e.f((a)object2, Utils.booleanToInt(bl2));
            if (object == null) {
                object = "";
            }
            e.a((a)object2, (String)object);
            e.a((a)object2, this.capturer_cb);
            e.b((a)object2, Utils.booleanToInt(bl3));
            e.d((a)object2, Utils.booleanToInt(bl4));
            e.c((a)object2, Utils.booleanToInt(bl6));
            e.e((a)object2, Utils.booleanToInt(bl5));
            this.otc_publisher = object = e.a(this.publisher_cb, (a)object2);
            e.a((SWIGTYPE_p_otc_publisher)object, (long)n);
            e.a((a)object2);
            this.handler.post(() -> ContextUtils.initialize((Context)context.getApplicationContext()));
            return;
        }
        throw new IllegalArgumentException("(Context context) is null, cannot create publisher object!");
    }

    @Deprecated
    public PublisherKit(Context context, String string, boolean bl, boolean bl2) {
        this(context, string, bl, 0, bl2, null, null, false, false);
    }

    @Deprecated
    public PublisherKit(Context context) {
        this(context, null, true, 0, true, null, null, false, false);
    }

    @Deprecated
    public PublisherKit(Context context, String string) {
        this(context, string, true, 0, true, null, null, false, false);
    }

    private static void copyFile(InputStream inputStream, OutputStream outputStream) {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkModelsFolder(Context context) {
        String[] stringArray;
        if (modelsFolderPath != null) {
            return;
        }
        modelsFolderPath = context.getApplicationContext().getApplicationInfo().dataDir + "/models";
        String[] stringArray2 = stringArray;
        if (!new File(modelsFolderPath).exists() && !stringArray2.mkdirs()) {
            throw new RuntimeException("Error creating models folder");
        }
        context = context.getApplicationContext().getAssets();
        try {
            stringArray2 = context.list("tflite");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error listing model files");
        }
        int n = stringArray2.length;
        int n2 = 0;
        while (true) {
            block10: {
                FileOutputStream fileOutputStream;
                File file;
                InputStream inputStream;
                if (n2 >= n) {
                    return;
                }
                String string = stringArray2[n2];
                try {
                    inputStream = context.open("tflite/" + string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Error copying model file: " + string);
                }
                File file2 = file;
                {
                    if (new File(modelsFolderPath + "/", string).exists()) break block10;
                }
                FileOutputStream fileOutputStream2 = fileOutputStream;
                {
                    InputStream inputStream2 = inputStream;
                    fileOutputStream2(file2);
                    PublisherKit.copyFile(inputStream2, fileOutputStream2);
                    inputStream2.close();
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                }
            }
            ++n2;
        }
    }

    static {
        Loader.load();
        OTCPublisherVideoTypeMap = new HashMap<PublisherKitVideoType, h>(){
            {
                1 v0 = this;
                ((AbstractMap)v0).put(PublisherKitVideoType.PublisherKitVideoTypeCamera, h.c);
                ((AbstractMap)v0).put(PublisherKitVideoType.PublisherKitVideoTypeScreen, h.d);
            }
        };
        VideoReasonMap = new SparseArray<String>(){
            {
                2 v0 = this;
                v0.append(1, "publishVideo");
                v0.append(2, "subscribeToVideo");
                v0.append(3, "quality");
                v0.append(4, "codecNotSupported");
            }
        };
        PublisherKitVideoTypeMap = new HashMap<h, PublisherKitVideoType>(){
            {
                3 v0 = this;
                ((AbstractMap)v0).put(h.c, PublisherKitVideoType.PublisherKitVideoTypeCamera);
                ((AbstractMap)v0).put(h.d, PublisherKitVideoType.PublisherKitVideoTypeScreen);
            }
        };
        modelsFolderPath = null;
    }

    public void onPause() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onPause() called", new Object[0]);
        Object object = publisherKit.renderer;
        if (object != null) {
            ((BaseVideoRenderer)object).onPause();
        }
        if ((object = this.capturer) != null) {
            ((BaseVideoCapturer)object).onPause();
        }
        PublisherKit publisherKit2 = this;
        publisherKit2.resumePublishVideoOnSessionResume = publisherKit2.getPublishVideo();
        publisherKit2.setPublishVideo(false);
        publisherKit2.isPaused = true;
    }

    public void onResume() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onResume() called", new Object[0]);
        if (publisherKit.isPaused) {
            this.isPaused = false;
            Object object = this.renderer;
            if (object != null) {
                ((BaseVideoRenderer)object).onResume();
            }
            if ((object = this.capturer) != null) {
                ((BaseVideoCapturer)object).onResume();
            }
            PublisherKit publisherKit2 = this;
            publisherKit2.setPublishVideo(publisherKit2.resumePublishVideoOnSessionResume);
        }
    }

    @Deprecated
    public void destroy() {
        this.log.d("Destroy(...) called", new Object[0]);
    }

    public void setPublishVideo(boolean bl) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("setPublishVideo(" + bl + ") called", new Object[0]);
        e.d(publisherKit.otc_publisher, Utils.booleanToInt(bl));
    }

    public void setPublishAudio(boolean bl) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("setPublishAudio(" + bl + ") called", new Object[0]);
        e.b(publisherKit.otc_publisher, Utils.booleanToInt(bl));
    }

    public void setPublishCaptions(boolean bl) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("setPublishCaptions(" + bl + ") called", new Object[0]);
        e.c(publisherKit.otc_publisher, Utils.booleanToInt(bl));
    }

    @Deprecated
    public void setName(String string) {
    }

    public void setPublisherVideoType(PublisherKitVideoType publisherKitVideoType) {
        e.a(this.otc_publisher, OTCPublisherVideoTypeMap.get((Object)publisherKitVideoType));
    }

    public String getName() {
        return e.c(this.otc_publisher);
    }

    public boolean getPublishVideo() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("getPublishVideo() called", new Object[0]);
        return Utils.intToBoolean(e.f(publisherKit.otc_publisher));
    }

    public boolean getPublishAudio() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("getPublishAudio() called", new Object[0]);
        return Utils.intToBoolean(e.d(publisherKit.otc_publisher));
    }

    public boolean getPublishCaptions() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("getPublishCaptions() called", new Object[0]);
        return Utils.intToBoolean(e.e(publisherKit.otc_publisher));
    }

    public Session getSession() {
        return new Session(e.h(this.otc_publisher), false);
    }

    public Stream getStream() {
        Object object = e.i(((PublisherKit)object).otc_publisher);
        if (object == null) {
            object = null;
        } else {
            Stream stream;
            Stream stream2 = stream;
            stream = new Stream((SWIGTYPE_p_otc_stream)object, true);
            object = stream2;
        }
        return object;
    }

    public PublisherKitVideoType getPublisherVideoType() {
        return PublisherKitVideoTypeMap.get(e.j(this.otc_publisher));
    }

    public void setPublisherListener(PublisherListener publisherListener) {
        this.publisherListener = publisherListener;
    }

    public void setAudioLevelListener(AudioLevelListener audioLevelListener) {
        this.audioLevelListener = audioLevelListener;
    }

    public void setRtcStatsReportListener(PublisherRtcStatsReportListener object) {
        swig_otc_rtc_stats_report_cb swig_otc_rtc_stats_report_cb2;
        PublisherRtcStatsReportListener publisherRtcStatsReportListener = object;
        object = swig_otc_rtc_stats_report_cb2;
        this.rtc_stats_report_cb = new swig_otc_rtc_stats_report_cb(this.build_rtc_stats_report_cb());
        e.a(this.otc_publisher, (otc_publisher_rtc_stats_report_cb)object);
        this.rtcStatsReportListener = publisherRtcStatsReportListener;
    }

    public void setVideoTransformers(ArrayList<VideoTransformer> arrayList) {
        this.handler.post(() -> {
            if (arrayList != null && arrayList.size() != 0) {
                ArrayList arrayList2 = arrayList;
                long[] lArray = new long[arrayList2.size()];
                int n = 0;
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    lArray[n] = swig_otc_video_transformer.getCPtr(((VideoTransformer)iterator.next()).otc_video_transformer);
                    ++n;
                }
                PublisherKit publisherKit = this;
                publisherKit.set_video_transformers_jni(swig_otc_publisher.getCPtr(publisherKit.otc_publisher), lArray);
                publisherKit._videoTransformers = new ArrayList(arrayList);
            } else {
                PublisherKit publisherKit = this;
                publisherKit.set_video_transformers_jni(swig_otc_publisher.getCPtr(publisherKit.otc_publisher), null);
                publisherKit._videoTransformers = new ArrayList();
            }
        });
    }

    public void setVideoListener(VideoListener videoListener) {
        this.videoListener = videoListener;
    }

    void onVideoDisabled(String string) {
    }

    void onVideoDisabledJNI(int n) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onVideoDisabled(...) called", new Object[0]);
        String string = (String)VideoReasonMap.get(n);
        publisherKit.handler.post(() -> this.onVideoDisabled(string));
        if (publisherKit.videoListener != null) {
            this.handler.post(() -> {
                VideoListener videoListener = this.videoListener;
                if (videoListener != null) {
                    videoListener.onVideoDisabled(this, string);
                }
            });
        }
    }

    void onVideoEnabled(String string) {
    }

    void onVideoEnabledJNI(int n) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onVideoEnabled(...) called", new Object[0]);
        String string = (String)VideoReasonMap.get(n);
        publisherKit.handler.post(() -> this.onVideoEnabled(string));
        if (publisherKit.videoListener != null) {
            this.handler.post(() -> {
                VideoListener videoListener = this.videoListener;
                if (videoListener != null) {
                    videoListener.onVideoEnabled(this, string);
                }
            });
        }
    }

    void onVideoDisableWarning() {
    }

    void onVideoDisableWarningJNI() {
        PublisherKit publisherKit = this;
        publisherKit.handler.post(() -> this.onVideoDisableWarning());
        if (publisherKit.videoListener != null) {
            this.handler.post(() -> {
                VideoListener videoListener = this.videoListener;
                if (videoListener != null) {
                    videoListener.onVideoDisableWarning(this);
                }
            });
        }
    }

    void onVideoDisableWarningLifted() {
    }

    void onVideoDisableWarningLiftedJNI() {
        PublisherKit publisherKit = this;
        publisherKit.handler.post(() -> this.onVideoDisableWarningLifted());
        if (publisherKit.videoListener != null) {
            this.handler.post(() -> {
                VideoListener videoListener = this.videoListener;
                if (videoListener != null) {
                    videoListener.onVideoDisableWarningLifted(this);
                }
            });
        }
    }

    public void setAudioTransformers(ArrayList<AudioTransformer> arrayList) {
        this.handler.post(() -> {
            if (arrayList != null && arrayList.size() != 0) {
                ArrayList arrayList2 = arrayList;
                long[] lArray = new long[arrayList2.size()];
                int n = 0;
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    lArray[n] = swig_otc_audio_transformer.getCPtr(((AudioTransformer)iterator.next()).otc_audio_transformer);
                    ++n;
                }
                PublisherKit publisherKit = this;
                publisherKit.set_audio_transformers_jni(swig_otc_publisher.getCPtr(publisherKit.otc_publisher), lArray);
                publisherKit._audioTransformers = new ArrayList(arrayList);
            } else {
                PublisherKit publisherKit = this;
                publisherKit.set_audio_transformers_jni(swig_otc_publisher.getCPtr(publisherKit.otc_publisher), null);
                publisherKit._audioTransformers = new ArrayList();
            }
        });
    }

    public void setStyle(String string, String string2) {
        BaseVideoRenderer baseVideoRenderer = ((PublisherKit)((Object)baseVideoRenderer)).renderer;
        if (baseVideoRenderer != null) {
            baseVideoRenderer.setStyle(string, string2);
        }
    }

    @Deprecated
    public void setRenderer(BaseVideoRenderer baseVideoRenderer) {
    }

    public BaseVideoRenderer getRenderer() {
        return this.renderer;
    }

    public BaseVideoCapturer getCapturer() {
        return this.capturer;
    }

    @Deprecated
    public void setCapturer(BaseVideoCapturer baseVideoCapturer) {
    }

    public View getView() {
        if (this.getRenderer() != null) {
            return this.renderer.getView();
        }
        return null;
    }

    public void setVideoStatsListener(VideoStatsListener videoStatsListener) {
        this.videoStatsListener = videoStatsListener;
    }

    public void setAudioStatsListener(AudioStatsListener audioStatsListener) {
        this.audioStatsListener = audioStatsListener;
    }

    public void setMuteListener(MuteListener muteListener) {
        this.muteListener = muteListener;
    }

    @Deprecated
    public void setAudioFallbackEnabled(boolean bl) {
        e.a(this.otc_publisher, Utils.booleanToInt(bl));
    }

    @Deprecated
    public boolean getAudioFallbackEnabled() {
        return Utils.intToBoolean(e.b(this.otc_publisher));
    }

    public void getRtcStatsReport() {
        e.g(this.otc_publisher);
    }

    void throwError(OpentokError opentokError) {
        this.onErrorJNI(opentokError.errorMessage, opentokError.errorCode.ordinal());
    }

    protected void onRtcStatsReport(PublisherRtcStats[] publisherRtcStatsArray) {
    }

    void onRtcStatsReportsJNI(String[] stringArray, String[] stringArray2) {
        this.log.d("onRtcStatsReportsJNI(...) called", new Object[0]);
        if (stringArray.length == 0) {
            this.log.e("onRtcStatsReportsJNI called with empty reports", new Object[0]);
            return;
        }
        PublisherRtcStats[] publisherRtcStatsArray = new PublisherRtcStats[stringArray.length];
        for (int k = 0; k < stringArray.length; ++k) {
            PublisherRtcStats publisherRtcStats;
            PublisherRtcStats publisherRtcStats2 = publisherRtcStats;
            publisherRtcStats2();
            publisherRtcStatsArray[k] = publisherRtcStats2;
            publisherRtcStats2.jsonArrayOfReports = stringArray[k];
            publisherRtcStats.connectionId = stringArray2[k];
        }
        PublisherKit publisherKit = this;
        publisherKit.handler.post(() -> this.onRtcStatsReport(publisherRtcStatsArray));
        if (publisherKit.rtcStatsReportListener != null) {
            this.handler.post(() -> {
                PublisherRtcStatsReportListener publisherRtcStatsReportListener = this.rtcStatsReportListener;
                if (publisherRtcStatsReportListener != null) {
                    publisherRtcStatsReportListener.onRtcStatsReport(this, publisherRtcStatsArray);
                }
            });
        }
    }

    protected void onStreamCreated(Stream stream) {
    }

    void onStreamCreatedJNI(long l) {
        Stream stream;
        PublisherKit publisherKit = this;
        publisherKit.log.d("onStreamCreated(...) called", new Object[0]);
        Stream stream2 = stream;
        stream = new Stream(l, true);
        publisherKit.handler.post(() -> this.onStreamCreated(stream2));
        if (publisherKit.publisherListener != null) {
            this.handler.post(() -> {
                PublisherListener publisherListener = this.publisherListener;
                if (publisherListener != null) {
                    publisherListener.onStreamCreated(this, stream2);
                }
            });
        }
    }

    protected void onStreamDestroyed(Stream stream) {
    }

    void onStreamDestroyedJNI(long l) {
        Stream stream;
        PublisherKit publisherKit = this;
        publisherKit.log.d("onStreamDestroyed(...) called", new Object[0]);
        Stream stream2 = stream;
        stream = new Stream(l, true);
        publisherKit.handler.post(() -> this.onStreamDestroyed(stream2));
        if (publisherKit.publisherListener != null) {
            this.handler.post(() -> {
                PublisherListener publisherListener = this.publisherListener;
                if (publisherListener != null) {
                    publisherListener.onStreamDestroyed(this, stream2);
                }
            });
        }
    }

    protected void onError(OpentokError opentokError) {
    }

    void onErrorJNI(String string, int n) {
        OpentokError opentokError;
        PublisherKit publisherKit = this;
        OpentokError opentokError2 = opentokError;
        opentokError = new OpentokError(OpentokError.Domain.PublisherErrorDomain, n, string);
        publisherKit.handler.post(() -> this.onError(opentokError2));
        if (publisherKit.publisherListener != null) {
            this.handler.post(() -> {
                PublisherListener publisherListener = this.publisherListener;
                if (publisherListener != null) {
                    publisherListener.onError(this, opentokError2);
                }
            });
        }
    }

    protected void onAudioLevelUpdated(float f2) {
    }

    void onAudioLevelUpdatedJNI(float f2) {
        PublisherKit publisherKit = this;
        publisherKit.handler.post(() -> this.onAudioLevelUpdated(f2));
        if (publisherKit.audioLevelListener != null) {
            this.handler.post(() -> {
                AudioLevelListener audioLevelListener = this.audioLevelListener;
                if (audioLevelListener != null) {
                    audioLevelListener.onAudioLevelUpdated(this, f2);
                }
            });
        }
    }

    protected void onMuteForced() {
    }

    void onMuteForcedJNI() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onMuteForcedJNI() called", new Object[0]);
        publisherKit.handler.post(() -> this.onMuteForced());
        if (publisherKit.muteListener != null) {
            this.handler.post(() -> {
                MuteListener muteListener = this.muteListener;
                if (muteListener != null) {
                    muteListener.onMuteForced(this);
                }
            });
        }
    }

    SWIGTYPE_p_otc_publisher getOtcPublisher() {
        return this.otc_publisher;
    }

    boolean onCaptureInitJNI(long l) {
        this.log.d("onCaptureInit(...) called", new Object[0]);
        this.otcCapturerHandle = l;
        if (this.capturer != null) {
            this.handler.post(() -> {
                BaseVideoCapturer baseVideoCapturer = ((PublisherKit)((Object)baseVideoCapturer)).capturer;
                if (baseVideoCapturer != null) {
                    baseVideoCapturer.init();
                }
            });
        }
        return true;
    }

    boolean onCaptureDestroyJNI(long l) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onCaptureDestroy(...) called", new Object[0]);
        publisherKit.otcCapturerHandle = 0L;
        if (publisherKit.capturer != null) {
            this.handler.post(() -> {
                BaseVideoCapturer baseVideoCapturer = ((PublisherKit)((Object)baseVideoCapturer)).capturer;
                if (baseVideoCapturer != null) {
                    baseVideoCapturer.destroy();
                }
            });
        }
        return true;
    }

    boolean onCaptureStartJNI(long l) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onCaptureStartJNI(...) enter", new Object[0]);
        if (publisherKit.capturer != null) {
            this.handler.post(() -> {
                BaseVideoCapturer baseVideoCapturer = ((PublisherKit)((Object)baseVideoCapturer)).capturer;
                if (baseVideoCapturer != null) {
                    baseVideoCapturer.startCapture();
                }
            });
        }
        this.log.d("onCaptureStartJNI(...) exit", new Object[0]);
        return true;
    }

    boolean onCaptureStopJNI(long l) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onCaptureStopJNI(...) enter", new Object[0]);
        if (publisherKit.capturer != null) {
            this.handler.post(() -> {
                BaseVideoCapturer baseVideoCapturer = ((PublisherKit)((Object)baseVideoCapturer)).capturer;
                if (baseVideoCapturer != null) {
                    baseVideoCapturer.stopCapture();
                }
            });
        }
        this.log.d("onCaptureStopJNI(...) exit", new Object[0]);
        return true;
    }

    boolean onCaptureSettingsJNI(long l) {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onCaptureSettings(...) called", new Object[0]);
        if (publisherKit.capturer != null) {
            new swig_otc_video_capturer_settings(l, false).updateValuesWithSettings(this.capturer.getCaptureSettings());
            return true;
        }
        return false;
    }

    void onFrameJNI(long l) {
        Object object = this.renderer;
        if (object != null) {
            object = ((BaseVideoRenderer)object).buildFrameInstance();
            ((BaseVideoRenderer.Frame)object).copyOtcFrame(l, this.capturer.getCaptureSettings().mirrorInLocalRender);
            this.renderer.onFrame((BaseVideoRenderer.Frame)object);
        }
    }

    void onAudioStatsJNI(PublisherAudioStats[] publisherAudioStatsArray) {
        if (this.audioStatsListener != null) {
            this.handler.post(() -> {
                AudioStatsListener audioStatsListener = this.audioStatsListener;
                if (audioStatsListener != null) {
                    audioStatsListener.onAudioStats(this, publisherAudioStatsArray);
                }
            });
        }
    }

    void onVideoStatsJNI(PublisherVideoStats[] publisherVideoStatsArray) {
        if (this.videoStatsListener != null) {
            this.handler.post(() -> {
                VideoStatsListener videoStatsListener = this.videoStatsListener;
                if (videoStatsListener != null) {
                    videoStatsListener.onVideoStats(this, publisherVideoStatsArray);
                }
            });
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(observable instanceof Session)) {
            return;
        }
        if (!(object instanceof Session.SessionPauseResumeEvent)) {
            return;
        }
        if (((Session.SessionPauseResumeEvent)object).isSessionPaused()) {
            this.onPause();
        } else {
            this.onResume();
        }
    }

    protected void finalize() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("finalize()", new Object[0]);
        Object object = publisherKit.otc_publisher;
        if (object != null) {
            e.a((SWIGTYPE_p_otc_publisher)object);
            this.otc_publisher = null;
            object = this.rtc_stats_report_cb;
            long l = object != null ? ((swig_otc_rtc_stats_report_cb)object).getCPointer() : 0L;
            swig_otc_publisher_cb swig_otc_publisher_cb2 = this.publisher_cb;
            if (swig_otc_publisher_cb2 != null && this.capturer_cb != null) {
                this.destroy_native_publisher_cbs(swig_otc_publisher_cb2.getCPointer(), this.capturer_cb.getCPointer(), l);
            }
        }
        super.finalize();
    }

    public void onStop() {
        PublisherKit publisherKit = this;
        publisherKit.log.d("onStop() enter.", new Object[0]);
        BaseVideoCapturer baseVideoCapturer = publisherKit.getCapturer();
        if (baseVideoCapturer != null) {
            baseVideoCapturer.onStop();
        }
        this.log.d("onStop() exit.", new Object[0]);
    }

    public void onRestart() {
        if ((this = ((PublisherKit)this).getCapturer()) != null) {
            ((BaseVideoCapturer)this).onRestart();
        }
    }

    native long build_native_publisher_cb();

    native long build_native_video_capturer_cb();

    native long build_rtc_stats_report_cb();

    native void destroy_native_publisher_cbs(long var1, long var3, long var5);

    native long otc_video_transformer_create_jni(int var1, String var2, String var3, VideoTransformer var4, SWIGTYPE_p_void var5);

    native long otc_audio_transformer_create_jni(int var1, String var2, String var3, AudioTransformer var4, SWIGTYPE_p_void var5);

    native void set_video_transformers_jni(long var1, long[] var3);

    native void set_audio_transformers_jni(long var1, long[] var3);

    native void destroy_video_transformer_jni(long var1);

    native void destroy_audio_transformer_jni(long var1);

    static class swig_otc_publisher_cb
    extends otc_publisher_callbacks {
        public swig_otc_publisher_cb(long l) {
            super(l, false);
        }

        public long getCPointer() {
            return otc_publisher_callbacks.getCPtr(this);
        }
    }

    static class swig_otc_video_capturer_cb
    extends otc_video_capturer_callbacks {
        public swig_otc_video_capturer_cb(long l) {
            super(l, false);
        }

        public long getCPointer() {
            return otc_video_capturer_callbacks.getCPtr(this);
        }
    }

    public static enum PublisherKitVideoType {
        PublisherKitVideoTypeCamera(1),
        PublisherKitVideoTypeScreen(2);

        private final int videoType;

        private PublisherKitVideoType(int n2) {
            this.videoType = n2;
        }

        static PublisherKitVideoType fromType(int n) {
            for (PublisherKitVideoType publisherKitVideoType : PublisherKitVideoType.values()) {
                if (publisherKitVideoType.getVideoType() != n) continue;
                return publisherKitVideoType;
            }
            throw new IllegalArgumentException("unknown type " + n);
        }

        public int getVideoType() {
            return this.videoType;
        }
    }

    public static interface PublisherListener {
        public void onStreamCreated(PublisherKit var1, Stream var2);

        public void onStreamDestroyed(PublisherKit var1, Stream var2);

        public void onError(PublisherKit var1, OpentokError var2);
    }

    public static interface AudioLevelListener {
        public void onAudioLevelUpdated(PublisherKit var1, float var2);
    }

    static class swig_otc_rtc_stats_report_cb
    extends otc_publisher_rtc_stats_report_cb {
        public swig_otc_rtc_stats_report_cb(long l) {
            super(l, false);
        }

        public long getCPointer() {
            return otc_publisher_rtc_stats_report_cb.getCPtr(this);
        }
    }

    public static interface PublisherRtcStatsReportListener {
        public void onRtcStatsReport(PublisherKit var1, PublisherRtcStats[] var2);
    }

    public static interface VideoListener {
        public void onVideoDisabled(PublisherKit var1, String var2);

        public void onVideoEnabled(PublisherKit var1, String var2);

        public void onVideoDisableWarning(PublisherKit var1);

        public void onVideoDisableWarningLifted(PublisherKit var1);
    }

    public static interface VideoStatsListener {
        public void onVideoStats(PublisherKit var1, PublisherVideoStats[] var2);
    }

    public static interface AudioStatsListener {
        public void onAudioStats(PublisherKit var1, PublisherAudioStats[] var2);
    }

    public static interface MuteListener {
        public void onMuteForced(PublisherKit var1);
    }

    public static class PublisherRtcStats {
        public String connectionId;
        public String jsonArrayOfReports;
    }

    static class swig_otc_video_capturer_settings
    extends otc_video_capturer_settings {
        public swig_otc_video_capturer_settings(long l, boolean bl) {
            super(l, bl);
        }

        public void updateValuesWithSettings(BaseVideoCapturer.CaptureSettings captureSettings) {
            this.setExpected_delay(captureSettings.expectedDelay);
            this.setFormat(captureSettings.format);
            this.setFps(captureSettings.fps);
            this.setHeight(captureSettings.height);
            this.setWidth(captureSettings.width);
            this.setMirror_on_local_render(Utils.booleanToInt(captureSettings.mirrorInLocalRender));
        }
    }

    public static class PublisherAudioStats {
        public String connectionId;
        public String subscriberId;
        public long audioPacketsLost;
        public long audioPacketsSent;
        public long audioBytesSent;
        public double timeStamp;
        public double startTime;

        PublisherAudioStats(String string, String string2, long l, long l2, long l3, double d2, double d3) {
            this.connectionId = string;
            this.subscriberId = string2;
            this.audioPacketsLost = l;
            this.audioPacketsSent = l2;
            this.audioBytesSent = l3;
            this.timeStamp = d2;
            this.startTime = d3;
        }
    }

    public static class PublisherVideoStats {
        public String connectionId;
        public String subscriberId;
        public long videoPacketsLost;
        public long videoPacketsSent;
        public long videoBytesSent;
        public double timeStamp;
        public double startTime;

        PublisherVideoStats(String string, String string2, long l, long l2, long l3, double d2, double d3) {
            this.connectionId = string;
            this.subscriberId = string2;
            this.videoPacketsLost = l;
            this.videoPacketsSent = l2;
            this.videoBytesSent = l3;
            this.timeStamp = d2;
            this.startTime = d3;
        }
    }

    static class swig_otc_publisher
    extends SWIGTYPE_p_otc_publisher {
        swig_otc_publisher() {
        }

        public static long getCPtr(SWIGTYPE_p_otc_publisher sWIGTYPE_p_otc_publisher) {
            return sWIGTYPE_p_otc_publisher == null ? 0L : SWIGTYPE_p_otc_publisher.getCPtr(sWIGTYPE_p_otc_publisher);
        }
    }

    public class AudioTransformer {
        private CustomAudioTransformer callbackTransformer;
        private otc_media_transformer_type typeTransformer;
        SWIGTYPE_p_otc_audio_transformer otc_audio_transformer;
        final /* synthetic */ PublisherKit this$0;

        public AudioTransformer(PublisherKit publisherKit, String string, String string2) {
            long l;
            ((AudioTransformer)((Object)swig_otc_audio_transformer3)).this$0 = publisherKit;
            ((AudioTransformer)((Object)swig_otc_audio_transformer3)).typeTransformer = otc_media_transformer_type.d;
            PublisherKit.checkModelsFolder(publisherKit.context);
            if (modelsFolderPath != null) {
                string2 = "{\"models_path\":\"" + modelsFolderPath + "\"}";
            }
            if ((l = publisherKit.otc_audio_transformer_create_jni(((AudioTransformer)((Object)swig_otc_audio_transformer3)).typeTransformer.a(), string, string2, (AudioTransformer)((Object)swig_otc_audio_transformer3), null)) != 0L) {
                swig_otc_audio_transformer swig_otc_audio_transformer2;
                AudioTransformer audioTransformer = swig_otc_audio_transformer3;
                swig_otc_audio_transformer swig_otc_audio_transformer3 = swig_otc_audio_transformer2;
                swig_otc_audio_transformer2 = new swig_otc_audio_transformer(l);
                audioTransformer.otc_audio_transformer = swig_otc_audio_transformer3;
                return;
            }
            throw new IllegalArgumentException("Error creating transformer");
        }

        public AudioTransformer(PublisherKit object, String string, CustomAudioTransformer customAudioTransformer) {
            PublisherKit publisherKit = ((AudioTransformer)((Object)swig_otc_audio_transformer3)).this$0 = object;
            object = otc_media_transformer_type.c;
            ((AudioTransformer)((Object)swig_otc_audio_transformer3)).typeTransformer = object;
            long l = publisherKit.otc_audio_transformer_create_jni(((otc_media_transformer_type)object).a(), string, null, (AudioTransformer)((Object)swig_otc_audio_transformer3), null);
            if (l != 0L) {
                swig_otc_audio_transformer swig_otc_audio_transformer2;
                AudioTransformer audioTransformer = swig_otc_audio_transformer3;
                swig_otc_audio_transformer swig_otc_audio_transformer3 = swig_otc_audio_transformer2;
                swig_otc_audio_transformer2 = new swig_otc_audio_transformer(l);
                audioTransformer.otc_audio_transformer = swig_otc_audio_transformer3;
                audioTransformer.callbackTransformer = customAudioTransformer;
                return;
            }
            int n = e.b();
            String string2 = "Error (" + n + ") creating transformer: " + e.a(n);
            throw new IllegalArgumentException(string2);
        }

        void onTransformAudioDataJNI(long l, int n, int n2, int n3, int n4) {
            AudioData audioData;
            AudioTransformer audioTransformer = audioData2;
            AudioData audioData2 = audioData;
            audioData = new AudioData(l, n, n2, n3, n4);
            audioTransformer.callbackTransformer.onTransform(audioData2);
        }

        protected void finalize() {
            AudioTransformer audioTransformer = this;
            audioTransformer.this$0.destroy_audio_transformer_jni(swig_otc_audio_transformer.getCPtr(this.otc_audio_transformer));
            super.finalize();
        }
    }

    static class swig_otc_audio_transformer
    extends SWIGTYPE_p_otc_audio_transformer {
        public swig_otc_audio_transformer(long l) {
            super(l, true);
        }

        public static long getCPtr(SWIGTYPE_p_otc_audio_transformer sWIGTYPE_p_otc_audio_transformer) {
            return sWIGTYPE_p_otc_audio_transformer == null ? 0L : SWIGTYPE_p_otc_audio_transformer.getCPtr(sWIGTYPE_p_otc_audio_transformer);
        }
    }

    public class VideoTransformer {
        private CustomVideoTransformer callbackTransformer;
        private otc_media_transformer_type typeTransformer;
        SWIGTYPE_p_otc_video_transformer otc_video_transformer;
        final /* synthetic */ PublisherKit this$0;

        public VideoTransformer(PublisherKit publisherKit, String string, String string2) {
            ((VideoTransformer)((Object)swig_otc_video_transformer3)).this$0 = publisherKit;
            ((VideoTransformer)((Object)swig_otc_video_transformer3)).typeTransformer = otc_media_transformer_type.d;
            if (string2.length() >= 2 && string2.charAt(0) == '{') {
                String string3 = string2;
                if (string3.charAt(string3.length() - 1) == '}') {
                    swig_otc_video_transformer swig_otc_video_transformer2;
                    long l;
                    PublisherKit.checkModelsFolder(publisherKit.context);
                    if (modelsFolderPath != null) {
                        string2 = "{\"models_path\":\"" + modelsFolderPath + "\"," + string2.substring(1);
                    }
                    if ((l = publisherKit.otc_video_transformer_create_jni(((VideoTransformer)((Object)swig_otc_video_transformer3)).typeTransformer.a(), string, string2, (VideoTransformer)((Object)swig_otc_video_transformer3), null)) == 0L) {
                        int n = e.b();
                        string = "Error (" + n + ") creating transformer: " + e.a(n);
                        if (n != OpentokError.ErrorCode.MediaTransformerOpenTokTransformersLibraryNotLoaded.getErrorCode() && n != OpentokError.ErrorCode.MediaTransformerOpenTokTransformersSymbolNotFound.getErrorCode()) {
                            throw new IllegalArgumentException(string);
                        }
                        throw new RuntimeException(string);
                    }
                    VideoTransformer videoTransformer = swig_otc_video_transformer3;
                    swig_otc_video_transformer swig_otc_video_transformer3 = swig_otc_video_transformer2;
                    swig_otc_video_transformer2 = new swig_otc_video_transformer(l);
                    videoTransformer.otc_video_transformer = swig_otc_video_transformer3;
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid properties");
        }

        public VideoTransformer(PublisherKit object, String string, CustomVideoTransformer customVideoTransformer) {
            PublisherKit publisherKit = ((VideoTransformer)((Object)swig_otc_video_transformer3)).this$0 = object;
            object = otc_media_transformer_type.c;
            ((VideoTransformer)((Object)swig_otc_video_transformer3)).typeTransformer = object;
            long l = publisherKit.otc_video_transformer_create_jni(((otc_media_transformer_type)object).a(), string, null, (VideoTransformer)((Object)swig_otc_video_transformer3), null);
            if (l != 0L) {
                swig_otc_video_transformer swig_otc_video_transformer2;
                VideoTransformer videoTransformer = swig_otc_video_transformer3;
                swig_otc_video_transformer swig_otc_video_transformer3 = swig_otc_video_transformer2;
                swig_otc_video_transformer2 = new swig_otc_video_transformer(l);
                videoTransformer.otc_video_transformer = swig_otc_video_transformer3;
                videoTransformer.callbackTransformer = customVideoTransformer;
                return;
            }
            int n = e.b();
            String string2 = "Error (" + n + ") creating transformer: " + e.a(n);
            throw new IllegalArgumentException(string2);
        }

        void onTransformVideoFrameJNI(long l) {
            BaseVideoRenderer baseVideoRenderer = ((VideoTransformer)((Object)frame)).this$0.renderer;
            if (baseVideoRenderer != null) {
                VideoTransformer videoTransformer = frame;
                BaseVideoRenderer.Frame frame = baseVideoRenderer.buildFrameInstance();
                frame.copyOtcFrame(l, Boolean.FALSE);
                videoTransformer.callbackTransformer.onTransform(frame);
            }
        }

        protected void finalize() {
            VideoTransformer videoTransformer = this;
            videoTransformer.this$0.destroy_video_transformer_jni(swig_otc_video_transformer.getCPtr(this.otc_video_transformer));
            super.finalize();
        }
    }

    static class swig_otc_video_transformer
    extends SWIGTYPE_p_otc_video_transformer {
        public swig_otc_video_transformer(long l) {
            super(l, true);
        }

        public static long getCPtr(SWIGTYPE_p_otc_video_transformer sWIGTYPE_p_otc_video_transformer) {
            return sWIGTYPE_p_otc_video_transformer == null ? 0L : SWIGTYPE_p_otc_video_transformer.getCPtr(sWIGTYPE_p_otc_video_transformer);
        }
    }

    public static interface CustomVideoTransformer {
        public void onTransform(BaseVideoRenderer.Frame var1);
    }

    public static interface CustomAudioTransformer {
        public void onTransform(AudioData var1);
    }

    public static class Builder {
        Context context;
        String name;
        boolean audioTrack = true;
        boolean videoTrack = true;
        boolean enableOpusDtx = false;
        BaseVideoCapturer capturer = null;
        BaseVideoRenderer renderer = null;
        int audioBitrate;
        boolean scalableScreenshare = false;
        boolean subscriberAudioFallback = true;
        boolean publisherAudioFallback = false;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder name(String string) {
            this.name = string;
            return this;
        }

        public Builder audioTrack(boolean bl) {
            this.audioTrack = bl;
            return this;
        }

        public Builder videoTrack(boolean bl) {
            this.videoTrack = bl;
            return this;
        }

        public Builder capturer(BaseVideoCapturer baseVideoCapturer) {
            this.capturer = baseVideoCapturer;
            return this;
        }

        public Builder renderer(BaseVideoRenderer baseVideoRenderer) {
            this.renderer = baseVideoRenderer;
            return this;
        }

        public Builder audioBitrate(int n) {
            this.audioBitrate = n;
            return this;
        }

        public Builder enableOpusDtx(boolean bl) {
            this.enableOpusDtx = bl;
            return this;
        }

        public Builder scalableScreenshare(boolean bl) {
            this.scalableScreenshare = bl;
            return this;
        }

        public Builder subscriberAudioFallbackEnabled(boolean bl) {
            this.subscriberAudioFallback = bl;
            return this;
        }

        public Builder publisherAudioFallbackEnabled(boolean bl) {
            this.publisherAudioFallback = bl;
            return this;
        }

        public PublisherKit build() {
            Builder builder = builder2;
            Builder builder2 = builder.context;
            String string = builder.name;
            boolean bl = builder.audioTrack;
            int n = builder.audioBitrate;
            boolean bl2 = builder.videoTrack;
            BaseVideoCapturer baseVideoCapturer = builder.capturer;
            BaseVideoRenderer baseVideoRenderer = builder.renderer;
            boolean bl3 = builder.enableOpusDtx;
            boolean bl4 = builder.scalableScreenshare;
            boolean bl5 = builder.subscriberAudioFallback;
            boolean bl6 = builder.publisherAudioFallback;
            return new PublisherKit((Context)builder2, string, bl, n, bl2, baseVideoCapturer, baseVideoRenderer, bl3, bl4, bl5, bl6);
        }
    }
}

