/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.view.TextureView;
import android.view.View;
import com.opentok.android.BaseVideoRenderer;
import com.opentok.android.OtLog;
import com.opentok.android.grafika.gles.EglCore;
import com.opentok.android.grafika.gles.WindowSurface;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.locks.ReentrantLock;

class TextureViewRenderer
extends BaseVideoRenderer {
    private final OtLog.LogToken log;
    private final TextureView view;
    private Renderer renderer;
    private boolean videoLastStatus;
    private boolean detached;
    private boolean mEnableVideoFit;

    public TextureViewRenderer(Context object) {
        Renderer renderer;
        TextureView textureView;
        TextureViewRenderer textureViewRenderer = this;
        textureViewRenderer.log = new OtLog.LogToken(this);
        textureViewRenderer.detached = false;
        textureViewRenderer.mEnableVideoFit = false;
        TextureView textureView2 = textureView;
        TextureViewRenderer textureViewRenderer2 = this;
        TextureView textureView3 = textureView2;
        textureView3(object);
        textureViewRenderer2.view = textureView3;
        object = renderer;
        textureViewRenderer2.renderer = new Renderer();
        textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)object);
        textureView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View view) {
                TextureViewRenderer.this.attachView();
            }

            public void onViewDetachedFromWindow(View view) {
                TextureViewRenderer.this.detachView();
            }
        });
        textureViewRenderer.renderer.start();
    }

    private void restartRenderer() {
        Renderer renderer;
        Renderer renderer2;
        TextureViewRenderer textureViewRenderer = this;
        Renderer renderer3 = renderer2 = renderer;
        renderer3();
        this.renderer = renderer3;
        renderer.enableVideoFit(this.mEnableVideoFit);
        textureViewRenderer.view.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.renderer);
        textureViewRenderer.renderer.start();
    }

    @Override
    public void onFrame(BaseVideoRenderer.Frame frame) {
        this.renderer.displayFrame(frame);
    }

    @Override
    public void setStyle(String string, String string2) {
        if ("STYLE_VIDEO_SCALE".equals(string)) {
            if ("STYLE_VIDEO_FIT".equals(string2)) {
                this.renderer.enableVideoFit(true);
                this.mEnableVideoFit = true;
            } else if ("STYLE_VIDEO_FILL".equals(string2)) {
                this.renderer.enableVideoFit(false);
                this.mEnableVideoFit = false;
            }
        }
    }

    @Override
    public void onVideoPropertiesChanged(boolean bl) {
        this.renderer.setEnableVideo(bl);
    }

    @Override
    public View getView() {
        return this.view;
    }

    void attachView() {
        if (this.detached) {
            this.detached = false;
            this.restartRenderer();
        }
    }

    void detachView() {
        this.detached = true;
    }

    @Override
    public void onPause() {
        TextureViewRenderer textureViewRenderer = this;
        textureViewRenderer.videoLastStatus = textureViewRenderer.renderer.isEnableVideo();
        textureViewRenderer.renderer.setEnableVideo(false);
    }

    @Override
    public void onResume() {
        TextureViewRenderer textureViewRenderer = this;
        textureViewRenderer.renderer.setEnableVideo(this.videoLastStatus);
        if (!textureViewRenderer.renderer.isAlive()) {
            this.restartRenderer();
        }
    }

    private static class Renderer
    extends Thread
    implements TextureView.SurfaceTextureListener {
        static final float[] xyzCoords = new float[]{-1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
        static final float[] uvCoords = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
        static final int COORDS_PER_VERTEX = 3;
        static final int TEXTURECOORDS_PER_VERTEX = 2;
        private final OtLog.LogToken log = new OtLog.LogToken(this);
        final Object lock = new Object();
        EglCore eglCore;
        private boolean videoEnabled = true;
        private boolean videoFitEnabled = false;
        SurfaceTexture surfaceTexture;
        int glProgram;
        final int[] textureIds = new int[3];
        final float[] scaleMatrix = new float[16];
        private final short[] vertexIndex;
        private final FloatBuffer vertexBuffer;
        private final FloatBuffer textureBuffer;
        private final ShortBuffer drawListBuffer;
        private int textureWidth;
        private int textureHeight;
        private int viewportWidth;
        private int viewportHeight;
        private int previousViewPortHeight;
        private int previousViewPortWidth;
        final ReentrantLock frameLock;
        BaseVideoRenderer.Frame currentFrame;

        Renderer() {
            FloatBuffer floatBuffer;
            short[] sArray = new short[6];
            short[] sArray2 = sArray;
            sArray[0] = 0;
            sArray[1] = 1;
            sArray[2] = 2;
            sArray[3] = 0;
            sArray[4] = 2;
            sArray[5] = 3;
            this.vertexIndex = sArray;
            this.frameLock = new ReentrantLock();
            Object object = xyzCoords;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(xyzCoords.length * 4);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.vertexBuffer = floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.put((float[])object);
            floatBuffer.position(0);
            object = uvCoords;
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(uvCoords.length * 4);
            byteBuffer2.order(ByteOrder.nativeOrder());
            this.textureBuffer = floatBuffer = byteBuffer2.asFloatBuffer();
            floatBuffer.put((float[])object);
            floatBuffer.position(0);
            ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(sArray2.length * 2);
            byteBuffer3.order(ByteOrder.nativeOrder());
            ShortBuffer shortBuffer = byteBuffer3.asShortBuffer();
            object = shortBuffer;
            this.drawListBuffer = object;
            shortBuffer.put(sArray2);
            shortBuffer.position(0);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitUntilSurfaceIsReady() {
            Object object = this.lock;
            synchronized (object) {
                Throwable throwable22;
                block9: {
                    while (true) {
                        try {
                            if (this.surfaceTexture != null) break;
                        }
                        catch (Throwable throwable22) {
                            try {
                                break block9;
                            }
                            catch (InterruptedException interruptedException) {
                                try {}
                                catch (Throwable throwable22) {
                                    // empty catch block
                                    break block9;
                                }
                                this.log.d("Waiting for surface ready was interrupted", new Object[0]);
                            }
                        }
                        {
                            this.lock.wait();
                        }
                    }
                    return;
                }
                throw throwable22;
            }
        }

        private void updateViewportSizeIfNeeded() {
            int n = this.viewportWidth;
            if (this.previousViewPortWidth != n || this.previousViewPortHeight != this.viewportHeight) {
                Renderer renderer = this;
                int n2 = renderer.viewportHeight;
                GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
                renderer.previousViewPortHeight = renderer.viewportHeight;
                renderer.previousViewPortWidth = renderer.viewportWidth;
            }
        }

        private void initializeTexture(int n, int n2, int n3, int n4) {
            GLES20.glActiveTexture((int)n);
            GLES20.glBindTexture((int)3553, (int)n2);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)n3, (int)n4, (int)0, (int)6409, (int)5121, null);
        }

        private void setupTextures(BaseVideoRenderer.Frame frame) {
            int[] nArray = this.textureIds;
            if (this.textureIds[0] != 0) {
                GLES20.glDeleteTextures((int)3, (int[])nArray, (int)0);
            }
            Renderer renderer = this;
            BaseVideoRenderer.Frame frame2 = frame;
            GLES20.glGenTextures((int)3, (int[])this.textureIds, (int)0);
            int n = frame2.getWidth();
            int n2 = frame2.getHeight();
            int n3 = n + 1 >> 1;
            int n4 = n2 + 1 >> 1;
            renderer.initializeTexture(33984, renderer.textureIds[0], n, n2);
            renderer.initializeTexture(33985, renderer.textureIds[1], n3, n4);
            renderer.initializeTexture(33986, renderer.textureIds[2], n3, n4);
            this.textureWidth = frame.getWidth();
            this.textureHeight = frame.getHeight();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void renderFrameLoop(WindowSurface windowSurface) {
            while (true) {
                Object object = this.lock;
                // MONITORENTER : object
                if (this.surfaceTexture == null) {
                    // MONITOREXIT : object
                    return;
                }
                this.frameLock.lock();
                if (this.currentFrame != null && this.videoEnabled) {
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GLES20.glClear((int)16384);
                    GLES20.glUseProgram((int)this.glProgram);
                    this.updateViewportSizeIfNeeded();
                    if (this.textureWidth != this.currentFrame.getWidth() || this.textureHeight != this.currentFrame.getHeight()) {
                        this.setupTextures(this.currentFrame);
                    }
                    this.updateTextures(this.currentFrame);
                    Matrix.setIdentityM((float[])this.scaleMatrix, (int)0);
                    float f2 = 1.0f;
                    float f3 = 1.0f;
                    float f4 = (float)this.currentFrame.getWidth() / (float)this.currentFrame.getHeight();
                    float f5 = (float)this.viewportWidth / (float)this.viewportHeight;
                    if (this.videoFitEnabled ? f4 > f5 : f4 < f5) {
                        f3 = f5 / f4;
                    } else {
                        f2 = f4 / f5;
                    }
                    float[] fArray = this.scaleMatrix;
                    int n = 0;
                    float f6 = this.currentFrame.isMirroredX() ? -1.0f : 1.0f;
                    Matrix.scaleM((float[])fArray, (int)n, (float)(f2 * f6), (float)f3, (float)1.0f);
                    object = this.scaleMatrix;
                    GLES20.glUniformMatrix4fv((int)GLES20.glGetUniformLocation((int)this.glProgram, (String)"uMVPMatrix"), (int)1, (boolean)false, (float[])object, (int)0);
                    object = this.drawListBuffer;
                    GLES20.glDrawElements((int)4, (int)this.vertexIndex.length, (int)5123, (Buffer)object);
                } else {
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GLES20.glClear((int)16384);
                }
                this.frameLock.unlock();
                windowSurface.c();
            }
        }

        private int loadShader(int n, String string) {
            int n2 = GLES20.glCreateShader((int)n);
            GLES20.glShaderSource((int)n2, (String)string);
            GLES20.glCompileShader((int)n2);
            return n2;
        }

        private void setupgl() {
            int n;
            Renderer renderer = object;
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20.glClear((int)16384);
            int n2 = renderer.loadShader(35633, "uniform mat4 uMVPMatrix;attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = aTextureCoord;\n}\n");
            int n3 = renderer.loadShader(35632, "precision mediump float;\nuniform sampler2D Ytex;\nuniform sampler2D Utex,Vtex;\nvarying vec2 vTextureCoord;\nvoid main(void) {\n  float nx,ny,r,g,b,y,u,v;\n  mediump vec4 txl,ux,vx;  nx=vTextureCoord[0];\n  ny=vTextureCoord[1];\n  y=texture2D(Ytex,vec2(nx,ny)).r;\n  u=texture2D(Utex,vec2(nx,ny)).r;\n  v=texture2D(Vtex,vec2(nx,ny)).r;\n  y=1.1643*(y-0.0625);\n  u=u-0.5;\n  v=v-0.5;\n  r=y+1.5958*v;\n  g=y-0.39173*u-0.81290*v;\n  b=y+2.017*u;\n  gl_FragColor=vec4(r,g,b,1.0);\n}\n");
            ((Renderer)object).glProgram = n = GLES20.glCreateProgram();
            GLES20.glAttachShader((int)n, (int)n2);
            GLES20.glAttachShader((int)renderer.glProgram, (int)n3);
            GLES20.glLinkProgram((int)renderer.glProgram);
            n2 = GLES20.glGetAttribLocation((int)renderer.glProgram, (String)"aPosition");
            int n4 = GLES20.glGetAttribLocation((int)renderer.glProgram, (String)"aTextureCoord");
            Renderer renderer2 = object;
            int n5 = n2;
            Object object = ((Renderer)object).vertexBuffer;
            GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)object);
            GLES20.glEnableVertexAttribArray((int)n5);
            object = renderer2.textureBuffer;
            GLES20.glVertexAttribPointer((int)n4, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)object);
            GLES20.glEnableVertexAttribArray((int)n4);
            GLES20.glUseProgram((int)renderer.glProgram);
            GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)renderer.glProgram, (String)"Ytex"), (int)0);
            GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)renderer.glProgram, (String)"Utex"), (int)1);
            GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)renderer.glProgram, (String)"Vtex"), (int)2);
            renderer.textureWidth = 0;
            renderer.textureHeight = 0;
        }

        @Override
        public void run() {
            WindowSurface windowSurface;
            WindowSurface windowSurface2;
            EglCore eglCore;
            Renderer renderer = this;
            renderer.waitUntilSurfaceIsReady();
            EglCore eglCore2 = eglCore;
            renderer.eglCore = new EglCore(null, 2);
            WindowSurface windowSurface3 = windowSurface2 = windowSurface;
            windowSurface3(eglCore2, this.surfaceTexture);
            windowSurface3.a();
            this.setupgl();
            this.renderFrameLoop(windowSurface2);
            windowSurface.d();
            renderer.eglCore.a();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            Object object = this.lock;
            synchronized (object) {
                this.surfaceTexture = surfaceTexture;
                this.viewportWidth = n;
                this.viewportHeight = n2;
                this.lock.notify();
                return;
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            Renderer renderer = this;
            renderer.viewportWidth = n;
            renderer.viewportHeight = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
            object = this.lock;
            synchronized (object) {
                this.surfaceTexture = null;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            Object object = this.lock;
            synchronized (object) {
                this.surfaceTexture = surfaceTexture;
                return;
            }
        }

        void enableVideoFit(boolean bl) {
            this.videoFitEnabled = bl;
        }

        void setEnableVideo(boolean bl) {
            this.videoEnabled = bl;
        }

        boolean isEnableVideo() {
            return this.videoEnabled;
        }

        void displayFrame(BaseVideoRenderer.Frame frame) {
            Renderer renderer = this;
            renderer.frameLock.lock();
            BaseVideoRenderer.Frame frame2 = renderer.currentFrame;
            if (frame2 != null) {
                frame2.destroy();
            }
            this.currentFrame = frame;
            this.frameLock.unlock();
        }

        void GlTexSubImage2D(int n, int n2, int n3, ByteBuffer byteBuffer) {
            if (n3 == n) {
                GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)n, (int)n2, (int)6409, (int)5121, (Buffer)byteBuffer);
            } else {
                for (int k = 0; k < n2; ++k) {
                    byteBuffer.position(k * n3);
                    GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)k, (int)n, (int)1, (int)6409, (int)5121, (Buffer)byteBuffer);
                }
            }
        }

        void updateTextures(BaseVideoRenderer.Frame object) {
            BaseVideoRenderer.Frame frame = object;
            int n = frame.getWidth();
            int n2 = frame.getHeight();
            int n3 = n + 1 >> 1;
            int n4 = n2 + 1 >> 1;
            ByteBuffer byteBuffer = frame.getBuffer();
            byteBuffer.clear();
            if (byteBuffer.remaining() != ((BaseVideoRenderer.Frame)object).getYplaneSize() + ((BaseVideoRenderer.Frame)object).getUVplaneSize() * 2) {
                Renderer renderer = this;
                renderer.textureWidth = 0;
                renderer.textureHeight = 0;
                return;
            }
            BaseVideoRenderer.Frame frame2 = object;
            Renderer renderer = this;
            BaseVideoRenderer.Frame frame3 = object;
            Renderer renderer2 = this;
            BaseVideoRenderer.Frame frame4 = object;
            GLES20.glPixelStorei((int)3317, (int)1);
            GLES20.glPixelStorei((int)3333, (int)1);
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.textureIds[0]);
            int n5 = frame4.getYstride();
            object = frame4.getYplane();
            renderer2.GlTexSubImage2D(n, n2, n5, (ByteBuffer)object);
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)3553, (int)renderer2.textureIds[1]);
            n5 = frame3.getUvStride();
            object = frame3.getUplane();
            renderer.GlTexSubImage2D(n3, n4, n5, (ByteBuffer)object);
            GLES20.glActiveTexture((int)33986);
            GLES20.glBindTexture((int)3553, (int)renderer.textureIds[2]);
            n5 = frame2.getUvStride();
            object = frame2.getVplane();
            this.GlTexSubImage2D(n3, n4, n5, (ByteBuffer)object);
        }
    }
}

