/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.webrtc.voiceengine61;

import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import com.vonage.webrtc.Logging;
import com.vonage.webrtc.voiceengine61.WebRtcAudioUtils;
import java.util.UUID;

public class WebRtcAudioEffects {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioEffects";
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    private static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    private static AudioEffect.Descriptor[] cachedEffects = null;
    private AcousticEchoCanceler aec = null;
    private NoiseSuppressor ns = null;
    private boolean shouldEnableAec = false;
    private boolean shouldEnableNs = false;

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.isAcousticEchoCancelerEffectAvailable();
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.isNoiseSuppressorEffectAvailable();
    }

    public static boolean isAcousticEchoCancelerBlacklisted() {
        String string = Build.MODEL;
        boolean bl = WebRtcAudioUtils.getBlackListedModelsForAecUsage().contains(string);
        if (bl) {
            Logging.w((String)TAG, (String)(string + " is blacklisted for HW AEC usage!"));
        }
        return bl;
    }

    public static boolean isNoiseSuppressorBlacklisted() {
        String string = Build.MODEL;
        boolean bl = WebRtcAudioUtils.getBlackListedModelsForNsUsage().contains(string);
        if (bl) {
            Logging.w((String)TAG, (String)(string + " is blacklisted for HW NS usage!"));
        }
        return bl;
    }

    private static boolean isAcousticEchoCancelerExcludedByUUID() {
        for (AudioEffect.Descriptor descriptor : WebRtcAudioEffects.getAvailableEffects()) {
            if (!descriptor.type.equals(AudioEffect.EFFECT_TYPE_AEC) || !descriptor.uuid.equals(AOSP_ACOUSTIC_ECHO_CANCELER)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNoiseSuppressorExcludedByUUID() {
        for (AudioEffect.Descriptor descriptor : WebRtcAudioEffects.getAvailableEffects()) {
            if (!descriptor.type.equals(AudioEffect.EFFECT_TYPE_NS) || !descriptor.uuid.equals(AOSP_NOISE_SUPPRESSOR)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAcousticEchoCancelerEffectAvailable() {
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AEC);
    }

    private static boolean isNoiseSuppressorEffectAvailable() {
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_NS);
    }

    public static boolean canUseAcousticEchoCanceler() {
        boolean bl = WebRtcAudioEffects.isAcousticEchoCancelerSupported() && !WebRtcAudioUtils.useWebRtcBasedAcousticEchoCanceler() && !WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted() && !WebRtcAudioEffects.isAcousticEchoCancelerExcludedByUUID();
        Logging.d((String)TAG, (String)("canUseAcousticEchoCanceler: " + bl));
        return bl;
    }

    public static boolean canUseNoiseSuppressor() {
        boolean bl = WebRtcAudioEffects.isNoiseSuppressorSupported() && !WebRtcAudioUtils.useWebRtcBasedNoiseSuppressor() && !WebRtcAudioEffects.isNoiseSuppressorBlacklisted() && !WebRtcAudioEffects.isNoiseSuppressorExcludedByUUID();
        Logging.d((String)TAG, (String)("canUseNoiseSuppressor: " + bl));
        return bl;
    }

    public static WebRtcAudioEffects create() {
        return new WebRtcAudioEffects();
    }

    private WebRtcAudioEffects() {
        Logging.d((String)TAG, (String)("ctor" + WebRtcAudioUtils.getThreadInfo()));
    }

    private boolean effectTypeIsVoIP(UUID uUID) {
        if (!WebRtcAudioUtils.runningOnJellyBeanMR2OrHigher()) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(uUID) && WebRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_NS.equals(uUID) && WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private static AudioEffect.Descriptor[] getAvailableEffects() {
        AudioEffect.Descriptor[] descriptorArray = cachedEffects;
        if (cachedEffects != null) {
            return descriptorArray;
        }
        cachedEffects = AudioEffect.queryEffects();
        return cachedEffects;
    }

    private static boolean isEffectTypeAvailable(UUID uUID) {
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        if (descriptorArray == null) {
            return false;
        }
        int n = descriptorArray.length;
        for (int k = 0; k < n; ++k) {
            if (!descriptorArray[k].type.equals(uUID)) continue;
            return true;
        }
        return false;
    }

    public boolean setAEC(boolean bl) {
        Logging.d((String)TAG, (String)("setAEC(" + bl + ")"));
        if (!WebRtcAudioEffects.canUseAcousticEchoCanceler()) {
            Logging.w((String)TAG, (String)"Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && bl != this.shouldEnableAec) {
            Logging.e((String)TAG, (String)"Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = bl;
        return true;
    }

    public boolean setNS(boolean bl) {
        Logging.d((String)TAG, (String)("setNS(" + bl + ")"));
        if (!WebRtcAudioEffects.canUseNoiseSuppressor()) {
            Logging.w((String)TAG, (String)"Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && bl != this.shouldEnableNs) {
            Logging.e((String)TAG, (String)"Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = bl;
        return true;
    }

    public void enable(int n) {
        StringBuilder stringBuilder;
        CharSequence charSequence;
        Logging.d((String)TAG, (String)("enable(audioSession=" + n + ")"));
        WebRtcAudioEffects.assertTrue(((WebRtcAudioEffects)((Object)stringBuilder2)).aec == null);
        WebRtcAudioEffects.assertTrue(((WebRtcAudioEffects)((Object)stringBuilder2)).ns == null);
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            Object object;
            ((WebRtcAudioEffects)((Object)stringBuilder2)).aec = object = AcousticEchoCanceler.create((int)n);
            if (object != null) {
                boolean bl = object.getEnabled();
                boolean bl2 = ((WebRtcAudioEffects)((Object)stringBuilder2)).shouldEnableAec && WebRtcAudioEffects.canUseAcousticEchoCanceler();
                if (((WebRtcAudioEffects)((Object)stringBuilder2)).aec.setEnabled(bl2) != 0) {
                    Logging.e((String)TAG, (String)"Failed to set the AcousticEchoCanceler state");
                }
                object = TAG;
                charSequence = new StringBuilder().append("AcousticEchoCanceler: was ");
                String string = bl ? "enabled" : "disabled";
                stringBuilder = charSequence.append(string).append(", enable: ").append(bl2).append(", is now: ");
                charSequence = ((WebRtcAudioEffects)((Object)stringBuilder2)).aec.getEnabled() ? "enabled" : "disabled";
                Logging.d((String)object, (String)stringBuilder.append((String)charSequence).toString());
            } else {
                Logging.e((String)TAG, (String)"Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            NoiseSuppressor noiseSuppressor;
            ((WebRtcAudioEffects)((Object)stringBuilder2)).ns = noiseSuppressor = NoiseSuppressor.create((int)n);
            if (noiseSuppressor != null) {
                boolean bl = noiseSuppressor.getEnabled();
                boolean bl3 = ((WebRtcAudioEffects)((Object)stringBuilder2)).shouldEnableNs && WebRtcAudioEffects.canUseNoiseSuppressor();
                if (((WebRtcAudioEffects)((Object)stringBuilder2)).ns.setEnabled(bl3) != 0) {
                    Logging.e((String)TAG, (String)"Failed to set the NoiseSuppressor state");
                }
                String string = TAG;
                stringBuilder = new StringBuilder().append("NoiseSuppressor: was ");
                charSequence = bl ? "enabled" : "disabled";
                WebRtcAudioEffects webRtcAudioEffects = stringBuilder2;
                StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence).append(", enable: ").append(bl3).append(", is now: ");
                String string2 = webRtcAudioEffects.ns.getEnabled() ? "enabled" : "disabled";
                Logging.d((String)string, (String)stringBuilder2.append(string2).toString());
            } else {
                Logging.e((String)TAG, (String)"Failed to create the NoiseSuppressor instance");
            }
        }
    }

    public void release() {
        Logging.d((String)TAG, (String)"release");
        AcousticEchoCanceler acousticEchoCanceler = this.aec;
        if (acousticEchoCanceler != null) {
            acousticEchoCanceler.release();
            this.aec = null;
        }
        if ((acousticEchoCanceler = this.ns) != null) {
            acousticEchoCanceler.release();
            this.ns = null;
        }
    }
}

