/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.webrtc.voiceengine61;

import android.media.AudioRecord;
import android.os.Process;
import com.vonage.webrtc.ContextUtils;
import com.vonage.webrtc.Logging;
import com.vonage.webrtc.ThreadUtils;
import com.vonage.webrtc.voiceengine61.WebRtcAudioEffects;
import com.vonage.webrtc.voiceengine61.WebRtcAudioUtils;
import java.nio.ByteBuffer;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static volatile boolean microphoneMute = false;
    private static WebRtcAudioRecordErrorCallback errorCallback;
    private final long nativeAudioRecord;
    private final ThreadUtils.ThreadChecker threadChecker;
    private WebRtcAudioEffects effects;
    private ByteBuffer byteBuffer;
    private AudioRecord audioRecord;
    private AudioRecordThread audioThread;
    private byte[] emptyBytes;

    public static void setErrorCallback(WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback) {
        Logging.d((String)TAG, (String)"Set error callback");
        errorCallback = webRtcAudioRecordErrorCallback;
    }

    WebRtcAudioRecord(long l) {
        ThreadUtils.ThreadChecker threadChecker;
        WebRtcAudioRecord webRtcAudioRecord = this;
        ThreadUtils.ThreadChecker threadChecker2 = threadChecker;
        WebRtcAudioRecord webRtcAudioRecord2 = this;
        ThreadUtils.ThreadChecker threadChecker3 = threadChecker2;
        threadChecker3();
        webRtcAudioRecord2.threadChecker = threadChecker3;
        webRtcAudioRecord2.effects = null;
        webRtcAudioRecord2.audioRecord = null;
        webRtcAudioRecord2.audioThread = null;
        threadChecker.checkIsOnValidThread();
        Logging.d((String)TAG, (String)("ctor" + WebRtcAudioUtils.getThreadInfo()));
        webRtcAudioRecord.nativeAudioRecord = l;
        webRtcAudioRecord.effects = WebRtcAudioEffects.create();
    }

    private boolean enableBuiltInAEC(boolean bl) {
        WebRtcAudioRecord webRtcAudioRecord = webRtcAudioEffects;
        webRtcAudioRecord.threadChecker.checkIsOnValidThread();
        Logging.d((String)TAG, (String)("enableBuiltInAEC(" + bl + ')'));
        WebRtcAudioEffects webRtcAudioEffects = webRtcAudioRecord.effects;
        if (webRtcAudioEffects == null) {
            Logging.e((String)TAG, (String)"Built-in AEC is not supported on this platform");
            return false;
        }
        return webRtcAudioEffects.setAEC(bl);
    }

    private boolean enableBuiltInNS(boolean bl) {
        WebRtcAudioRecord webRtcAudioRecord = webRtcAudioEffects;
        webRtcAudioRecord.threadChecker.checkIsOnValidThread();
        Logging.d((String)TAG, (String)("enableBuiltInNS(" + bl + ')'));
        WebRtcAudioEffects webRtcAudioEffects = webRtcAudioRecord.effects;
        if (webRtcAudioEffects == null) {
            Logging.e((String)TAG, (String)"Built-in NS is not supported on this platform");
            return false;
        }
        return webRtcAudioEffects.setNS(bl);
    }

    private int initRecording(int n, int n2) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d((String)TAG, (String)("initRecording(sampleRate=" + n + ", channels=" + n2 + ")"));
        if (!WebRtcAudioUtils.hasPermission(ContextUtils.getApplicationContext(), "android.permission.RECORD_AUDIO")) {
            this.reportWebRtcAudioRecordInitError("RECORD_AUDIO permission is missing");
            return -1;
        }
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int n3 = n / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(n2 * 2 * n3);
        Logging.d((String)TAG, (String)("byteBuffer.capacity: " + this.byteBuffer.capacity()));
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        long l = this.nativeAudioRecord;
        this.nativeCacheDirectBufferAddress(this.byteBuffer, l);
        n2 = this.channelCountToConfiguration(n2);
        int n4 = AudioRecord.getMinBufferSize((int)n, (int)n2, (int)2);
        if (n4 != -1 && n4 != -2) {
            block7: {
                AudioRecord audioRecord;
                Logging.d((String)TAG, (String)("AudioRecord.getMinBufferSize: " + n4));
                n4 = Math.max(n4 * 2, this.byteBuffer.capacity());
                Logging.d((String)TAG, (String)("bufferSizeInBytes: " + n4));
                AudioRecord audioRecord2 = audioRecord;
                try {
                    this.audioRecord = audioRecord2;
                    if (new AudioRecord(7, n, n2, 2, n4).getState() == 1) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + illegalArgumentException.getMessage());
                    this.releaseAudioResources();
                    return -1;
                }
                this.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
                this.releaseAudioResources();
                return -1;
            }
            WebRtcAudioEffects webRtcAudioEffects = this.effects;
            if (webRtcAudioEffects != null) {
                webRtcAudioEffects.enable(this.audioRecord.getAudioSessionId());
            }
            this.logMainParameters();
            this.logMainParametersExtended();
            return n3;
        }
        this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + n4);
        return -1;
    }

    private boolean startRecording() {
        AudioRecordThread audioRecordThread;
        int n;
        WebRtcAudioRecord webRtcAudioRecord = this;
        webRtcAudioRecord.threadChecker.checkIsOnValidThread();
        Logging.d((String)TAG, (String)"startRecording");
        WebRtcAudioRecord.assertTrue(webRtcAudioRecord.audioRecord != null);
        WebRtcAudioRecord.assertTrue(this.audioThread == null);
        try {
            this.audioRecord.startRecording();
            n = 0;
        }
        catch (IllegalStateException illegalStateException) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + illegalStateException.getMessage());
            return false;
        }
        while (this.audioRecord.getRecordingState() != 3 && ++n < 2) {
            this.threadSleep(200L);
        }
        if (this.audioRecord.getRecordingState() != 3) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            return false;
        }
        AudioRecordThread audioRecordThread2 = audioRecordThread;
        audioRecordThread2("AudioRecordJavaThread");
        this.audioThread = audioRecordThread2;
        audioRecordThread.start();
        return true;
    }

    private boolean stopRecording() {
        WebRtcAudioRecord webRtcAudioRecord = this;
        webRtcAudioRecord.threadChecker.checkIsOnValidThread();
        Logging.d((String)TAG, (String)"stopRecording");
        WebRtcAudioRecord.assertTrue(webRtcAudioRecord.audioThread != null);
        WebRtcAudioRecord webRtcAudioRecord2 = this;
        webRtcAudioRecord2.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly((Thread)webRtcAudioRecord2.audioThread, (long)2000L)) {
            Logging.e((String)TAG, (String)"Join of AudioRecordJavaThread timed out");
        }
        this.audioThread = null;
        WebRtcAudioEffects webRtcAudioEffects = this.effects;
        if (webRtcAudioEffects != null) {
            webRtcAudioEffects.release();
        }
        this.releaseAudioResources();
        return true;
    }

    private void logMainParameters() {
        Logging.d((String)TAG, (String)("AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate()));
    }

    private void logMainParametersExtended() {
        if (WebRtcAudioUtils.runningOnMarshmallowOrHigher()) {
            Logging.d((String)TAG, (String)("AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames()));
        }
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n) {
        return n == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    public static void setMicrophoneMute(boolean bl) {
        Logging.w((String)TAG, (String)("setMicrophoneMute(" + bl + ")"));
        microphoneMute = bl;
    }

    private void releaseAudioResources() {
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String string) {
        Logging.e((String)TAG, (String)("Init recording error: " + string));
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordInitError(string);
        }
    }

    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode audioRecordStartErrorCode, String string) {
        Logging.e((String)TAG, (String)("Start recording error: " + (Object)((Object)audioRecordStartErrorCode) + ". " + string));
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordStartError(audioRecordStartErrorCode, string);
        }
    }

    private void reportWebRtcAudioRecordError(String string) {
        Logging.e((String)TAG, (String)("Run-time recording error: " + string));
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordError(string);
        }
    }

    private void threadSleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Logging.e((String)TAG, (String)("Thread.sleep failed: " + interruptedException.getMessage()));
        }
    }

    public static interface WebRtcAudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            block6: {
                Process.setThreadPriority((int)-19);
                Logging.d((String)WebRtcAudioRecord.TAG, (String)("AudioRecordThread" + WebRtcAudioUtils.getThreadInfo()));
                WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
                System.nanoTime();
                while (this.keepAlive) {
                    int n = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                    if (n == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                        if (microphoneMute) {
                            AudioRecordThread audioRecordThread = this;
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.clear();
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                        }
                        WebRtcAudioRecord webRtcAudioRecord = WebRtcAudioRecord.this;
                        long l = webRtcAudioRecord.nativeAudioRecord;
                        webRtcAudioRecord.nativeDataIsRecorded(n, l);
                        continue;
                    }
                    String string = "AudioRecord.read failed: " + n;
                    Logging.e((String)WebRtcAudioRecord.TAG, (String)string);
                    if (n != -3) continue;
                    this.keepAlive = false;
                    WebRtcAudioRecord.this.reportWebRtcAudioRecordError(string);
                }
                if (WebRtcAudioRecord.this.audioRecord == null) break block6;
                try {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e((String)WebRtcAudioRecord.TAG, (String)("AudioRecord.stop failed: " + illegalStateException.getMessage()));
                }
            }
        }

        public void stopThread() {
            Logging.d((String)WebRtcAudioRecord.TAG, (String)"stopThread");
            this.keepAlive = false;
        }
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

