/*
Copyright 2012 Opera Software ASA

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.opera.core.systems.testing.drivers;

import com.opera.core.systems.OperaSettings;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

/**
 * Implements shared functionality across the various {@link OperaDriverSupplier} implementations.
 * Specifically it allows you to get and set the capabilities for a particular driver supplier.
 *
 * @author Andreas Tolf Tolfsen <andreastt@opera.com>
 */
public abstract class AbstractOperaDriverSupplier implements OperaDriverSupplier {

  protected OperaSettings settings;
  protected Capabilities capabilities;

  public AbstractOperaDriverSupplier() {
    setSettings(new OperaSettings());
    setCapabilities(DesiredCapabilities.opera());
  }

  public AbstractOperaDriverSupplier(OperaSettings settings) {
    setSettings(settings);
  }

  public void setSettings(OperaSettings newSettings) {
    settings = newSettings;
  }

  public OperaSettings getSettings() {
    return settings;
  }

  public void setCapabilities(Capabilities newCapabilities) {
    capabilities = newCapabilities;
  }

  public Capabilities getCapabilities() {
    return capabilities;
  }

}