/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.opera.core.systems.arguments.OperaArgument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperaArguments
implements com.opera.core.systems.arguments.interfaces.OperaArguments {
    public static String DEFAULT_SIGN = OperaArgument.OperaArgumentSign.POSIX_SIGN.getValue();
    protected List<OperaArgument> arguments = new ArrayList<OperaArgument>();

    public OperaArguments() {
    }

    public OperaArguments(String spaceDelimitedArguments) {
        this.merge(OperaArguments.parse(spaceDelimitedArguments));
    }

    @Override
    public void add(String key) {
        OperaArgument argument = new OperaArgument(key);
        this.arguments.add(argument);
    }

    @Override
    public void add(String key, String value) {
        OperaArgument argument = new OperaArgument(key, value);
        this.arguments.add(argument);
    }

    @Override
    public void add(OperaArgument argument) {
        this.arguments.add(argument);
    }

    @Override
    public OperaArgument get(int index) {
        return this.arguments.get(index);
    }

    @Override
    public List<OperaArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public Iterator<OperaArgument> iterator() {
        return this.getArguments().iterator();
    }

    @Override
    public List<String> getArgumentsAsStringList() {
        ArrayList<String> stringList = new ArrayList<String>();
        for (OperaArgument argument : this) {
            stringList.add(this.sign() + argument.getArgument());
            if (argument.getValue() == null || argument.getValue().isEmpty()) continue;
            stringList.add(argument.getValue());
        }
        return stringList;
    }

    @Override
    public String toString() {
        Joiner joiner = Joiner.on((String)" ").skipNulls();
        return joiner.join(this.getArgumentsAsStringList());
    }

    @Override
    public int size() {
        return this.arguments.size();
    }

    public static OperaArguments parse(String string) {
        OperaArguments parsed = new OperaArguments();
        if (string == null || string.isEmpty()) {
            return parsed;
        }
        Pattern p = Pattern.compile("(?:-{1,2}|\\/)([\\w]+)(?:=|\\s*)(?:\"?([^-][\\w:=\\-_\\.\\/\\\\]*)\"?)?");
        Matcher m = p.matcher(string);
        while (m.find()) {
            parsed.add(m.group(1), m.group(2));
        }
        return parsed;
    }

    @Override
    public final OperaArguments merge(com.opera.core.systems.arguments.interfaces.OperaArguments extraArguments) {
        Preconditions.checkNotNull((Object)extraArguments);
        if (extraArguments.getArguments() != null || !extraArguments.getArguments().isEmpty()) {
            this.arguments.addAll(extraArguments.getArguments());
        }
        return this;
    }

    @Override
    public String sign() {
        return DEFAULT_SIGN;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject json = new JSONObject();
        for (OperaArgument argument : this) {
            json.put(argument.getArgument(), (Object)argument.getValue());
        }
        return json;
    }
}

