/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.Preconditions;
import com.opera.core.systems.preferences.OperaFilePreferences;
import com.opera.core.systems.preferences.OperaPreferences;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;

public class OperaProfile {
    private File directory;
    private File preferenceFile;
    private boolean randomProfile = false;
    private OperaPreferences preferences;

    public OperaProfile() {
        this(TemporaryFilesystem.getDefaultTmpFS().createTempDir("opera", "profile"));
        this.randomProfile = true;
    }

    public OperaProfile(String profileDirectoryPath) {
        this(new File(profileDirectoryPath));
    }

    public OperaProfile(File profileDirectory) {
        Preconditions.checkArgument((!profileDirectory.getPath().isEmpty() ? 1 : 0) != 0, (Object)"Profile directory path is empty");
        this.directory = profileDirectory;
        this.preferenceFile = OperaProfile.getPreferenceFile(this.directory);
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new WebDriverException("Unable to create directory path: " + this.directory.getPath());
        }
        this.setPreferences(new OperaFilePreferences(this.preferenceFile));
    }

    public OperaPreferences preferences() {
        return this.preferences;
    }

    public void setPreferences(OperaPreferences newPreferences) {
        if (!(newPreferences instanceof OperaFilePreferences)) {
            OperaFilePreferences convertedPreferences = new OperaFilePreferences(this.preferenceFile);
            convertedPreferences.merge(newPreferences);
            this.preferences = convertedPreferences;
        } else {
            this.preferences = newPreferences;
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public void cleanUp() {
        if (this.randomProfile) {
            TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(this.getDirectory());
        }
    }

    public String toJson() throws IOException {
        return new Zip().zip(this.getDirectory());
    }

    public static OperaProfile fromJson(String json) throws IOException {
        File directory = TemporaryFilesystem.getDefaultTmpFS().createTempDir("opera", "duplicate");
        new Zip().unzip(json, directory);
        return new OperaProfile(directory);
    }

    private static File getPreferenceFile(File directory) {
        final String directoryPath = directory.getAbsolutePath() + File.separator;
        LinkedHashSet<File> candidates = new LinkedHashSet<File>(){
            {
                this.add(new File(directoryPath + "operaprefs.ini"));
                this.add(new File(directoryPath + "opera.ini"));
            }
        };
        for (File candidate : candidates) {
            if (!candidate.exists()) continue;
            return candidate;
        }
        return new File(directoryPath + "operaprefs.ini");
    }
}

