/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.opera.core.systems.OperaArguments;
import com.opera.core.systems.OperaPaths;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaProfile;
import com.opera.core.systems.arguments.OperaCoreArguments;
import com.opera.core.systems.arguments.OperaDesktopArguments;
import com.opera.core.systems.common.lang.OperaBoolean;
import com.opera.core.systems.runner.launcher.OperaLauncherRunner;
import com.opera.core.systems.scope.internal.OperaIntervals;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.DesiredCapabilities;

public class OperaSettings {
    private final Map<Capability, CapabilityInstance> options = new HashMap<Capability, CapabilityInstance>();
    private final DesiredCapabilities surplusCapabilities = new DesiredCapabilities();
    private final OperaLogging logging = new OperaLogging();
    private boolean supportsPd = true;

    public OperaSettings() {
        for (Capability capability : Capability.values()) {
            this.options.put(capability, new CapabilityInstance(capability));
        }
        this.initializeLogging();
    }

    public OperaSettings(OperaProfile profile) {
        this();
        this.setProfile(profile);
    }

    public OperaLogging logging() {
        return this.logging;
    }

    public File getBinary() {
        return (File)this.options.get((Object)Capability.BINARY).getValue();
    }

    public void setBinary(File binary) {
        this.options.get((Object)Capability.BINARY).setValue(binary);
    }

    public OperaArguments arguments() {
        return (OperaArguments)this.options.get((Object)Capability.ARGUMENTS).getValue();
    }

    public String getHost() {
        return (String)this.options.get((Object)Capability.HOST).getValue();
    }

    public void setHost(String ip) {
        this.options.get((Object)Capability.HOST).setValue(ip);
    }

    public int getPort() {
        return (Integer)this.options.get((Object)Capability.PORT).getValue();
    }

    public void setPort(int port) {
        this.options.get((Object)Capability.PORT).setValue(Capability.PORT.sanitize(String.valueOf(port)));
    }

    public File getLauncher() {
        if (System.getenv("OPERA_LAUNCHER") != null && !System.getenv("OPERA_LAUNCHER").isEmpty()) {
            this.options.get((Object)Capability.LAUNCHER).setValue(new File(System.getenv("OPERA_LAUNCHER")));
        }
        return (File)this.options.get((Object)Capability.LAUNCHER).getValue();
    }

    public void setLauncher(File launcherBinary) throws IOException {
        OperaLauncherRunner.assertLauncherGood(launcherBinary);
        this.options.get((Object)Capability.LAUNCHER).setValue(launcherBinary);
    }

    public OperaProfile profile() {
        return (OperaProfile)this.options.get((Object)Capability.PROFILE).getValue();
    }

    public void setProfile(String profileDirectory) {
        this.options.get((Object)Capability.PROFILE).setValue(Capability.PROFILE.sanitize(profileDirectory));
        if (profileDirectory != null && profileDirectory.isEmpty()) {
            this.supportsPd = false;
        }
    }

    public void setProfile(OperaProfile profile) {
        this.options.get((Object)Capability.PROFILE).setValue(profile);
    }

    public boolean useIdle() {
        return (Boolean)this.options.get((Object)Capability.OPERAIDLE).getValue();
    }

    public void setIdle(boolean enabled) {
        this.options.get((Object)Capability.OPERAIDLE).setValue(enabled);
    }

    public Integer getDisplay() {
        return (Integer)this.options.get((Object)Capability.DISPLAY).getValue();
    }

    public void setDisplay(int display) {
        if (!Platform.getCurrent().is(Platform.LINUX)) {
            throw new UnsupportedOperationException("Unsupported platform: " + Platform.getCurrent());
        }
        this.options.get((Object)Capability.DISPLAY).setValue(display);
    }

    public boolean autostart() {
        return (Boolean)this.options.get((Object)Capability.AUTOSTART).getValue();
    }

    public void autostart(boolean enabled) {
        this.options.get((Object)Capability.AUTOSTART).setValue(enabled);
        if (!enabled) {
            this.setPort((int)OperaIntervals.SERVER_DEFAULT_PORT_IDENTIFIER.getValue());
        }
    }

    public OperaProduct getProduct() {
        return (OperaProduct)((Object)this.options.get((Object)Capability.PRODUCT).getValue());
    }

    public void setProduct(OperaProduct product) {
        this.options.get((Object)Capability.PRODUCT).setValue((Object)product);
        OperaCoreArguments arguments = this.getProduct().is(OperaProduct.DESKTOP) ? new OperaDesktopArguments() : new OperaCoreArguments();
        this.options.get((Object)Capability.ARGUMENTS).setValue(arguments.merge(this.arguments()));
    }

    @Deprecated
    public boolean noRestart() {
        return (Boolean)this.options.get((Object)Capability.NO_RESTART).getValue();
    }

    @Deprecated
    public void noRestart(boolean enabled) {
        this.options.get((Object)Capability.NO_RESTART).setValue(enabled);
    }

    public boolean hasDetach() {
        return (Boolean)this.options.get((Object)Capability.DETACH).getValue();
    }

    public void setDetach(boolean enabled) {
        this.options.get((Object)Capability.DETACH).setValue(enabled);
    }

    @Deprecated
    public String getBackend() {
        return (String)this.options.get((Object)Capability.BACKEND).getValue();
    }

    @Deprecated
    public void setBackend(String backend) {
        this.options.get((Object)Capability.BACKEND).setValue(backend);
    }

    public boolean supportsDebugProxy() {
        return (long)this.getPort() != OperaIntervals.SERVER_DEFAULT_PORT.getValue();
    }

    public boolean supportsPd() {
        return !this.getProduct().is(OperaProduct.CORE) && this.supportsPd;
    }

    public OperaSettings merge(Capabilities capabilities) {
        for (Map.Entry capability : capabilities.asMap().entrySet()) {
            Capability capabilityReference = Capability.findCapability((String)capability.getKey());
            if (this.options.containsKey((Object)capabilityReference)) {
                this.options.get((Object)capabilityReference).setValue(capabilityReference.sanitize(capability.getValue()));
                continue;
            }
            this.surplusCapabilities.setCapability((String)capability.getKey(), capability.getValue());
        }
        this.initializeLogging();
        return this;
    }

    public Capabilities toCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.opera();
        for (CapabilityInstance option : this.options.values()) {
            if (option.getValue() == null) continue;
            capabilities.setCapability(option.getCapability(), option.getValue());
        }
        return capabilities.merge((Capabilities)this.surplusCapabilities);
    }

    public JSONObject toJson() throws IOException, JSONException {
        JSONObject json = new JSONObject();
        for (CapabilityInstance option : this.options.values()) {
            Object value = option.getValue();
            if (value == null) continue;
            value = value instanceof OperaProfile ? ((OperaProfile)value).toJson() : (value instanceof OperaArguments && ((OperaArguments)value).size() > 0 ? ((OperaArguments)value).toJson() : (value instanceof Boolean ? Integer.valueOf((Boolean)value != false ? 1 : 0) : String.valueOf(value)));
            json.put(option.getIdentifier(), value);
        }
        return json;
    }

    public String toString() {
        return String.format("OperaSettings %s", this.options.values());
    }

    private void initializeLogging() {
        this.logging().setLevel(this.logging().getLevel());
        this.logging().setFile(this.logging().getFile());
    }

    public static class Builder {
        private final OperaSettings settings = new OperaSettings();

        public Builder usingProfile(OperaProfile profile) {
            this.settings.setProfile(profile);
            return this;
        }

        public OperaSettings get() {
            return this.settings;
        }
    }

    public class OperaLogging {
        public Level getLevel() {
            return (Level)((CapabilityInstance)OperaSettings.this.options.get((Object)Capability.LOGGING_LEVEL)).getValue();
        }

        public void setLevel(Level level) {
            Preconditions.checkNotNull((Object)level);
            ((CapabilityInstance)OperaSettings.this.options.get((Object)Capability.LOGGING_LEVEL)).setValue(level);
            Logger root = Logger.getLogger("");
            root.setLevel(level);
            for (Handler handler : root.getHandlers()) {
                handler.setLevel(level);
            }
        }

        public File getFile() {
            return (File)((CapabilityInstance)OperaSettings.this.options.get((Object)Capability.LOGGING_FILE)).getValue();
        }

        public void setFile(File file) {
            ((CapabilityInstance)OperaSettings.this.options.get((Object)Capability.LOGGING_FILE)).setValue(file);
            if (file != null) {
                FileHandler logFile;
                try {
                    logFile = new FileHandler(file.getPath(), true);
                    logFile.setFormatter(new SimpleFormatter());
                }
                catch (IOException e) {
                    throw new WebDriverException("Unable to write to log file: " + e.getMessage(), (Throwable)e);
                }
                logFile.setLevel(this.getLevel());
                Logger.getLogger("").addHandler(logFile);
            }
        }
    }

    private class CapabilityInstance {
        private final String identifier;
        private final String capabilityName;
        private Object value = null;

        public CapabilityInstance(Capability capability) {
            this.identifier = capability.getIdentifier();
            this.capabilityName = capability.getCapability();
            this.value = capability.getDefaultValue();
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final String getCapability() {
            return this.capabilityName;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String toString() {
            return String.format("%s=%s", this.getIdentifier(), this.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Capability {
        LOGGING_LEVEL("logging.level"){

            Level getDefaultValue() {
                return Level.INFO;
            }

            Object sanitize(Object value) {
                if (value == null || value instanceof Level) {
                    return value;
                }
                return Level.parse(String.valueOf(value).toUpperCase());
            }
        }
        ,
        LOGGING_FILE("logging.file"){

            Object sanitize(Object path) {
                if (path != null && path instanceof String) {
                    return new File(String.valueOf(path));
                }
                return path;
            }
        }
        ,
        BINARY{

            File getDefaultValue() {
                return new File(OperaPaths.operaPath());
            }

            Object sanitize(Object path) {
                if (path == null) {
                    return this.getDefaultValue();
                }
                if (path instanceof String) {
                    return new File(String.valueOf(path));
                }
                return path;
            }
        }
        ,
        ARGUMENTS{

            OperaArguments getDefaultValue() {
                return new OperaArguments();
            }

            OperaArguments sanitize(Object arguments) {
                if (arguments instanceof String) {
                    return new OperaArguments(String.valueOf(arguments));
                }
                if (arguments instanceof OperaArguments) {
                    return (OperaArguments)arguments;
                }
                return new OperaArguments();
            }
        }
        ,
        HOST{

            String getDefaultValue() {
                return "127.0.0.1";
            }

            Object sanitize(Object host) {
                if (host == null) {
                    return host;
                }
                return String.valueOf(host);
            }
        }
        ,
        PORT{

            Integer getDefaultValue() {
                return PortProber.findFreePort();
            }

            Integer sanitize(Object value) {
                Preconditions.checkNotNull((Object)value);
                int port = Integer.parseInt(String.valueOf(value));
                if ((long)port == OperaIntervals.SERVER_RANDOM_PORT_IDENTIFIER.getValue()) {
                    return PortProber.findFreePort();
                }
                if ((long)port == OperaIntervals.SERVER_DEFAULT_PORT_IDENTIFIER.getValue()) {
                    return (int)OperaIntervals.SERVER_DEFAULT_PORT.getValue();
                }
                return port;
            }
        }
        ,
        LAUNCHER{

            File getDefaultValue() {
                if (System.getenv("OPERA_LAUNCHER") != null && !System.getenv("OPERA_LAUNCHER").isEmpty()) {
                    return new File(System.getenv("OPERA_LAUNCHER"));
                }
                return OperaLauncherRunner.launcherDefaultLocation();
            }

            Object sanitize(Object path) {
                if (path != null) {
                    return new File(String.valueOf(path));
                }
                return path;
            }
        }
        ,
        PROFILE{

            OperaProfile getDefaultValue() {
                return new OperaProfile();
            }

            Object sanitize(Object value) {
                if (value instanceof String && String.valueOf(value) != null) {
                    String profileDirectory = String.valueOf(value);
                    if (!profileDirectory.isEmpty()) {
                        return new OperaProfile(profileDirectory);
                    }
                    return new OperaProfile(new File(System.getProperty("user.home") + File.separator + ".autotest"));
                }
                if (value instanceof OperaProfile) {
                    return value;
                }
                return new OperaProfile();
            }
        }
        ,
        OPERAIDLE("idle"){

            Boolean getDefaultValue() {
                return false;
            }

            Boolean sanitize(Object enabled) {
                Preconditions.checkNotNull((Object)enabled);
                return OperaBoolean.parseBoolean(String.valueOf(enabled));
            }
        }
        ,
        DISPLAY{

            Integer sanitize(Object display) {
                Preconditions.checkNotNull((Object)display);
                return Integer.parseInt(String.valueOf(display));
            }
        }
        ,
        AUTOSTART{

            Boolean getDefaultValue() {
                return true;
            }

            Boolean sanitize(Object enabled) {
                Preconditions.checkNotNull((Object)enabled);
                return OperaBoolean.parseBoolean(String.valueOf(enabled));
            }
        }
        ,
        NO_RESTART{

            Boolean getDefaultValue() {
                return false;
            }

            Boolean sanitize(Object enabled) {
                Preconditions.checkNotNull((Object)enabled);
                return OperaBoolean.parseBoolean(String.valueOf(enabled));
            }
        }
        ,
        NO_QUIT{

            Boolean getDefaultValue() {
                return (Boolean)DETACH.getDefaultValue();
            }

            Boolean sanitize(Object enabled) {
                return (Boolean)DETACH.sanitize(enabled);
            }
        }
        ,
        DETACH{

            Boolean getDefaultValue() {
                return false;
            }

            Boolean sanitize(Object enabled) {
                Preconditions.checkNotNull((Object)enabled);
                return OperaBoolean.parseBoolean(String.valueOf(enabled));
            }
        }
        ,
        PRODUCT{

            OperaProduct getDefaultValue() {
                return OperaProduct.ALL;
            }

            OperaProduct sanitize(Object product) {
                if (product == null) {
                    return null;
                }
                if (product instanceof OperaProduct) {
                    return (OperaProduct)((Object)product);
                }
                return OperaProduct.get(String.valueOf(product));
            }
        }
        ,
        BACKEND{

            String getDefaultValue() {
                return "software";
            }

            Object sanitize(Object backend) {
                return backend;
            }
        };

        private static final String CAPABILITY_PREFIX = "opera.";
        private static final ImmutableMap<String, Capability> lookup;
        private final String identifier = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
        private final String capability;

        private Capability() {
            this.capability = CAPABILITY_PREFIX + this.name().toLowerCase();
        }

        private Capability(String capabilityName) {
            this.capability = CAPABILITY_PREFIX + capabilityName;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getCapability() {
            return this.capability;
        }

        Object getDefaultValue() {
            return null;
        }

        Object sanitize(Object value) {
            Preconditions.checkNotNull((Object)value);
            return value;
        }

        public String toString() {
            return this.getCapability();
        }

        public static Capability findCapability(String capabilityName) {
            return (Capability)((Object)lookup.get((Object)capabilityName));
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Capability capability : Capability.values()) {
                builder.put((Object)capability.getCapability(), (Object)capability);
            }
            lookup = builder.build();
        }
    }
}

