/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaAtoms;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.model.Canvas;
import com.opera.core.systems.model.ColorResult;
import com.opera.core.systems.model.OperaColor;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.scope.exceptions.ResponseNotReceivedException;
import com.opera.core.systems.scope.internal.OperaColors;
import com.opera.core.systems.scope.internal.OperaKeys;
import com.opera.core.systems.scope.internal.OperaMouseKeys;
import com.opera.core.systems.scope.services.IEcmaScriptDebugger;
import com.opera.core.systems.scope.services.IOperaExec;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.remote.RemoteWebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperaWebElement
extends RemoteWebElement {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final int objectId;
    private final int runtimeId;
    private final OperaDriver parent;
    private final IOperaExec execService;
    private final IEcmaScriptDebugger debugger;
    private static final HashMap<Character, String> keysLookup = new HashMap();
    private Coordinates coordinates = new Coordinates(){

        public Point getLocationOnScreen() {
            throw new UnsupportedOperationException();
        }

        public Point getLocationInViewPort() {
            String coordinates = OperaWebElement.this.debugger.callFunctionOnObject("locator.scrollIntoView();\nvar x = 0, y = 0;\nif(window.top !== window.self) {\nx = (window.screenLeft - window.top.screenLeft) + window.scrollX;\ny = (window.screenTop - window.top.screenTop) + window.scrollY;\n}\nreturn (( x + locator.getBoundingClientRect().left) + ',' + ( y + locator.getBoundingClientRect().top));\n", OperaWebElement.this.objectId);
            String[] location = coordinates.split(",");
            return new Point(Integer.valueOf(location[0]).intValue(), Integer.valueOf(location[1]).intValue());
        }

        public Point getLocationInDOM() {
            return OperaWebElement.this.getLocation();
        }

        public Object getAuxiliry() {
            throw new UnsupportedOperationException();
        }
    };

    public OperaWebElement(OperaDriver parent, int objectId) {
        this.parent = parent;
        this.objectId = objectId;
        parent.objectIds.add(objectId);
        this.debugger = parent.getScriptDebugger();
        this.execService = parent.getExecService();
        this.runtimeId = this.debugger.getRuntimeId();
    }

    public final String callMethod(String method) {
        return this.debugger.callFunctionOnObject(method, this.objectId);
    }

    private void executeMethod(String script) {
        this.debugger.callFunctionOnObject(script, this.objectId, false);
    }

    private Object evaluateMethod(String script) {
        return this.debugger.callFunctionOnObject(script, this.objectId, true);
    }

    public void click() {
        this.assertElementNotStale();
        this.assertElementDisplayed();
        this.parent.getScopeServices().captureOperaIdle();
        if (this.getTagName().equals("OPTION")) {
            this.callMethod("return " + (Object)((Object)OperaAtoms.CLICK) + "(locator)");
        } else {
            this.parent.getMouse().click(this.getCoordinates());
        }
        try {
            this.parent.waitForLoadToComplete();
        }
        catch (ResponseNotReceivedException e) {
            this.logger.fine("Response not received, returning control to user");
        }
    }

    @Deprecated
    public void middleClick() {
        Point point = this.coordinates.getLocationInViewPort();
        this.execService.mouseAction(point.x, point.y, OperaMouseKeys.MIDDLE);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public String getAttribute(String attribute) {
        this.assertElementNotStale();
        if (attribute.equalsIgnoreCase("value")) {
            return this.callMethod("if(/^input|select|option|textarea$/i.test(locator.nodeName)){return locator.value;}return locator.textContent;");
        }
        return this.callMethod("return " + (Object)((Object)OperaAtoms.GET_ATTRIBUTE) + "(locator, '" + attribute + "')");
    }

    private boolean hasAttribute(String attr) {
        return this.getAttribute(attr) != null;
    }

    public String getText() {
        this.assertElementNotStale();
        return this.callMethod("return " + (Object)((Object)OperaAtoms.GET_TEXT) + "(locator)");
    }

    public boolean isDisplayed() {
        this.assertElementNotStale();
        return (Boolean)this.evaluateMethod("return " + (Object)((Object)OperaAtoms.IS_DISPLAYED) + "(locator)");
    }

    public boolean isEnabled() {
        this.assertElementNotStale();
        return (Boolean)this.evaluateMethod("return " + (Object)((Object)OperaAtoms.IS_ENABLED) + "(locator)");
    }

    public boolean isSelected() {
        this.assertElementNotStale();
        return (Boolean)this.evaluateMethod("return " + (Object)((Object)OperaAtoms.IS_SELECTED) + "(locator)");
    }

    public void clear() {
        this.verifyCanInteractWithElement();
        if (this.isEnabled() && !Boolean.valueOf(this.getAttribute("readonly")).booleanValue()) {
            this.executeMethod("return " + (Object)((Object)OperaAtoms.CLEAR) + "(locator)");
        }
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.verifyCanInteractWithElement();
        ArrayList<String> holdKeys = new ArrayList<String>();
        holdKeys.add(OperaKeys.SHIFT.getValue());
        holdKeys.add(OperaKeys.CONTROL.getValue());
        ArrayList<String> heldKeys = new ArrayList<String>();
        if (this.getTagName().equals("INPUT") && this.hasAttribute("type") && this.getAttribute("type").equalsIgnoreCase("file")) {
            this.click();
        } else {
            this.executeMethod("locator.focus()");
            if (this.getTagName().equals("INPUT")) {
                this.executeMethod("function(elem) {  var doc = elem.ownerDocument || elem;  var prevActiveElem = doc.activeElement;  if (elem != prevActiveElem && prevActiveElem)    prevActiveElem.blur();  elem.focus();  if (elem != prevActiveElem && elem.value && elem.value.length &&      elem.setSelectionRange) {    elem.setSelectionRange(elem.value.length, elem.value.length);  }  if (elem != doc.activeElement)    throw new Error('Failed to send keys because cannot focus element');}(locator)");
            }
        }
        this.parent.getScopeServices().captureOperaIdle();
        for (CharSequence seq : keysToSend) {
            if (seq instanceof Keys) {
                String key = OperaKeys.get(((Keys)seq).name());
                if (holdKeys.contains(key) && !heldKeys.contains(key) && !this.execService.keyIsPressed(key)) {
                    this.execService.key(key, false);
                    heldKeys.add(key);
                    continue;
                }
                if (key.equals("null")) {
                    for (String hkey : heldKeys) {
                        this.execService.key(hkey, true);
                    }
                    continue;
                }
                this.execService.key(key);
                continue;
            }
            if (((Object)seq).toString().equals("\n")) {
                this.execService.key("enter");
                continue;
            }
            for (int i = 0; i < seq.length(); ++i) {
                Character c = Character.valueOf(seq.charAt(i));
                String keyName = OperaWebElement.charToKeyName(c.charValue());
                if (keyName == null) {
                    this.execService.type(c.toString());
                    continue;
                }
                String key = OperaKeys.get(keyName);
                if (holdKeys.contains(key) && !heldKeys.contains(key) && !this.execService.keyIsPressed(key)) {
                    this.execService.key(key, false);
                    heldKeys.add(key);
                    continue;
                }
                if (key.equals("null")) {
                    for (String hkey : heldKeys) {
                        this.execService.key(hkey, true);
                    }
                    continue;
                }
                this.execService.key(key);
            }
        }
        if (heldKeys.size() > 0) {
            for (String key : heldKeys) {
                this.execService.key(key, true);
            }
        }
        try {
            this.parent.waitForLoadToComplete();
        }
        catch (ResponseNotReceivedException e) {
            this.logger.fine("Response not received, returning control to user");
        }
    }

    private static String charToKeyName(char c) {
        if (keysLookup.isEmpty()) {
            for (Keys k : Keys.values()) {
                keysLookup.put(Character.valueOf(k.charAt(0)), k.name());
            }
        }
        return keysLookup.get(Character.valueOf(c));
    }

    public void submit() {
        this.parent.getScopeServices().captureOperaIdle();
        this.evaluateMethod("return " + (Object)((Object)OperaAtoms.SUBMIT) + "(locator)");
        try {
            this.parent.waitForLoadToComplete();
        }
        catch (ResponseNotReceivedException e) {
            this.logger.fine("Response not received, returning control to user");
        }
    }

    public Point getLocation() {
        this.assertElementNotStale();
        String coordinates = this.debugger.callFunctionOnObject("var coords = " + (Object)((Object)OperaAtoms.GET_LOCATION) + "(locator); return coords.x + ',' + coords.y;", this.objectId);
        if (coordinates.isEmpty()) {
            this.logger.warning("Falling back to non-atom positioning code in getLocation");
            coordinates = this.debugger.callFunctionOnObject("var coords = locator.getBoundingClientRect();return (coords.left-window.pageXOffset)+','+(coords.top-window.pageYOffset)", this.objectId);
        }
        String[] location = coordinates.split(",");
        return new Point(Integer.valueOf(location[0]).intValue(), Integer.valueOf(location[1]).intValue());
    }

    public Dimension getSize() {
        this.assertElementNotStale();
        String widthAndHeight = this.debugger.callFunctionOnObject("var s=" + (Object)((Object)OperaAtoms.GET_SIZE) + "(locator);return s.width+','+s.height;", this.objectId);
        String[] dimension = widthAndHeight.split(",");
        return new Dimension(Integer.valueOf(dimension[0]).intValue(), Integer.valueOf(dimension[1]).intValue());
    }

    public String getImageHash() {
        return this.getImageHash(10L, new String[0]);
    }

    public String getImageHash(long timeout, String ... hashes) {
        return this.saveScreenshot("", timeout, false, hashes);
    }

    public String saveScreenshot(String filename) {
        return this.saveScreenshot(filename, 10L, true, new String[0]);
    }

    public String saveScreenshot(String filename, long timeout) {
        return this.saveScreenshot(filename, timeout, true, new String[0]);
    }

    public String saveScreenshot(String filename, long timeout, boolean includeImage, String ... hashes) {
        this.assertElementNotStale();
        Canvas canvas = this.buildCanvas();
        ScreenShotReply reply = this.execService.screenWatcher(canvas, timeout, includeImage, hashes);
        if (includeImage && reply.getPng() != null) {
            try {
                FileChannel stream = new FileOutputStream(filename).getChannel();
                stream.write(ByteBuffer.wrap(reply.getPng()));
                stream.close();
            }
            catch (Exception e) {
                throw new WebDriverException("Failed to write file: " + e.getMessage());
            }
        }
        return reply.getMd5();
    }

    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) {
        this.assertElementNotStale();
        Canvas canvas = this.buildCanvas();
        return this.execService.screenWatcher(canvas, timeout, true, hashes);
    }

    @Deprecated
    public boolean containsColor(OperaColors ... colors) {
        this.assertElementNotStale();
        Canvas canvas = this.buildCanvas();
        ScreenShotReply reply = this.execService.containsColor(canvas, 100L, colors);
        List<ColorResult> results = reply.getColorResult();
        for (ColorResult result : results) {
            if (result.getCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private Canvas buildCanvas() {
        Canvas canvas = new Canvas();
        Dimension dimension = this.getSize();
        Point point = this.coordinates.getLocationInViewPort();
        int x = point.x;
        int y = point.y;
        int w = Math.max(dimension.width, 1);
        int h = Math.max(dimension.height, 1);
        canvas.setX(x);
        canvas.setY(y);
        canvas.setHeight(h);
        canvas.setWidth(w);
        canvas.setViewPortRelative(true);
        return canvas;
    }

    public String getTagName() {
        this.assertElementNotStale();
        return this.callMethod("return (locator.tagName);");
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        if (this.isDisplayed()) {
            return this.getLocation();
        }
        return null;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getRuntimeId() {
        return this.runtimeId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OperaWebElement) {
            OperaWebElement ref = (OperaWebElement)((Object)obj);
            return ref.getObjectId() == this.getObjectId() && ref.getRuntimeId() == this.getRuntimeId();
        }
        return false;
    }

    public int hashCode() {
        int result = 42;
        result = 31 * result + this.objectId;
        result = 31 * result + this.runtimeId;
        return result;
    }

    public String toString() {
        return "element" + this.hashCode();
    }

    private WebElement findSingleElement(String using, String type) {
        Integer id = this.debugger.executeScriptOnObject(using, this.objectId);
        if (id != null) {
            return new OperaWebElement(this.parent, id);
        }
        throw new NoSuchElementException("Cannot find element with " + type);
    }

    protected WebElement findElement(final String by, final String using) {
        final OperaWebElement el = this;
        return this.parent.implicitlyWaitFor(new Callable<WebElement>(){

            @Override
            public WebElement call() throws Exception {
                return OperaWebElement.this.parent.findElement(by, using, el);
            }
        });
    }

    protected List<WebElement> findElements(String by, String using) {
        return this.parent.findElements(by, using, this);
    }

    private List<WebElement> findMultipleElements(String using, String type) {
        Integer id = this.debugger.executeScriptOnObject(using, this.objectId);
        if (id == null) {
            throw new NoSuchElementException("Cannot find element(s) with " + type);
        }
        return this.parent.processElements(id);
    }

    public WebElement findElementByName(String using) {
        return this.findSingleElement("document.evaluate(\"descendant-or-self::*[@name='" + using + "']\",locator,null,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext()", "name");
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findMultipleElements("var result = document.evaluate(\"descendant-or-self::*[@name='" + using + "']\"" + ", locator, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE,  null);\n" + "var elements = new Array();\n" + "var element = result.iterateNext();\n" + "while (element) {\n" + "  elements.push(element);\n" + "  element = result.iterateNext();\n" + "}\n" + "return elements", "XPath");
    }

    protected void finalize() throws Throwable {
        this.debugger.releaseObject(this.objectId);
        super.finalize();
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public String getCssValue(String property) {
        this.assertElementNotStale();
        String value = this.callMethod("return " + (Object)((Object)OperaAtoms.GET_EFFECTIVE_STYLE) + "(locator, '" + property + "')");
        if (property.contains("color") && value.contains("rgb")) {
            return new OperaColor(value).getHex();
        }
        return value;
    }

    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    private void verifyCanInteractWithElement() {
        this.assertElementNotStale();
        this.assertElementDisplayed();
        this.assertElementEnabled();
    }

    private void assertElementDisplayed() {
        this.assertElementDisplayed("You may only interact with visible elements");
    }

    private void assertElementDisplayed(String message) {
        Boolean displayed = this.parent.implicitlyWaitFor(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return OperaWebElement.this.isDisplayed();
            }
        });
        if (displayed == null || !displayed.booleanValue()) {
            throw new ElementNotVisibleException(message);
        }
    }

    private void assertElementEnabled() {
        this.assertElementEnabled("You may only interact with enabled elements");
    }

    private void assertElementEnabled(String message) {
        if (!this.isEnabled()) {
            throw new InvalidElementStateException(message);
        }
    }

    private void assertElementNotStale() {
        if (!this.parent.objectIds.contains(this.objectId)) {
            throw new StaleElementReferenceException("Element appears to be stale.  Did you navigate away from the page that contained it?  And is the current window focussed the same as the one holding this element?");
        }
        if (Boolean.valueOf(this.callMethod("locator.parentNode == undefined")).booleanValue()) {
            throw new StaleElementReferenceException("The element seems to be disconnected from the DOM.  This means that the user cannot interact with it.");
        }
    }
}

