/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.preferences;

import com.opera.core.systems.preferences.AbstractOperaPreferences;
import com.opera.core.systems.preferences.OperaPreferences;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;

public class OperaFilePreferences
extends AbstractOperaPreferences {
    private File preferenceFile;

    public OperaFilePreferences(File preferenceFile) {
        Ini ini;
        this.preferenceFile = preferenceFile;
        if (!preferenceFile.exists()) {
            try {
                if (!preferenceFile.createNewFile()) {
                    throw new IOException("File exists");
                }
            }
            catch (IOException e) {
                throw new WebDriverException("Unable to create new preference file: " + e.getMessage());
            }
            return;
        }
        TemporaryFilesystem fs = null;
        try {
            String currentLine;
            fs = TemporaryFilesystem.getDefaultTmpFS();
            File temporaryPreferenceFile = new File(fs.createTempDir("operadriver", "preferences").getAbsolutePath() + File.separator + "opera.ini");
            BufferedReader reader = new BufferedReader(new FileReader(preferenceFile));
            BufferedWriter writer = new BufferedWriter(new FileWriter(temporaryPreferenceFile));
            String newLine = System.getProperty("line.separator");
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.contains("Opera Preferences version")) continue;
                writer.write(currentLine + newLine);
            }
            reader.close();
            writer.close();
            ini = new Ini(temporaryPreferenceFile);
        }
        catch (FileNotFoundException e) {
            throw new WebDriverException("Unknown file: " + preferenceFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new WebDriverException("Unable to read file: " + preferenceFile.getPath());
        }
        finally {
            if (fs != null) {
                fs.deleteTemporaryFiles();
            }
        }
        for (Map.Entry section : ini.entrySet()) {
            for (Map.Entry entry : ((Profile.Section)section.getValue()).entrySet()) {
                this.set(((Profile.Section)section.getValue()).getName(), (String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void set(String section, String key, Object value) {
        this.set(new FilePreference(this, section, key, value));
    }

    public void set(OperaPreferences.OperaPreference preference) {
        if (!(preference instanceof FilePreference)) {
            super.set(FilePreference.convert(this, preference));
        } else {
            super.set(preference);
        }
        this.write();
    }

    public void write() {
        try {
            Wini ini = new Wini(this.preferenceFile);
            for (OperaPreferences.OperaPreference p : this) {
                ini.put(p.getSection(), p.getKey(), ((AbstractOperaPreferences.AbstractPreference)p).getValue(true));
            }
            ini.store(this.preferenceFile);
        }
        catch (IOException e) {
            throw new WebDriverException("Unable to write to preference file: " + e.getMessage());
        }
    }

    public static class FilePreference
    extends AbstractOperaPreferences.AbstractPreference {
        private OperaFilePreferences parent;

        public FilePreference(OperaFilePreferences parent, String section, String key, Object value) {
            super(section, key, value);
            this.parent = parent;
        }

        public void setValue(Object value) {
            super.setValue(value);
            this.parent.write();
        }

        public static FilePreference convert(OperaFilePreferences parent, OperaPreferences.OperaPreference convertee) {
            return new FilePreference(parent, convertee.getSection(), convertee.getKey(), convertee.getValue());
        }
    }
}

