/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.launcher;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.opera.core.systems.runner.launcher.OperaLauncherProtos;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperaLauncherProtocol {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Socket socket;

    public OperaLauncherProtocol(Socket socket) throws SocketException {
        this.socket = socket;
        this.socket.setSoTimeout(180000);
        this.logger.finer("Setting launcher protocol timeout to " + this.socket.getSoTimeout() + " ms");
        this.logger.fine("Got launcher connection from " + this.socket.getRemoteSocketAddress().toString());
    }

    public void shutdown() throws IOException {
        this.socket.close();
    }

    private void sendRequestHeader(MessageType type, int size) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.put((byte)76);
        buf.put((byte)49);
        buf.put(type.getValue());
        buf.put((byte)0);
        buf.putInt(size);
        buf.flip();
        this.logger.finest("SEND: type=0, command=" + type.getValue() + ", size=" + size);
        this.socket.getOutputStream().write(buf.array());
    }

    public ResponseEncapsulation sendRequest(MessageType type, byte[] body) throws IOException {
        this.sendRequestHeader(type, body != null ? body.length : 0);
        if (body != null) {
            this.socket.getOutputStream().write(body);
        }
        return this.recvMessage();
    }

    public void sendRequestWithoutResponse(MessageType type, byte[] body) throws IOException {
        this.sendRequestHeader(type, body != null ? body.length : 0);
        if (body != null) {
            this.socket.getOutputStream().write(body);
        }
    }

    private void recv(byte[] buffer, int length) throws IOException {
        int res;
        for (int bytes = 0; bytes < length; bytes += res) {
            res = this.socket.getInputStream().read(buffer, bytes, length - bytes);
            if (res > 0) {
                continue;
            }
            return;
        }
    }

    private ResponseEncapsulation recvMessage() throws IOException {
        GeneratedMessage msg = null;
        byte[] headers = new byte[8];
        this.recv(headers, headers.length);
        if (headers[0] != 76 || headers[1] != 49) {
            throw new IOException("Wrong launcher protocol header");
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.put(headers, 4, 4);
        buf.flip();
        int size = buf.getInt();
        this.logger.finest("RECV: type=" + headers[3] + ", command=" + headers[2] + ", size=" + size);
        byte[] data = new byte[size];
        this.recv(data, size);
        boolean success = headers[3] == 1;
        MessageType type = MessageType.get(headers[2]);
        if (type == null) {
            throw new IOException("Unable to determine message type");
        }
        if (headers[3] != 1 && headers[3] != 2) {
            throw new IOException("Unable to determine success or error");
        }
        switch (type) {
            case MSG_HELLO: {
                OperaLauncherProtos.LauncherHandshakeResponse.Builder response = OperaLauncherProtos.LauncherHandshakeResponse.newBuilder();
                this.buildMessage(response, data);
                msg = response.build();
                break;
            }
            case MSG_START: 
            case MSG_STATUS: 
            case MSG_STOP: {
                OperaLauncherProtos.LauncherStatusResponse.Builder response = OperaLauncherProtos.LauncherStatusResponse.newBuilder();
                this.buildMessage(response, data);
                msg = response.build();
                break;
            }
            case MSG_SCREENSHOT: {
                OperaLauncherProtos.LauncherScreenshotResponse.Builder response = OperaLauncherProtos.LauncherScreenshotResponse.newBuilder();
                this.buildMessage(response, data);
                msg = response.build();
                break;
            }
        }
        return new ResponseEncapsulation(success, msg);
    }

    private GeneratedMessage.Builder<?> buildMessage(GeneratedMessage.Builder<?> builder, byte[] message) throws IOException {
        try {
            return (GeneratedMessage.Builder)builder.mergeFrom(message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException("Could not parse launcher message " + builder.getDescriptorForType().getFullName() + ": " + e.getMessage());
        }
    }

    public class ResponseEncapsulation {
        private boolean success;
        private GeneratedMessage response;

        public ResponseEncapsulation(boolean success, GeneratedMessage response) {
            this.success = success;
            this.response = response;
        }

        public GeneratedMessage getResponse() {
            return this.response;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        MSG_HELLO(0),
        MSG_START(1),
        MSG_STATUS(2),
        MSG_SCREENSHOT(3),
        MSG_STOP(4),
        MSG_SHUTDOWN(5);

        private static final Map<Byte, MessageType> lookup;
        private byte code;

        private MessageType(byte n2) {
            this.code = n2;
        }

        public byte getValue() {
            return this.code;
        }

        public static MessageType get(byte code) {
            return lookup.get(code);
        }

        static {
            lookup = new TreeMap<Byte, MessageType>();
            for (MessageType command : EnumSet.allOf(MessageType.class)) {
                lookup.put(command.getValue(), command);
            }
        }
    }
}

