/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.launcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.protobuf.GeneratedMessage;
import com.opera.core.systems.OperaPaths;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.arguments.OperaArgument;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.runner.OperaLaunchers;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.runner.OperaRunnerException;
import com.opera.core.systems.runner.launcher.OperaLauncherBinary;
import com.opera.core.systems.runner.launcher.OperaLauncherProtocol;
import com.opera.core.systems.runner.launcher.OperaLauncherProtos;
import com.opera.core.systems.scope.internal.OperaIntervals;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Level;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.os.CommandLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperaLauncherRunner
extends OperaRunner
implements com.opera.core.systems.runner.interfaces.OperaRunner {
    public static final String LAUNCHER_ENV_VAR = "OPERA_LAUNCHER";
    private final URL bundledLauncher;
    private final int launcherPort = PortProber.findFreePort();
    private OperaLauncherBinary launcherRunner = null;
    private OperaLauncherProtocol launcherProtocol = null;
    private String crashlog = null;

    public OperaLauncherRunner() {
        this(new OperaSettings());
    }

    public OperaLauncherRunner(OperaSettings s) {
        super(s);
        this.bundledLauncher = OperaLaunchers.class.getClassLoader().getResource("launchers/" + OperaLauncherRunner.launcherNameForOS());
        if (this.bundledLauncher == null) {
            throw new OperaRunnerException("Not able to locate bundled launcher: " + this.bundledLauncher);
        }
        try {
            if (this.settings.getLauncher().getCanonicalPath().equals(OperaLauncherRunner.launcherDefaultLocation().getCanonicalPath()) && (!this.settings.getLauncher().exists() || this.isLauncherOutdated(this.settings.getLauncher()))) {
                this.extractLauncher(this.bundledLauncher, this.settings.getLauncher());
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException(e);
        }
        OperaLauncherRunner.makeLauncherExecutable(this.settings.getLauncher());
        if (this.settings.getBinary() == null) {
            this.settings.setBinary(new File(OperaPaths.operaPath()));
        }
        ImmutableList<String> arguments = this.buildArguments();
        this.logger.config("launcher arguments: " + arguments);
        try {
            this.launcherRunner = new OperaLauncherBinary(this.settings.getLauncher().getPath(), (String[])arguments.toArray((Object[])new String[arguments.size()]));
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to start launcher: " + e.getMessage());
        }
        this.logger.fine("Waiting for launcher connection on port " + this.launcherPort);
        try {
            ServerSocket listenerServer = new ServerSocket(this.launcherPort);
            listenerServer.setSoTimeout((int)OperaIntervals.LAUNCHER_TIMEOUT.getValue());
            this.launcherProtocol = new OperaLauncherProtocol(listenerServer.accept());
            this.logger.fine("Connected with launcher on port " + this.launcherPort);
            listenerServer.close();
            OperaLauncherProtos.LauncherHandshakeRequest.Builder request = OperaLauncherProtos.LauncherHandshakeRequest.newBuilder();
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_HELLO, request.build().toByteArray());
            if (!res.isSuccess()) {
                throw new OperaRunnerException("Did not get launcher handshake: " + res.getResponse().toString());
            }
            this.logger.finer("Got launcher handshake: " + res.getResponse().toString());
        }
        catch (SocketTimeoutException e) {
            throw new OperaRunnerException("Timeout waiting for launcher to connect on port " + this.launcherPort, e);
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to listen to launcher port " + this.launcherPort, e);
        }
    }

    protected ImmutableList<String> buildArguments() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"-host").add((Object)this.settings.getHost());
        builder.add((Object)"-port").add((Object)String.format("%s", this.launcherPort));
        if (this.settings.getDisplay() != null && this.settings.getDisplay() > 0) {
            builder.add((Object)"-display").add((Object)String.format(":%s", this.settings.getDisplay()));
        }
        if (this.settings.logging().getLevel() != Level.OFF) {
            builder.add((Object)"-console");
            builder.add((Object)"-verbosity").add((Object)OperaLauncherRunner.toLauncherLoggingLevel(this.settings.logging().getLevel()).toString());
        }
        if (this.settings.getProduct() != OperaProduct.ALL) {
            builder.add((Object)"-profile").add((Object)this.settings.getProduct().toString());
        }
        if (this.settings.getBackend() != null && !this.settings.getBackend().isEmpty()) {
            builder.add((Object)"-backend").add((Object)this.settings.getBackend());
        }
        if (this.settings.hasDetach()) {
            builder.add((Object)"-noquit");
        }
        builder.add((Object)"-bin").add((Object)this.settings.getBinary().getAbsolutePath());
        for (OperaArgument argument : this.settings.arguments()) {
            builder.add((Object)(this.settings.arguments().sign() + argument.getArgument()));
            if (argument.getValue() == null || argument.getValue().isEmpty()) continue;
            builder.add((Object)argument.getValue());
        }
        return builder.build();
    }

    @Override
    public void startOpera() {
        this.logger.fine("Instructing launcher to start Opera...");
        try {
            byte[] request = OperaLauncherProtos.LauncherStartRequest.newBuilder().build().toByteArray();
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_START, request);
            if (this.handleStatusMessage(res.getResponse()) != OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new IOException("launcher unable to start binary");
            }
            try {
                Thread.sleep(OperaIntervals.PROCESS_START_SLEEP.getValue());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STATUS, request);
            if (this.handleStatusMessage(res.getResponse()) != OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new OperaRunnerException("Opera exited immediately; possibly incorrect arguments?  Command: " + this.launcherRunner.getCommands());
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not start Opera: " + e.getMessage());
        }
        this.logger.fine("Opera launched through launcher");
    }

    @Override
    public void stopOpera() {
        this.logger.fine("Instructing launcher to stop Opera...");
        try {
            OperaLauncherProtos.LauncherStopRequest.Builder request = OperaLauncherProtos.LauncherStopRequest.newBuilder();
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STOP, request.build().toByteArray());
            if (this.handleStatusMessage(res.getResponse()) == OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new IOException("launcher unable to stop binary");
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not stop Opera: " + e.getMessage());
        }
        this.logger.fine("Opera stopped through launcher");
    }

    @Override
    public boolean isOperaRunning() {
        return this.isOperaRunning(0);
    }

    @Override
    public boolean isOperaRunning(int processId) {
        try {
            OperaLauncherProtos.LauncherStatusRequest.Builder request = OperaLauncherProtos.LauncherStatusRequest.newBuilder();
            if (processId > 0) {
                request.setProcessid(processId);
            }
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STATUS, request.build().toByteArray());
            this.logger.finer("Getting Opera's status from launcher: " + res.getResponse().toString());
            return this.handleStatusMessage(res.getResponse()) == OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING;
        }
        catch (IOException e) {
            this.logger.fine("Could not get state of Opera, assuming launcher has shut down");
            return false;
        }
    }

    @Override
    public boolean hasOperaCrashed() {
        return this.crashlog != null;
    }

    @Override
    public String getOperaCrashlog() {
        return this.crashlog;
    }

    @Override
    public void shutdown() {
        this.logger.fine("Shutting down launcher");
        try {
            this.launcherProtocol.sendRequestWithoutResponse(OperaLauncherProtocol.MessageType.MSG_SHUTDOWN, null);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.launcherProtocol.shutdown();
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to shut down launcher", e);
        }
        if (this.launcherRunner != null) {
            this.launcherRunner.shutdown();
            this.launcherRunner = null;
        }
    }

    private OperaLauncherProtos.LauncherStatusResponse.StatusType handleStatusMessage(GeneratedMessage msg) {
        OperaLauncherProtos.LauncherStatusResponse response = (OperaLauncherProtos.LauncherStatusResponse)msg;
        this.logger.finest("[LAUNCHER] Status: " + response.getStatus().toString());
        if (response.hasExitcode()) {
            this.logger.finest("[LAUNCHER] Status: exitCode=" + response.getExitcode());
        }
        if (response.hasCrashlog()) {
            this.logger.finest("[LAUNCHER] Status: crashLog=yes");
        } else {
            this.logger.finest("[LAUNCHER] Status: crashLog=no");
        }
        if (response.getLogmessagesCount() > 0) {
            for (String message : response.getLogmessagesList()) {
                this.logger.finest("[LAUNCHER LOG] " + message);
            }
        } else {
            this.logger.finest("[LAUNCHER LOG] No log...");
        }
        OperaLauncherProtos.LauncherStatusResponse.StatusType status = response.getStatus();
        this.crashlog = status == OperaLauncherProtos.LauncherStatusResponse.StatusType.CRASHED ? (response.hasCrashlog() ? response.getCrashlog().toStringUtf8() : "") : null;
        return status;
    }

    @Override
    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) {
        byte[] resultBytes;
        String resultMd5;
        boolean blank = false;
        this.logger.fine("Instructing launcher to take screenshot");
        try {
            OperaLauncherProtos.LauncherScreenshotRequest.Builder request = OperaLauncherProtos.LauncherScreenshotRequest.newBuilder();
            for (String hash : hashes) {
                request.addKnownMD5S(hash);
            }
            request.setKnownMD5STimeoutMs((int)timeout);
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_SCREENSHOT, request.build().toByteArray());
            OperaLauncherProtos.LauncherScreenshotResponse response = (OperaLauncherProtos.LauncherScreenshotResponse)res.getResponse();
            resultMd5 = response.getMd5();
            resultBytes = response.getImagedata().toByteArray();
            if (response.hasBlank()) {
                blank = response.getBlank();
            }
        }
        catch (SocketTimeoutException e) {
            throw new OperaRunnerException("Could not get screenshot from launcher (Socket Timeout)", e);
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not get screenshot from launcher with exception: " + e, e);
        }
        this.isOperaRunning();
        ScreenShotReply screenshotreply = new ScreenShotReply(resultMd5, resultBytes);
        screenshotreply.setBlank(blank);
        screenshotreply.setCrashed(this.hasOperaCrashed());
        return screenshotreply;
    }

    private void extractLauncher(URL sourceLauncher, File targetLauncher) {
        FileOutputStream os;
        block8: {
            Preconditions.checkNotNull((Object)sourceLauncher);
            Preconditions.checkNotNull((Object)targetLauncher);
            InputStream is = null;
            os = null;
            try {
                targetLauncher.getParentFile().mkdirs();
                if (!targetLauncher.exists()) {
                    Files.touch((File)targetLauncher);
                }
                is = sourceLauncher.openStream();
                os = new FileOutputStream(targetLauncher);
                ByteStreams.copy((InputStream)is, (OutputStream)os);
                if (is == null) break block8;
            }
            catch (IOException e) {
                try {
                    throw new OperaRunnerException("Cannot write file to disk: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        Closeables.closeQuietly(is);
                    }
                    if (os != null) {
                        Closeables.closeQuietly(os);
                    }
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)is);
        }
        if (os != null) {
            Closeables.closeQuietly((Closeable)os);
        }
        this.logger.fine("New launcher copied to " + targetLauncher.getPath());
    }

    private boolean isLauncherOutdated(File launcher) {
        try {
            return !Arrays.equals(OperaLauncherRunner.md5(this.bundledLauncher.openStream()), OperaLauncherRunner.md5(launcher));
        }
        catch (NoSuchAlgorithmException e) {
            throw new OperaRunnerException("Algorithm is not available in your environment: " + e.getMessage());
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to open stream or file: " + e.getMessage());
        }
    }

    public static File launcherDefaultLocation() {
        return new File(System.getProperty("user.home") + "/.launcher/" + OperaLauncherRunner.launcherNameForOS());
    }

    public static void assertLauncherGood(File launcher) throws IOException {
        if (!launcher.exists()) {
            throw new IOException("Unknown file: " + launcher.getPath());
        }
        if (!launcher.isFile()) {
            throw new IOException("Not a file: " + launcher.getPath());
        }
        if (!FileHandler.canExecute((File)launcher).booleanValue()) {
            throw new IOException("Not executable: " + launcher.getPath());
        }
    }

    private static void makeLauncherExecutable(File launcher) {
        Platform current = Platform.getCurrent();
        if (current.is(Platform.UNIX) || current.is(Platform.MAC)) {
            CommandLine line = new CommandLine("chmod", new String[]{"u+x", launcher.getAbsolutePath()});
            line.execute();
        }
    }

    private static String launcherNameForOS() {
        boolean is64 = "64".equals(System.getProperty("sun.arch.data.model"));
        Platform currentPlatform = Platform.getCurrent();
        switch (currentPlatform) {
            case LINUX: 
            case UNIX: {
                return is64 ? "launcher-linux-x86_64" : "launcher-linux-i686";
            }
            case MAC: {
                return "launcher-mac";
            }
            case WINDOWS: 
            case VISTA: 
            case XP: {
                return "launcher-win32-i86pc.exe";
            }
        }
        throw new WebDriverException("Could not find a platform that supports bundled launchers, please set it manually");
    }

    private static byte[] md5(InputStream fis) throws NoSuchAlgorithmException, IOException {
        return ByteStreams.hash((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])ByteStreams.toByteArray((InputStream)fis)), (HashFunction)Hashing.md5()).asBytes();
    }

    private static byte[] md5(File file) throws NoSuchAlgorithmException, IOException {
        return Files.hash((File)file, (HashFunction)Hashing.md5()).asBytes();
    }

    protected static Level toLauncherLoggingLevel(Level level) {
        switch (level.intValue()) {
            case 1000: {
                return Level.SEVERE;
            }
            case 900: {
                return Level.WARNING;
            }
            case 400: 
            case 500: 
            case 700: 
            case 800: {
                return Level.FINE;
            }
            case -2147483648: 
            case 300: {
                return Level.FINEST;
            }
        }
        return Level.OFF;
    }
}

