/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.CoreUtilsCommand;
import com.opera.core.systems.scope.protos.CoreProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.ICoreUtils;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUtils
extends AbstractService
implements ICoreUtils {
    private boolean supportsMeta = false;
    private CoreProtos.BrowserInformation browserInformation;

    public CoreUtils(ScopeServices services, String version) {
        super(services, version);
        String serviceName = "core";
        if (!this.isVersionInRange(version, "1.2", serviceName)) {
            this.supportsMeta = true;
        }
        services.setCoreUtils(this);
    }

    @Override
    public void init() {
        if (this.hasMetaInformation()) {
            this.browserInformation = this.getBrowserInformation();
        }
    }

    @Override
    public boolean hasMetaInformation() {
        return this.supportsMeta;
    }

    @Override
    public String getCoreVersion() {
        this.assertHasMetaInformation();
        return this.browserInformation.getCoreVersion();
    }

    @Override
    public String getOperatingSystem() {
        this.assertHasMetaInformation();
        return this.browserInformation.getOperatingSystem();
    }

    @Override
    public String getProduct() {
        this.assertHasMetaInformation();
        return this.browserInformation.getProduct();
    }

    @Override
    public String getBinaryPath() {
        this.assertHasMetaInformation();
        return this.browserInformation.getBinaryPath();
    }

    @Override
    public String getUserAgent() {
        this.assertHasMetaInformation();
        return this.browserInformation.getUserAgent();
    }

    @Override
    public Integer getProcessID() {
        this.assertHasMetaInformation();
        return this.browserInformation.getProcessID();
    }

    @Override
    public void clearPrivateData(List<CoreProtos.ClearFlags> flags) {
        CoreProtos.ClearPrivateDataArg.Builder arg = CoreProtos.ClearPrivateDataArg.newBuilder();
        arg.addAllClearList(flags);
        this.executeCommand(CoreUtilsCommand.CLEAR_PRIVATE_DATA, (AbstractMessage.Builder<?>)arg);
    }

    public void clearPrivateData(OperaDriver.PrivateData ... flags) {
        this.clearPrivateData(this.privateDataFlagsToScope(flags));
    }

    private CoreProtos.BrowserInformation getBrowserInformation() {
        UmsProtos.Response response = this.executeCommand(CoreUtilsCommand.GET_BROWSER_INFORMATION, null);
        CoreProtos.BrowserInformation.Builder builder = CoreProtos.BrowserInformation.newBuilder();
        CoreUtils.buildPayload(response, builder);
        return builder.build();
    }

    private List<CoreProtos.ClearFlags> privateDataFlagsToScope(OperaDriver.PrivateData ... flags) {
        ArrayList<CoreProtos.ClearFlags> clearFlags = new ArrayList<CoreProtos.ClearFlags>();
        block18: for (OperaDriver.PrivateData flag : flags) {
            switch (flag) {
                case ALL: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_ALL);
                    continue block18;
                }
                case VISITED_LINKS: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_VISITED_LINKS);
                    continue block18;
                }
                case DISK_CACHE: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_DISK_CACHE);
                    continue block18;
                }
                case IMAGE_CACHE: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_IMAGE_CACHE);
                    continue block18;
                }
                case MEMORY_CACHE: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_MEMORY_CACHE);
                    continue block18;
                }
                case SENSITIVE_DATA: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_SENSITIVE_DATA);
                    continue block18;
                }
                case SESSION_COOKIES: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_SESSION_COOKIES);
                    continue block18;
                }
                case ALL_COOKIES: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_ALL_COOKIES);
                    continue block18;
                }
                case GLOBAL_HISTORY: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_GLOBAL_HISTORY);
                    continue block18;
                }
                case CONSOLE: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_CONSOLE);
                    continue block18;
                }
                case THUMBNAILS: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_THUMBNAILS);
                    continue block18;
                }
                case WEBDATABASES: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_WEBDATABASES);
                    continue block18;
                }
                case WEBSTORAGE: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_WEBSTORAGE);
                    continue block18;
                }
                case APPCACHE: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_APPCACHE);
                    continue block18;
                }
                case GEOLOCATION_PERMISSIONS: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_GEOLOCATION_PERMISSIONS);
                    continue block18;
                }
                case SITE_PREFS: {
                    clearFlags.add(CoreProtos.ClearFlags.CLEAR_SITE_PREFS);
                    continue block18;
                }
                default: {
                    throw new WebDriverException("Unhandled private data flag: " + (Object)((Object)flag));
                }
            }
        }
        return clearFlags;
    }

    private void assertHasMetaInformation() {
        if (!this.hasMetaInformation()) {
            throw new UnsupportedCommandException("not available in this product");
        }
    }
}

