/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.DesktopUtilsCommand;
import com.opera.core.systems.scope.protos.DesktopUtilsProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.IDesktopUtils;

public class DesktopUtils
extends AbstractService
implements IDesktopUtils {
    public DesktopUtils(ScopeServices services, String version) {
        super(services, version);
        String serviceName = "desktop-utils";
        if (!this.isVersionInRange(version, "3.0", serviceName)) {
            throw new UnsupportedOperationException(serviceName + " version " + version + " is not supported");
        }
        services.setDesktopUtils(this);
    }

    public void init() {
    }

    public String getString(String enumText, boolean stripAmpersand) {
        DesktopUtilsProtos.DesktopStringID.Builder stringBuilder = DesktopUtilsProtos.DesktopStringID.newBuilder();
        stringBuilder.setEnumText(enumText);
        UmsProtos.Response response = this.executeCommand(DesktopUtilsCommand.GET_STRING, (AbstractMessage.Builder<?>)stringBuilder);
        DesktopUtilsProtos.DesktopStringText.Builder stringTextBuilder = DesktopUtilsProtos.DesktopStringText.newBuilder();
        DesktopUtils.buildPayload(response, stringTextBuilder);
        DesktopUtilsProtos.DesktopStringText stringText = stringTextBuilder.build();
        String str = this.removeCR(stringText.getText());
        if (stripAmpersand && str.contains("(&")) {
            return str.replaceAll("\\(&.\\)", "");
        }
        if (stripAmpersand && str.contains("&")) {
            return str.replace("&", "");
        }
        return str;
    }

    public String removeCR(String text) {
        return text.replaceAll("(\\r)", "");
    }

    public String getOperaPath() {
        UmsProtos.Response response = this.executeCommand(DesktopUtilsCommand.GET_OPERA_PATH, null);
        DesktopUtilsProtos.DesktopPath.Builder pathBuilder = DesktopUtilsProtos.DesktopPath.newBuilder();
        DesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPath string_path = pathBuilder.build();
        return string_path.getPath();
    }

    public String getLargePreferencesPath() {
        UmsProtos.Response response = this.executeCommand(DesktopUtilsCommand.GET_LARGE_PREFERENCES_PATH, null);
        DesktopUtilsProtos.DesktopPath.Builder pathBuilder = DesktopUtilsProtos.DesktopPath.newBuilder();
        DesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPath stringPath = pathBuilder.build();
        return stringPath.getPath();
    }

    public String getSmallPreferencesPath() {
        UmsProtos.Response response = this.executeCommand(DesktopUtilsCommand.GET_SMALL_PREFERENCES_PATH, null);
        DesktopUtilsProtos.DesktopPath.Builder pathBuilder = DesktopUtilsProtos.DesktopPath.newBuilder();
        DesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPath stringPath = pathBuilder.build();
        return stringPath.getPath();
    }

    public String getCachePreferencesPath() {
        UmsProtos.Response response = this.executeCommand(DesktopUtilsCommand.GET_CACHE_PREFERENCES_PATH, null);
        DesktopUtilsProtos.DesktopPath.Builder pathBuilder = DesktopUtilsProtos.DesktopPath.newBuilder();
        DesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPath stringPath = pathBuilder.build();
        return stringPath.getPath();
    }

    public int getOperaPid() {
        UmsProtos.Response response = this.executeCommand(DesktopUtilsCommand.GET_OPERA_PID, null);
        DesktopUtilsProtos.DesktopPid.Builder pathBuilder = DesktopUtilsProtos.DesktopPid.newBuilder();
        DesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPid desktopPid = pathBuilder.build();
        return desktopPid.getPid();
    }
}

