/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.testing.drivers;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.testing.drivers.DefaultOperaDriverSupplier;
import com.opera.core.systems.testing.drivers.OperaDriverSupplier;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperaDriverBuilder
implements Supplier<OperaDriver> {
    private Class driverClass = null;
    private OperaDriverSupplier driverSupplier;
    private OperaSettings settings = new OperaSettings();
    private Level loggingLevel = null;

    public OperaDriverBuilder() {
        this(new DefaultOperaDriverSupplier());
    }

    public OperaDriverBuilder(OperaDriverSupplier supplier) {
        this.driverSupplier = supplier;
    }

    public OperaDriverBuilder(Class<? extends OperaDriver> driverImplementation) {
        this.driverClass = driverImplementation;
    }

    public OperaDriverBuilder using(OperaSettings settings) {
        this.settings = settings;
        return this;
    }

    public OperaDriverBuilder modifyLogLevel(Level level) {
        this.loggingLevel = level;
        return this;
    }

    public OperaDriver get() {
        OperaDriver driver;
        if (this.loggingLevel != null) {
            this.settings.logging().setLevel(this.loggingLevel);
        }
        if (this.driverSupplier == null) {
            Preconditions.checkNotNull((Object)this.driverClass, (Object)"No driver class specified");
            try {
                Class constructor = (Class)this.driverClass.getClass().getConstructor(Class.class).newInstance(this.settings);
                driver = (OperaDriver)((Object)constructor.newInstance());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Unable to recognize implementation's constructor");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Illegal access: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.driverSupplier.setSettings(this.settings);
            driver = (OperaDriver)((Object)this.driverSupplier.get());
        }
        return driver;
    }
}

