/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.testing.drivers;

import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.scope.services.IOperaExec;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;

public class TestOperaDriver
extends OperaDriver {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final Platform currentPlatform = Platform.getCurrent();
    private String controlWindow = this.getWindowHandle();
    private OperaProduct currentProduct = null;

    public TestOperaDriver(Capabilities capabilities) {
        super(capabilities);
    }

    public TestOperaDriver(OperaSettings settings) {
        super(settings);
    }

    public OperaRunner getRunner() {
        return this.runner;
    }

    public OperaSettings getSettings() {
        return this.settings;
    }

    public Capabilities getCapabilities() {
        return this.settings.toCapabilities();
    }

    public boolean isRunning() {
        return !this.settings.autostart() || this.runner != null && this.runner.isOperaRunning();
    }

    public ScopeServices getServices() {
        return this.getScopeServices();
    }

    public IOperaExec getExecService() {
        return super.getExecService();
    }

    public String getControlWindow() {
        return this.controlWindow;
    }

    public void closeAll() {
        this.closeAll(ClosingStrategy.SWITCH_TO);
    }

    public void closeAll(ClosingStrategy strategy) {
        int windowCountBeforeClosing = this.getWindowCount();
        if (windowCountBeforeClosing <= 1) {
            return;
        }
        switch (strategy) {
            case SWITCH_TO: {
                this.closeAllUsingSwitchTo();
                break;
            }
            case ACTION: {
                this.closeAllUsingAction();
            }
        }
        if (this.getWindowCount() != 1) {
            this.logger.warning("Should have had " + (windowCountBeforeClosing - 1) + " fewer window(s)");
        }
        if (!this.getControlWindow().equals(this.getWindowHandle())) {
            this.logger.warning("After closing windows, we were not in the default control window");
            this.switchTo().window(this.getControlWindow());
        }
    }

    public TestOperaUtils utils() {
        return new TestOperaUtils();
    }

    public static Capabilities getDefaultCapabilities() {
        return new OperaSettings().toCapabilities();
    }

    private void closeAllUsingSwitchTo() {
        for (String windowHandle : this.getWindowHandles()) {
            if (windowHandle.equals(this.getControlWindow())) continue;
            this.switchTo().window(windowHandle);
            this.close();
        }
    }

    private void closeAllUsingAction() {
        if (this.utils().getProduct().is(OperaProduct.DESKTOP)) {
            throw new UnsupportedOperationException("Closing pages by Opera action not supported on product DESKTOP");
        }
        this.getScopeServices().getExec().action("Close all pages", new String[0]);
    }

    public class TestOperaUtils
    extends OperaDriver.OperaUtils {
        public OperaProduct getProduct() {
            if (TestOperaDriver.this.currentProduct == null) {
                TestOperaDriver.this.currentProduct = OperaProduct.CORE;
                String requestedProduct = System.getenv("OPERA_PRODUCT");
                if (TestOperaDriver.this.isRunning() && (requestedProduct == null || requestedProduct.isEmpty())) {
                    requestedProduct = super.getProduct().toString();
                } else {
                    TestOperaDriver.this.logger.warning("Driver is not running, defaulting to " + (Object)((Object)TestOperaDriver.this.currentProduct));
                }
                try {
                    TestOperaDriver.this.currentProduct = OperaProduct.get(requestedProduct);
                }
                catch (IllegalArgumentException e) {
                    TestOperaDriver.this.logger.warning("Product '" + requestedProduct + "' not found, defaulting to " + (Object)((Object)TestOperaDriver.this.currentProduct));
                }
            }
            return TestOperaDriver.this.currentProduct;
        }

        public Platform getPlatform() {
            return TestOperaDriver.this.currentPlatform;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClosingStrategy {
        SWITCH_TO,
        ACTION;

    }
}

