/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.util;

import com.opera.core.systems.util.SocketListener;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class SocketMonitor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ReentrantLock lock = new ReentrantLock();
    private final List<SelectorChangeRequest> changes = new LinkedList<SelectorChangeRequest>();
    private Selector selector;

    public SocketMonitor() {
        try {
            this.selector = SelectorProvider.provider().openSelector();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(SelectableChannel channel, SocketListener listener, int selectMask) {
        this.logger.finest(String.format("Add channel: %s, mask=%s", channel, this.debugMask(selectMask)));
        List<SelectorChangeRequest> list = this.changes;
        synchronized (list) {
            this.changes.add(new SelectorChangeRequest(channel, Operation.ADD, selectMask, listener));
            this.selector.wakeup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modify(SelectableChannel channel, SocketListener listener, int selectMask) {
        this.logger.finest(String.format("Modify channel: %s, mask=%s", channel, this.debugMask(selectMask)));
        if (channel == null) {
            return false;
        }
        List<SelectorChangeRequest> list = this.changes;
        synchronized (list) {
            this.changes.add(new SelectorChangeRequest(channel, Operation.MODIFY, selectMask, listener));
            this.selector.wakeup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SelectableChannel channel) {
        this.logger.finest(String.format("Remove channel: %s", channel));
        if (channel == null) {
            return;
        }
        List<SelectorChangeRequest> list = this.changes;
        synchronized (list) {
            this.changes.add(new SelectorChangeRequest(channel, Operation.REMOVE));
            this.selector.wakeup();
        }
    }

    public void stop() {
        this.selector.wakeup();
    }

    public boolean poll() {
        return this.poll(Long.MAX_VALUE);
    }

    public boolean poll(long ms) {
        boolean ok = this.pollSockets(ms);
        this.applyChanges();
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollSockets(long ms) {
        if (this.selector.keys().isEmpty()) {
            return true;
        }
        this.lock.lock();
        try {
            Selector selector = this.selector;
            synchronized (selector) {
                this.selector.select(ms);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
        this.lock.lock();
        try {
            for (SelectionKey key : this.selector.selectedKeys()) {
                try {
                    this.processSelectionKey(key);
                }
                catch (CancelledKeyException cke) {
                    cke.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    key.cancel();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChanges() {
        List<SelectorChangeRequest> list = this.changes;
        synchronized (list) {
            if (this.changes.isEmpty()) {
                return;
            }
            for (SelectorChangeRequest request : this.changes) {
                try {
                    request.dump();
                    switch (request.operation) {
                        case ADD: {
                            try {
                                request.channel.register(this.selector, request.mask, request.listener);
                            }
                            catch (ClosedChannelException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case MODIFY: {
                            SelectionKey key = request.channel.keyFor(this.selector);
                            if (key == null) break;
                            key.interestOps(request.mask);
                            break;
                        }
                        case REMOVE: {
                            SelectionKey selKey = request.channel.keyFor(this.selector);
                            if (selKey == null) break;
                            selKey.cancel();
                        }
                    }
                }
                catch (CancelledKeyException e) {
                    this.logger.finest("Key was cancelled - ignoring...");
                }
            }
            this.changes.clear();
        }
    }

    protected void processSelectionKey(SelectionKey key) throws IOException {
        int notTriggered;
        SelectableChannel channel = key.channel();
        if (!key.isValid()) {
            return;
        }
        SocketListener listener = (SocketListener)key.attachment();
        int currentMask = key.interestOps();
        int triggerMask = key.readyOps();
        int wantedMask = 0;
        if (key.isValid() && key.isAcceptable() && listener.canRead(channel)) {
            wantedMask |= 0x10;
        }
        if (key.isValid() && key.isConnectable() && listener.canRead(channel)) {
            wantedMask |= 8;
        }
        if (key.isValid() && key.isReadable() && listener.canRead(channel)) {
            wantedMask |= 1;
        }
        if (key.isValid() && key.isWritable() && listener.canWrite(channel)) {
            wantedMask |= 4;
        }
        if ((wantedMask |= (notTriggered = currentMask & ~triggerMask)) != currentMask) {
            if (wantedMask != 0) {
                if (key.isValid()) {
                    key.interestOps(wantedMask);
                }
            } else {
                key.cancel();
            }
        }
    }

    private String debugMask(int mask) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if ((mask & 1) == 1) {
            builder.append(" READ");
        }
        if ((mask & 4) == 4) {
            builder.append(" WRITE");
        }
        if ((mask & 0x10) == 16) {
            builder.append(" ACCEPT");
        }
        if ((mask & 8) == 8) {
            builder.append(" CONNECT");
        }
        builder.append("}");
        return builder.toString();
    }

    private class SelectorChangeRequest {
        protected final SelectableChannel channel;
        protected final Operation operation;
        protected final int mask;
        protected final SocketListener listener;

        public SelectorChangeRequest(SelectableChannel channel, Operation operation) {
            this(channel, operation, 0, null);
        }

        public SelectorChangeRequest(SelectableChannel channel, Operation operation, int mask, SocketListener listener) {
            this.channel = channel;
            this.operation = operation;
            this.mask = mask;
            this.listener = listener;
        }

        public void dump() {
            SocketMonitor.this.logger.finest(String.format("SelectorChangeRequest: %s socket=%s, mask=%d", new Object[]{this.operation, this.channel, this.mask}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        ADD,
        MODIFY,
        REMOVE;

    }
}

