/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaAtoms;
import com.opera.core.systems.OperaKeyboard;
import com.opera.core.systems.OperaMouse;
import com.opera.core.systems.OperaPaths;
import com.opera.core.systems.OperaWebElement;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.Utils;
import com.opera.core.systems.interaction.OperaAction;
import com.opera.core.systems.interaction.UserInteraction;
import com.opera.core.systems.model.ScopeActions;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.model.ScriptResult;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.runner.launcher.OperaLauncherRunner;
import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.handlers.PbActionHandler;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.PrefsProtos;
import com.opera.core.systems.scope.services.ICookieManager;
import com.opera.core.systems.scope.services.ICoreUtils;
import com.opera.core.systems.scope.services.IEcmaScriptDebugger;
import com.opera.core.systems.scope.services.IOperaExec;
import com.opera.core.systems.scope.services.IPrefs;
import com.opera.core.systems.scope.services.IWindowManager;
import com.opera.core.systems.settings.OperaDriverSettings;
import com.opera.core.systems.util.CapabilitiesSanitizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperaDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public static final String LOGGING_LEVEL = "opera.logging.level";
    public static final String LOGGING_FILE = "opera.logging.file";
    public static final String BINARY = "opera.binary";
    public static final String ARGUMENTS = "opera.arguments";
    public static final String HOST = "opera.host";
    public static final String PORT = "opera.port";
    public static final String LAUNCHER = "opera.launcher";
    public static final String PROFILE = "opera.profile";
    public static final String OPERAIDLE = "opera.idle";
    public static final String DISPLAY = "opera.display";
    public static final String AUTOSTART = "opera.autostart";
    public static final String NO_RESTART = "opera.no_restart";
    public static final String NO_QUIT = "opera.no_quit";
    public static final String GUESS_BINARY_PATH = "opera.guess_binary_path";
    public static final String PRODUCT = "opera.product";
    protected DesiredCapabilities capabilities;
    protected OperaRunner operaRunner;
    protected IEcmaScriptDebugger debugger;
    protected IOperaExec exec;
    protected IPrefs prefs;
    protected IWindowManager windowManager;
    protected ICoreUtils coreUtils;
    protected ICookieManager cookieManager;
    protected ScopeServices services;
    protected ScopeActions actionHandler;
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private FileHandler logFile = null;
    protected Set<Integer> objectIds = new HashSet<Integer>();
    private String version;

    public OperaDriver() {
        this((Capabilities)null);
    }

    @Deprecated
    public OperaDriver(OperaDriverSettings settings) {
        this(settings.getCapabilities());
    }

    public OperaDriver(Capabilities c) {
        this.capabilities = (DesiredCapabilities)OperaDriver.getDefaultCapabilities();
        if (c != null) {
            this.capabilities.merge(CapabilitiesSanitizer.sanitize(c));
        }
        Level logLevel = Level.parse(((String)this.capabilities.getCapability(LOGGING_LEVEL)).toUpperCase());
        Logger root = Logger.getLogger("");
        root.setLevel(logLevel);
        if (this.capabilities.getCapability(LOGGING_FILE) != null) {
            try {
                this.logFile = new FileHandler((String)this.capabilities.getCapability(LOGGING_FILE), true);
                this.logFile.setFormatter(new SimpleFormatter());
            }
            catch (IOException e) {
                throw new WebDriverException("Unable to write to file: " + e);
            }
        }
        if (this.logFile != null) {
            root.addHandler(this.logFile);
        }
        for (Handler h : root.getHandlers()) {
            h.setLevel(logLevel);
        }
        if (((Boolean)this.capabilities.getCapability(AUTOSTART)).booleanValue()) {
            String path;
            OperaPaths paths = new OperaPaths();
            if (((Boolean)this.capabilities.getCapability(GUESS_BINARY_PATH)).booleanValue() && this.capabilities.getCapability(BINARY) == null) {
                this.capabilities.setCapability(BINARY, paths.operaPath());
            } else if (this.capabilities.getCapability(BINARY) == null && (path = System.getenv("OPERA_PATH")) != null && path.length() > 0) {
                this.capabilities.setCapability(BINARY, path);
            }
            if (this.capabilities.getCapability(LAUNCHER) == null) {
                this.capabilities.setCapability(LAUNCHER, paths.launcherPath());
            }
            if ((Integer)this.capabilities.getCapability(PORT) == 0) {
                this.capabilities.setCapability(PORT, (Object)PortProber.findFreePort());
            }
            if (this.capabilities.getCapability(BINARY) != null) {
                this.operaRunner = new OperaLauncherRunner(this.capabilities);
            }
        } else {
            this.capabilities.setCapability(PORT, (Object)-1);
        }
        this.start();
    }

    public static Capabilities getDefaultCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.opera();
        capabilities.setJavascriptEnabled(true);
        capabilities.setCapability(LOGGING_LEVEL, "INFO");
        capabilities.setCapability(LOGGING_FILE, (String)null);
        capabilities.setCapability(BINARY, (String)null);
        capabilities.setCapability(HOST, "127.0.0.1");
        capabilities.setCapability(PORT, (Object)-1);
        capabilities.setCapability(ARGUMENTS, "");
        capabilities.setCapability(LAUNCHER, (String)null);
        capabilities.setCapability(DISPLAY, (Object)null);
        capabilities.setCapability(PROFILE, "");
        capabilities.setCapability(AUTOSTART, true);
        capabilities.setCapability(NO_RESTART, false);
        capabilities.setCapability(NO_QUIT, false);
        capabilities.setCapability(GUESS_BINARY_PATH, true);
        capabilities.setCapability(OPERAIDLE, false);
        return capabilities;
    }

    private void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            this.quit();
            throw new WebDriverException((Throwable)e);
        }
        this.logger.finer("Initialization done");
    }

    protected void init() {
        this.createScopeServices();
        if (this.operaRunner != null) {
            this.operaRunner.startOpera();
        }
        this.services.init();
        this.debugger = this.services.getDebugger();
        this.debugger.setDriver(this);
        this.windowManager = this.services.getWindowManager();
        this.exec = this.services.getExec();
        this.coreUtils = this.services.getCoreUtils();
        this.actionHandler = new PbActionHandler(this.services);
        this.cookieManager = this.services.getCookieManager();
        this.prefs = this.services.getPrefs();
    }

    protected Map<String, String> getServicesList() {
        HashMap<String, String> versions = new HashMap<String, String>();
        versions.put("ecmascript-debugger", "5.0");
        versions.put("window-manager", "2.0");
        versions.put("exec", "2.0");
        versions.put("core", "1.0");
        versions.put("cookie-manager", "1.0");
        versions.put("prefs", "1.0");
        versions.put("selftest", "1.1");
        return versions;
    }

    private void createScopeServices() {
        try {
            int port;
            Map<String, String> versions = this.getServicesList();
            boolean manualStart = true;
            if (this.capabilities.getCapability(BINARY) != null) {
                manualStart = false;
            }
            if ((port = ((Integer)this.capabilities.getCapability(PORT)).intValue()) == -1) {
                port = 7001;
            }
            this.services = new ScopeServices(versions, port, manualStart);
            this.services.setProduct((String)this.capabilities.getCapability(PRODUCT));
            this.services.startStpThread();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void quit() {
        this.logger.fine("Opera Driver shutting down");
        TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(new File((String)this.capabilities.getCapability(PROFILE)));
        if (this.services != null) {
            this.services.shutdown();
        }
        if (this.operaRunner != null) {
            this.operaRunner.shutdown();
        }
        if (this.logFile != null) {
            this.logFile.close();
        }
    }

    public void get(String url) {
        this.get(url, OperaIntervals.PAGE_LOAD_TIMEOUT.getValue());
    }

    public int get(String url, long timeout) {
        if (url == null) {
            throw new NullPointerException("Invalid url");
        }
        if (this.services.getConnection() == null) {
            throw new CommunicationException("Unable to open URL because Opera is not connected.");
        }
        this.gc();
        this.exec.releaseKeys();
        int activeWindowId = this.windowManager.getActiveWindowId();
        String oldUrl = this.getCurrentUrl();
        this.services.captureOperaIdle();
        this.windowManager.openUrl(activeWindowId, url);
        if (oldUrl == null || !url.replace(oldUrl, "").startsWith("#")) {
            if (this.useOperaIdle()) {
                try {
                    if (timeout == OperaIntervals.PAGE_LOAD_TIMEOUT.getValue()) {
                        timeout = OperaIntervals.OPERA_IDLE_TIMEOUT.getValue();
                    }
                    this.services.waitForOperaIdle(timeout);
                }
                catch (WebDriverException e) {
                    this.logger.warning("Opera Idle timed out, continue test... exception: " + (Object)((Object)e));
                }
            } else {
                this.services.waitForWindowLoaded(activeWindowId, timeout);
            }
        }
        if (OperaIntervals.ENABLE_DEBUGGER.getValue() == 1L) {
            this.switchTo().defaultContent();
        }
        return this.windowManager.getLastHttpResponseCode().getAndSet(0);
    }

    public String getCurrentUrl() {
        return this.debugger.executeJavascript("return document.location.href");
    }

    private void gc() {
        this.debugger.releaseObjects();
        this.objectIds.clear();
    }

    public void close() {
        this.closeWindow();
        this.windowManager.filterActiveWindow();
    }

    private void closeWindow() {
        this.windowManager.closeWindow(this.windowManager.getActiveWindowId());
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    protected WebElement findElement(String by, String using) {
        return this.findElement(by, using, null);
    }

    protected WebElement findElement(String by, String using, OperaWebElement el) {
        Integer id;
        boolean isAvailable;
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null");
        }
        using = this.escapeJsString(using);
        long start = System.currentTimeMillis();
        String script = el == null ? "return " + OperaAtoms.FIND_ELEMENT.getValue() + "({\"" + by + "\": \"" + using + "\"})" : "return " + OperaAtoms.FIND_ELEMENT.getValue() + "({\"" + by + "\": \"" + using + "\"}, locator)";
        do {
            id = el == null ? this.debugger.getObject(script) : this.debugger.executeScriptOnObject(script, el.getObjectId());
            boolean bl = isAvailable = id != null;
            if (isAvailable) continue;
            OperaDriver.sleep(OperaIntervals.EXEC_SLEEP.getValue());
        } while (!isAvailable && this.hasTimeRemaining(start));
        OperaIntervals.WAIT_FOR_ELEMENT.setValue(0L);
        if (isAvailable) {
            String error = this.debugger.callFunctionOnObject("return (locator instanceof Error) ? locator.message : ''", id);
            if (!error.isEmpty()) {
                throw new InvalidSelectorException(error);
            }
            Boolean isStale = Boolean.valueOf(this.debugger.callFunctionOnObject("locator.parentNode == undefined", id));
            if (isStale.booleanValue()) {
                throw new StaleElementReferenceException("This element is no longer part of DOM");
            }
            return new OperaWebElement(this, id);
        }
        throw new NoSuchElementException("Cannot find element(s) with " + by);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    protected List<WebElement> findElements(String by, String using) {
        return this.findElements(by, using, null);
    }

    protected List<WebElement> findElements(String by, String using, OperaWebElement el) {
        List<WebElement> elements;
        Integer id;
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null");
        }
        using = this.escapeJsString(using);
        long start = System.currentTimeMillis();
        int count = 0;
        String script = el == null ? "return " + OperaAtoms.FIND_ELEMENTS.getValue() + "({\"" + by + "\": \"" + using + "\"})" : "return " + OperaAtoms.FIND_ELEMENTS.getValue() + "({\"" + by + "\": \"" + using + "\"}, locator)";
        while (true) {
            String error;
            if (!(error = this.debugger.callFunctionOnObject("return (locator instanceof Error) ? locator.message : ''", id = el == null ? this.debugger.getObject(script) : this.debugger.executeScriptOnObject(script, el.getObjectId()))).isEmpty()) {
                throw new InvalidSelectorException(error);
            }
            elements = this.processElements(id);
            if (elements != null) {
                count = elements.size();
            }
            if (count != 0 || !this.hasTimeRemaining(start)) break;
            OperaDriver.sleep(OperaIntervals.EXEC_SLEEP.getValue());
        }
        OperaIntervals.WAIT_FOR_ELEMENT.setValue(0L);
        if (id != null) {
            return elements;
        }
        throw new NoSuchElementException("Cannot find element(s) with " + by);
    }

    public String getPageSource() {
        return this.debugger.executeJavascript("return document.documentElement.outerHTML || (typeof window.XMLSerializer != 'undefined') ? (new window.XMLSerializer()).serializeToString(document) : ''");
    }

    public String getTitle() {
        return this.debugger.executeJavascript("return top.document.title ? top.document.title : '';");
    }

    public String getWindowHandle() {
        return this.debugger.executeJavascript("return top.window.name ? top.window.name : top.document.title;");
    }

    public Set<String> getWindowHandles() {
        List<Integer> windowIds = this.windowManager.getWindowHandles();
        TreeSet<String> handles = new TreeSet<String>();
        if (OperaIntervals.ENABLE_DEBUGGER.getValue() != 1L) {
            for (Integer windowId : windowIds) {
                handles.add(windowId.toString());
            }
            return handles;
        }
        this.windowManager.clearFilter();
        for (Integer windowId : windowIds) {
            String handleName = this.debugger.executeJavascript("return top.window.name ? top.window.name : (top.document.title ? top.document.title : 'undefined');", windowId);
            handles.add(handleName);
        }
        this.windowManager.filterActiveWindow();
        this.debugger.resetRuntimesList();
        return handles;
    }

    public int getWindowCount() {
        return this.windowManager.getWindowHandles().size();
    }

    public WebDriver.TargetLocator switchTo() {
        return new OperaTargetLocator();
    }

    public List<String> listFrames() {
        return this.debugger.listFramePaths();
    }

    protected String escapeJsString(String string) {
        return this.escapeJsString(string, "\"");
    }

    private String escapeJsString(String string, String quote) {
        Pattern escapePattern = Pattern.compile("([^\\\\])" + quote);
        Matcher m = escapePattern.matcher(" " + string);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "$1\\\\" + quote);
        }
        m.appendTail(sb);
        return sb.substring(1);
    }

    private WebElement findActiveElement() {
        return this.findSingleElement("document.activeElement;", "active element");
    }

    protected List<WebElement> processElements(Integer id) {
        List<Integer> ids = this.debugger.examineObjects(id);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        for (Integer objectId : ids) {
            toReturn.add((WebElement)new OperaWebElement(this, objectId));
        }
        return toReturn;
    }

    public void waitForLoadToComplete() {
        if (this.useOperaIdle()) {
            this.services.waitForOperaIdle(OperaIntervals.PAGE_LOAD_TIMEOUT.getValue());
        } else {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            long endTime = System.currentTimeMillis() + OperaIntervals.PAGE_LOAD_TIMEOUT.getValue();
            while (!"complete".equals(this.debugger.executeJavascript("return document.readyState"))) {
                if (System.currentTimeMillis() < endTime) {
                    OperaDriver.sleep(OperaIntervals.POLL_INVERVAL.getValue());
                    continue;
                }
                throw new WebDriverException("Timeout while loading page");
            }
        }
    }

    public WebElement findElementByName(String using) {
        return this.findSingleElement("document.getElementsByName('" + this.escapeJsString(using, "'") + "')[0];", "name");
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findMultipleElements("document.getElementsByName('" + this.escapeJsString(using, "'") + "');", "name");
    }

    public WebDriver.Navigation navigate() {
        return new OperaNavigation();
    }

    public WebDriver.Options manage() {
        return new OperaOptions();
    }

    public void operaAction(String using, String ... params) {
        this.exec.action(using, params);
    }

    private Set<String> getOperaActionList() {
        return this.exec.getActionList();
    }

    private static void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private List<WebElement> findMultipleElements(String script, String type) {
        Integer id;
        List<WebElement> elements;
        long start = System.currentTimeMillis();
        int count = 0;
        while (true) {
            if ((elements = this.processElements(id = this.debugger.getObject(script))) != null) {
                count = elements.size();
            }
            if (count != 0 || !this.hasTimeRemaining(start)) break;
            OperaDriver.sleep(OperaIntervals.EXEC_SLEEP.getValue());
        }
        OperaIntervals.WAIT_FOR_ELEMENT.setValue(0L);
        if (id != null) {
            return elements;
        }
        throw new NoSuchElementException("Cannot find element(s) with " + type);
    }

    private WebElement findSingleElement(String script, String type) {
        Integer id;
        boolean isAvailable;
        long start = System.currentTimeMillis();
        do {
            boolean bl = isAvailable = (id = this.debugger.getObject(script)) != null;
            if (isAvailable) continue;
            OperaDriver.sleep(OperaIntervals.EXEC_SLEEP.getValue());
        } while (!isAvailable && this.hasTimeRemaining(start));
        OperaIntervals.WAIT_FOR_ELEMENT.setValue(0L);
        if (isAvailable) {
            Boolean isStale = Boolean.valueOf(this.debugger.callFunctionOnObject("locator.parentNode == undefined", id));
            if (isStale.booleanValue()) {
                throw new StaleElementReferenceException("This element is no longer part of DOM");
            }
            return new OperaWebElement(this, id);
        }
        throw new NoSuchElementException("Cannot find element(s) with " + type);
    }

    boolean hasTimeRemaining(long start) {
        return System.currentTimeMillis() - start < OperaIntervals.WAIT_FOR_ELEMENT.getValue();
    }

    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) {
        return this.operaRunner.saveScreenshot(timeout, hashes);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        OperaWebElement body = (OperaWebElement)this.findElementByTagName("body");
        return (X)target.convertFromPngBytes(body.saveScreenshot(0L, new String[0]).getPng());
    }

    public boolean isOperaIdleAvailable() {
        return this.services.isOperaIdleAvailable();
    }

    private boolean useOperaIdle() {
        return (Boolean)this.capabilities.getCapability(OPERAIDLE) != false && this.isOperaIdleAvailable();
    }

    public void setUseOperaIdle(boolean useIdle) {
        this.capabilities.setCapability(OPERAIDLE, true);
    }

    public Object executeScript(String script, Object ... args) {
        Object object = this.debugger.scriptExecutor(script, args);
        if (object instanceof ScriptResult) {
            ScriptResult result = (ScriptResult)object;
            Integer objectId = result.getObjectId();
            if (objectId == null) {
                return null;
            }
            if (result.getClassName().endsWith("Element")) {
                return new OperaWebElement(this, objectId);
            }
            if (result.getClassName().equals("NodeList")) {
                return this.processElements(objectId);
            }
            if (result.getClassName().equals("Array") || result.getClassName().equals("Object")) {
                return this.debugger.examineScriptResult(objectId);
            }
        }
        return object;
    }

    public boolean isJavascriptEnabled() {
        return OperaIntervals.ENABLE_DEBUGGER.getValue() == 1L;
    }

    @Deprecated
    public void executeActions(OperaAction action) {
        this.services.captureOperaIdle();
        List<UserInteraction> actions = action.getActions();
        for (UserInteraction userInteraction : actions) {
            userInteraction.execute((WebDriver)this);
        }
        this.waitForLoadToComplete();
    }

    public void key(String key) {
        if (key.equalsIgnoreCase("enter")) {
            this.services.captureOperaIdle();
        }
        this.keyDown(key);
        this.keyUp(key);
        if (key.equalsIgnoreCase("enter")) {
            this.waitForLoadToComplete();
        }
    }

    public void keyDown(String key) {
        this.exec.key(key, false);
    }

    public void keyUp(String key) {
        this.exec.key(key, true);
    }

    public void releaseKeys() {
        this.exec.releaseKeys();
    }

    public void type(String using) {
        this.exec.type(using);
    }

    public String getVersion() {
        if (this.version == null) {
            URL res = OperaDriver.class.getClassLoader().getResource("VERSION");
            try {
                InputStream stream = res.openStream();
                this.version = IOUtils.toString((InputStream)stream);
                stream.close();
            }
            catch (Exception e) {
                this.version = "(Unknown)";
            }
        }
        return this.version;
    }

    protected IEcmaScriptDebugger getScriptDebugger() {
        return this.debugger;
    }

    protected IOperaExec getExecService() {
        return this.exec;
    }

    protected IWindowManager getWindowManager() {
        return this.windowManager;
    }

    protected ScopeServices getScopeServices() {
        return this.services;
    }

    public String getPref(String section, String key) {
        return this.services.getPrefs().getPref(section, key, PrefsProtos.GetPrefArg.Mode.CURRENT);
    }

    public String getDefaultPref(String section, String key) {
        return this.services.getPrefs().getPref(section, key, PrefsProtos.GetPrefArg.Mode.DEFAULT);
    }

    public Map<String, PrefsProtos.Pref> listPrefs(boolean sort, String section) {
        HashMap<String, PrefsProtos.Pref> map = new HashMap<String, PrefsProtos.Pref>();
        for (PrefsProtos.Pref p : this.prefs.listPrefs(sort, section)) {
            map.put(p.getKey(), p);
        }
        return map;
    }

    public Map<String, Map<String, PrefsProtos.Pref>> listAllPrefs() {
        List<PrefsProtos.Pref> allPrefs = this.prefs.listPrefs(true, null);
        HashMap<String, Map<String, PrefsProtos.Pref>> result = new HashMap<String, Map<String, PrefsProtos.Pref>>();
        for (PrefsProtos.Pref pref : allPrefs) {
            String section = pref.getSection();
            String key = pref.getKey();
            if (!result.containsKey(section)) {
                result.put(section, new HashMap());
            }
            result.get(section).put(key, pref);
        }
        return result;
    }

    public void setPref(String section, String key, String value) {
        this.services.getPrefs().setPrefs(section, key, value);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        throw new UnsupportedOperationException();
    }

    public Keyboard getKeyboard() {
        return new OperaKeyboard(this);
    }

    public Mouse getMouse() {
        return new OperaMouse(this);
    }

    public String selftest(List<String> modules, long timeout) {
        return this.services.selftest(modules, timeout);
    }

    public Utils utils() {
        return new OperaUtils();
    }

    @Deprecated
    public OperaRunner getOperaRunner() {
        return this.operaRunner;
    }

    public class OperaUtils
    implements Utils {
        public String getCoreVersion() {
            return OperaDriver.this.coreUtils.getCoreVersion();
        }

        public String getOS() {
            return OperaDriver.this.coreUtils.getOperatingSystem();
        }

        public String getProduct() {
            return OperaDriver.this.coreUtils.getProduct();
        }

        public String getBinaryPath() {
            return OperaDriver.this.coreUtils.getBinaryPath();
        }

        public String getUserAgent() {
            return OperaDriver.this.coreUtils.getUserAgent();
        }

        public int getPID() {
            return OperaDriver.this.coreUtils.getProcessID();
        }
    }

    private class OperaTimeouts
    implements WebDriver.Timeouts {
        private OperaTimeouts() {
        }

        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            OperaIntervals.WAIT_FOR_ELEMENT.setValue(TimeUnit.MILLISECONDS.convert(time, unit));
            return this;
        }

        public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
            OperaIntervals.SCRIPT_TIMEOUT.setValue(TimeUnit.MILLISECONDS.convert(time, unit));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OperaOptions
    implements WebDriver.Options {
        private OperaOptions() {
        }

        public void addCookie(Cookie cookie) {
            if (cookie.getExpiry() == null) {
                cookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), new Date(new Date().getTime() + 1827387392L), false);
            }
            OperaDriver.this.debugger.executeJavascript("document.cookie='" + cookie.toString() + "'", false);
        }

        public void deleteCookieNamed(String name) {
            Cookie cookie = this.getCookieNamed(name);
            this.deleteCookie(cookie);
        }

        public void deleteCookie(Cookie cookie) {
            if (OperaDriver.this.cookieManager == null) {
                throw new UnsupportedOperationException("Deleting cookies are not supported without the cookie-manager service");
            }
            OperaDriver.this.cookieManager.removeCookie(cookie.getDomain(), cookie.getPath(), cookie.getName());
            OperaDriver.this.gc();
        }

        public void deleteAllCookies() {
            if (OperaDriver.this.cookieManager == null) {
                throw new UnsupportedOperationException("Deleting cookies are not supported without the cookie-manager service");
            }
            OperaDriver.this.cookieManager.removeAllCookies();
        }

        public Set<Cookie> getCookies() {
            if (OperaDriver.this.cookieManager == null) {
                throw new UnsupportedOperationException("Setting cookies are not supported without the cookie-manager service");
            }
            return OperaDriver.this.cookieManager.getCookie(OperaDriver.this.debugger.executeJavascript("window.location.hostname"), null);
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            return null;
        }

        public WebDriver.Timeouts timeouts() {
            return new OperaTimeouts();
        }

        public WebDriver.ImeHandler ime() {
            return null;
        }
    }

    private class OperaNavigation
    implements WebDriver.Navigation {
        private OperaNavigation() {
        }

        public void back() {
            OperaDriver.this.services.captureOperaIdle();
            OperaDriver.this.exec.action("Back", new String[0]);
            OperaDriver.this.waitForLoadToComplete();
        }

        public void forward() {
            OperaDriver.this.services.captureOperaIdle();
            OperaDriver.this.exec.action("Forward", new String[0]);
            OperaDriver.this.waitForLoadToComplete();
        }

        public void to(String url) {
            OperaDriver.this.get(url);
        }

        public void to(URL url) {
            OperaDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            OperaDriver.this.services.captureOperaIdle();
            OperaDriver.this.exec.action("Reload", new String[0]);
            OperaDriver.this.waitForLoadToComplete();
        }
    }

    private class OperaTargetLocator
    implements WebDriver.TargetLocator {
        private OperaTargetLocator() {
        }

        public WebElement activeElement() {
            return OperaDriver.this.findActiveElement();
        }

        public WebDriver defaultContent() {
            OperaDriver.this.windowManager.filterActiveWindow();
            OperaDriver.this.debugger.resetFramePath();
            return OperaDriver.this;
        }

        public WebDriver frame(int frameIndex) {
            OperaDriver.this.debugger.resetFramePath();
            int framesLength = Integer.valueOf(OperaDriver.this.debugger.executeJavascript("return document.frames.length"));
            if (frameIndex < 0 || frameIndex >= framesLength) {
                throw new NoSuchFrameException("Invalid frame index: " + frameIndex);
            }
            OperaDriver.this.debugger.changeRuntime(frameIndex);
            return OperaDriver.this;
        }

        public WebDriver frame(String frameName) {
            OperaDriver.this.debugger.changeRuntime(frameName);
            return OperaDriver.this;
        }

        public WebDriver window(String windowName) {
            OperaDriver.this.windowManager.clearFilter();
            List<Integer> windowIds = OperaDriver.this.windowManager.getWindowHandles();
            Integer id = 0;
            for (Integer windowId : windowIds) {
                String name = OperaDriver.this.debugger.executeJavascript("return top.window.name ? top.window.name : top.document.title;", windowId);
                if (!name.equals(windowName)) continue;
                id = windowId;
                break;
            }
            if (id == 0) {
                throw new NoSuchWindowException("Window with name " + windowName + " not found");
            }
            OperaDriver.this.windowManager.setActiveWindowId(id);
            OperaDriver.this.windowManager.filterActiveWindow();
            OperaDriver.this.debugger.resetRuntimesList();
            this.defaultContent();
            OperaDriver.this.debugger.executeJavascript("window.focus()", false);
            return OperaDriver.this;
        }

        public WebDriver frame(WebElement frameElement) {
            throw new UnsupportedOperationException();
        }

        public Alert alert() {
            throw new UnsupportedOperationException();
        }
    }
}

