/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.CommandLine;

public class OperaPaths {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public String operaPath() {
        String path = System.getenv("OPERA_PATH");
        if (this.isPathValid(path)) {
            return path;
        }
        Platform platform = Platform.getCurrent();
        switch (platform) {
            case LINUX: 
            case UNIX: {
                path = "/usr/bin/opera";
                if (this.isPathValid(path)) break;
                CommandLine line = new CommandLine("which", new String[]{"opera"});
                line.execute();
                path = line.getStdOut().trim();
                break;
            }
            case MAC: {
                path = "/Applications/Opera.app/Contents/MacOS/Opera";
                break;
            }
            case WINDOWS: 
            case XP: 
            case VISTA: {
                String progfiles;
                String x86 = System.getenv("ProgramFiles(x86)");
                String string = progfiles = x86 == null ? System.getenv("PROGRAMFILES") : x86;
                if (progfiles == null) {
                    progfiles = "\\Program Files";
                }
                path = progfiles + "\\Opera\\opera.exe";
                break;
            }
            default: {
                throw new WebDriverException("Auto find is not support on this platform");
            }
        }
        return this.isPathValid(path) ? path : null;
    }

    public String launcherPath() {
        String path = System.getenv("OPERA_LAUNCHER");
        if (!this.isPathValid(path)) {
            path = this.extractLauncher(FileUtils.getUserDirectoryPath() + File.separatorChar + ".launcher");
        }
        return path;
    }

    private String extractLauncher(String executablePath) {
        String launcherName = this.getLauncherNameForOS();
        URL res = OperaDriver.class.getClassLoader().getResource("launcher/" + launcherName);
        if (res != null) {
            String url = res.toExternalForm();
            if (url.startsWith("jar:") || url.startsWith("wsjar:")) {
                executablePath = executablePath + File.separatorChar + launcherName;
                File launcher = new File(executablePath);
                boolean copy = false;
                if (!launcher.exists()) {
                    copy = true;
                } else {
                    try {
                        copy = !Arrays.equals(OperaPaths.md5(executablePath), OperaPaths.md5(res.openStream()));
                    }
                    catch (Exception e) {
                        copy = true;
                    }
                }
                if (copy) {
                    try {
                        if (!launcher.exists()) {
                            FileUtils.touch((File)launcher);
                        }
                        InputStream is = res.openStream();
                        FileOutputStream os = new FileOutputStream(launcher);
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        is.close();
                        ((OutputStream)os).close();
                        launcher.setLastModified(launcher.lastModified());
                    }
                    catch (IOException e) {
                        throw new WebDriverException("Cant write file to disk : " + e.getMessage());
                    }
                    this.logger.fine("New launcher copied to " + executablePath);
                }
            } else if (url.startsWith("file:")) {
                File f;
                try {
                    f = new File(res.toURI());
                }
                catch (URISyntaxException e) {
                    f = new File(res.getPath());
                }
                executablePath = f.getAbsolutePath();
            }
        }
        if (executablePath != null) {
            this.makeLauncherExecutable(executablePath);
        }
        return executablePath;
    }

    private void makeLauncherExecutable(String executablePath) {
        Platform current = Platform.getCurrent();
        if (current.is(Platform.LINUX) || current.is(Platform.MAC)) {
            CommandLine line = new CommandLine("chmod", new String[]{"755", executablePath});
            line.execute();
        }
    }

    private String getLauncherNameForOS() {
        boolean is64 = "64".equals(System.getProperty("sun.arch.data.model"));
        Platform currentPlatform = Platform.getCurrent();
        switch (currentPlatform) {
            case LINUX: 
            case UNIX: {
                return is64 ? "launcher-linux-x86_64" : "launcher-linux-i686";
            }
            case MAC: {
                return "launcher-mac";
            }
            case WINDOWS: 
            case XP: 
            case VISTA: {
                return "launcher-win32-i86pc.exe";
            }
        }
        throw new WebDriverException("Could not find a platform that supports bundled launchers, please set it manually");
    }

    private boolean isPathValid(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    private static byte[] md5(InputStream fis) throws Exception {
        int numRead;
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        return complete.digest();
    }

    private static byte[] md5(String filename) throws Exception {
        return OperaPaths.md5(new FileInputStream(filename));
    }
}

