/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaAtoms;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.model.Canvas;
import com.opera.core.systems.model.ColorResult;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.scope.internal.OperaColors;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.internal.OperaKeys;
import com.opera.core.systems.scope.internal.OperaMouseKeys;
import com.opera.core.systems.scope.services.IEcmaScriptDebugger;
import com.opera.core.systems.scope.services.IOperaExec;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.remote.RemoteWebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperaWebElement
extends RemoteWebElement {
    private final int objectId;
    private final IEcmaScriptDebugger debugger;
    private final OperaDriver parent;
    private final int runtimeId;
    private final IOperaExec execService;
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final HashMap<Character, String> keysLookup = new HashMap();
    private Coordinates coordinates = new Coordinates(){

        public Point getLocationOnScreen() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Point getLocationInViewPort() {
            String coordinates = OperaWebElement.this.debugger.callFunctionOnObject("locator.scrollIntoView();\nvar x = 0, y = 0;\nif(window.frameElement) {\nx = (window.screenLeft - window.top.screenLeft) + window.scrollX;\ny = (window.screenTop - window.top.screenTop) + window.scrollY;\n}\nreturn (( x + locator.getBoundingClientRect().left) + ',' + ( y + locator.getBoundingClientRect().top));\n", OperaWebElement.this.objectId);
            String[] location = coordinates.split(",");
            return new Point(Integer.valueOf(location[0]).intValue(), Integer.valueOf(location[1]).intValue());
        }

        public Point getLocationInDOM() {
            return OperaWebElement.this.getLocation();
        }

        public Object getAuxiliry() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };

    public int getObjectId() {
        return this.objectId;
    }

    public int getRuntimeId() {
        return this.runtimeId;
    }

    public OperaWebElement(OperaDriver parent, int objectId) {
        this.parent = parent;
        this.objectId = objectId;
        parent.objectIds.add(objectId);
        this.debugger = parent.getScriptDebugger();
        this.execService = parent.getExecService();
        this.runtimeId = this.debugger.getRuntimeId();
    }

    public final String callMethod(String using) {
        return this.debugger.callFunctionOnObject(using, this.objectId);
    }

    private final void executeMethod(String using) {
        this.debugger.callFunctionOnObject(using, this.objectId, false);
    }

    private final Object evaluateMethod(String using) {
        return this.debugger.callFunctionOnObject(using, this.objectId, true);
    }

    public void rightClick() {
        this.parent.actionHandler.rightClick((WebElement)this);
    }

    @Deprecated
    public void hover() {
        this.mouseOver();
    }

    public void mouseOver() {
        Point point = this.coordinates.getLocationInViewPort();
        this.execService.mouseAction(point.x, point.y, new OperaMouseKeys[0]);
    }

    public void mouseOut() {
        Point point = this.coordinates.getLocationInViewPort();
        this.execService.mouseAction(point.x, point.y, new OperaMouseKeys[0]);
        this.execService.mouseAction(0, 0, new OperaMouseKeys[0]);
    }

    public void mouseDown() {
        Point point = this.coordinates.getLocationInViewPort();
        this.execService.mouseAction(point.x, point.y, OperaMouseKeys.LEFT_DOWN);
    }

    public void mouseUp() {
        Point point = this.coordinates.getLocationInViewPort();
        this.execService.mouseAction(point.x, point.y, OperaMouseKeys.LEFT_DOWN);
    }

    public void click(int times) {
        Point point = this.coordinates.getLocationInViewPort();
        this.execService.mouseAction(point.x, point.y, times, OperaMouseKeys.LEFT);
    }

    public void middleClick() {
        Point point = this.coordinates.getLocationInViewPort();
        this.execService.mouseAction(point.x, point.y, OperaMouseKeys.MIDDLE);
    }

    public void click() {
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("You can't click an element that is not displayed");
        }
        this.parent.getScopeServices().captureOperaIdle();
        Integer id = this.debugger.executeScriptOnObject("return locator.parentNode", this.objectId);
        OperaWebElement parentNode = new OperaWebElement(this.parent, id);
        String multiple = parentNode.getAttribute("multiple");
        if (parentNode.getTagName().equalsIgnoreCase("SELECT") && multiple != null && !multiple.equals("false")) {
            this.toggle();
        } else if (this.getTagName().equals("OPTION")) {
            this.setSelected();
        } else {
            this.parent.actionHandler.click((WebElement)this, "");
        }
        this.parent.waitForLoadToComplete();
    }

    public void click(int x, int y) {
        this.parent.getScopeServices().captureOperaIdle();
        this.parent.actionHandler.click((WebElement)this, x, y);
        this.parent.waitForLoadToComplete();
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public String getAttribute(String attribute) {
        this.throwIfStale();
        if (attribute.toLowerCase().equals("value")) {
            return this.callMethod("if(/^input|select|textarea$/i.test(locator.nodeName)){return locator.value;}return locator.textContent;");
        }
        return this.callMethod("return " + OperaAtoms.GET_ATTRIBUTE.getValue() + "(locator, '" + attribute + "')");
    }

    public String getElementName() {
        return this.callMethod("locator.nodeName");
    }

    public String getText() {
        return this.callMethod("return " + OperaAtoms.GET_TEXT.getValue() + "(locator)");
    }

    @Deprecated
    public String getValue() {
        return this.callMethod("if(/^input|select|textarea$/i.test(locator.nodeName)){return locator.value;}return locator.textContent;");
    }

    public boolean isDisplayed() {
        this.throwIfStale();
        return (Boolean)this.evaluateMethod("return " + OperaAtoms.IS_DISPLAYED.getValue() + "(locator)");
    }

    public boolean isEnabled() {
        this.throwIfStale();
        return (Boolean)this.evaluateMethod("return " + OperaAtoms.IS_ENABLED.getValue() + "(locator)");
    }

    public boolean isSelected() {
        this.throwIfStale();
        return (Boolean)this.evaluateMethod("return " + OperaAtoms.IS_SELECTED.getValue() + "(locator)");
    }

    @Deprecated
    public boolean isVisible() {
        return this.isDisplayed();
    }

    public void clear() {
        if (this.isEnabled() && !Boolean.valueOf(this.getAttribute("readonly")).booleanValue()) {
            this.executeMethod("return " + OperaAtoms.CLEAR.getValue() + "(locator)");
        }
    }

    public void sendKeys(CharSequence ... keysToSend) {
        ArrayList<String> holdKeys = new ArrayList<String>();
        holdKeys.add(OperaKeys.SHIFT.getValue());
        holdKeys.add(OperaKeys.CONTROL.getValue());
        ArrayList<String> heldKeys = new ArrayList<String>();
        long start = System.currentTimeMillis();
        boolean isDisplayed = false;
        while (!(isDisplayed = this.isDisplayed()) && this.parent.hasTimeRemaining(start)) {
            OperaWebElement.sleep(OperaIntervals.EXEC_SLEEP.getValue());
        }
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("You can't type on an element that is not displayed");
        }
        if (!this.isEnabled()) {
            throw new InvalidElementStateException("You can't type on an element that is disabled");
        }
        if (this.getTagName().equalsIgnoreCase("input") && this.hasAttribute("type") && this.getAttribute("type").equals("file")) {
            this.click();
        } else {
            this.executeMethod("locator.focus()");
            if (this.getTagName().equalsIgnoreCase("input")) {
                this.executeMethod("function(elem) {  var doc = elem.ownerDocument || elem;  var prevActiveElem = doc.activeElement;  if (elem != prevActiveElem && prevActiveElem)    prevActiveElem.blur();  elem.focus();  if (elem != prevActiveElem && elem.value && elem.value.length &&      elem.setSelectionRange) {    elem.setSelectionRange(elem.value.length, elem.value.length);  }  if (elem != doc.activeElement)    throw new Error('Failed to send keys because cannot focus element');}(locator)");
            }
        }
        this.parent.getScopeServices().captureOperaIdle();
        for (CharSequence seq : keysToSend) {
            if (seq instanceof Keys) {
                String key = OperaKeys.get(((Keys)seq).name());
                if (holdKeys.contains(key) && !heldKeys.contains(key) && !this.execService.keyIsPressed(key)) {
                    this.execService.key(key, false);
                    heldKeys.add(key);
                    continue;
                }
                if (key == "null") {
                    for (String hkey : heldKeys) {
                        this.execService.key(hkey, true);
                    }
                    continue;
                }
                this.execService.key(key);
                continue;
            }
            if (((Object)seq).toString().equals("\n")) {
                this.execService.key("enter");
                continue;
            }
            for (int i = 0; i < seq.length(); ++i) {
                Character c = Character.valueOf(seq.charAt(i));
                String keyName = OperaWebElement.charToKeyName(c.charValue());
                if (keyName == null) {
                    this.execService.type(c.toString());
                    continue;
                }
                String key = OperaKeys.get(keyName);
                if (holdKeys.contains(key) && !heldKeys.contains(key) && !this.execService.keyIsPressed(key)) {
                    this.execService.key(key, false);
                    heldKeys.add(key);
                    continue;
                }
                if (key == "null") {
                    for (String hkey : heldKeys) {
                        this.execService.key(hkey, true);
                    }
                    continue;
                }
                this.execService.key(key);
            }
        }
        if (heldKeys.size() > 0) {
            for (String key : heldKeys) {
                this.execService.key(key, true);
            }
        }
        this.parent.waitForLoadToComplete();
    }

    private static String charToKeyName(char c) {
        if (keysLookup.isEmpty()) {
            for (Keys k : Keys.values()) {
                keysLookup.put(Character.valueOf(k.charAt(0)), k.name());
            }
        }
        return keysLookup.get(Character.valueOf(c));
    }

    private boolean hasAttribute(String attr) {
        return this.getAttribute(attr) != null;
    }

    @Deprecated
    public void setSelected() {
        String tagName = this.getTagName();
        if (!this.isEnabled()) {
            throw new InvalidElementStateException("Cannot select disabled element");
        }
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("Cannot select an element that is not displayed");
        }
        if (!tagName.equals("INPUT") && !tagName.equals("OPTION")) {
            throw new InvalidElementStateException("Cannot select a " + tagName + " element");
        }
        this.evaluateMethod("return " + OperaAtoms.SET_SELECTED.getValue() + "(locator, true)");
    }

    public void submit() {
        this.parent.getScopeServices().captureOperaIdle();
        this.evaluateMethod("return " + OperaAtoms.SUBMIT.getValue() + "(locator)");
        this.parent.waitForLoadToComplete();
    }

    @Deprecated
    public boolean toggle() {
        String tagName = this.getTagName();
        if (!tagName.equals("INPUT") && !tagName.equals("OPTION")) {
            throw new InvalidElementStateException("Cannot toggle a " + tagName + " element");
        }
        if (tagName.equalsIgnoreCase("input") && this.getAttribute("type").equalsIgnoreCase("radio")) {
            throw new InvalidElementStateException("You can't toggle an radio element");
        }
        Integer id = this.debugger.executeScriptOnObject("return locator.parentNode", this.objectId);
        OperaWebElement parentNode = new OperaWebElement(this.parent, id);
        if (parentNode.getTagName().equalsIgnoreCase("SELECT") && parentNode.getAttribute("multiple") == null) {
            throw new InvalidElementStateException("You can't toggle on a regular select");
        }
        if (!this.isEnabled()) {
            throw new InvalidElementStateException("Cannot toggle disabled element");
        }
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("Cannot select an element that is not displayed");
        }
        return (Boolean)this.debugger.callFunctionOnObject("return " + OperaAtoms.TOGGLE.getValue() + "(locator)", this.objectId, true);
    }

    public static void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Deprecated
    public void dragAndDropBy(int x, int y) {
        Point point = this.getLocation();
        this.execService.mouseAction(point.x, point.y, OperaMouseKeys.LEFT_DOWN);
        x = x + point.x < 0 ? 0 : x + point.x;
        y = y + point.y < 0 ? 0 : y + point.y;
        this.execService.mouseAction(x, y, new OperaMouseKeys[0]);
        this.execService.mouseAction(x, y, OperaMouseKeys.LEFT_UP);
    }

    @Deprecated
    public void dragAndDropOn(WebElement element) {
        Point currentLocation = this.getLocation();
        Point dragPoint = element.getLocation();
        this.execService.mouseAction(currentLocation.x, currentLocation.y, OperaMouseKeys.LEFT_DOWN);
        this.execService.mouseAction(dragPoint.x, dragPoint.y, new OperaMouseKeys[0]);
        this.execService.mouseAction(dragPoint.x, dragPoint.y, OperaMouseKeys.LEFT_UP);
    }

    public Point getLocation() {
        String coordinates = this.debugger.callFunctionOnObject("var coords = " + OperaAtoms.GET_LOCATION.getValue() + "(locator); return coords.x + ',' + coords.y;", this.objectId);
        if (coordinates.isEmpty()) {
            this.logger.warning("Falling back to non-atom positioning code in getLocation");
            coordinates = this.debugger.callFunctionOnObject("var coords = locator.getBoundingClientRect();return (coords.left-window.pageXOffset)+','+(coords.top-window.pageYOffset)", this.objectId);
        }
        String[] location = coordinates.split(",");
        return new Point(Integer.valueOf(location[0]).intValue(), Integer.valueOf(location[1]).intValue());
    }

    public Dimension getSize() {
        if (!this.parent.objectIds.contains(this.objectId)) {
            throw new StaleElementReferenceException("You cant interact with stale elements");
        }
        String widthAndHeight = this.debugger.callFunctionOnObject("var s=" + OperaAtoms.GET_SIZE.getValue() + "(locator);return s.width+','+s.height;", this.objectId);
        String[] dimension = widthAndHeight.split(",");
        return new Dimension(Integer.valueOf(dimension[0]).intValue(), Integer.valueOf(dimension[1]).intValue());
    }

    public String getImageHash() {
        return this.getImageHash(10L, new String[0]);
    }

    public String getImageHash(long timeout, String ... hashes) {
        return this.saveScreenshot("", timeout, false, hashes);
    }

    public String saveScreenshot(String filename) {
        return this.saveScreenshot(filename, 10L, true, new String[0]);
    }

    public String saveScreenshot(String filename, long timeout) {
        return this.saveScreenshot(filename, timeout, true, new String[0]);
    }

    public String saveScreenshot(String filename, long timeout, boolean includeImage, String ... hashes) {
        Canvas canvas = this.buildCanvas();
        ScreenShotReply reply = this.execService.screenWatcher(canvas, timeout, includeImage, hashes);
        if (includeImage && reply.getPng() != null) {
            try {
                FileOutputStream stream = new FileOutputStream(filename);
                stream.write(reply.getPng());
                stream.close();
            }
            catch (Exception e) {
                throw new WebDriverException("Failed to write file: " + e.getMessage());
            }
        }
        return reply.getMd5();
    }

    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) {
        Canvas canvas = this.buildCanvas();
        return this.execService.screenWatcher(canvas, timeout, true, hashes);
    }

    public boolean containsColor(OperaColors ... colors) {
        Canvas canvas = this.buildCanvas();
        ScreenShotReply reply = this.execService.containsColor(canvas, 100L, colors);
        List<ColorResult> results = reply.getColorResult();
        for (ColorResult result : results) {
            if (result.getCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private Canvas buildCanvas() {
        Canvas canvas = new Canvas();
        Dimension dimension = this.getSize();
        Point point = this.coordinates.getLocationInViewPort();
        int x = point.x;
        int y = point.y;
        int w = Math.max(dimension.width, 1);
        int h = Math.max(dimension.height, 1);
        canvas.setX(x);
        canvas.setY(y);
        canvas.setHeight(h);
        canvas.setWidth(w);
        canvas.setViewPortRelative(true);
        return canvas;
    }

    public String getTagName() {
        return this.callMethod("return (locator.tagName);");
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        if (this.isDisplayed()) {
            return this.getLocation();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OperaWebElement) {
            OperaWebElement ref = (OperaWebElement)((Object)obj);
            return ref.getObjectId() == this.getObjectId() && ref.getRuntimeId() == this.getRuntimeId();
        }
        return false;
    }

    public int hashCode() {
        int result = 42;
        result = 31 * result + this.objectId;
        result = 31 * result + this.runtimeId;
        return result;
    }

    public String toString() {
        return "element" + this.hashCode();
    }

    private WebElement findSingleElement(String using, String type) {
        Integer id = this.debugger.executeScriptOnObject(using, this.objectId);
        if (id != null) {
            return new OperaWebElement(this.parent, id);
        }
        throw new NoSuchElementException("Cannot find element with " + type);
    }

    protected WebElement findElement(String by, String using) {
        return this.parent.findElement(by, using, this);
    }

    protected List<WebElement> findElements(String by, String using) {
        return this.parent.findElements(by, using, this);
    }

    private final List<WebElement> findMultipleElements(String using, String type) {
        Integer id = this.debugger.executeScriptOnObject(using, this.objectId);
        if (id == null) {
            throw new NoSuchElementException("Cannot find element(s) with " + type);
        }
        List<WebElement> elements = this.parent.processElements(id);
        return elements;
    }

    public WebElement findElementByName(String using) {
        return this.findSingleElement("document.evaluate(\"descendant-or-self::*[@name='" + using + "']\",locator,null,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext()", "name");
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findMultipleElements("var result = document.evaluate(\"descendant-or-self::*[@name='" + using + "']\"" + ", locator, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE,  null);\n" + "var elements = new Array();\n" + "var element = result.iterateNext();\n" + "while (element) {\n" + "  elements.push(element);\n" + "  element = result.iterateNext();\n" + "}\n" + "return elements", "XPath");
    }

    protected void finalize() throws Throwable {
        this.debugger.releaseObject(this.objectId);
        super.finalize();
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public String getCssValue(String property) {
        return this.callMethod("return " + OperaAtoms.GET_EFFECTIVE_STYLE.getValue() + "(locator, '" + property + "')");
    }

    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    private void throwIfStale() {
        if (!this.parent.objectIds.contains(this.objectId) || Boolean.valueOf(this.debugger.callFunctionOnObject("locator.parentNode == undefined", this.objectId)).booleanValue()) {
            throw new StaleElementReferenceException("You cant interact with stale elements");
        }
    }
}

