/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.ProcessUtils;

public class OperaLauncherBinary
extends Thread {
    private Process process;
    private OutputWatcher watcher;
    private Thread outputWatcherThread;
    private List<String> commands = new ArrayList<String>();
    private static Logger logger = Logger.getLogger(OperaLauncherBinary.class.getName());
    private AtomicBoolean running = new AtomicBoolean(false);

    public OperaLauncherBinary(String location, String ... args) {
        super(new ThreadGroup("run-process"), "launcher");
        this.commands.add(location);
        if (args != null && args.length > 0) {
            this.commands.addAll(Arrays.asList(args));
        }
        this.init();
    }

    public String getCommand() {
        return this.commands.toString();
    }

    public void kill() {
        this.watcher.kill();
    }

    public void shutdown() {
        this.kill();
    }

    public void init() {
        ProcessBuilder builder = new ProcessBuilder(this.commands);
        try {
            builder.redirectErrorStream(true);
            this.process = builder.start();
            this.watcher = new OutputWatcher(this.process);
            this.outputWatcherThread = new Thread(this.getThreadGroup(), this.watcher, "output-watcher");
            this.running.set(true);
            this.outputWatcherThread.start();
        }
        catch (IOException e) {
            throw new WebDriverException("Could not start the launcher process: " + e.getMessage());
        }
    }

    public void run() {
        logger.fine("Waiting for launcher binary to exit");
        while (this.running.get()) {
            try {
                int exit = this.process.waitFor();
                logger.fine("Launcher exited with return value " + exit);
                this.running.set(false);
            }
            catch (InterruptedException e) {
                logger.warning("Got interrupted, will terminate launcher");
                this.process.destroy();
            }
        }
    }

    private class OutputWatcher
    implements Runnable {
        private Process process;

        public OutputWatcher(Process process) {
            this.process = process;
        }

        public void run() {
            logger.finer("Running launcher: " + OperaLauncherBinary.this.running.get());
            InputStream stream = this.process.getInputStream();
            String buffer = "";
            while (OperaLauncherBinary.this.running.get()) {
                try {
                    int r = stream.read();
                    if (r == -1) {
                        return;
                    }
                    if (r == 10) {
                        logger.finest("line break: " + buffer);
                        buffer = "";
                        continue;
                    }
                    buffer = buffer + (char)r;
                }
                catch (IOException iOException) {}
            }
        }

        public void kill() {
            OperaLauncherBinary.this.running.set(false);
            try {
                ProcessUtils.killProcess((Process)this.process);
            }
            catch (Exception e) {
                logger.warning("Could not kill the process: " + e.getMessage());
            }
        }
    }
}

