/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.handlers;

import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.model.Canvas;
import com.opera.core.systems.model.ScopeActions;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.scope.internal.OperaMouseKeys;
import com.opera.core.systems.scope.services.IWindowManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class PbActionHandler
extends ScopeActions {
    public PbActionHandler(ScopeServices services) {
        super(services);
    }

    public void click(WebElement element, String locator) {
        Point point = ((RemoteWebElement)element).getCoordinates().getLocationInViewPort();
        System.out.println(point);
        this.services.getExec().mouseAction(point.x + 1, point.y + 1, OperaMouseKeys.LEFT);
    }

    public void click(WebElement element, int x, int y) {
        Point point = ((RemoteWebElement)element).getCoordinates().getLocationInViewPort();
        this.services.getExec().mouseAction(point.x + x, point.y + y, OperaMouseKeys.LEFT);
    }

    public void get(String url) {
        IWindowManager wm = this.services.getWindowManager();
        wm.openUrl(wm.getActiveWindowId(), url);
    }

    public void rightClick(WebElement element) {
        Point point = ((RemoteWebElement)element).getCoordinates().getLocationInViewPort();
        this.services.getExec().mouseAction(point.x, point.y, OperaMouseKeys.RIGHT);
    }

    public void saveScreenshot(File pngFile) {
        if (pngFile == null) {
            throw new IllegalArgumentException("Method parameter pngFile must not be null");
        }
        File dir = pngFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new WebDriverException("Could not create directory " + dir.getAbsolutePath());
        }
        Canvas canvas = new Canvas();
        canvas.setX(0);
        canvas.setY(0);
        String[] dimensions = this.scriptDebugger.executeJavascript("return (window.innerWidth + \",\" + window.innerHeight);").split(",");
        canvas.setHeight(Integer.valueOf(dimensions[1]));
        canvas.setWidth(Integer.valueOf(dimensions[0]));
        canvas.setViewPortRelative(true);
        ScreenShotReply reply = this.services.getExec().screenWatcher(canvas, 1L, true, new String[0]);
        try {
            FileOutputStream stream = new FileOutputStream(pngFile.getAbsolutePath());
            stream.write(reply.getPng());
            stream.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

