/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.SelftestCommand;
import com.opera.core.systems.scope.protos.SelftestProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.ISelftest;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selftest
extends AbstractService
implements ISelftest {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static Pattern errorPattern = Pattern.compile("Warning: Pattern '([^']+)' did not match any tests\nWarning: There is no module named '([^']+)'\n");

    public Selftest(ScopeServices services, String version) {
        super(services, version);
        String serviceName = "selftest";
        if (!this.isVersionInRange(version, "2.0", serviceName)) {
            this.logger.info(serviceName + " version " + version + " is not supported");
        } else {
            services.setSelftest(this);
        }
    }

    @Override
    public void runSelftests(List<String> modules) {
        this.logger.fine(String.format("runSelftests(%s)", modules.toString()));
        SelftestProtos.RunModulesArg.Builder builder = SelftestProtos.RunModulesArg.newBuilder();
        builder.addAllModuleList(modules);
        builder.setOutputType(SelftestProtos.RunModulesArg.OutputType.MACHINE_READABLE);
        UmsProtos.Response response = this.executeCommand(SelftestCommand.RUN_MODULES, (AbstractMessage.Builder<?>)builder);
        this.logger.fine(String.format("Selftest response: %s", new Object[]{response}));
    }

    public static List<ISelftest.SelftestResult> parseSelftests(String output) {
        String[] lines;
        ArrayList<ISelftest.SelftestResult> results = new ArrayList<ISelftest.SelftestResult>();
        Matcher matcher = errorPattern.matcher(output);
        if (matcher.matches()) {
            return null;
        }
        for (String line : lines = output.split("\\n")) {
            ISelftest.ResultType result;
            String[] pieces = line.split("\\t");
            String tagAndDescription = pieces[0];
            String resultString = pieces[1];
            String more = pieces.length > 2 ? pieces[2] : null;
            String[] otherPieces = tagAndDescription.split(":", 2);
            String tag = otherPieces[0];
            String description = otherPieces[1];
            if (resultString.equals("PASS")) {
                result = ISelftest.ResultType.PASS;
            } else if (resultString.equals("FAIL")) {
                result = ISelftest.ResultType.FAIL;
            } else if (resultString.equals("SKIP")) {
                result = ISelftest.ResultType.SKIP;
            } else {
                throw new RuntimeException(String.format("Unknown test result %s", resultString));
            }
            results.add(new ISelftest.SelftestResult(tag, description, result, more));
        }
        return results;
    }
}

