/*
Copyright 2008-2011 Opera Software ASA

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.opera.core.systems.interaction;

import java.util.Arrays;
import java.util.List;

/**
 * OperaAction(s) are used to simulate continuous user events such as pressing a button and clicking
 * an element same time.
 *
 * @author Deniz Turkoglu <dturkoglu@opera.com>
 */
public class OperaAction {

  private List<UserInteraction> actions;

  public List<UserInteraction> getActions() {
    return actions;
  }

  public OperaAction(UserInteraction... userInteractions) {
    this.actions = Arrays.asList(userInteractions);
  }

}
