/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.launcher;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.opera.core.systems.OperaPaths;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.arguments.OperaCoreArguments;
import com.opera.core.systems.arguments.OperaDesktopArguments;
import com.opera.core.systems.runner.OperaLaunchers;
import com.opera.core.systems.runner.OperaRunnerException;
import com.opera.core.systems.runner.OperaRunnerSettings;
import com.opera.core.systems.runner.launcher.OperaLauncherRunner;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.CommandLine;

public class OperaLauncherRunnerSettings
extends OperaRunnerSettings {
    public static final Logger logger = Logger.getLogger(OperaLauncherRunnerSettings.class.getName());
    protected File launcher;

    public void setLoggingLevel(Level level) {
        this.loggingLevel = OperaLauncherRunner.toLauncherLoggingLevel(level);
    }

    public File getLauncher() {
        if (this.launcher == null) {
            this.launcher = new File(OperaLauncherRunnerSettings.launcherPath());
        }
        return this.launcher;
    }

    public void setLauncher(File launcher) {
        if (!(launcher.exists() && launcher.isFile() && launcher.canExecute())) {
            throw new OperaRunnerException("Invalid launcher: " + launcher);
        }
        this.launcher = launcher;
    }

    public static OperaLauncherRunnerSettings getDefaultSettings() {
        OperaLauncherRunnerSettings settings = new OperaLauncherRunnerSettings();
        OperaCoreArguments arguments = settings.getProduct().is(OperaProduct.DESKTOP) ? new OperaDesktopArguments() : new OperaCoreArguments();
        settings.setArguments(arguments);
        return settings;
    }

    private static String launcherPath() {
        String path = System.getenv("OPERA_LAUNCHER");
        if (!OperaPaths.isPathValid(path)) {
            if (path != null && !path.isEmpty()) {
                throw new OperaRunnerException("Path from OPERA_LAUNCHER does not exist: " + path);
            }
            try {
                String userHome = System.getProperty("user.home");
                path = OperaLauncherRunnerSettings.extractLauncher(new File(userHome + File.separator + ".launcher"));
            }
            catch (OperaRunnerException e) {
                throw new WebDriverException("Unable to extract bundled launcher: " + e.getMessage());
            }
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    private static String extractLauncher(File launcherPath) {
        block17: {
            block16: {
                launcherName = OperaLauncherRunnerSettings.getLauncherNameForOS();
                targetLauncher = new File(launcherPath.getAbsolutePath() + File.separatorChar + launcherName);
                sourceLauncher = OperaLaunchers.class.getClassLoader().getResource("launchers/" + launcherName);
                if (sourceLauncher == null) {
                    throw new OperaRunnerException("Unknown file: " + sourceLauncher);
                }
                if (targetLauncher.exists()) {
                    try {
                        v0 = copy = Arrays.equals(OperaLauncherRunnerSettings.md5(targetLauncher), OperaLauncherRunnerSettings.md5(sourceLauncher.openStream())) == false;
                        if (!copy) ** GOTO lbl18
                        OperaLauncherRunnerSettings.logger.fine("Old launcher detected, upgrading");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new OperaRunnerException("Algorithm is not available in your environment: " + e);
                    }
                    catch (IOException e) {
                        throw new OperaRunnerException("Unable to open stream or file: " + e);
                    }
                } else {
                    OperaLauncherRunnerSettings.logger.fine("No launcher found, copying");
                    copy = true;
                }
lbl18:
                // 3 sources

                if (!copy) break block17;
                is = null;
                os = null;
                try {
                    if (!targetLauncher.exists()) {
                        launcherPath.mkdirs();
                        Files.touch((File)targetLauncher);
                    }
                    is = sourceLauncher.openStream();
                    os = new FileOutputStream(targetLauncher);
                    ByteStreams.copy((InputStream)is, (OutputStream)os);
                    if (!targetLauncher.setLastModified(targetLauncher.lastModified())) {
                        throw new OperaRunnerException("Unable to set modification time for file: " + targetLauncher);
                    }
                    if (is == null) break block16;
                }
                catch (IOException e) {
                    try {
                        throw new WebDriverException("Cannot write file to disk: " + e.getMessage());
                    }
                    catch (Throwable var8_10) {
                        if (is != null) {
                            Closeables.closeQuietly((Closeable)is);
                        }
                        if (os != null) {
                            Closeables.closeQuietly(os);
                        }
                        throw var8_10;
                    }
                }
                Closeables.closeQuietly((Closeable)is);
            }
            if (os != null) {
                Closeables.closeQuietly((Closeable)os);
            }
            OperaLauncherRunnerSettings.logger.fine("New launcher copied to " + targetLauncher.getAbsolutePath());
        }
        if (copy) {
            OperaLauncherRunnerSettings.makeLauncherExecutable(targetLauncher);
        }
        return targetLauncher.getAbsolutePath();
    }

    public void makeLauncherExecutable() {
        OperaLauncherRunnerSettings.makeLauncherExecutable(this.getLauncher());
    }

    private static void makeLauncherExecutable(File launcher) {
        Platform current = Platform.getCurrent();
        if (current.is(Platform.UNIX) || current.is(Platform.MAC)) {
            CommandLine line = new CommandLine("chmod", new String[]{"u+x", launcher.getAbsolutePath()});
            line.execute();
        }
    }

    protected static String getLauncherNameForOS() {
        boolean is64 = "64".equals(System.getProperty("sun.arch.data.model"));
        Platform currentPlatform = Platform.getCurrent();
        switch (currentPlatform) {
            case LINUX: 
            case UNIX: {
                return is64 ? "launcher-linux-x86_64" : "launcher-linux-i686";
            }
            case MAC: {
                return "launcher-mac";
            }
            case WINDOWS: 
            case VISTA: 
            case XP: {
                return "launcher-win32-i86pc.exe";
            }
        }
        throw new WebDriverException("Could not find a platform that supports bundled launchers, please set it manually");
    }

    private boolean isPathValid(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    private static byte[] md5(InputStream fis) throws NoSuchAlgorithmException, IOException {
        return ByteStreams.getDigest((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])ByteStreams.toByteArray((InputStream)fis)), (MessageDigest)MessageDigest.getInstance("MD5"));
    }

    private static byte[] md5(File file) throws NoSuchAlgorithmException, IOException {
        return Files.getDigest((File)file, (MessageDigest)MessageDigest.getInstance("MD5"));
    }
}

