/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.collect.ImmutableList;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.internal.input.KeyEvent;
import com.opera.core.systems.internal.input.KeyboardModifiers;
import com.opera.core.systems.scope.internal.OperaKey;
import com.opera.core.systems.scope.services.Exec;
import java.util.List;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Keys;

public class OperaKeyboard
implements Keyboard {
    private final Exec exec;
    private final KeyboardModifiers modifiers = new KeyboardModifiers();

    public OperaKeyboard(OperaDriver parent) {
        this.exec = parent.getScopeServices().getExec();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (CharSequence sequence : keysToSend) {
            for (int i = 0; i < sequence.length(); ++i) {
                builder.add((Object)new KeyEvent(sequence.charAt(i)));
            }
        }
        this.sendKeys((List<KeyEvent>)builder.build());
        this.releaseModifiers();
    }

    private void sendKeys(List<KeyEvent> events) {
        for (KeyEvent event : events) {
            if (event.isNewLine()) {
                this.exec.key(OperaKey.ENTER.toScope());
                continue;
            }
            if (event.isModifierRelease()) {
                this.releaseModifiers();
                continue;
            }
            if (event.isModifier()) {
                this.pressOrReleaseModifier(event.getKey());
                continue;
            }
            if (event.isSpecial()) {
                this.exec.key(OperaKey.get(event.getKey()).toScope());
                continue;
            }
            this.type(event.getCharacter());
        }
    }

    protected void releaseModifiers() {
        for (Keys modifierKey : this.modifiers) {
            this.releaseKey(modifierKey);
        }
    }

    private void pressOrReleaseModifier(Keys modifier) {
        if (this.modifiers.contains(modifier)) {
            this.releaseKey(modifier);
        } else {
            this.pressKey(modifier);
        }
    }

    private void type(char key) {
        String string = String.valueOf(key);
        if (this.modifiers.contains(Keys.LEFT_SHIFT) || this.modifiers.contains(Keys.SHIFT)) {
            string = string.toUpperCase();
        }
        this.exec.key(string);
    }

    public void pressKey(Keys keyToPress) {
        this.modifiers.add(keyToPress);
        this.exec.key(OperaKey.get(keyToPress).toScope(), false);
    }

    public void releaseKey(Keys keyToRelease) {
        this.modifiers.remove(keyToRelease);
        this.exec.key(OperaKey.get(keyToRelease).toScope(), true);
    }
}

