/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opera.core.systems.preferences.OperaFilePreferences;
import com.opera.core.systems.preferences.OperaPreferences;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.json.JSONObject;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;

public class OperaProfile {
    public static final String BASE64_JSON_KEY = "base64";
    private File directory;
    private File preferenceFile;
    private boolean randomProfile = false;
    private OperaPreferences preferences;

    public OperaProfile() {
        this(TemporaryFilesystem.getDefaultTmpFS().createTempDir("opera", "profile"));
        this.randomProfile = true;
    }

    public OperaProfile(String profileDirectoryPath) {
        this(new File(profileDirectoryPath));
    }

    public OperaProfile(File profileDirectory) {
        Preconditions.checkArgument((!profileDirectory.getPath().isEmpty() ? 1 : 0) != 0, (Object)"Profile directory path is empty");
        this.directory = profileDirectory;
        this.preferenceFile = OperaProfile.getPreferenceFile(this.directory);
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new WebDriverException("Unable to create directory path: " + this.directory.getPath());
        }
        this.setPreferences(new OperaFilePreferences(this.preferenceFile));
    }

    public OperaPreferences preferences() {
        return this.preferences;
    }

    public void setPreferences(OperaPreferences newPreferences) {
        if (!(newPreferences instanceof OperaFilePreferences)) {
            OperaFilePreferences convertedPreferences = new OperaFilePreferences(this.preferenceFile);
            convertedPreferences.merge(newPreferences);
            this.preferences = convertedPreferences;
        } else {
            this.preferences = newPreferences;
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public void cleanUp() {
        if (this.randomProfile) {
            TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(this.getDirectory());
        }
    }

    public JSONObject toJson() throws IOException {
        String base64 = new Zip().zip(this.getDirectory());
        ImmutableMap map = ImmutableMap.of((Object)"className", (Object)this.getClass().getName(), (Object)BASE64_JSON_KEY, (Object)base64);
        return new JSONObject((Map)map);
    }

    public static OperaProfile fromJson(String json) throws IOException {
        File directory = TemporaryFilesystem.getDefaultTmpFS().createTempDir("opera", "duplicate");
        new Zip().unzip(json, directory);
        return new OperaProfile(directory);
    }

    private static File getPreferenceFile(File directory) {
        ImmutableList candidates = ImmutableList.of((Object)new File(directory, "operaprefs.ini"), (Object)new File(directory, "opera.ini"));
        for (File candidate : candidates) {
            if (!candidate.exists()) continue;
            return candidate;
        }
        return (File)candidates.get(0);
    }
}

