/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.arguments;

public class OperaArgument {
    private String argument;
    private String value;

    public OperaArgument(String argument) {
        this(argument, null);
    }

    public OperaArgument(String argument, Object value) {
        this.argument = OperaArgument.sanitize(argument);
        if (value != null) {
            this.value = String.valueOf(value);
        }
    }

    public String getArgument() {
        return this.argument;
    }

    public String getValue() {
        return this.value;
    }

    private static String sanitize(String key) {
        for (OperaArgumentSign sign : OperaArgumentSign.values()) {
            if (!OperaArgument.hasSwitch(key, sign.sign).booleanValue()) continue;
            return key.substring(sign.sign.length());
        }
        return key;
    }

    private static Boolean hasSwitch(String key, String sign) {
        return key.length() > sign.length() && key.substring(0, sign.length()).equals(sign);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.argument == null ? 0 : this.argument.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OperaArgument other = (OperaArgument)obj;
        return !(this.argument == null ? other.argument != null : !this.argument.equals(other.argument));
    }

    public static enum OperaArgumentSign {
        GNU_SIGN("--"),
        POSIX_SIGN("-"),
        WINDOWS_SIGN("/");

        private final String sign;

        private OperaArgumentSign(String sign) {
            this.sign = sign;
        }

        public String getValue() {
            return this.sign;
        }
    }
}

