/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.preferences;

import com.google.common.base.Preconditions;
import com.opera.core.systems.common.lang.OperaStrings;
import com.opera.core.systems.preferences.OperaGenericPreferences;
import com.opera.core.systems.preferences.OperaPreferences;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;

public abstract class AbstractOperaPreferences
implements OperaPreferences {
    protected LinkedHashSet<OperaPreferences.OperaPreference> preferences = new LinkedHashSet();

    @Override
    public Iterator<OperaPreferences.OperaPreference> iterator() {
        return this.preferences.iterator();
    }

    @Override
    public Iterable<OperaPreferences.OperaPreference> all() {
        return this.preferences;
    }

    @Override
    public void set(OperaPreferences.OperaPreference preference) {
        for (OperaPreferences.OperaPreference p : this) {
            if (!p.getSection().equalsIgnoreCase(preference.getSection()) || !p.getKey().equalsIgnoreCase(preference.getKey())) continue;
            p.setValue(preference.getValue());
            return;
        }
        this.preferences.add(preference);
    }

    @Override
    public void set(String section, String key, Object value) {
        this.set(new OperaGenericPreferences.GenericPreference(section, key, value));
    }

    @Override
    public OperaPreferences.OperaPreference get(String section, String key) {
        for (OperaPreferences.OperaPreference p : this) {
            if (!p.getSection().equalsIgnoreCase(section) || !p.getKey().equalsIgnoreCase(key)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void merge(OperaPreferences newPreferences) {
        for (OperaPreferences.OperaPreference preference : newPreferences) {
            this.set(preference);
        }
    }

    @Override
    public int size() {
        return this.preferences.size();
    }

    public static abstract class AbstractPreference
    implements OperaPreferences.OperaPreference {
        protected Object defaultValue;
        private final String section;
        private final String key;
        private Object value;

        public AbstractPreference(String section, String key, Object value) {
            this.section = section;
            this.key = key;
            this.value = this.sanitizeValue(value);
        }

        @Override
        public String getSection() {
            return this.section;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.getValue(false);
        }

        public Object getValue(boolean operaCompatible) {
            if (this.value == null) {
                return null;
            }
            if (operaCompatible) {
                if (this.value instanceof File) {
                    return ((File)this.value).getPath();
                }
                if (this.value instanceof Boolean) {
                    return (Boolean)this.value != false ? "1" : "0";
                }
                return this.value.toString();
            }
            String stringValue = this.value.toString();
            if (OperaStrings.isNumeric(stringValue) && this.isTruthy(this.value)) {
                return this.value.equals("1");
            }
            if (OperaStrings.isInteger(stringValue)) {
                return Integer.valueOf(stringValue);
            }
            if (OperaStrings.isDouble(stringValue)) {
                return Double.parseDouble(stringValue);
            }
            return stringValue;
        }

        @Override
        public void setValue(Object value) {
            Preconditions.checkNotNull((Object)value);
            this.value = this.sanitizeValue(value);
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public String toString() {
            return "Preference [section: " + this.getSection() + ", key: " + this.getKey() + ", value: " + this.getValue().toString() + "]";
        }

        private Object sanitizeValue(Object value) {
            if (value instanceof Boolean) {
                value = Boolean.parseBoolean(value.toString()) ? "1" : "0";
            }
            return value;
        }

        private boolean isTruthy(Object o) {
            String s = o.toString();
            return s.equals("0") || s.equals("1") || s.equals("true") || s.equals("false");
        }
    }
}

