/*
 * Decompiled with CFR 0.152.
 */
package com.opsdatastore.plugin;

import com.google.inject.internal.util.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate-plugin", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class GenerateMojo
extends AbstractMojo {
    private static final String PLUGIN_INFO_FILE = "ods.plugin.info";
    private static final String PLUGIN_INFO_FILE_DIR = "plugin-info";
    private static final String ARTIFACT_UNZIP_TARGET = "target/plugin-workspace/plugin-classes";
    private static final String DEFAULT_ARTIFACT = "target/${project.artifactId}-${project.version}.jar";
    private static final String PLUGIN_ARTIFACT = "target/${project.artifactId}-${project.version}-plugin.zip";
    @Parameter(property="skip", readonly=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="pluginProvider", readonly=false)
    private String pluginProvider;
    @Parameter(property="pluginId", readonly=false)
    private String pluginId;
    @Parameter(property="pluginVersion", readonly=false)
    private String pluginVersion;
    @Parameter(property="pluginDescription", readonly=false)
    private String pluginDescription;
    @Parameter(property="pluginClass", readonly=false)
    private String pluginClass;
    @Parameter(property="pluginDependencies", readonly=false)
    private String pluginDependencies;
    @Parameter(property="overrideDefaultArtifact", readonly=false, defaultValue="false")
    private boolean overrideDefaultArtifact;
    @Component
    protected MavenProject project;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        if (!"jar".equalsIgnoreCase(this.project.getPackaging())) {
            throw new MojoExecutionException("OpsDataStore Plugin Maven Plugin can only be used on projects with packacing type: jar");
        }
        File baseDirectory = this.project.getBasedir();
        File buildDirectory = new File(this.project.getBuild().getDirectory());
        File pluginWorkspace = new File(buildDirectory, "plugin-workspace");
        FileUtils.deleteQuietly((File)pluginWorkspace);
        pluginWorkspace.mkdirs();
        File assemblyFile = new File(pluginWorkspace, "assembly.xml");
        try (InputStream is = this.readResourceFileAsStream("assembly.xml");
             FileOutputStream os = new FileOutputStream(assemblyFile);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write assembly.xml", ex);
        }
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-antrun-plugin"), (String)MojoExecutor.version((String)"1.6")), (String)MojoExecutor.goal((String)"run"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"target"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"unzip", (MojoExecutor.Attributes)MojoExecutor.attributes((MojoExecutor.Attribute[])new MojoExecutor.Attribute[]{MojoExecutor.attribute((String)"src", (String)DEFAULT_ARTIFACT), MojoExecutor.attribute((String)"dest", (String)ARTIFACT_UNZIP_TARGET)}), (MojoExecutor.Element[])new MojoExecutor.Element[0])})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        File artifactUnzipTarget = new File(baseDirectory, ARTIFACT_UNZIP_TARGET);
        File currentOdsPluginInfoDir = new File(artifactUnzipTarget, PLUGIN_INFO_FILE);
        File odsPluginInfoDir = new File(pluginWorkspace, PLUGIN_INFO_FILE_DIR);
        odsPluginInfoDir.mkdirs();
        File finalOdsPluginInfo = new File(odsPluginInfoDir, PLUGIN_INFO_FILE);
        if (currentOdsPluginInfoDir.exists()) {
            try {
                FileUtils.copyFile((File)currentOdsPluginInfoDir, (File)finalOdsPluginInfo);
            }
            catch (IOException ie) {
                throw new MojoExecutionException("Failed to copy plugin info file from " + currentOdsPluginInfoDir.getAbsolutePath() + " to " + finalOdsPluginInfo.getAbsolutePath(), (Exception)ie);
            }
        } else {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"3.0.0")), (String)MojoExecutor.goal((String)"unpack-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (String)PLUGIN_INFO_FILE), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)odsPluginInfoDir.getAbsolutePath())}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        }
        Properties pluginInfoProperties = new Properties();
        if (finalOdsPluginInfo.exists()) {
            try {
                FileInputStream fis = new FileInputStream(finalOdsPluginInfo);
                Object object = null;
                try {
                    pluginInfoProperties.load(fis);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (fis != null) {
                        if (object != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            fis.close();
                        }
                    }
                }
            }
            catch (IOException ie) {
                throw new MojoExecutionException("Failed to read properties from " + finalOdsPluginInfo.getAbsolutePath(), (Exception)ie);
            }
            this.pluginProvider = this.pluginProvider != null ? this.pluginProvider : pluginInfoProperties.getProperty("plugin.provider");
            this.pluginClass = this.pluginClass != null ? this.pluginClass : pluginInfoProperties.getProperty("plugin.class");
            String string = this.pluginDescription = this.pluginDescription != null ? this.pluginDescription : pluginInfoProperties.getProperty("plugin.description");
        }
        if (this.pluginProvider == null) {
            throw new MojoExecutionException("No value found for pluginProvider found in either plugin definition or in ods.plugin.info");
        }
        if (this.pluginClass == null) {
            throw new MojoExecutionException("No value is set for pluginClass found in plugin declaration or in ods.plugin.info");
        }
        String pluginType = pluginInfoProperties.getProperty("plugin.type");
        if (pluginType != null) {
            switch (pluginType) {
                case "collector": {
                    this.configureCollectorPlugin(pluginWorkspace, pluginInfoProperties);
                }
            }
        }
        File manifestFile = new File(pluginWorkspace, "plugin-classes/META-INF/MANIFEST.MF");
        String usedPluginDescription = this.pluginDescription != null ? this.pluginDescription : (this.project.getDescription() != null ? this.project.getDescription() : "");
        ArrayList existingManifestLines = Lists.newArrayList();
        if (manifestFile.exists()) {
            try {
                FileUtils.readLines((File)manifestFile).forEach(line -> {
                    if (line != null && !line.isEmpty()) {
                        existingManifestLines.add(line);
                    }
                });
            }
            catch (IOException | RuntimeException ie) {
                throw new MojoExecutionException("Failed to read original manifestFile", ie);
            }
        }
        List<String> manifestLines = Arrays.asList("Plugin-Id: " + (this.pluginId == null ? this.project.getArtifactId() : this.pluginId), "Plugin-Provider: " + this.pluginProvider, "Plugin-Version: " + (this.pluginVersion == null ? this.project.getVersion() : this.pluginVersion), "Plugin-Description: " + usedPluginDescription, "Plugin-Class: " + this.pluginClass, "Plugin-Dependencies: " + (this.pluginDependencies == null ? "" : this.pluginDependencies));
        try {
            FileUtils.writeLines((File)manifestFile, (Collection)existingManifestLines, (boolean)false);
            FileUtils.writeLines((File)manifestFile, manifestLines, (boolean)true);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to write to " + manifestFile.getAbsolutePath(), (Exception)ex);
        }
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-assembly-plugin"), (String)MojoExecutor.version((String)"2.5.3")), (String)MojoExecutor.goal((String)"single"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"descriptor"), (String)assemblyFile.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"appendAssemblyId"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"attach"), (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        if (this.overrideDefaultArtifact) {
            DefaultArtifact placeholder = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.project.getArtifact().getScope(), this.project.getArtifact().getType(), "placeholder", this.project.getArtifact().getArtifactHandler());
            this.project.setArtifact((Artifact)placeholder);
        }
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"build-helper-maven-plugin"), (String)MojoExecutor.version((String)"1.3")), (String)MojoExecutor.goal((String)"attach-artifact"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifacts"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifact"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"file"), (String)PLUGIN_ARTIFACT), MojoExecutor.element((String)MojoExecutor.name((String)"classifier"), (String)"plugin"), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"zip")})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        if (this.overrideDefaultArtifact) {
            Artifact pluginArtifact = null;
            Iterator artifactIt = this.project.getAttachedArtifacts().iterator();
            while (artifactIt.hasNext()) {
                Artifact artifact = (Artifact)artifactIt.next();
                if (!"plugin".equals(artifact.getClassifier())) continue;
                pluginArtifact = artifact;
                artifactIt.remove();
            }
            this.project.setArtifact((Artifact)this.convertToDefaultArtifact(pluginArtifact));
        }
    }

    private DefaultArtifact convertToDefaultArtifact(Artifact artifact) {
        DefaultArtifact result = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getType(), artifact.getClassifier(), artifact.getArtifactHandler());
        result.setResolved(true);
        result.setFile(artifact.getFile());
        return result;
    }

    private InputStream readResourceFileAsStream(String resource) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
    }

    private void configureCollectorPlugin(File pluginWorkspace, Properties pluginInfo) throws MojoExecutionException {
    }
}

