/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Delete the details of an alert using alert id, tiny id or alias")
public class DeleteAlertDetailsRequest {
    @JsonProperty(value="identifier")
    private String identifier = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="identifierType")
    private IdentifierTypeEnum identifierType = IdentifierTypeEnum.ID;
    @JsonProperty(value="source")
    private String source = null;
    @JsonProperty(value="user")
    private String user = null;
    @JsonProperty(value="keys")
    private List<String> keys = new ArrayList<String>();

    public DeleteAlertDetailsRequest identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Identifier of alert which could be alert id, tiny id or alert alias")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public DeleteAlertDetailsRequest note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="Additional alert note to add")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public DeleteAlertDetailsRequest identifierType(IdentifierTypeEnum identifierType) {
        this.identifierType = identifierType;
        return this;
    }

    @ApiModelProperty(value="Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'")
    public IdentifierTypeEnum getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(IdentifierTypeEnum identifierType) {
        this.identifierType = identifierType;
    }

    public DeleteAlertDetailsRequest source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="Display name of the request source")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public DeleteAlertDetailsRequest user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="Display name of the request owner")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public DeleteAlertDetailsRequest keys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    public DeleteAlertDetailsRequest addKeysItem(String keysItem) {
        this.keys.add(keysItem);
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Comma separated list of keys to remove from the custom properties of the alert (e.g. 'key1,key2')")
    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteAlertDetailsRequest deleteAlertDetailsRequest = (DeleteAlertDetailsRequest)o;
        return ObjectUtils.equals((Object)this.identifier, (Object)deleteAlertDetailsRequest.identifier) && ObjectUtils.equals((Object)this.note, (Object)deleteAlertDetailsRequest.note) && ObjectUtils.equals((Object)((Object)this.identifierType), (Object)((Object)deleteAlertDetailsRequest.identifierType)) && ObjectUtils.equals((Object)this.source, (Object)deleteAlertDetailsRequest.source) && ObjectUtils.equals((Object)this.user, (Object)deleteAlertDetailsRequest.user) && ObjectUtils.equals(this.keys, deleteAlertDetailsRequest.keys);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.identifier, this.note, this.identifierType, this.source, this.user, this.keys});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteAlertDetailsRequest {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    identifierType: ").append(this.toIndentedString((Object)this.identifierType)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    keys: ").append(this.toIndentedString(this.keys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IdentifierTypeEnum {
        ID("id"),
        ALIAS("alias"),
        TINY("tiny");

        private String value;

        private IdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IdentifierTypeEnum fromValue(String text) {
            for (IdentifierTypeEnum b : IdentifierTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

