/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="List alert logs for the given alert identifier")
public class ListAlertLogsRequest {
    @JsonProperty(value="limit")
    private Integer limit = null;
    @JsonProperty(value="identifier")
    private String identifier = null;
    @JsonProperty(value="identifierType")
    private IdentifierTypeEnum identifierType = IdentifierTypeEnum.ID;
    @JsonProperty(value="offset")
    private String offset = null;
    @JsonProperty(value="direction")
    private DirectionEnum direction = DirectionEnum.NEXT;
    @JsonProperty(value="order")
    private OrderEnum order = OrderEnum.DESC;

    public ListAlertLogsRequest limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(value="Maximum number of items to provide in the result. Must be a positive integer value. Default value is 20 and maximum value is 100")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ListAlertLogsRequest identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Identifier of alert which could be alert id, tiny id or alert alias")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public ListAlertLogsRequest identifierType(IdentifierTypeEnum identifierType) {
        this.identifierType = identifierType;
        return this;
    }

    @ApiModelProperty(value="Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'")
    public IdentifierTypeEnum getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(IdentifierTypeEnum identifierType) {
        this.identifierType = identifierType;
    }

    public ListAlertLogsRequest offset(String offset) {
        this.offset = offset;
        return this;
    }

    @ApiModelProperty(value="Starting value of the offset property")
    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public ListAlertLogsRequest direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(value="Page direction to apply for the given offset with 'next' and 'prev'")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public ListAlertLogsRequest order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="Sorting order of the result set")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListAlertLogsRequest listAlertLogsRequest = (ListAlertLogsRequest)o;
        return ObjectUtils.equals((Object)this.limit, (Object)listAlertLogsRequest.limit) && ObjectUtils.equals((Object)this.identifier, (Object)listAlertLogsRequest.identifier) && ObjectUtils.equals((Object)((Object)this.identifierType), (Object)((Object)listAlertLogsRequest.identifierType)) && ObjectUtils.equals((Object)this.offset, (Object)listAlertLogsRequest.offset) && ObjectUtils.equals((Object)((Object)this.direction), (Object)((Object)listAlertLogsRequest.direction)) && ObjectUtils.equals((Object)((Object)this.order), (Object)((Object)listAlertLogsRequest.order));
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.limit, this.identifier, this.identifierType, this.offset, this.direction, this.order});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListAlertLogsRequest {\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    identifierType: ").append(this.toIndentedString((Object)this.identifierType)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrderEnum {
        ASC("asc"),
        DESC("desc");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderEnum fromValue(String text) {
            for (OrderEnum b : OrderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum DirectionEnum {
        NEXT("next"),
        PREV("prev");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromValue(String text) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum IdentifierTypeEnum {
        ID("id"),
        ALIAS("alias"),
        TINY("tiny");

        private String value;

        private IdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IdentifierTypeEnum fromValue(String text) {
            for (IdentifierTypeEnum b : IdentifierTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

