/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client;

import com.ifountain.opsgenie.client.OpsGenieClientException;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.http.OpsGenieHttpClient;
import com.ifountain.opsgenie.client.http.OpsGenieHttpResponse;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.BaseRequestWithHttpParameters;
import com.ifountain.opsgenie.client.model.BaseResponse;
import com.ifountain.opsgenie.client.model.beans.APIConfiguration;
import com.ifountain.opsgenie.client.util.JsonUtils;
import com.ifountain.opsgenie.client.util.LogUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntity;

public abstract class AbstractOpsGenieHttpClient {
    protected Log log;
    protected OpsGenieHttpClient httpClient;
    private String apiKey;
    private String rootUri = "https://api.opsgenie.com";

    public AbstractOpsGenieHttpClient(OpsGenieHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    protected String getRootUri() {
        return this.rootUri;
    }

    protected void setRootUri(String rootUri) {
        this.rootUri = rootUri;
    }

    public void close() {
        this.httpClient.close();
    }

    protected BaseResponse doPostRequest(BaseRequest request) throws IOException, OpsGenieClientException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=utf-8");
        String uri = this.rootUri + request.getEndPoint();
        String json = JsonUtils.toJson(request);
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with content Parameters:" + LogUtils.getInsensitiveLogMessage(JsonUtils.toMap(request))));
        OpsGenieHttpResponse httpResponse = this.httpClient.post(uri, json, headers);
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected BaseResponse doPostRequest(BaseRequestWithHttpParameters request) throws OpsGenieClientException, IOException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=utf-8");
        String uri = this.rootUri + request.getEndPoint();
        String json = JsonUtils.toJson(request);
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with content Parameters:" + LogUtils.getInsensitiveLogMessage(JsonUtils.toMap(request))));
        OpsGenieHttpResponse httpResponse = this.httpClient.post(uri, json, headers, request.getHttpParameters());
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected BaseResponse doPostRequest(BaseRequest request, MultipartEntity entity) throws IOException, OpsGenieClientException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        String uri = this.rootUri + request.getEndPoint();
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with multipart data"));
        OpsGenieHttpResponse httpResponse = this.httpClient.post(uri, (HttpEntity)entity);
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected BaseResponse doDeleteRequest(BaseRequest request) throws OpsGenieClientException, IOException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        String uri = this.rootUri + request.getEndPoint();
        Map parameters = JsonUtils.toMap(request);
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with Parameters:" + LogUtils.getInsensitiveLogMessage(parameters)));
        OpsGenieHttpResponse httpResponse = this.httpClient.delete(uri, parameters);
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected BaseResponse doGetRequest(BaseRequest request) throws OpsGenieClientException, IOException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        String uri = this.rootUri + request.getEndPoint();
        Map parameters = JsonUtils.toMap(request);
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with Parameters:" + LogUtils.getInsensitiveLogMessage(parameters)));
        OpsGenieHttpResponse httpResponse = this.httpClient.get(uri, parameters);
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected BaseResponse doPostRequestV2(BaseRequest request) throws IOException, OpsGenieClientException, ParseException {
        APIConfiguration apiConfiguration = this.getAPIConfigurationForPostOrPatchOrPut(request);
        OpsGenieHttpResponse httpResponse = this.httpClient.post(apiConfiguration.getUri(), apiConfiguration.getJson(), apiConfiguration.getHeaders(), apiConfiguration.getParameters());
        return this.handleAndPopulateResponse(httpResponse, request);
    }

    protected BaseResponse doGetRequestV2(BaseRequest request) throws OpsGenieClientException, IOException, ParseException {
        APIConfiguration apiConfiguration = this.getAPIConfigurationForGetOrDelete(request);
        OpsGenieHttpResponse httpResponse = this.httpClient.get(apiConfiguration.getUri(), apiConfiguration.getParameters(), apiConfiguration.getHeaders());
        return this.handleAndPopulateResponse(httpResponse, request);
    }

    protected BaseResponse doDeleteRequestV2(BaseRequest request) throws OpsGenieClientException, IOException, ParseException {
        APIConfiguration apiConfiguration = this.getAPIConfigurationForGetOrDelete(request);
        OpsGenieHttpResponse httpResponse = this.httpClient.delete(apiConfiguration.getUri(), apiConfiguration.getParameters(), apiConfiguration.getHeaders());
        return this.handleAndPopulateResponse(httpResponse, request);
    }

    protected BaseResponse doPatchRequestV2(BaseRequest request) throws IOException, OpsGenieClientException, ParseException {
        APIConfiguration apiConfiguration = this.getAPIConfigurationForPostOrPatchOrPut(request);
        OpsGenieHttpResponse httpResponse = this.httpClient.patch(apiConfiguration.getUri(), apiConfiguration.getJson(), apiConfiguration.getParameters(), apiConfiguration.getHeaders());
        return this.handleAndPopulateResponse(httpResponse, request);
    }

    protected BaseResponse doPutRequestV2(BaseRequest request) throws IOException, OpsGenieClientException, ParseException {
        APIConfiguration apiConfiguration = this.getAPIConfigurationForPostOrPatchOrPut(request);
        OpsGenieHttpResponse httpResponse = this.httpClient.put(apiConfiguration.getUri(), apiConfiguration.getJson(), apiConfiguration.getParameters(), apiConfiguration.getHeaders());
        return this.handleAndPopulateResponse(httpResponse, request);
    }

    private void setAndValidateApiKey(BaseRequest request) throws OpsGenieClientValidationException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
    }

    private APIConfiguration getAPIConfigurationForPostOrPatchOrPut(BaseRequest request) throws OpsGenieClientValidationException, ParseException, IOException {
        this.setAndValidateApiKey(request);
        APIConfiguration apiConfiguration = new APIConfiguration();
        apiConfiguration.setUri(this.rootUri + request.getEndPoint());
        apiConfiguration.setParameters(request.getRequestParams());
        apiConfiguration.setHeaders(request.getReqHeadersForPostOrPatch());
        apiConfiguration.setJson(JsonUtils.toJson(request));
        this.log.info((Object)("Executing OpsGenie request to [" + apiConfiguration.getUri() + "] with content Parameters:" + LogUtils.getInsensitiveLogMessage(JsonUtils.toMap(request))));
        return apiConfiguration;
    }

    private APIConfiguration getAPIConfigurationForGetOrDelete(BaseRequest request) throws OpsGenieClientValidationException, IOException, ParseException {
        this.setAndValidateApiKey(request);
        APIConfiguration apiConfiguration = new APIConfiguration();
        apiConfiguration.setUri(this.rootUri + request.getEndPoint());
        apiConfiguration.setHeaders(request.getReqHeadersForGetOrDelete());
        apiConfiguration.setParameters(request.getRequestParams());
        this.log.info((Object)("Executing OpsGenie request to [" + apiConfiguration.getUri() + "] with Parameters:" + LogUtils.getInsensitiveLogMessage(apiConfiguration.getParameters())));
        return apiConfiguration;
    }

    private BaseResponse handleAndPopulateResponse(OpsGenieHttpResponse httpResponse, BaseRequest request) throws OpsGenieClientException, IOException, ParseException {
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected void handleResponse(OpsGenieHttpResponse response) throws IOException, OpsGenieClientException {
        if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
            String contentType = response.getHeaders().get("Content-Type");
            if (contentType != null && contentType.toLowerCase().startsWith("application/json")) {
                Map error = JsonUtils.parse(response.getContent());
                throw new OpsGenieClientException((String)error.get("error"), (Integer)error.get("code"));
            }
            throw new IOException(new String(response.getContent(), "UTF-8"));
        }
    }

    protected BaseResponse populateResponse(BaseRequest request, OpsGenieHttpResponse httpResponse) throws ParseException, IOException {
        return request.createResponse();
    }
}

