/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client;

import com.ifountain.opsgenie.client.IAccountOpsGenieClient;
import com.ifountain.opsgenie.client.IAlertOpsGenieClient;
import com.ifountain.opsgenie.client.IAlertPolicyOpsGenieClient;
import com.ifountain.opsgenie.client.IContactOpsGenieClient;
import com.ifountain.opsgenie.client.IEscalationOpsGenieClient;
import com.ifountain.opsgenie.client.IGroupOpsGenieClient;
import com.ifountain.opsgenie.client.IIntegrationOpsGenieClient;
import com.ifountain.opsgenie.client.INotificationRuleOpsGenieClient;
import com.ifountain.opsgenie.client.IOpsGenieClient;
import com.ifountain.opsgenie.client.IScheduleOpsGenieClient;
import com.ifountain.opsgenie.client.ITeamOpsGenieClient;
import com.ifountain.opsgenie.client.IUserOpsGenieClient;
import com.ifountain.opsgenie.client.InnerAccountOpsGenieClient;
import com.ifountain.opsgenie.client.InnerAlertOpsGenieClient;
import com.ifountain.opsgenie.client.InnerAlertPolicyOpsGenieClient;
import com.ifountain.opsgenie.client.InnerContactOpsGenieClient;
import com.ifountain.opsgenie.client.InnerEscalationOpsGenieClient;
import com.ifountain.opsgenie.client.InnerGroupOpsGenieClient;
import com.ifountain.opsgenie.client.InnerIntegrationOpsGenieClient;
import com.ifountain.opsgenie.client.InnerNotificationRuleOpsGenieClient;
import com.ifountain.opsgenie.client.InnerScheduleOpsGenieClient;
import com.ifountain.opsgenie.client.InnerTeamOpsGenieClient;
import com.ifountain.opsgenie.client.InnerUserOpsGenieClient;
import com.ifountain.opsgenie.client.JsonOpsgenieHttpClient;
import com.ifountain.opsgenie.client.OpsGenieClientException;
import com.ifountain.opsgenie.client.StreamOpsgenieHttpClient;
import com.ifountain.opsgenie.client.http.OpsGenieHttpClient;
import com.ifountain.opsgenie.client.model.BaseResponse;
import com.ifountain.opsgenie.client.model.beans.Heartbeat;
import com.ifountain.opsgenie.client.model.customer.AddAlertAttachmentRequest;
import com.ifountain.opsgenie.client.model.customer.AddAlertAttachmentResponse;
import com.ifountain.opsgenie.client.model.customer.AddHeartbeatRequest;
import com.ifountain.opsgenie.client.model.customer.AddHeartbeatResponse;
import com.ifountain.opsgenie.client.model.customer.CopyNotificationRulesRequest;
import com.ifountain.opsgenie.client.model.customer.CopyNotificationRulesResponse;
import com.ifountain.opsgenie.client.model.customer.DeleteHeartbeatRequest;
import com.ifountain.opsgenie.client.model.customer.DeleteHeartbeatResponse;
import com.ifountain.opsgenie.client.model.customer.EnableHeartbeatRequest;
import com.ifountain.opsgenie.client.model.customer.EnableHeartbeatResponse;
import com.ifountain.opsgenie.client.model.customer.GetHeartbeatRequest;
import com.ifountain.opsgenie.client.model.customer.GetHeartbeatResponse;
import com.ifountain.opsgenie.client.model.customer.HeartbeatPingRequest;
import com.ifountain.opsgenie.client.model.customer.HeartbeatPingResponse;
import com.ifountain.opsgenie.client.model.customer.HeartbeatRequest;
import com.ifountain.opsgenie.client.model.customer.HeartbeatResponse;
import com.ifountain.opsgenie.client.model.customer.ListHeartbeatsRequest;
import com.ifountain.opsgenie.client.model.customer.ListHeartbeatsResponse;
import com.ifountain.opsgenie.client.model.customer.UpdateHeartbeatRequest;
import com.ifountain.opsgenie.client.model.customer.UpdateHeartbeatResponse;
import com.ifountain.opsgenie.client.rest.RestApiClient;
import com.ifountain.opsgenie.client.rest.response.RestSuccessResult;
import com.ifountain.opsgenie.client.swagger.ApiClient;
import com.ifountain.opsgenie.client.swagger.Configuration;
import com.ifountain.opsgenie.client.swagger.api.AlertApi;
import com.ifountain.opsgenie.client.swagger.auth.ApiKeyAuth;
import com.ifountain.opsgenie.client.util.ClientConfiguration;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class OpsGenieClient
implements IOpsGenieClient {
    private InnerUserOpsGenieClient innerUserOpsGenieClient;
    private InnerGroupOpsGenieClient innerGroupOpsGenieClient;
    private InnerTeamOpsGenieClient innerTeamOpsGenieClient;
    private InnerEscalationOpsGenieClient innerEscalationOpsGenieClient;
    private InnerAlertOpsGenieClient innerAlertOpsGenieClient;
    private InnerScheduleOpsGenieClient innerScheduleOpsGenieClient;
    private InnerAlertPolicyOpsGenieClient innerAlertPolicyOpsGenieClient;
    private IIntegrationOpsGenieClient innerIntegrationOpsGenieClient;
    private INotificationRuleOpsGenieClient innerNotificationRuleOpsGenieClient;
    private IAccountOpsGenieClient innerAccountOpsGenieClient;
    private IContactOpsGenieClient innerContactOpsGenieClient;
    private JsonOpsgenieHttpClient jsonHttpClient;
    private StreamOpsgenieHttpClient streamOpsgenieHttpClient;
    private RestApiClient restApiClient;
    private ApiClient swaggerApiClient;

    public OpsGenieClient(ClientConfiguration config) {
        this(new OpsGenieHttpClient(config));
    }

    public OpsGenieClient() {
        this(new OpsGenieHttpClient());
    }

    public OpsGenieClient(OpsGenieHttpClient httpClient) {
        this.jsonHttpClient = new JsonOpsgenieHttpClient(httpClient);
        this.streamOpsgenieHttpClient = new StreamOpsgenieHttpClient(httpClient);
        this.jsonHttpClient.setApiKey(this.getApiKey());
        this.restApiClient = new RestApiClient(httpClient);
        this.restApiClient.setApiKey(this.getApiKey());
        this.swaggerApiClient = Configuration.getDefaultApiClient();
        this.innerUserOpsGenieClient = new InnerUserOpsGenieClient(this.jsonHttpClient);
        this.innerGroupOpsGenieClient = new InnerGroupOpsGenieClient(this.jsonHttpClient);
        this.innerTeamOpsGenieClient = new InnerTeamOpsGenieClient(this.jsonHttpClient);
        this.innerEscalationOpsGenieClient = new InnerEscalationOpsGenieClient(this.jsonHttpClient);
        this.innerAlertOpsGenieClient = new InnerAlertOpsGenieClient(this.jsonHttpClient);
        this.innerScheduleOpsGenieClient = new InnerScheduleOpsGenieClient(this.jsonHttpClient, this.streamOpsgenieHttpClient);
        this.innerAlertPolicyOpsGenieClient = new InnerAlertPolicyOpsGenieClient(this.jsonHttpClient);
        this.innerIntegrationOpsGenieClient = new InnerIntegrationOpsGenieClient(this.jsonHttpClient);
        this.innerContactOpsGenieClient = new InnerContactOpsGenieClient(this.jsonHttpClient);
        this.innerNotificationRuleOpsGenieClient = new InnerNotificationRuleOpsGenieClient(this.jsonHttpClient);
        this.innerAccountOpsGenieClient = new InnerAccountOpsGenieClient(this.jsonHttpClient);
    }

    @Override
    public IUserOpsGenieClient user() {
        return this.innerUserOpsGenieClient;
    }

    @Override
    @Deprecated
    public IGroupOpsGenieClient group() {
        return this.innerGroupOpsGenieClient;
    }

    @Override
    public ITeamOpsGenieClient team() {
        return this.innerTeamOpsGenieClient;
    }

    @Override
    public IEscalationOpsGenieClient escalation() {
        return this.innerEscalationOpsGenieClient;
    }

    @Override
    @Deprecated
    public IAlertOpsGenieClient alert() {
        return this.innerAlertOpsGenieClient;
    }

    @Override
    public IScheduleOpsGenieClient schedule() {
        return this.innerScheduleOpsGenieClient;
    }

    @Override
    public IAlertPolicyOpsGenieClient alertPolicy() {
        return this.innerAlertPolicyOpsGenieClient;
    }

    @Override
    public IIntegrationOpsGenieClient integration() {
        return this.innerIntegrationOpsGenieClient;
    }

    @Override
    public INotificationRuleOpsGenieClient notificationRule() {
        return this.innerNotificationRuleOpsGenieClient;
    }

    @Override
    @Deprecated
    public HeartbeatResponse heartbeat(HeartbeatRequest heartbeatRequest) throws OpsGenieClientException, IOException, ParseException {
        return (HeartbeatResponse)this.jsonHttpClient.doPostRequest(heartbeatRequest);
    }

    @Override
    public HeartbeatPingResponse pingHeartbeat(HeartbeatPingRequest pingRequest) throws OpsGenieClientException, IOException, ParseException {
        RestSuccessResult<Object> result = this.restApiClient.post(pingRequest.getEndPoint()).apiKey(pingRequest.getApiKey()).getResponse(Object.class);
        HeartbeatPingResponse response = new HeartbeatPingResponse();
        this.populateMetaData(response, result);
        return response;
    }

    private void populateMetaData(BaseResponse response, RestSuccessResult<?> result) {
        response.setSuccess(true);
        if (result.getTook() != null) {
            response.setTook(result.getTook().intValue());
        }
        response.setJson(result.getRawData());
    }

    @Override
    public AddAlertAttachmentResponse addAlertAttachment(AddAlertAttachmentRequest request) throws ParseException, OpsGenieClientException, IOException {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (request.getFile() != null) {
            entity.addPart("file", (ContentBody)new FileBody(request.getFile()));
        }
        if (request.getIndexFile() != null) {
            entity.addPart("indexFile", (ContentBody)new StringBody(request.getIndexFile(), "text/plain", Charset.forName("utf-8")));
        }
        if (request.getUser() != null) {
            entity.addPart("user", (ContentBody)new StringBody(request.getUser(), "text/plain", Charset.forName("utf-8")));
        }
        RestSuccessResult<Object> result = this.restApiClient.post(request.getEndPoint()).addParameter("alertIdentifierType", request.getAlertIdentifierType().getValue()).httpEntity((HttpEntity)entity).apiKey(request.getApiKey()).getResponse(Object.class);
        AddAlertAttachmentResponse response = new AddAlertAttachmentResponse();
        this.populateMetaData(response, result);
        return response;
    }

    @Override
    public DeleteHeartbeatResponse deleteHeartbeat(DeleteHeartbeatRequest deleteHeartbeatRequest) throws OpsGenieClientException, IOException, ParseException {
        RestSuccessResult<Object> result = this.restApiClient.delete(deleteHeartbeatRequest.getEndPoint()).apiKey(deleteHeartbeatRequest.getApiKey()).getResponse(Object.class);
        DeleteHeartbeatResponse response = new DeleteHeartbeatResponse();
        this.populateMetaData(response, result);
        return response;
    }

    @Override
    public AddHeartbeatResponse addHeartbeat(AddHeartbeatRequest addHeartbeatRequest) throws OpsGenieClientException, IOException, ParseException {
        RestSuccessResult<Heartbeat> result = this.restApiClient.post(addHeartbeatRequest.getEndPoint()).apiKey(addHeartbeatRequest.getApiKey()).json(addHeartbeatRequest).getResponse(Heartbeat.class);
        AddHeartbeatResponse response = new AddHeartbeatResponse();
        this.populateMetaData(response, result);
        response.setName(result.getData().getName());
        return response;
    }

    @Override
    public UpdateHeartbeatResponse updateHeartbeat(UpdateHeartbeatRequest updateHeartbeatRequest) throws OpsGenieClientException, IOException, ParseException {
        RestSuccessResult<Heartbeat> result = this.restApiClient.patch(updateHeartbeatRequest.getEndPoint()).json(updateHeartbeatRequest).apiKey(updateHeartbeatRequest.getApiKey()).getResponse(Heartbeat.class);
        UpdateHeartbeatResponse response = new UpdateHeartbeatResponse();
        this.populateMetaData(response, result);
        response.setName(result.getData().getName());
        return response;
    }

    @Override
    public EnableHeartbeatResponse enableHeartbeat(EnableHeartbeatRequest enableHeartbeatRequest) throws OpsGenieClientException, IOException, ParseException {
        RestSuccessResult<Object> result = this.restApiClient.post(enableHeartbeatRequest.getEndPoint()).apiKey(enableHeartbeatRequest.getApiKey()).getResponse(Object.class);
        EnableHeartbeatResponse response = new EnableHeartbeatResponse();
        this.populateMetaData(response, result);
        return response;
    }

    @Override
    public GetHeartbeatResponse getHeartbeat(GetHeartbeatRequest request) throws OpsGenieClientException, IOException, ParseException {
        RestSuccessResult<Heartbeat> result = this.restApiClient.get(request.getEndPoint()).apiKey(request.getApiKey()).getResponse(Heartbeat.class);
        GetHeartbeatResponse response = new GetHeartbeatResponse();
        this.populateMetaData(response, result);
        response.setHeartbeat(result.getData());
        return response;
    }

    @Override
    @Deprecated
    public ListHeartbeatsResponse listHeartbeats(ListHeartbeatsRequest listHeartbeatsRequest) throws OpsGenieClientException, IOException, ParseException {
        return (ListHeartbeatsResponse)this.jsonHttpClient.doGetRequest(listHeartbeatsRequest);
    }

    @Override
    public CopyNotificationRulesResponse copyNotificationRules(CopyNotificationRulesRequest copyNotificationRulesRequest) throws OpsGenieClientException, IOException, ParseException {
        return (CopyNotificationRulesResponse)this.jsonHttpClient.doPostRequest(copyNotificationRulesRequest);
    }

    @Override
    public AlertApi alertV2() {
        ApiKeyAuth genieKey = (ApiKeyAuth)this.swaggerApiClient.getAuthentication("GenieKey");
        if (StringUtils.isNotEmpty((CharSequence)this.getApiKey())) {
            genieKey.setApiKey(this.getApiKey());
        }
        genieKey.setApiKeyPrefix("GenieKey");
        return new AlertApi();
    }

    @Override
    public void setRootUri(String rootUri) {
        this.jsonHttpClient.setRootUri(rootUri);
        this.streamOpsgenieHttpClient.setRootUri(rootUri);
        this.restApiClient.setRootUrl(rootUri);
        this.swaggerApiClient.setBasePath(rootUri);
    }

    public String getApiKey() {
        return this.jsonHttpClient != null ? this.jsonHttpClient.getApiKey() : null;
    }

    public void setApiKey(String apiKey) {
        if (this.jsonHttpClient != null) {
            this.jsonHttpClient.setApiKey(apiKey);
        }
        if (this.restApiClient != null) {
            this.restApiClient.setApiKey(apiKey);
        }
        if (this.swaggerApiClient != null) {
            ApiKeyAuth genieKey = (ApiKeyAuth)this.swaggerApiClient.getAuthentication("GenieKey");
            genieKey.setApiKeyPrefix("GenieKey");
            genieKey.setApiKey(apiKey);
        }
    }

    @Override
    public void close() {
        this.jsonHttpClient.close();
        this.streamOpsgenieHttpClient.close();
    }

    @Override
    public IContactOpsGenieClient contact() {
        return this.innerContactOpsGenieClient;
    }

    @Override
    public IAccountOpsGenieClient account() {
        return this.innerAccountOpsGenieClient;
    }
}

