/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.http;

import com.ifountain.opsgenie.client.OpsGenieClientException;
import com.ifountain.opsgenie.client.http.OpsGenieHttpResponse;
import com.ifountain.opsgenie.client.util.ClientConfiguration;
import com.ifountain.opsgenie.client.util.ClientProxyConfiguration;
import com.ifountain.opsgenie.client.util.JsonUtils;
import com.ifountain.opsgenie.client.util.UriUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;

public class OpsGenieHttpClient {
    private DefaultHttpClient httpClient;
    private ClientConfiguration config;

    public OpsGenieHttpClient() {
        this(new ClientConfiguration());
    }

    public OpsGenieHttpClient(ClientConfiguration config) {
        this.config = config;
        this.createHttpClient();
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
            this.httpClient = null;
        }
    }

    protected ClientConfiguration getConfig() {
        return this.config;
    }

    public OpsGenieHttpResponse post(String uri, Map<String, Object> parameters) throws IOException, OpsGenieClientException {
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            formParams.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, "UTF-8");
        return this.post(uri, (HttpEntity)entity);
    }

    public OpsGenieHttpResponse post(String uri, String content) throws IOException, OpsGenieClientException {
        return this.post(uri, content, new HashMap<String, String>());
    }

    public OpsGenieHttpResponse post(String uri, byte[] content) throws IOException, OpsGenieClientException {
        return this.post(uri, content, new HashMap<String, String>());
    }

    public OpsGenieHttpResponse post(String uri, HttpEntity entity) throws IOException, OpsGenieClientException {
        return this.post(uri, entity, new HashMap<String, String>());
    }

    public OpsGenieHttpResponse post(String uri, String content, Map<String, String> headers) throws IOException, OpsGenieClientException {
        HttpPost postMethod = this.preparePostMethod(uri, content, headers);
        return this.executeHttpMethod((HttpRequestBase)postMethod);
    }

    public OpsGenieHttpResponse post(String uri, byte[] content, Map<String, String> headers) throws IOException, OpsGenieClientException {
        HttpPost postMethod = this.preparePostMethod(uri, content, headers);
        return this.executeHttpMethod((HttpRequestBase)postMethod);
    }

    public OpsGenieHttpResponse post(String uri, HttpEntity entity, Map<String, String> headers) throws IOException, OpsGenieClientException {
        HttpPost postMethod = this.preparePostMethod(uri, entity, headers);
        return this.executeHttpMethod((HttpRequestBase)postMethod);
    }

    public OpsGenieHttpResponse post(String uri, HttpEntity entity, Map<String, String> headers, Map<String, Object> parameters) throws IOException, OpsGenieClientException {
        HttpPost postMethod = this.preparePostMethod(UriUtils.generateUriWithParams(uri, parameters), entity, headers);
        return this.executeHttpMethod((HttpRequestBase)postMethod);
    }

    public OpsGenieHttpResponse post(String uri, String content, Map<String, String> headers, Map<String, Object> parameters) throws IOException, OpsGenieClientException {
        HttpPost postMethod = this.preparePostMethod(uri, content, headers, parameters);
        return this.executeHttpMethod((HttpRequestBase)postMethod);
    }

    public HttpPost preparePostMethod(String uri, String content, Map<String, String> headers, Map<String, Object> parameters) throws UnsupportedEncodingException, OpsGenieClientException {
        StringEntity entity = new StringEntity(content, "UTF-8");
        entity.setChunked(true);
        return this.preparePostMethod(UriUtils.generateUriWithParams(uri, parameters), (HttpEntity)entity, headers);
    }

    private HttpPost preparePostMethod(String uri, String content, Map<String, String> headers) throws UnsupportedEncodingException, OpsGenieClientException {
        StringEntity entity = new StringEntity(content, "UTF-8");
        entity.setChunked(true);
        return this.preparePostMethod(uri, (HttpEntity)entity, headers);
    }

    private HttpPost preparePostMethod(String uri, byte[] content, Map<String, String> headers) throws OpsGenieClientException {
        ByteArrayEntity entity = new ByteArrayEntity(content);
        entity.setChunked(true);
        return this.preparePostMethod(uri, (HttpEntity)entity, headers);
    }

    private HttpPost preparePostMethod(String uri, HttpEntity entity, Map<String, String> headers) throws OpsGenieClientException {
        HttpPost postMethod = new HttpPost(UriUtils.generateUri(uri));
        postMethod.setEntity(entity);
        this.configureHeaders((HttpRequestBase)postMethod, headers);
        return postMethod;
    }

    private HttpPost preparePostMethod(URI uri, HttpEntity entity, Map<String, String> headers) {
        HttpPost postMethod = new HttpPost(uri);
        postMethod.setEntity(entity);
        this.configureHeaders((HttpRequestBase)postMethod, headers);
        return postMethod;
    }

    public OpsGenieHttpResponse put(String uri, Map<String, Object> contentMap, Map<String, Object> parameters) throws IOException, OpsGenieClientException {
        HttpPut putMethod = this.preparePutMethod(uri, contentMap, parameters);
        return this.executeHttpMethod((HttpRequestBase)putMethod);
    }

    public OpsGenieHttpResponse put(String uri, String content, Map<String, Object> parameters) throws IOException, OpsGenieClientException {
        HttpPut putMethod = this.preparePutMethod(uri, content, parameters);
        return this.executeHttpMethod((HttpRequestBase)putMethod);
    }

    public OpsGenieHttpResponse put(String uri, String content, Map<String, Object> parameters, Map<String, String> headers) throws IOException, OpsGenieClientException {
        HttpPut putMethod = this.preparePutMethod(uri, content, parameters, headers);
        return this.executeHttpMethod((HttpRequestBase)putMethod);
    }

    public HttpPut preparePutMethod(String uri, Map<String, Object> contentMap, Map<String, Object> parameters) throws IOException, OpsGenieClientException {
        HttpPut putMethod = new HttpPut(UriUtils.generateUriWithParams(uri, parameters));
        StringEntity entity = new StringEntity(JsonUtils.toJson(contentMap), "UTF-8");
        entity.setChunked(true);
        putMethod.setEntity((HttpEntity)entity);
        return putMethod;
    }

    public HttpPut preparePutMethod(String uri, String content, Map<String, Object> parameters) throws IOException, OpsGenieClientException {
        HttpPut putMethod = new HttpPut(UriUtils.generateUriWithParams(uri, parameters));
        StringEntity entity = new StringEntity(content, "UTF-8");
        entity.setChunked(true);
        putMethod.setEntity((HttpEntity)entity);
        return putMethod;
    }

    public HttpPut preparePutMethod(String uri, String content, Map<String, Object> parameters, Map<String, String> headers) throws IOException, OpsGenieClientException {
        HttpPut putMethod = new HttpPut(UriUtils.generateUriWithParams(uri, parameters));
        StringEntity entity = new StringEntity(content, "UTF-8");
        entity.setChunked(true);
        putMethod.setEntity((HttpEntity)entity);
        this.configureHeaders((HttpRequestBase)putMethod, headers);
        return putMethod;
    }

    public OpsGenieHttpResponse patch(String uri, String content, Map<String, Object> parameters, Map<String, String> headers) throws IOException, OpsGenieClientException {
        HttpPatch patchMethod = this.preparePatchMethod(uri, content, parameters, headers);
        return this.executeHttpMethod((HttpRequestBase)patchMethod);
    }

    public HttpPatch preparePatchMethod(String uri, String content, Map<String, Object> parameters, Map<String, String> headers) throws IOException, OpsGenieClientException {
        HttpPatch patchMethod = new HttpPatch(UriUtils.generateUriWithParams(uri, parameters));
        StringEntity entity = new StringEntity(content, "UTF-8");
        entity.setChunked(true);
        patchMethod.setEntity((HttpEntity)entity);
        this.configureHeaders((HttpRequestBase)patchMethod, headers);
        return patchMethod;
    }

    public OpsGenieHttpResponse get(String uri, Map<String, Object> parameters) throws IOException, OpsGenieClientException {
        return this.get(uri, parameters, new HashMap<String, String>());
    }

    public OpsGenieHttpResponse get(String uri, Map<String, Object> parameters, Map<String, String> headers) throws IOException, OpsGenieClientException {
        HttpGet get = new HttpGet(UriUtils.generateUriWithParams(uri, parameters));
        this.configureHeaders((HttpRequestBase)get, headers);
        return this.executeHttpMethod((HttpRequestBase)get);
    }

    public OpsGenieHttpResponse delete(String uri, Map<String, Object> parameters) throws IOException, OpsGenieClientException {
        HttpDelete delete = new HttpDelete(UriUtils.generateUriWithParams(uri, parameters));
        this.configureHeaders((HttpRequestBase)delete, new HashMap<String, String>());
        return this.executeHttpMethod((HttpRequestBase)delete);
    }

    public OpsGenieHttpResponse delete(String uri, Map<String, Object> parameters, Map<String, String> headers) throws IOException, OpsGenieClientException {
        HttpDelete delete = new HttpDelete(UriUtils.generateUriWithParams(uri, parameters));
        this.configureHeaders((HttpRequestBase)delete, headers);
        return this.executeHttpMethod((HttpRequestBase)delete);
    }

    public OpsGenieHttpResponse executeHttpMethod(HttpRequestBase method) throws IOException {
        return new OpsgenieHttpClientRetryMechanism(method).execute();
    }

    private void configureHeaders(HttpRequestBase httpRequest, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase entityEnclosingRequest = (HttpEntityEnclosingRequestBase)httpRequest;
            if (entityEnclosingRequest.getEntity().getContentType() == null && (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0)) {
                httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8".toLowerCase());
            }
        } else if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8".toLowerCase());
        }
    }

    private void createHttpClient() {
        BasicClientConnectionManager connectionManager;
        String userAgent = this.config.getUserAgent();
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent((HttpParams)httpClientParams, (String)userAgent);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)this.config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)this.config.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpClientParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpClientParams, (boolean)true);
        int socketSendBufferSizeHint = this.config.getSocketSendBufferSizeHint();
        int socketReceiveBufferSizeHint = this.config.getSocketReceiveBufferSizeHint();
        if (socketSendBufferSizeHint > 0 || socketReceiveBufferSizeHint > 0) {
            HttpConnectionParams.setSocketBufferSize((HttpParams)httpClientParams, (int)Math.max(socketSendBufferSizeHint, socketReceiveBufferSizeHint));
        }
        if (this.config.getMaxConnections() > 1) {
            PoolingClientConnectionManager poolingClientConnectionManager = new PoolingClientConnectionManager();
            poolingClientConnectionManager.setDefaultMaxPerRoute(this.config.getMaxConnections());
            poolingClientConnectionManager.setMaxTotal(this.config.getMaxConnections());
            connectionManager = poolingClientConnectionManager;
        } else {
            connectionManager = new BasicClientConnectionManager();
        }
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpClientParams);
        if (this.config.getCredentials() != null) {
            this.httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, this.config.getCredentials());
        }
        try {
            SSLSocketFactory sf = this.createSocketFactory();
            List<Integer> httpsPorts = this.config.getHttpsPorts();
            if (httpsPorts == null) {
                httpsPorts = Arrays.asList(443);
            }
            for (int httpsPort : httpsPorts) {
                this.httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", httpsPort, (SchemeSocketFactory)sf));
            }
        }
        catch (Exception sf) {
            // empty catch block
        }
        if (this.config.getRetryHandler() != null) {
            this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)this.config.getRetryHandler());
        }
        if (this.config.getClientProxyConfiguration() != null) {
            String proxyHost = this.config.getClientProxyConfiguration().getProxyHost();
            int proxyPort = this.config.getClientProxyConfiguration().getProxyPort();
            HttpHost proxyHttpHost = this.config.getClientProxyConfiguration().getProxyProtocol() == null ? new HttpHost(proxyHost, proxyPort) : new HttpHost(proxyHost, proxyPort, this.config.getClientProxyConfiguration().getProxyProtocol());
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHttpHost);
            String proxyUsername = this.config.getClientProxyConfiguration().getProxyUsername();
            String proxyPassword = this.config.getClientProxyConfiguration().getProxyPassword();
            String proxyDomain = this.config.getClientProxyConfiguration().getProxyDomain();
            String proxyWorkstation = this.config.getClientProxyConfiguration().getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                if (this.config.getClientProxyConfiguration().getAuthType() == ClientProxyConfiguration.AuthType.NT) {
                    this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
                } else if (this.config.getClientProxyConfiguration().getAuthType() == ClientProxyConfiguration.AuthType.BASIC) {
                    this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
                }
            }
        }
    }

    private SSLSocketFactory createSocketFactory() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sslContext.init(null, new TrustManager[]{tm}, null);
        return new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }

    private class OpsgenieHttpClientRetryMechanism {
        HttpRequestBase request;

        public OpsgenieHttpClientRetryMechanism(HttpRequestBase request) {
            this.request = request;
        }

        public OpsGenieHttpResponse execute() throws IOException {
            OpsGenieHttpResponse opsGenieHttpResponse;
            int retryCount = 1;
            while (true) {
                this.request.reset();
                opsGenieHttpResponse = (OpsGenieHttpResponse)OpsGenieHttpClient.this.httpClient.execute((HttpUriRequest)this.request, (ResponseHandler)new ResponseHandler<OpsGenieHttpResponse>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public OpsGenieHttpResponse handleResponse(HttpResponse httpResponse) throws IOException {
                        try {
                            Header[] allHeaders;
                            OpsGenieHttpResponse response = new OpsGenieHttpResponse();
                            if (httpResponse.getEntity() != null) {
                                byte[] content = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
                                Header contentType = httpResponse.getEntity().getContentType();
                                String object = contentType != null ? contentType.getValue() : null;
                                response.setContentType(object);
                                response.setContent(content);
                            }
                            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
                            for (Header header : allHeaders = httpResponse.getAllHeaders()) {
                                response.addHeader(header.getName(), header.getValue());
                            }
                            OpsGenieHttpResponse opsGenieHttpResponse = response;
                            return opsGenieHttpResponse;
                        }
                        finally {
                            OpsgenieHttpClientRetryMechanism.this.request.abort();
                        }
                    }
                });
                if (OpsGenieHttpClient.this.config.getRetryHandler() == null || !OpsGenieHttpClient.this.config.getRetryHandler().retryRequest((HttpRequest)this.request, opsGenieHttpResponse, retryCount)) break;
                ++retryCount;
            }
            return opsGenieHttpResponse;
        }
    }
}

