/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseResponse;
import com.ifountain.opsgenie.client.model.Request;
import com.ifountain.opsgenie.client.model.beans.ScheduleRotation;
import com.ifountain.opsgenie.client.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(alphabetic=true)
public abstract class BaseRequest<T extends BaseResponse, K extends BaseRequest>
implements Request {
    @JsonIgnore
    private String apiKey;

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public K withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return (K)this;
    }

    @JsonIgnore
    public void validate() throws OpsGenieClientValidationException {
        if (this.apiKey == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("apiKey");
        }
    }

    @JsonIgnore
    public Map<String, Object> getRequestParams() {
        return new HashMap<String, Object>();
    }

    @JsonIgnore
    public Map<String, String> getReqHeadersForGetOrDelete() {
        return this.addGenieKey();
    }

    public void validateRotations(List<ScheduleRotation> rotations) throws OpsGenieClientValidationException {
        if (Objects.nonNull(rotations)) {
            for (ScheduleRotation rotation : rotations) {
                rotation.validateScheduleRotation();
            }
        }
    }

    @JsonIgnore
    public Map<String, String> getReqHeadersForPostOrPatch() {
        Map<String, String> headers = this.addGenieKey();
        headers.put("Content-Type", "application/json; charset=utf-8");
        return headers;
    }

    private Map<String, String> addGenieKey() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "GenieKey " + this.apiKey);
        return headers;
    }

    @JsonIgnore
    @Deprecated
    public String getCustomerKey() {
        return this.apiKey;
    }

    @Deprecated
    public void setCustomerKey(String apiKey) {
        this.setApiKey(apiKey);
    }

    @Deprecated
    public Map serialize() throws OpsGenieClientValidationException {
        this.validate();
        try {
            return JsonUtils.toMap(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract T createResponse();
}

